/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.CursorType;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.DBCollectionFindOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BSONObject;
import org.bson.Document;
import org.bson.types.CodeWScope;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.query.ArraySlice;
import org.mongodb.morphia.query.CountOptions;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.CriteriaJoin;
import org.mongodb.morphia.query.FieldCriteria;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.FieldEndImpl;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Meta;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.MorphiaKeyIterator;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryValidator;
import org.mongodb.morphia.query.Sort;
import org.mongodb.morphia.query.ValidationException;
import org.mongodb.morphia.query.WhereCriteria;

public class QueryImpl<T>
extends CriteriaContainerImpl
implements Query<T> {
    private static final Logger LOG = MorphiaLoggerFactory.get(QueryImpl.class);
    private final DatastoreImpl ds;
    private final DBCollection dbColl;
    private final Class<T> clazz;
    private EntityCache cache;
    private boolean validateName = true;
    private boolean validateType = true;
    private Boolean includeFields;
    private BasicDBObject baseQuery;
    private FindOptions options;

    FindOptions getOptions() {
        if (this.options == null) {
            this.options = new FindOptions();
        }
        return this.options;
    }

    public QueryImpl(Class<T> clazz, DBCollection coll, Datastore ds) {
        super(CriteriaJoin.AND);
        Entity entAn;
        this.setQuery(this);
        this.clazz = clazz;
        this.ds = (DatastoreImpl)ds;
        this.dbColl = coll;
        this.cache = this.ds.getMapper().createEntityCache();
        MappedClass mc = this.ds.getMapper().getMappedClass(clazz);
        Entity entity = entAn = mc == null ? null : mc.getEntityAnnotation();
        if (entAn != null) {
            this.getOptions().readPreference((ReadPreference)(this.ds.getMapper().getMappedClass(clazz).getEntityAnnotation().queryNonPrimary() ? ReadPreference.secondaryPreferred() : null));
        }
    }

    public static BasicDBObject parseFieldsString(String str, Class clazz, Mapper mapper, boolean validate) {
        String[] parts;
        BasicDBObject ret = new BasicDBObject();
        for (String s : parts = str.split(",")) {
            s = s.trim();
            int dir = 1;
            if (s.startsWith("-")) {
                dir = -1;
                s = s.substring(1).trim();
            }
            if (validate) {
                StringBuilder sb = new StringBuilder(s);
                QueryValidator.validateQuery(clazz, mapper, sb, FilterOperator.IN, "", true, false);
                s = sb.toString();
            }
            ret.put((Object)s, (Object)dir);
        }
        return ret;
    }

    @Override
    public List<Key<T>> asKeyList() {
        return this.asKeyList(this.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Key<T>> asKeyList(FindOptions options) {
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        MorphiaKeyIterator<T> keys = this.fetchKeys(options);
        try {
            for (Key key : keys) {
                results.add(key);
            }
        }
        finally {
            keys.close();
        }
        return results;
    }

    @Override
    public List<T> asList() {
        return this.asList(this.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> asList(FindOptions options) {
        ArrayList<T> results = new ArrayList<T>();
        MorphiaIterator<T, T> iter = this.fetch(options);
        try {
            for (T ent : iter) {
                results.add(ent);
            }
        }
        finally {
            iter.close();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("asList: %s \t %d entities, iterator time: driver %d ms, mapper %d ms %n\t cache: %s %n\t for %s", this.dbColl.getName(), results.size(), iter.getDriverTime(), iter.getMapperTime(), this.cache.stats(), this.getQueryObject()));
        }
        return results;
    }

    @Override
    @Deprecated
    public long countAll() {
        DBObject query = this.getQueryObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing count(" + this.dbColl.getName() + ") for query: " + query);
        }
        return this.dbColl.getCount(query);
    }

    @Override
    public long count() {
        return this.dbColl.getCount(this.getQueryObject());
    }

    @Override
    public long count(CountOptions options) {
        return this.dbColl.getCount(this.getQueryObject(), options.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetch() {
        return this.fetch(this.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetch(FindOptions options) {
        DBCursor cursor = this.prepareCursor(options);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting cursor(" + this.dbColl.getName() + ")  for query:" + cursor.getQuery());
        }
        return new MorphiaIterator(this.ds, (Iterator<DBObject>)cursor, this.ds.getMapper(), this.clazz, this.dbColl.getName(), this.cache);
    }

    @Override
    public MorphiaIterator<T, T> fetchEmptyEntities() {
        return this.fetchEmptyEntities(this.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetchEmptyEntities(FindOptions options) {
        Query cloned = this.cloneQuery();
        ((QueryImpl)cloned).getOptions().projection((DBObject)new BasicDBObject("_id", (Object)1));
        ((QueryImpl)cloned).includeFields = true;
        return ((QueryImpl)cloned).fetch();
    }

    @Override
    public MorphiaKeyIterator<T> fetchKeys() {
        return this.fetchKeys(this.getOptions());
    }

    @Override
    public MorphiaKeyIterator<T> fetchKeys(FindOptions options) {
        Query cloned = this.cloneQuery();
        ((QueryImpl)cloned).getOptions().projection((DBObject)new BasicDBObject("_id", (Object)1));
        ((QueryImpl)cloned).includeFields = true;
        return new MorphiaKeyIterator<T>(this.ds, super.prepareCursor(options), this.ds.getMapper(), this.clazz, this.dbColl.getName());
    }

    @Override
    public T get() {
        return this.get(this.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(FindOptions options) {
        MorphiaIterator<T, T> it = this.fetch(options.copy().limit(1));
        try {
            T t = it.hasNext() ? (T)it.next() : null;
            return t;
        }
        finally {
            it.close();
        }
    }

    @Override
    public Key<T> getKey() {
        return this.getKey(this.getOptions());
    }

    @Override
    public Key<T> getKey(FindOptions options) {
        MorphiaKeyIterator<T> it = this.fetchKeys(options.copy().limit(1));
        Key key = it.hasNext() ? (Key)it.next() : null;
        it.close();
        return key;
    }

    @Override
    @Deprecated
    public MorphiaIterator<T, T> tail() {
        return this.tail(true);
    }

    @Override
    @Deprecated
    public MorphiaIterator<T, T> tail(boolean awaitData) {
        return this.fetch(this.getOptions().copy().cursorType(awaitData ? CursorType.TailableAwait : CursorType.Tailable));
    }

    @Override
    @Deprecated
    public Query<T> batchSize(int value) {
        this.getOptions().batchSize(value);
        return this;
    }

    @Override
    public QueryImpl<T> cloneQuery() {
        QueryImpl<T> n = new QueryImpl<T>(this.clazz, this.dbColl, this.ds);
        n.cache = this.ds.getMapper().createEntityCache();
        n.includeFields = this.includeFields;
        n.setQuery(n);
        n.validateName = this.validateName;
        n.validateType = this.validateType;
        n.baseQuery = this.copy((DBObject)this.baseQuery);
        n.options = this.options != null ? this.options.copy() : null;
        n.setAttachedTo(this.getAttachedTo());
        n.setChildren((List<Criteria>)(this.getChildren() == null ? null : new ArrayList<Criteria>(this.getChildren())));
        return n;
    }

    protected BasicDBObject copy(DBObject dbObject) {
        return dbObject == null ? null : new BasicDBObject(dbObject.toMap());
    }

    @Override
    @Deprecated
    public Query<T> comment(String comment) {
        this.getOptions().modifier("$comment", comment);
        return this;
    }

    @Override
    public FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this, field, container);
    }

    @Override
    @Deprecated
    public Query<T> disableCursorTimeout() {
        this.getOptions().noCursorTimeout(true);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> disableSnapshotMode() {
        this.getOptions().getModifiers().removeField("$snapshot");
        return this;
    }

    @Override
    public Query<T> disableValidation() {
        this.validateName = false;
        this.validateType = false;
        return this;
    }

    @Override
    @Deprecated
    public Query<T> enableCursorTimeout() {
        this.getOptions().noCursorTimeout(false);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> enableSnapshotMode() {
        this.getOptions().modifier("$snapshot", true);
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateName = true;
        this.validateType = true;
        return this;
    }

    @Override
    public Map<String, Object> explain() {
        return this.explain(this.getOptions());
    }

    @Override
    public Map<String, Object> explain(FindOptions options) {
        return this.prepareCursor(options).explain().toMap();
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return new FieldEndImpl<QueryImpl>(this, name, this);
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this, prop, op, value));
        return this;
    }

    @Override
    @Deprecated
    public int getBatchSize() {
        return this.getOptions().getBatchSize();
    }

    @Override
    @Deprecated
    public DBCollection getCollection() {
        return this.dbColl;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    @Deprecated
    public DBObject getFieldsObject() {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null || projection.keySet().size() == 0) {
            return null;
        }
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        Entity entityAnnotation = mc.getEntityAnnotation();
        BasicDBObject fieldsFilter = this.copy(projection);
        if (this.includeFields.booleanValue() && entityAnnotation != null && !entityAnnotation.noClassnameStored()) {
            fieldsFilter.put((Object)"className", (Object)1);
        }
        return fieldsFilter;
    }

    @Override
    @Deprecated
    public int getLimit() {
        return this.getOptions().getLimit();
    }

    @Override
    @Deprecated
    public int getOffset() {
        return this.getOptions().getSkip();
    }

    @Override
    @Deprecated
    public DBObject getQueryObject() {
        BasicDBObject obj = new BasicDBObject();
        if (this.baseQuery != null) {
            obj.putAll((BSONObject)this.baseQuery);
        }
        this.addTo((DBObject)obj);
        return obj;
    }

    public void setQueryObject(DBObject query) {
        this.baseQuery = new BasicDBObject(query.toMap());
    }

    @Override
    @Deprecated
    public DBObject getSortObject() {
        DBObject sort = this.getOptions().getSortDBObject();
        return sort == null ? null : new BasicDBObject(sort.toMap());
    }

    @Override
    @Deprecated
    public Query<T> hintIndex(String idxName) {
        this.getOptions().modifier("$hint", idxName);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> limit(int value) {
        this.getOptions().limit(value);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> lowerIndexBound(DBObject lowerBound) {
        if (lowerBound != null) {
            this.getOptions().modifier("$min", new Document(lowerBound.toMap()));
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> maxScan(int value) {
        if (value > 0) {
            this.getOptions().modifier("$maxScan", value);
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> maxTime(long value, TimeUnit unit) {
        this.getOptions().modifier("$maxTimeMS", TimeUnit.MILLISECONDS.convert(value, unit));
        return this;
    }

    long getMaxTime(TimeUnit unit) {
        Long maxTime = (Long)this.getOptions().getModifiers().get("$maxTimeMS");
        return unit.convert(maxTime != null ? maxTime : 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public Query<T> offset(int value) {
        this.getOptions().skip(value);
        return this;
    }

    @Override
    public Query<T> order(String sort) {
        this.getOptions().sort((DBObject)QueryImpl.parseFieldsString(sort, this.clazz, this.ds.getMapper(), this.validateName));
        return this;
    }

    @Override
    public Query<T> order(Meta sort) {
        QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), new StringBuilder(sort.getField()), FilterOperator.IN, "", false, false);
        this.getOptions().sort(sort.toDatabase());
        return this;
    }

    @Override
    public Query<T> order(Sort ... sorts) {
        BasicDBObject sortList = new BasicDBObject();
        for (Sort sort : sorts) {
            String s = sort.getField();
            if (this.validateName) {
                StringBuilder sb = new StringBuilder(s);
                QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), sb, FilterOperator.IN, "", true, false);
                s = sb.toString();
            }
            sortList.put((Object)s, (Object)sort.getOrder());
        }
        this.getOptions().sort((DBObject)sortList);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> queryNonPrimary() {
        this.getOptions().readPreference(ReadPreference.secondaryPreferred());
        return this;
    }

    @Override
    @Deprecated
    public Query<T> queryPrimaryOnly() {
        this.getOptions().readPreference(ReadPreference.primary());
        return this;
    }

    @Override
    public Query<T> retrieveKnownFields() {
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        ArrayList<String> fields = new ArrayList<String>(mc.getPersistenceFields().size() + 1);
        for (MappedField mf : mc.getPersistenceFields()) {
            fields.add(mf.getNameToStore());
        }
        this.retrievedFields(true, fields.toArray(new String[fields.size()]));
        return this;
    }

    @Override
    public Query<T> project(String field, boolean include) {
        StringBuilder sb = new StringBuilder(field);
        QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), sb, FilterOperator.EQUAL, null, this.validateName, false);
        String fieldName = sb.toString();
        this.validateProjections(fieldName, include);
        this.project(fieldName, include ? 1 : 0);
        return this;
    }

    private void project(String fieldName, Object value) {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null) {
            projection = new BasicDBObject();
            this.getOptions().projection(projection);
        }
        projection.put(fieldName, value);
    }

    private void project(DBObject value) {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null) {
            projection = new BasicDBObject();
            this.getOptions().projection(projection);
        }
        projection.putAll((BSONObject)value);
    }

    @Override
    public Query<T> project(String field, ArraySlice slice) {
        StringBuilder sb = new StringBuilder(field);
        QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), sb, FilterOperator.EQUAL, null, this.validateName, false);
        String fieldName = sb.toString();
        this.validateProjections(fieldName, true);
        this.project(fieldName, slice.toDatabase());
        return this;
    }

    @Override
    public Query<T> project(Meta meta) {
        StringBuilder sb = new StringBuilder(meta.getField());
        QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), sb, FilterOperator.EQUAL, null, false, false);
        String fieldName = sb.toString();
        this.validateProjections(fieldName, true);
        this.project(meta.toDatabase());
        return this;
    }

    private void validateProjections(String field, boolean include) {
        if (!(this.includeFields == null || include == this.includeFields || this.includeFields.booleanValue() && "_id".equals(field))) {
            throw new ValidationException("You cannot mix included and excluded fields together");
        }
        if (this.includeFields == null) {
            this.includeFields = include;
        }
    }

    @Override
    @Deprecated
    public Query<T> retrievedFields(boolean include, String ... list) {
        if (this.includeFields != null && include != this.includeFields) {
            throw new IllegalStateException("You cannot mix included and excluded fields together");
        }
        for (String field : list) {
            this.project(field, include);
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> returnKey() {
        this.getOptions().getModifiers().put("$returnKey", (Object)true);
        return this;
    }

    @Override
    public Query<T> search(String search) {
        BasicDBObject op = new BasicDBObject("$search", (Object)search);
        this.criteria("$text").equal(op);
        return this;
    }

    @Override
    public Query<T> search(String search, String language) {
        BasicDBObject op = new BasicDBObject("$search", (Object)search).append("$language", (Object)language);
        this.criteria("$text").equal(op);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> upperIndexBound(DBObject upperBound) {
        if (upperBound != null) {
            this.getOptions().getModifiers().put("$max", (Object)new BasicDBObject(upperBound.toMap()));
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> useReadPreference(ReadPreference readPref) {
        this.getOptions().readPreference(readPref);
        return this;
    }

    @Override
    public Query<T> where(String js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public Query<T> where(CodeWScope js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public String getFieldName() {
        return null;
    }

    @Deprecated
    public DatastoreImpl getDatastore() {
        return this.ds;
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public boolean isValidatingTypes() {
        return this.validateType;
    }

    public MorphiaIterator<T, T> iterator() {
        return this.fetch();
    }

    @Deprecated
    public DBCursor prepareCursor() {
        return this.prepareCursor(this.getOptions());
    }

    private DBCursor prepareCursor(FindOptions findOptions) {
        DBObject query = this.getQueryObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.dbColl.getName(), query, findOptions));
        }
        if (findOptions.isSnapshot() && (findOptions.getSortDBObject() != null || findOptions.hasHint())) {
            LOG.warning("Snapshotted query should not have hint/sort.");
        }
        if (findOptions.getCursorType() != CursorType.NonTailable && findOptions.getSortDBObject() != null) {
            LOG.warning("Sorting on tail is not allowed.");
        }
        return this.dbColl.find(query, findOptions.getOptions().copy().sort(this.getSortObject()).projection(this.getFieldsObject())).setDecoderFactory(this.ds.getDecoderFact());
    }

    public String toString() {
        return String.format("{ query: %s %s }", this.getQueryObject(), this.getOptions().getProjection() == null ? "" : ", projection: " + this.getFieldsObject());
    }

    protected FilterOperator translate(String operator) {
        return FilterOperator.fromString(operator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryImpl)) {
            return false;
        }
        QueryImpl query = (QueryImpl)o;
        if (this.validateName != query.validateName) {
            return false;
        }
        if (this.validateType != query.validateType) {
            return false;
        }
        if (!this.dbColl.equals(query.dbColl)) {
            return false;
        }
        if (!this.clazz.equals(query.clazz)) {
            return false;
        }
        if (this.includeFields != null ? !this.includeFields.equals(query.includeFields) : query.includeFields != null) {
            return false;
        }
        if (this.baseQuery != null ? !this.baseQuery.equals((Object)query.baseQuery) : query.baseQuery != null) {
            return false;
        }
        return this.compare(this.options, query.options);
    }

    private boolean compare(FindOptions these, FindOptions those) {
        if (these == null && those != null || these != null && those == null) {
            return false;
        }
        if (these == null) {
            return true;
        }
        DBCollectionFindOptions dbOptions = these.getOptions();
        DBCollectionFindOptions that = those.getOptions();
        if (dbOptions.getBatchSize() != that.getBatchSize()) {
            return false;
        }
        if (dbOptions.getLimit() != that.getLimit()) {
            return false;
        }
        if (dbOptions.getMaxTime(TimeUnit.MILLISECONDS) != that.getMaxTime(TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (dbOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS) != that.getMaxAwaitTime(TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (dbOptions.getSkip() != that.getSkip()) {
            return false;
        }
        if (dbOptions.isNoCursorTimeout() != that.isNoCursorTimeout()) {
            return false;
        }
        if (dbOptions.isOplogReplay() != that.isOplogReplay()) {
            return false;
        }
        if (dbOptions.isPartial() != that.isPartial()) {
            return false;
        }
        if (dbOptions.getModifiers() != null ? !dbOptions.getModifiers().equals(that.getModifiers()) : that.getModifiers() != null) {
            return false;
        }
        if (dbOptions.getProjection() != null ? !dbOptions.getProjection().equals(that.getProjection()) : that.getProjection() != null) {
            return false;
        }
        if (dbOptions.getSort() != null ? !dbOptions.getSort().equals(that.getSort()) : that.getSort() != null) {
            return false;
        }
        if (dbOptions.getCursorType() != that.getCursorType()) {
            return false;
        }
        if (dbOptions.getReadPreference() != null ? !dbOptions.getReadPreference().equals(that.getReadPreference()) : that.getReadPreference() != null) {
            return false;
        }
        if (dbOptions.getReadConcern() != null ? !dbOptions.getReadConcern().equals((Object)that.getReadConcern()) : that.getReadConcern() != null) {
            return false;
        }
        return dbOptions.getCollation() != null ? dbOptions.getCollation().equals((Object)that.getCollation()) : that.getCollation() == null;
    }

    private int hash(FindOptions options) {
        if (options == null) {
            return 0;
        }
        int result = options.getBatchSize();
        result = 31 * result + this.getLimit();
        result = 31 * result + (options.getModifiers() != null ? options.getModifiers().hashCode() : 0);
        result = 31 * result + (options.getProjection() != null ? options.getProjection().hashCode() : 0);
        result = 31 * result + (int)(options.getMaxTime(TimeUnit.MILLISECONDS) ^ options.getMaxTime(TimeUnit.MILLISECONDS) >>> 32);
        result = 31 * result + (int)(options.getMaxAwaitTime(TimeUnit.MILLISECONDS) ^ options.getMaxAwaitTime(TimeUnit.MILLISECONDS) >>> 32);
        result = 31 * result + options.getSkip();
        result = 31 * result + (options.getSortDBObject() != null ? options.getSortDBObject().hashCode() : 0);
        result = 31 * result + (options.getCursorType() != null ? options.getCursorType().hashCode() : 0);
        result = 31 * result + (options.isNoCursorTimeout() ? 1 : 0);
        result = 31 * result + (options.isOplogReplay() ? 1 : 0);
        result = 31 * result + (options.isPartial() ? 1 : 0);
        result = 31 * result + (options.getReadPreference() != null ? options.getReadPreference().hashCode() : 0);
        result = 31 * result + (options.getReadConcern() != null ? options.getReadConcern().hashCode() : 0);
        result = 31 * result + (options.getCollation() != null ? options.getCollation().hashCode() : 0);
        return result;
    }

    public int hashCode() {
        int result = this.dbColl.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + (this.validateName ? 1 : 0);
        result = 31 * result + (this.validateType ? 1 : 0);
        result = 31 * result + (this.includeFields != null ? this.includeFields.hashCode() : 0);
        result = 31 * result + (this.baseQuery != null ? this.baseQuery.hashCode() : 0);
        result = 31 * result + this.hash(this.options);
        return result;
    }
}

