/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.mongodb.morphia.query.UpdateException;

public class PushOptions {
    private Integer position;
    private Integer slice;
    private Integer sort;
    private DBObject sortDocument;

    public PushOptions position(int position) {
        if (position < 0) {
            throw new UpdateException("The position must be at least 0.");
        }
        this.position = position;
        return this;
    }

    public PushOptions slice(int slice) {
        this.slice = slice;
        return this;
    }

    public PushOptions sort(int sort) {
        this.sort = sort;
        return this;
    }

    public PushOptions sort(String field, int direction) {
        if (this.sort != null) {
            throw new IllegalStateException("sortDocument can not be set if sort already is");
        }
        if (this.sortDocument == null) {
            this.sortDocument = new BasicDBObject();
        }
        this.sortDocument.put(field, (Object)direction);
        return this;
    }

    void update(BasicDBObject dbObject) {
        if (this.position != null) {
            dbObject.put((Object)"$position", (Object)this.position);
        }
        if (this.slice != null) {
            dbObject.put((Object)"$slice", (Object)this.slice);
        }
        if (this.sort != null) {
            dbObject.put((Object)"$sort", (Object)this.sort);
        }
        if (this.sortDocument != null) {
            dbObject.put((Object)"$sort", (Object)this.sortDocument);
        }
    }

    public static PushOptions options() {
        return new PushOptions();
    }
}

