/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.classrules;

import java.util.HashSet;
import java.util.Set;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ClassConstraint;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;

public class DuplicatedAttributeNames
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        HashSet<String> foundNames = new HashSet<String>();
        for (MappedField mappedField : mc.getPersistenceFields()) {
            for (String name : mappedField.getLoadNames()) {
                if (foundNames.add(name)) continue;
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mappedField, this.getClass(), "Mapping to MongoDB field name '" + name + "' is duplicated; you cannot map different java fields to the same MongoDB field."));
            }
        }
    }
}

