/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation;

import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.validation.ClassConstraint;

public class ConstraintViolation {
    private final MappedClass clazz;
    private final Class<? extends ClassConstraint> validator;
    private final String message;
    private final Level level;
    private MappedField field;

    public ConstraintViolation(Level level, MappedClass clazz, MappedField field, Class<? extends ClassConstraint> validator, String message) {
        this(level, clazz, validator, message);
        this.field = field;
    }

    public ConstraintViolation(Level level, MappedClass clazz, Class<? extends ClassConstraint> validator, String message) {
        this.level = level;
        this.clazz = clazz;
        this.message = message;
        this.validator = validator;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPrefix() {
        String fn = this.field != null ? this.field.getJavaFieldName() : "";
        return this.clazz.getClazz().getName() + "." + fn;
    }

    public String render() {
        return String.format("%s complained about %s : %s", this.validator.getSimpleName(), this.getPrefix(), this.message);
    }

    public static enum Level {
        MINOR,
        INFO,
        WARNING,
        SEVERE,
        FATAL;

    }
}

