/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.lazy.proxy;

import org.mongodb.morphia.mapping.lazy.proxy.ProxiedReference;

public final class ProxyHelper {
    private ProxyHelper() {
    }

    public static <T> T unwrap(T entity) {
        if (ProxyHelper.isProxy(entity)) {
            return (T)ProxyHelper.asProxy(entity).__unwrap();
        }
        return entity;
    }

    public static boolean isProxy(Object entity) {
        return entity != null && ProxyHelper.isProxied(entity.getClass());
    }

    private static <T> ProxiedReference asProxy(T entity) {
        return (ProxiedReference)entity;
    }

    public static boolean isProxied(Class<?> clazz) {
        return ProxiedReference.class.isAssignableFrom(clazz);
    }

    public static Class getReferentClass(Object entity) {
        if (ProxyHelper.isProxy(entity)) {
            return ProxyHelper.asProxy(entity).__getReferenceObjClass();
        }
        return entity != null ? entity.getClass() : null;
    }

    public static boolean isUnFetched(Object entity) {
        return !ProxyHelper.isFetched(entity);
    }

    public static boolean isFetched(Object entity) {
        return entity == null || !ProxyHelper.isProxy(entity) || ProxyHelper.asProxy(entity).__isFetched();
    }
}

