/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mongodb.morphia.geo.Geometry;
import org.mongodb.morphia.geo.LineString;

public class Polygon
implements Geometry {
    private final LineString exteriorBoundary;
    private final List<LineString> interiorBoundaries;

    private Polygon() {
        this.exteriorBoundary = null;
        this.interiorBoundaries = new ArrayList<LineString>();
    }

    Polygon(LineString exteriorBoundary, LineString ... interiorBoundaries) {
        this.exteriorBoundary = exteriorBoundary;
        this.interiorBoundaries = Arrays.asList(interiorBoundaries);
    }

    Polygon(List<LineString> boundaries) {
        this.exteriorBoundary = boundaries.get(0);
        this.interiorBoundaries = boundaries.size() > 1 ? boundaries.subList(1, boundaries.size()) : new ArrayList<LineString>();
    }

    public List<LineString> getCoordinates() {
        ArrayList<LineString> polygonBoundaries = new ArrayList<LineString>();
        polygonBoundaries.add(this.exteriorBoundary);
        polygonBoundaries.addAll(this.interiorBoundaries);
        return polygonBoundaries;
    }

    public LineString getExteriorBoundary() {
        return this.exteriorBoundary;
    }

    public List<LineString> getInteriorBoundaries() {
        return Collections.unmodifiableList(this.interiorBoundaries);
    }

    public int hashCode() {
        int result = this.exteriorBoundary.hashCode();
        result = 31 * result + this.interiorBoundaries.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        if (!this.exteriorBoundary.equals(polygon.exteriorBoundary)) {
            return false;
        }
        return this.interiorBoundaries.equals(polygon.interiorBoundaries);
    }

    public String toString() {
        return "Polygon{exteriorBoundary=" + this.exteriorBoundary + ", interiorBoundaries=" + this.interiorBoundaries + '}';
    }
}

