/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.geo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.geo.GeoJsonType;
import org.mongodb.morphia.geo.Geometry;
import org.mongodb.morphia.geo.GeometryFactory;
import org.mongodb.morphia.mapping.MappedField;

public class GeometryShapeConverter
extends TypeConverter
implements SimpleValueConverter {
    private final GeoJsonType geoJsonType;
    private final List<GeometryFactory> factories;

    GeometryShapeConverter(GeoJsonType ... geoJsonTypes) {
        super(geoJsonTypes[0].getTypeClass());
        this.geoJsonType = geoJsonTypes[0];
        this.factories = Arrays.asList(geoJsonTypes);
    }

    @Override
    public Geometry decode(Class<?> targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        return this.decodeObject((List)((DBObject)fromDBObject).get("coordinates"), this.factories);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value != null) {
            Object encodedObjects = this.encodeObjects(((Geometry)value).getCoordinates());
            return new BasicDBObject("type", (Object)this.geoJsonType.getType()).append("coordinates", encodedObjects);
        }
        return null;
    }

    private Geometry decodeObject(List mongoDBGeometry, List<GeometryFactory> geometryFactories) {
        GeometryFactory factory = geometryFactories.get(0);
        if (geometryFactories.size() == 1) {
            return factory.createGeometry(mongoDBGeometry);
        }
        ArrayList<Geometry> decodedObjects = new ArrayList<Geometry>();
        for (Object objectThatNeedsDecoding : mongoDBGeometry) {
            decodedObjects.add(this.decodeObject((List)objectThatNeedsDecoding, geometryFactories.subList(1, geometryFactories.size())));
        }
        return factory.createGeometry(decodedObjects);
    }

    private Object encodeObjects(List value) {
        ArrayList<Object> encodedObjects = new ArrayList<Object>();
        for (Object object : value) {
            if (object instanceof Geometry) {
                encodedObjects.add(this.encodeObjects(((Geometry)object).getCoordinates()));
                continue;
            }
            encodedObjects.add(this.getMapper().getConverters().encode(object));
        }
        return encodedObjects;
    }

    public static class PointConverter
    extends GeometryShapeConverter {
        public PointConverter() {
            super(GeoJsonType.POINT);
        }
    }

    public static class LineStringConverter
    extends GeometryShapeConverter {
        public LineStringConverter() {
            super(GeoJsonType.LINE_STRING, GeoJsonType.POINT);
        }
    }

    public static class MultiPointConverter
    extends GeometryShapeConverter {
        public MultiPointConverter() {
            super(GeoJsonType.MULTI_POINT, GeoJsonType.POINT);
        }
    }

    public static class MultiLineStringConverter
    extends GeometryShapeConverter {
        public MultiLineStringConverter() {
            super(GeoJsonType.MULTI_LINE_STRING, GeoJsonType.LINE_STRING, GeoJsonType.POINT);
        }
    }

    public static class PolygonConverter
    extends GeometryShapeConverter {
        public PolygonConverter() {
            super(GeoJsonType.POLYGON, GeoJsonType.LINE_STRING, GeoJsonType.POINT);
        }
    }

    public static class MultiPolygonConverter
    extends GeometryShapeConverter {
        public MultiPolygonConverter() {
            super(GeoJsonType.MULTI_POLYGON, GeoJsonType.POLYGON, GeoJsonType.LINE_STRING, GeoJsonType.POINT);
        }
    }
}

