/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import java.time.LocalTime;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;

public class LocalTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    private static final int MILLI_MODULO = 1000000;

    public LocalTimeConverter() {
        super(LocalTime.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof LocalTime) {
            return val;
        }
        if (val instanceof Number) {
            return LocalTime.ofNanoOfDay(((Number)val).longValue() * 1000000L);
        }
        throw new IllegalArgumentException("Can't convert to LocalTime from " + val);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        LocalTime time = (LocalTime)value;
        return time.toNanoOfDay() / 1000000L;
    }
}

