/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;

public class LocalDateTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    public LocalDateTimeConverter() {
        super(LocalDateTime.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDateTime) {
            return val;
        }
        if (val instanceof Date) {
            return LocalDateTime.ofInstant(((Date)val).toInstant(), ZoneId.systemDefault());
        }
        throw new IllegalArgumentException("Can't convert to LocalDateTime from " + val);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
    }
}

