/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.converters.ConverterException;
import org.mongodb.morphia.converters.Converters;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.EphemeralMappedField;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.utils.ReflectionUtils;

public class IterableConverter
extends TypeConverter {
    public Object decode(Class targetClass, Object fromDBObject, MappedField mf) {
        if (mf == null || fromDBObject == null) {
            return fromDBObject;
        }
        Class<?> subtypeDest = mf.getSubClass();
        Collection<?> values = this.createNewCollection(mf);
        Converters converters = this.getMapper().getConverters();
        if (fromDBObject.getClass().isArray()) {
            for (Object o : (Object[])fromDBObject) {
                values.add(converters.decode(subtypeDest != null ? subtypeDest : o.getClass(), o, mf));
            }
        } else if (fromDBObject instanceof Iterable) {
            for (Object o : (Iterable)fromDBObject) {
                if (o instanceof DBObject) {
                    List<MappedField> typeParameters = mf.getTypeParameters();
                    if (!typeParameters.isEmpty()) {
                        MappedField mappedField = typeParameters.get(0);
                        if (mappedField instanceof EphemeralMappedField) {
                            values.add(converters.decode(subtypeDest != null ? subtypeDest : o.getClass(), o, mappedField));
                            continue;
                        }
                        throw new UnsupportedOperationException("mappedField isn't an EphemeralMappedField");
                    }
                    values.add(converters.decode(subtypeDest != null ? subtypeDest : o.getClass(), o, mf));
                    continue;
                }
                values.add(converters.decode(subtypeDest != null ? subtypeDest : o.getClass(), o, mf));
            }
        } else {
            values.add(converters.decode(subtypeDest != null ? subtypeDest : fromDBObject.getClass(), fromDBObject, mf));
        }
        if (mf.getType().isArray()) {
            return ReflectionUtils.convertToArray(subtypeDest, (List)values);
        }
        return values;
    }

    @Override
    public Object encode(Object value, MappedField mf) {
        List<Object> iterableValues;
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) == 0 || value.getClass().getComponentType().isPrimitive()) {
                return value;
            }
            iterableValues = Arrays.asList((Object[])value);
        } else {
            if (!(value instanceof Iterable)) {
                throw new ConverterException(String.format("Cannot cast %s to Iterable for MappedField: %s", value.getClass(), mf));
            }
            iterableValues = (List<Object>)value;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (mf != null && mf.getSubClass() != null) {
            for (Object t : iterableValues) {
                values.add(this.getMapper().getConverters().encode(mf.getSubClass(), t));
            }
        } else {
            for (Object t : iterableValues) {
                values.add(this.getMapper().getConverters().encode(t));
            }
        }
        return !values.isEmpty() || this.getMapper().getOptions().isStoreEmpties() ? values : null;
    }

    protected boolean isSupported(Class c, MappedField mf) {
        if (mf != null) {
            return mf.isMultipleValues() && !mf.isMap();
        }
        return c.isArray() || ReflectionUtils.implementsInterface(c, Iterable.class);
    }

    private Collection<?> createNewCollection(MappedField mf) {
        ObjectFactory of = this.getMapper().getOptions().getObjectFactory();
        return mf.isSet() ? of.createSet(mf) : of.createList(mf);
    }
}

