/*
 * Decompiled with CFR 0.152.
 */
package com.wxpay.utils;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.wxpay.utils.GetWxOrderno;
import com.wxpay.utils.MD5Util;
import com.wxpay.utils.RequestHandler;
import com.wxpay.utils.Sha1Util;
import com.wxpay.utils.WxPayDto;
import com.wxpay.utils.WxPayResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class WXPayUtil {
    private static Object Server;
    private static String QRfromGoogle;

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static int toInt(Object obj) {
        int a = 0;
        try {
            if (obj != null) {
                a = Integer.parseInt(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a;
    }

    public static String getCurrTime() {
        Date now = new Date();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = outFormat.format(now);
        return s;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String strDate = formatter.format(date);
        return strDate;
    }

    public static int buildRandom(int length) {
        int num = 1;
        double random = Math.random();
        if (random < 0.1) {
            random += 0.1;
        }
        for (int i = 0; i < length; ++i) {
            num *= 10;
        }
        return (int)(random * (double)num);
    }

    public static String getCharacterEncoding(HttpServletRequest request, HttpServletResponse response) {
        if (null == request || null == response) {
            return "gbk";
        }
        String enc = request.getCharacterEncoding();
        if (null == enc || "".equals(enc)) {
            enc = response.getCharacterEncoding();
        }
        if (null == enc || "".equals(enc)) {
            enc = "gbk";
        }
        return enc;
    }

    public static String URLencode(String content) {
        String URLencode = WXPayUtil.replace(Server.equals(content), "+", "%20");
        return URLencode;
    }

    private static String replace(boolean equals, String string, String string2) {
        return null;
    }

    public static long getUnixTime(Date date) {
        if (null == date) {
            return 0L;
        }
        return date.getTime() / 1000L;
    }

    public static String QRfromGoogle(String chl) {
        int widhtHeight = 300;
        String EC_level = "L";
        int margin = 0;
        chl = WXPayUtil.URLencode(chl);
        String QRfromGoogle = "http://chart.apis.google.com/chart?chs=" + widhtHeight + "x" + widhtHeight + "&cht=qr&chld=" + EC_level + "|" + margin + "&chl=" + chl;
        return QRfromGoogle;
    }

    public static String date2String(Date date, String formatType) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatType);
        return sdf.format(date);
    }

    public static SortedMap<String, String> getPackage(WxPayDto wxPayDto) {
        KApplicationProperties.WXConfig wxConfig = SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getWxConfig();
        String totalFee = WXPayUtil.getMoney(wxPayDto.getTotalFee());
        String nonce_str = WXPayUtil.getNonceStr();
        TreeMap<String, String> contentMap = new TreeMap<String, String>();
        contentMap.put("appid", wxConfig.getAppid());
        contentMap.put("body", wxPayDto.getBody());
        contentMap.put("input_charset", "UTF-8");
        contentMap.put("mch_id", wxConfig.getMchid());
        contentMap.put("nonce_str", nonce_str);
        contentMap.put("out_trade_no", wxPayDto.getOrderId());
        contentMap.put("total_fee", totalFee);
        contentMap.put("spbill_create_ip", wxPayDto.getSpbillCreateIp());
        contentMap.put("notify_url", wxConfig.getCallBackUrl());
        contentMap.put("trade_type", "APP");
        RequestHandler reqHandler = new RequestHandler(null, null);
        reqHandler.init(wxConfig.getAppid(), wxConfig.getSecret(), wxConfig.getApiKey());
        String sign = reqHandler.createSign(contentMap);
        contentMap.put("sign", sign);
        String xml = WXPayUtil.paramsToxmlStr(contentMap);
        new GetWxOrderno();
        String prepay_id = GetWxOrderno.getPayNo("https://api.mch.weixin.qq.com/pay/unifiedorder", xml);
        TreeMap<String, String> payMap = new TreeMap<String, String>();
        String timestamp = Sha1Util.getTimeStamp();
        nonce_str = WXPayUtil.getNonceStr();
        contentMap.clear();
        contentMap.put("appid", wxConfig.getAppid());
        contentMap.put("noncestr", nonce_str);
        contentMap.put("package", "Sign=WXPay");
        contentMap.put("partnerid", wxConfig.getMchid());
        contentMap.put("prepayid", prepay_id);
        contentMap.put("timestamp", timestamp);
        payMap.put("appId", wxConfig.getAppid());
        payMap.put("partnerId", wxConfig.getMchid());
        payMap.put("prepayId", prepay_id);
        payMap.put("timeStamp", timestamp);
        payMap.put("nonceStr", nonce_str);
        payMap.put("package", "Sign=WXPay");
        contentMap.put("prepayid", prepay_id);
        payMap.put("sign", reqHandler.createSign(contentMap));
        return payMap;
    }

    public static String getNonceStr() {
        String currTime = WXPayUtil.getCurrTime();
        String strTime = currTime.substring(5, currTime.length());
        String strRandom = WXPayUtil.buildRandom(4) + "";
        return strTime + strRandom;
    }

    public static String getMoney(String amount) {
        if (amount == null) {
            return "";
        }
        String currency = amount.replaceAll("\\$|\\\uffe5|\\,", "");
        int index = currency.indexOf(".");
        int length = currency.length();
        Long amLong = 0L;
        amLong = index == -1 ? Long.valueOf(currency + "00") : (length - index >= 3 ? Long.valueOf(currency.substring(0, index + 3).replace(".", "")) : (length - index == 2 ? Long.valueOf(currency.substring(0, index + 2).replace(".", "") + 0) : Long.valueOf(currency.substring(0, index + 1).replace(".", "") + "00")));
        return amLong.toString();
    }

    public static String createSign(TreeMap<String, String> treeMap, String partnerKey) {
        String string1 = WXPayUtil.originalStr(treeMap, true);
        String stringSignTemp = string1 + "key=" + partnerKey;
        System.out.println("\u7b7e\u540d\u8c03\u8bd5\u8f93\u51fa\uff1a" + stringSignTemp);
        String sign = MD5Util.MD5Encode(stringSignTemp, "UTF-8").toUpperCase();
        return sign;
    }

    public static String originalStr(Map<String, String> treeMap, boolean endTag) {
        Set<Map.Entry<String, String>> entry = treeMap.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> obj : entry) {
            String k = obj.getKey();
            String v = obj.getValue();
            if (StringUtils.isEmpty((Object)v)) continue;
            sb.append(k + "=" + v + "&");
        }
        if (!endTag) {
            String params = sb.substring(0, sb.lastIndexOf("&"));
            return params;
        }
        return sb.toString();
    }

    public static String paramsToxmlStr(Map<String, String> param) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml>");
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                if (entry.getKey().equals("attach") || entry.getKey().equals("body") || entry.getKey().equals("sign")) {
                    buffer.append("<" + entry.getKey() + ">");
                    buffer.append("<![CDATA[" + entry.getValue() + "]]>");
                    buffer.append("</" + entry.getKey() + ">");
                    continue;
                }
                buffer.append("<" + entry.getKey() + ">");
                buffer.append(entry.getValue());
                buffer.append("</" + entry.getKey() + ">");
            }
        }
        buffer.append("</xml>");
        return buffer.toString();
    }

    public static WxPayResult mapToWxPayResult(Map<String, String> m) {
        WxPayResult wpr = new WxPayResult();
        wpr.setAppid(m.get("appid"));
        wpr.setBankType(m.get("bank_type"));
        wpr.setCashFee(m.get("cash_fee"));
        wpr.setFeeType(m.get("fee_type"));
        wpr.setIsSubscribe(m.get("is_subscribe"));
        wpr.setMchId(m.get("mch_id"));
        wpr.setNonceStr(m.get("nonce_str"));
        wpr.setOpenid(m.get("openid"));
        wpr.setOutTradeNo(m.get("out_trade_no"));
        wpr.setResultCode(m.get("result_code"));
        wpr.setReturnCode(m.get("return_code"));
        wpr.setSign(m.get("sign"));
        wpr.setTimeEnd(m.get("time_end"));
        wpr.setTotalFee(m.get("total_fee"));
        wpr.setTradeType(m.get("trade_type"));
        wpr.setTransactionId(m.get("transaction_id"));
        return wpr;
    }
}

