/*
 * Decompiled with CFR 0.152.
 */
package com.wxpay.utils;

import com.wxpay.utils.MD5Util;
import com.wxpay.utils.WXPayUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHandler {
    private String tokenUrl;
    private String gateUrl;
    private String notifyUrl;
    private String appid;
    private String appkey;
    private String partnerkey;
    private String appsecret;
    private String key;
    private SortedMap parameters;
    private String Token;
    private String charset;
    private String debugInfo;
    private String last_errcode = "0";
    private HttpServletRequest request;
    private HttpServletResponse response;

    public RequestHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.charset = "UTF-8";
        this.parameters = new TreeMap();
        this.notifyUrl = "https://gw.tenpay.com/gateway/simpleverifynotifyid.xml";
    }

    public void init(String app_id, String app_secret, String partner_key) {
        this.last_errcode = "0";
        this.Token = "token_";
        this.debugInfo = "";
        this.appid = app_id;
        this.partnerkey = partner_key;
        this.appsecret = app_secret;
        this.key = partner_key;
    }

    public void init() {
    }

    public String getLasterrCode() {
        return this.last_errcode;
    }

    public String getGateUrl() {
        return this.gateUrl;
    }

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return null == s ? "" : s;
    }

    public void setKey(String key) {
        this.partnerkey = key;
    }

    public void setAppKey(String key) {
        this.appkey = key;
    }

    public String UrlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, this.charset).replace("+", "%20");
    }

    public String genPackage(SortedMap<String, String> packageParams) throws UnsupportedEncodingException {
        String sign = this.createSign(packageParams);
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            sb.append(k + "=" + this.UrlEncode(v) + "&");
        }
        String packageValue = sb.append("sign=" + sign).toString();
        return packageValue;
    }

    public String createSign(SortedMap<String, String> packageParams) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.getKey());
        String sign = MD5Util.MD5Encode(sb.toString(), this.charset).toUpperCase();
        return sign;
    }

    public boolean createMd5Sign(String signParams) {
        StringBuffer sb = new StringBuffer();
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("sign".equals(k) || null == v || "".equals(v)) continue;
            sb.append(k + "=" + v + "&");
        }
        String enc = WXPayUtil.getCharacterEncoding(this.request, this.response);
        String sign = MD5Util.MD5Encode(sb.toString(), enc).toLowerCase();
        String tenpaySign = this.getParameter("sign").toLowerCase();
        this.setDebugInfo(sb.toString() + " => sign:" + sign + " tenpaySign:" + tenpaySign);
        return tenpaySign.equals(sign);
    }

    public String parseXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (null == v || "".equals(v) || "appkey".equals(k)) continue;
            sb.append("<" + k + ">" + this.getParameter(k) + "</" + k + ">\n");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public void setPartnerkey(String partnerkey) {
        this.partnerkey = partnerkey;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public String getKey() {
        return this.key;
    }
}

