/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.util;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.config.AlipayConfig;
import com.alipay.sign.RSA;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class AliPayUtil {
    static KApplicationProperties.AliPayConfig aliPayConfig = SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getAliPayConfig();
    public static String APP_ID = aliPayConfig.getAppid();
    public static String APP_PRIVATE_KEY = aliPayConfig.getApp_private_key();
    public static String CHARSET = aliPayConfig.getCharset();
    public static String ALIPAY_PUBLIC_KEY = aliPayConfig.getAlipay_public_key();
    public static String callBackUrl = aliPayConfig.getCallBackUrl();
    public static String PID = aliPayConfig.getPid();
    static AlipayClient alipayClient;

    public static AlipayClient getAliPayClient() {
        if (alipayClient != null) {
            return alipayClient;
        }
        alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", APP_ID, APP_PRIVATE_KEY, "json", CHARSET, ALIPAY_PUBLIC_KEY, "RSA2");
        return alipayClient;
    }

    public static String getOutTradeNo() {
        int r1 = (int)(Math.random() * 10.0);
        int r2 = (int)(Math.random() * 10.0);
        long now = System.currentTimeMillis();
        String id = String.valueOf(r1) + String.valueOf(r2) + String.valueOf(now);
        return id;
    }

    public static String getOrderInfo(String subject, String body, String price, String orderNo) {
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(body);
        model.setSubject(subject);
        model.setOutTradeNo(orderNo);
        model.setTimeoutExpress("30m");
        model.setTotalAmount(price);
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(callBackUrl);
        try {
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)AliPayUtil.getAliPayClient().sdkExecute((AlipayRequest)request);
            System.out.println("\u8fd4\u56deorder  " + response.getBody());
            return response.getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String content) {
        return RSA.sign(content, AlipayConfig.private_key, AlipayConfig.input_charset);
    }

    public static Map<String, String> getAlipayResult(HttpServletRequest request) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }
        return params;
    }

    public String getAuthInfo() throws AlipayApiException {
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AliPayUtil.getAliPayClient().execute((AlipayRequest)request);
        return null;
    }
}

