/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.service;

import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.KSession;
import cn.xyz.mianshi.model.UserLoginTokenKey;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AuthKeys;
import cn.xyz.mianshi.vo.Comment;
import cn.xyz.mianshi.vo.Emoji;
import cn.xyz.mianshi.vo.ForwardAmount;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.mianshi.vo.PlayAmount;
import cn.xyz.mianshi.vo.Praise;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.User;
import com.shiku.redisson.AbstractRedisson;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.redisson.api.GeoUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RGeo;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisServiceImpl
extends AbstractRedisson {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Autowired(required=false)
    private RedissonClient redissonClient;
    public static final String ROOMPUSH_MEMBERLIST = "roomPush_member:%s";
    public static final String ROOMJID_LIST = "roomJidList:%s";
    public static final String ROOM_NOPUSH_Jids = "room_nopushJids:%s";
    public static final String STATIC_NICKNAME = "static:nickname:%s";
    public static final String GET_USER_BY_ACCOUNT = "user:account:%s";
    public static final String USER_ONLINE = "user_online:%s";
    public static final String USER_COLLECT_COMMON = "user_collect:common:%s";
    public static final String USER_COLLECT_EMOTICON = "user_collect:emoticon:%s";
    public static final String FRIENDS_USERIDS = "friends:toUserIds:%s";
    public static final String NOSYSTENNUM_USERIDS = "nosystemnum:userIds";
    public static final String ADDRESSBOOK_USERIDS = "addressBook:userIds";
    public static final String FRIENDS_USERS = "friends:toUsers:%s";
    public static final String S_MSG_COMMENT_MSGID = "s_msg:comment_msgId:%s";
    public static final String S_MSG_PRAISE_MSGID = "s_msg:praise_msgId:%s";
    public static final String S_MSG_PLAY_MSGID = "s_msg:play_msgId:%s";
    public static final String S_MSG_FORWARD_MSGID = "s_msg:forward_msgId:%s";
    public static final String S_MSG_MSGID = "s_msg:msg_msgId:%s";
    public static final String ROOMS = "room:rooms:%s";
    public static final String GEO_LOCATION_ROOM = "locationRoom:%s";
    public static final String GEO_LOCATION_ROOM_ID = "locationRoom:id:%s";
    public static final String ROOM_MEMBERLIST = "room:memberList:%s";
    public static final String ROOM_NOTICELIST = "room:noticeList:%s";
    public static final String ROOM_SHARELIST = "room:shareList:%s";
    public static final String PAY_TRANSACTION_CODE = "transaction:%s:%s";
    public static final String PAY_ORDER_SIGN = "payOrderSign:%s";
    public static final String QRCODE_KEY = "qrCodeKey:%s";
    public static final String AUTH_KEY = "authKey:%s";
    public static final String USER_RANDOM_STR_KEY = "userRandomStr:%s";
    public static final String PAY_QRKEY = "payQrKey:%s";
    public static final String AUTHKEYS_KEY = "authkeys:%s";
    public static final String LOGINCODES_KEY = "LOGINCODES:%s";
    public static final String GET_LOGIN_TOKEN_KEY = "login:loginToken:%s:%s";
    public static final String LOGIN_TOKEN_KEY = "login:loginTokenKeys:%s";
    public static final String GET_SESSON_KEY = "sesson:%s";
    public static final String USER_TOKENKEYS = "loginToken:token:%s:*";
    public static final String GET_MESSAGEKEY_KEY = "messageKey:%s:%s";

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public List<Integer> queryRoomPushMemberUserIds(String jid) {
        String key = String.format(ROOMPUSH_MEMBERLIST, jid);
        RList list = this.redissonClient.getList(key, (Codec)IntegerCodec.INSTANCE);
        return list.readAll();
    }

    public void addRoomPushMember(String jid, Integer userId) {
        String key = String.format(ROOMPUSH_MEMBERLIST, jid);
        RList list = this.redissonClient.getList(key, (Codec)IntegerCodec.INSTANCE);
        if (!list.contains((Object)userId)) {
            list.addAsync((Object)userId);
        }
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public void removeRoomPushMember(String jid, Integer userId) {
        String key = String.format(ROOMPUSH_MEMBERLIST, jid);
        this.redissonClient.getList(key, (Codec)IntegerCodec.INSTANCE).removeAsync((Object)userId);
    }

    public void saveRoom(Room room) {
        String key = String.format(ROOMS, room.getId().toString());
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)room, 86400L, TimeUnit.SECONDS);
    }

    public Room queryRoom(ObjectId roomId) {
        String key = String.format(ROOMS, roomId.toString());
        RBucket bucket = this.redissonClient.getBucket(key);
        if (bucket.isExists()) {
            return (Room)bucket.get();
        }
        return null;
    }

    public void deleteRoom(String roomId) {
        String key = String.format(ROOMS, roomId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<Room.Member> getMemberList(String roomId) {
        String key = String.format(ROOM_MEMBERLIST, roomId);
        RList rList = this.redissonClient.getList(key);
        return rList.readAll();
    }

    public List<Room.Member> getMemberList(String roomId, Integer pageIndex, Integer pageSize) {
        String key = String.format(ROOM_MEMBERLIST, roomId);
        List<Room.Member> redisPageLimit = this.redisPageLimit(key, pageIndex, pageSize);
        return redisPageLimit;
    }

    public void deleteMemberList(String roomId) {
        String key = String.format(ROOM_MEMBERLIST, roomId);
        this.redissonClient.getBucket(key).delete();
    }

    public void saveMemberList(String roomId, List<Room.Member> members) {
        String key = String.format(ROOM_MEMBERLIST, roomId);
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(members);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Room.Notice> getNoticeList(ObjectId roomId) {
        String key = String.format(ROOM_NOTICELIST, roomId.toString());
        RList rList = this.redissonClient.getList(key);
        return rList.readAll();
    }

    public void deleteNoticeList(Object roomId) {
        String key = String.format(ROOM_NOTICELIST, roomId.toString());
        this.redissonClient.getBucket(key).delete();
    }

    public void saveNoticeList(ObjectId roomId, List<Room.Notice> notices) {
        String key = String.format(ROOM_NOTICELIST, roomId.toString());
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(notices);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Room.Share> getShareList(ObjectId roomId, Integer pageIndex, Integer pageSize) {
        String key = String.format(ROOM_SHARELIST, roomId.toString());
        List<Room.Share> redisPageLimit = this.redisPageLimit(key, pageIndex, pageSize);
        return redisPageLimit;
    }

    public void deleteShareList(Object roomId) {
        String key = String.format(ROOM_SHARELIST, roomId.toString());
        this.redissonClient.getBucket(key).delete();
    }

    public void saveShareList(ObjectId roomId, List<Room.Share> shares) {
        String key = String.format(ROOM_SHARELIST, roomId.toString());
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(shares);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Emoji> getUserCollectCommon(Integer userId) {
        String key = String.format(USER_COLLECT_COMMON, userId);
        RList rList = this.redissonClient.getList(key);
        return rList;
    }

    public List<Emoji> getUserCollectCommonLimit(Integer userId, Integer pageIndex, Integer pageSize) {
        String key = String.format(USER_COLLECT_COMMON, userId);
        List<Emoji> redisPageLimit = this.redisPageLimit(key, pageIndex, pageSize);
        return redisPageLimit;
    }

    public void deleteUserCollectCommon(Integer userId) {
        String key = String.format(USER_COLLECT_COMMON, userId);
        this.redissonClient.getBucket(key).delete();
    }

    public void saveUserCollectCommon(Integer userId, List<Emoji> emojis) {
        String key = String.format(USER_COLLECT_COMMON, userId);
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(emojis);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Emoji> getUserCollectEmoticon(Integer userId) {
        String key = String.format(USER_COLLECT_EMOTICON, userId);
        RList rList = this.redissonClient.getList(key);
        return rList;
    }

    public List<Emoji> getUserCollectEmoticonLimit(Integer userId, Integer pageIndex, Integer pageSize) {
        String key = String.format(USER_COLLECT_EMOTICON, userId);
        List<Emoji> redisPageLimit = this.redisPageLimit(key, pageIndex, pageSize);
        return redisPageLimit;
    }

    public void deleteUserCollectEmoticon(Integer userId) {
        String key = String.format(USER_COLLECT_EMOTICON, userId);
        this.redissonClient.getBucket(key).delete();
    }

    public void saveUserCollectEmoticon(Integer userId, List<Emoji> emojis) {
        String key = String.format(USER_COLLECT_EMOTICON, userId);
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(emojis);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public List<String> queryUserRoomJidList(Integer userId) {
        String key = String.format(ROOMJID_LIST, userId);
        RList list = this.redissonClient.getList(key);
        if (0 == list.size()) {
            List<String> roomsJidList = SKBeanUtils.getRoomManager().queryUserRoomsJidList(userId);
            if (0 < roomsJidList.size()) {
                list.addAllAsync(roomsJidList);
                list.expire(604800L, TimeUnit.SECONDS);
            }
            return roomsJidList;
        }
        return list.readAll();
    }

    public void updateUserRoomJidList(Integer userId) {
        String key = String.format(ROOMJID_LIST, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        List<String> roomsJidList = SKBeanUtils.getRoomManager().queryUserRoomsJidList(userId);
        bucket.set(roomsJidList, 604800L, TimeUnit.SECONDS);
    }

    public void deleteUserRoomJidList(Integer userId) {
        String key = String.format(ROOMJID_LIST, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    public void saveUserNickName(String userId, String nickName) {
        String key = String.format(STATIC_NICKNAME, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        if (!StringUtil.isEmpty(nickName)) {
            bucket.set((Object)nickName, 86400L, TimeUnit.SECONDS);
        }
        bucket.deleteAsync();
    }

    public String queryUserNickName(Integer userId) {
        String key = String.format(STATIC_NICKNAME, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public User queryUserByAccount(String account) {
        String key = String.format(GET_USER_BY_ACCOUNT, account);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (User)bucket.get();
    }

    public void saveUserByAccount(String account, User user) {
        String key = String.format(GET_USER_BY_ACCOUNT, account);
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.setAsync((Object)user, 43200L, TimeUnit.SECONDS);
    }

    public void deleteUserByAccount(String account) {
        String key = String.format(GET_USER_BY_ACCOUNT, account);
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.deleteAsync();
    }

    public void saveUserOnline(String userId, int status) {
        String key = String.format(USER_ONLINE, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        if (1 == status) {
            bucket.set((Object)1, 172800L, TimeUnit.SECONDS);
        } else {
            bucket.deleteAsync();
        }
    }

    public int queryUserOnline(Integer userId) {
        String key = String.format(USER_ONLINE, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        if (bucket.isExists()) {
            return 1;
        }
        return 0;
    }

    public List<String> queryNoPushJidLists(Integer userId) {
        String key = String.format(ROOM_NOPUSH_Jids, userId);
        RList list = this.redissonClient.getList(key);
        if (0 == list.size()) {
            List<String> roomsJidList = SKBeanUtils.getRoomManager().queryUserNoPushJidList(userId);
            if (0 < roomsJidList.size()) {
                list.addAllAsync(roomsJidList);
                list.expire(86400L, TimeUnit.SECONDS);
            }
            return roomsJidList;
        }
        return list.readAll();
    }

    public void addToRoomNOPushJids(Integer userId, String jid) {
        String key = String.format(ROOM_NOPUSH_Jids, userId);
        RList list = this.redissonClient.getList(key);
        if (!list.contains((Object)jid)) {
            list.addAsync((Object)jid);
        }
        list.expire(86400L, TimeUnit.SECONDS);
    }

    public void removeToRoomNOPushJids(Integer userId, String jid) {
        String key = String.format(ROOM_NOPUSH_Jids, userId);
        RList list = this.redissonClient.getList(key);
        list.removeAsync((Object)jid);
        list.expire(86400L, TimeUnit.SECONDS);
    }

    public void saveFriendsUserIdsList(Integer userId, List<Integer> friendIds) {
        String key = String.format(FRIENDS_USERIDS, userId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(friendIds);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public void saveNoSystemNumUserIds(List<Integer> userIds) {
        RList list = this.redissonClient.getList(NOSYSTENNUM_USERIDS);
        list.clear();
        list.addAll(userIds);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Integer> getNoSystemNumUserIds() {
        RList list = this.redissonClient.getList(NOSYSTENNUM_USERIDS);
        return list.readAll();
    }

    public void deleteNoSystemNumUserIds() {
        this.redissonClient.getBucket(NOSYSTENNUM_USERIDS).delete();
    }

    public void deleteFriendsUserIdsList(Integer userId) {
        String key = String.format(FRIENDS_USERIDS, userId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<Integer> getFriendsUserIdsList(Integer userId) {
        String key = String.format(FRIENDS_USERIDS, userId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public void saveFriendsList(Integer userId, List<Friends> friends) {
        String key = String.format(FRIENDS_USERS, userId);
        RList bucket = this.redissonClient.getList(key);
        bucket.clear();
        bucket.addAll(friends);
        bucket.expire(604800L, TimeUnit.SECONDS);
    }

    public void deleteFriends(Integer userId) {
        String key = String.format(FRIENDS_USERS, userId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<Friends> getFriendsList(Integer userId) {
        String key = String.format(FRIENDS_USERS, userId);
        RList friendList = this.redissonClient.getList(key);
        return friendList.readAll();
    }

    public void deleteMsgComment(String msgId) {
        String key = String.format(S_MSG_COMMENT_MSGID, msgId);
        this.redissonClient.getBucket(key).delete();
    }

    public void saveMsgComment(String msgId, List<Comment> msgs) {
        String key = String.format(S_MSG_COMMENT_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(msgs);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Comment> getMsgComment(String msgId) {
        String key = String.format(S_MSG_COMMENT_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public void deleteMsgPraise(String msgId) {
        String key = String.format(S_MSG_PRAISE_MSGID, msgId);
        this.redissonClient.getBucket(key).delete();
    }

    public void saveMsgPraise(String msgId, List<Praise> msgs) {
        String key = String.format(S_MSG_PRAISE_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(msgs);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public List<Praise> getMsgPraise(String msgId) {
        String key = String.format(S_MSG_PRAISE_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public void saveMsgPlay(String msgId, List<PlayAmount> playAmounts) {
        String key = String.format(S_MSG_PLAY_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(playAmounts);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public void deleteMsgPlay(String msgId) {
        String key = String.format(S_MSG_PLAY_MSGID, msgId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<PlayAmount> getMsgPlay(String msgId) {
        String key = String.format(S_MSG_PLAY_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public void saveMsgForward(String msgId, List<ForwardAmount> forwardAmounts) {
        String key = String.format(S_MSG_FORWARD_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(forwardAmounts);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public void deleteMsgForward(String msgId) {
        String key = String.format(S_MSG_FORWARD_MSGID, msgId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<ForwardAmount> getMsgForward(String msgId) {
        String key = String.format(S_MSG_FORWARD_MSGID, msgId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public Integer getPaymentCode(String paymentCode) {
        String key = paymentCode;
        RBucket bucket = this.redissonClient.getBucket(key);
        return (Integer)bucket.get();
    }

    public void savePaymentCode(String paymentCode, Integer userId) {
        String key = paymentCode;
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)userId, 600L, TimeUnit.SECONDS);
    }

    public void delAddressBookFriendsUserIds(Integer userId) {
        String key = String.format(ADDRESSBOOK_USERIDS, userId);
        this.redissonClient.getBucket(key).delete();
    }

    public List<Integer> getAddressBookFriendsUserIds(Integer userId) {
        String key = String.format(ADDRESSBOOK_USERIDS, userId);
        RList list = this.redissonClient.getList(key);
        return list.readAll();
    }

    public void saveAddressBookFriendsUserIds(Integer userId, List<Integer> friendIds) {
        String key = String.format(ADDRESSBOOK_USERIDS, userId);
        RList list = this.redissonClient.getList(key);
        list.clear();
        list.addAll(friendIds);
        list.expire(604800L, TimeUnit.SECONDS);
    }

    public synchronized String queryLocationRoomJid(double longitude, double latitude, String password) {
        String key = String.format(GEO_LOCATION_ROOM_ID, password);
        String jid = null;
        RGeo geo = this.redissonClient.getGeo(key);
        List radius = geo.radius(longitude, latitude, 5.0, GeoUnit.KILOMETERS, 1);
        if (0 == radius.size()) {
            jid = StringUtil.randomUUID();
            geo.add(longitude, latitude, (Object)jid);
            geo.expire(10L, TimeUnit.MINUTES);
        } else {
            jid = (String)radius.get(0);
        }
        return jid;
    }

    public Room queryLocationRoom(int userId, double longitude, double latitude, String password, String name) {
        Room result = null;
        String jid = this.queryLocationRoomJid(longitude, latitude, password);
        String key = String.format(GEO_LOCATION_ROOM, jid);
        RBucket bucket = this.redissonClient.getBucket(key);
        result = (Room)bucket.get();
        if (null == result) {
            result = new Room();
            result.setJid(jid);
            Room.Member member = new Room.Member();
            member.setUserId(userId);
            member.setNickname(SKBeanUtils.getUserManager().getNickName(userId));
            if (!StringUtil.isEmpty(name)) {
                result.setName(name);
            } else {
                result.setName(member.getNickname());
            }
            result.addMember(member);
            bucket.set((Object)result);
            bucket.expire(10L, TimeUnit.MINUTES);
        } else {
            Room.Member member = new Room.Member();
            member.setUserId(userId);
            member.setNickname(SKBeanUtils.getUserManager().getNickName(userId));
            result.addMember(member);
            bucket.set((Object)result);
        }
        return result;
    }

    public Room queryLocationRoom(String jid) {
        String key = String.format(GEO_LOCATION_ROOM, jid);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (Room)bucket.get();
    }

    public void saveLocationRoom(String jid, Room room) {
        String key = String.format(GEO_LOCATION_ROOM, jid);
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)room);
    }

    public void exitLocationRoom(int userId, String jid) {
        String key = String.format(GEO_LOCATION_ROOM, jid);
        RBucket bucket = this.redissonClient.getBucket(key);
        if (!bucket.isExists()) {
            return;
        }
        Room room = (Room)bucket.get();
        room.removeMember(userId);
        bucket.set((Object)room);
    }

    public void savePayOrderSign(String orderId, String sign) {
        String key = String.format(PAY_ORDER_SIGN, orderId);
        RBucket rbucket = this.redissonClient.getBucket(key);
        rbucket.set((Object)sign, 86400L, TimeUnit.SECONDS);
    }

    public String queryPayOrderSign(String orderId) {
        String key = String.format(PAY_ORDER_SIGN, orderId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public void saveUserRandomStr(int userId, String userRandomStr) {
        RBucket bucket = this.redissonClient.getBucket(String.format(USER_RANDOM_STR_KEY, userId));
        bucket.set((Object)userRandomStr, 3600L, TimeUnit.SECONDS);
    }

    public String getUserRandomStr(int userId) {
        RBucket bucket = this.redissonClient.getBucket(String.format(USER_RANDOM_STR_KEY, userId));
        return (String)bucket.get();
    }

    public boolean deleteUserRandomStr(int userId) {
        RBucket bucket = this.redissonClient.getBucket(String.format(USER_RANDOM_STR_KEY, userId));
        return bucket.delete();
    }

    public void saveTransactionSignCode(int userId, String codeId, String code) {
        String key = String.format(PAY_TRANSACTION_CODE, userId, codeId);
        RBucket rbucket = this.redissonClient.getBucket(key);
        rbucket.set((Object)code, 60L, TimeUnit.SECONDS);
    }

    public String queryTransactionSignCode(int userId, String codeId) {
        String key = String.format(PAY_TRANSACTION_CODE, userId, codeId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public boolean cleanTransactionSignCode(int userId, String codeId) {
        String key = String.format(PAY_TRANSACTION_CODE, userId, codeId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.delete();
    }

    public void savePayQrKey(int userId, String qrKey) {
        String key = this.buildRedisKey(PAY_QRKEY, new Object[]{userId});
        this.setBucket(key, qrKey, 86400L);
    }

    public String queryPayQrKey(int userId) {
        String key = this.buildRedisKey(PAY_QRKEY, new Object[]{userId});
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public boolean cleanPayQrKey(int userId) {
        return this.deleteBucket(PAY_QRKEY, new Object[]{userId});
    }

    public AuthKeys getAuthKeys(int userId) {
        String key = String.format(AUTHKEYS_KEY, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (AuthKeys)bucket.get();
    }

    public AuthKeys saveAuthKeys(int userId, AuthKeys authKeys) {
        String key = String.format(AUTHKEYS_KEY, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)authKeys, 86400L, TimeUnit.SECONDS);
        return (AuthKeys)bucket.get();
    }

    public boolean deleteAuthKeys(int userId) {
        String key = String.format(AUTHKEYS_KEY, userId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.delete();
    }

    public void saveLoginCode(int userId, String deviceId, String code) {
        String key = String.format(LOGINCODES_KEY, userId, deviceId);
        RBucket rbucket = this.redissonClient.getBucket(key);
        rbucket.set((Object)code, 60L, TimeUnit.SECONDS);
    }

    public String queryLoginSignCode(int userId, String deviceId) {
        String key = String.format(LOGINCODES_KEY, userId, deviceId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public boolean cleanLoginCode(int userId, String deviceId) {
        String key = String.format(LOGINCODES_KEY, userId, deviceId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.delete();
    }

    private void saveLoginToken(int userId, String deviceId, String loginToken) {
        String key = String.format(GET_LOGIN_TOKEN_KEY, userId, deviceId);
        RBucket bucket = this.redissonClient.getBucket(key);
        String oldToken = (String)bucket.get();
        if (!StringUtil.isEmpty(oldToken)) {
            this.cleanLoginTokenKeys(oldToken);
        }
        bucket.set((Object)loginToken, 4233600L, TimeUnit.SECONDS);
    }

    public String queryLoginToken(int userId, String deviceId) {
        String key = String.format(GET_LOGIN_TOKEN_KEY, userId, deviceId);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    public boolean cleanLoginToken(int userId, String deviceId) {
        String key = String.format(GET_LOGIN_TOKEN_KEY, userId, deviceId);
        RBucket bucket = this.redissonClient.getBucket(key);
        this.cleanLoginTokenKeys((String)bucket.get());
        return bucket.delete();
    }

    public void saveLoginTokenKeys(UserLoginTokenKey loginKey) {
        String key = String.format(LOGIN_TOKEN_KEY, loginKey.getLoginToken());
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)loginKey, 4233600L, TimeUnit.SECONDS);
        this.saveLoginToken(loginKey.getUserId(), loginKey.getDeviceId(), loginKey.getLoginToken());
    }

    public UserLoginTokenKey queryLoginTokenKeys(String loginToken) {
        String key = String.format(LOGIN_TOKEN_KEY, loginToken);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (UserLoginTokenKey)bucket.get();
    }

    public boolean cleanLoginTokenKeys(String loginToken) {
        if (StringUtil.isEmpty(loginToken)) {
            return true;
        }
        String key = String.format(LOGIN_TOKEN_KEY, loginToken);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.delete();
    }

    public void saveUserSesson(KSession session) {
        String key = String.format(GET_SESSON_KEY, session.getAccessToken());
        RBucket bucket = this.redissonClient.getBucket(key);
        bucket.set((Object)session, 2592000L, TimeUnit.SECONDS);
        this.saveMessageKey(session.getUserId(), session.getDeviceId(), session.getMessageKey());
    }

    public KSession queryUserSesson(String accessToken) {
        String key = String.format(GET_SESSON_KEY, accessToken);
        RBucket bucket = this.redissonClient.getBucket(key);
        return (KSession)bucket.get();
    }

    public boolean cleanUserSesson(String accessToken) {
        KSession session = this.queryUserSesson(accessToken);
        if (null != session) {
            this.cleanMessageKey(session.getUserId(), session.getDeviceId());
            KSessionUtil.removeAccessTokenByDeviceId(session.getUserId(), session.getDeviceId());
        }
        return this.deleteBucket(GET_SESSON_KEY, new Object[]{accessToken});
    }

    public boolean cleanUserAllLoginInfo(int userId) {
        String patternKey = this.buildRedisKey(USER_TOKENKEYS, new Object[]{userId});
        this.redissonClient.getKeys().getKeysStreamByPattern(patternKey).forEach(key -> {
            String token = (String)this.redissonClient.getBucket(key).get();
            KSession session = this.queryUserSesson(token);
            if (null != session) {
                this.cleanLoginToken(session.getUserId(), session.getDeviceId());
                this.cleanMessageKey(session.getUserId(), session.getDeviceId());
                KSessionUtil.removeAccessTokenByDeviceId(session.getUserId(), session.getDeviceId());
            }
            this.deleteBucket(GET_SESSON_KEY, new Object[]{token});
        });
        return true;
    }

    public void cleanUserInfo(int userId) {
        String patternKey = this.buildRedisKey(USER_TOKENKEYS, new Object[]{userId});
        this.redissonClient.getKeys().getKeysStreamByPattern(patternKey).forEach(key -> {
            String token = (String)this.redissonClient.getBucket(key).get();
            KSession session = this.queryUserSesson(token);
            if (null != session) {
                this.cleanLoginToken(session.getUserId(), session.getDeviceId());
                this.cleanMessageKey(session.getUserId(), session.getDeviceId());
                KSessionUtil.removeAccessTokenByDeviceId(session.getUserId(), session.getDeviceId());
                this.cleanUserSesson(session.getAccessToken());
                KSessionUtil.deleteUserByUserId(userId);
            }
            this.deleteBucket(GET_SESSON_KEY, new Object[]{token});
        });
    }

    public void saveMessageKey(int userId, String deviceId, String messageKey) {
        String key = this.buildRedisKey(GET_MESSAGEKEY_KEY, new Object[]{userId, deviceId});
        this.setBucket(key, messageKey, 2592000L);
    }

    public void cleanMessageKey(int userId, String deviceId) {
        this.deleteBucket(GET_MESSAGEKEY_KEY, new Object[]{userId, deviceId});
    }

    public void saveQRCodeKey(String qrCodeKey, Map<String, String> map) {
        String key = String.format(QRCODE_KEY, qrCodeKey);
        RBucket rbBucket = this.redissonClient.getBucket(key);
        rbBucket.set(map, 120L, TimeUnit.SECONDS);
    }

    public void savaAuthKey(String authKey, Map<String, Object> mapResultStatus) {
        String key = String.format(AUTH_KEY, authKey);
        RBucket rbBucket = this.redissonClient.getBucket(key);
        rbBucket.set(mapResultStatus, 5L, TimeUnit.MINUTES);
    }

    public Object queryQRCodeKey(String qrCodeKey) {
        String key = String.format(QRCODE_KEY, qrCodeKey);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.get();
    }

    public Object queryAuthKey(String authKey) {
        String key = String.format(AUTH_KEY, authKey);
        RBucket bucket = this.redissonClient.getBucket(key);
        return bucket.get();
    }

    public <T> List<T> redisPageLimit(String key, Integer pageIndex, Integer pageSize) {
        int count;
        RList tList = this.redissonClient.getList(key);
        if (tList.size() == 0) {
            return null;
        }
        int toIndex = 0;
        int fromIndex = pageIndex * pageSize;
        toIndex = 0 == pageIndex ? pageSize : (pageIndex + 1) * pageSize;
        if (toIndex >= (count = tList.size())) {
            toIndex = count;
        }
        if (fromIndex > toIndex) {
            return null;
        }
        RList subList = tList.subList(fromIndex, toIndex);
        return subList.readAll();
    }
}

