/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.service;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.Md5Util;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.alibaba.fastjson.JSON;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jivesoftware.smackx.ping.PingManager;
import org.jxmpp.jid.Jid;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="xmppService")
public class KXMPPServiceImpl
implements ApplicationContextAware {
    private List<String> sysUserList = Collections.synchronizedList(new ArrayList());
    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Autowired(required=false)
    private KApplicationProperties.MQConfig mqConfig;
    public static final int OPENREDPAKET = 83;
    public static final int RECEDEREDPAKET = 86;
    public static final int RECEIVETRANSFER = 88;
    public static final int REFUNDTRANSFER = 89;
    public static final int CODEPAYMENT = 90;
    public static final int CODEARRIVAL = 91;
    public static final int CODERECEIPT = 92;
    public static final int CODEERECEIPTARRIVAL = 93;
    public static final int OPENPAYSUCCESS = 97;
    public static final int FILEUPLOAD = 401;
    public static final int DELETEFILE = 402;
    public static final int deleteFriends = 515;
    public static final int joinBlacklist = 513;
    public static final int moveBlacklist = 514;
    public static final int batchAddFriend = 510;
    public static final int registAddressBook = 511;
    public static final int consoleDeleteUsers = 512;
    public static final int multipointLoginDataSync = 800;
    public static final int updatePersonalInfo = 801;
    public static final int updateRoomInfo = 802;
    public static final int AUTHLOGINDEVICE = 810;
    public static final int CHANGE_NICK_NAME = 901;
    public static final int CHANGE_ROOM_NAME = 902;
    public static final int DELETE_MEMBER = 904;
    public static final int DELETE_ROOM = 903;
    public static final int GAG = 906;
    public static final int NEW_MEMBER = 907;
    public static final int NEW_NOTICE = 905;
    public static final int OFFLINE = 908;
    public static final int ONLINE = 909;
    public static final int BARRAGE = 910;
    public static final int GIFT = 911;
    public static final int LIVEPRAISE = 912;
    public static final int SETADMIN = 913;
    public static final int JOINLIVE = 914;
    public static final int SHOWREAD = 915;
    public static final int RoomNeedVerify = 916;
    public static final int RoomIsPublic = 917;
    public static final int RoomShowMember = 918;
    public static final int RoomAllowSendCard = 919;
    public static final int RoomAllBanned = 920;
    public static final int RoomAllowInviteFriend = 921;
    public static final int RoomAllowUploadFile = 922;
    public static final int RoomAllowConference = 923;
    public static final int RoomAllowSpeakCourse = 924;
    public static final int RoomTransfer = 925;
    public static final int RoomDisable = 926;
    public static final int LiveRoomSignOut = 927;
    public static final int LiveRoomBannedSpeak = 928;
    public static final int LiveRoomSettingAdmin = 929;
    public static final int SetRoomSettingInvisibleGuardian = 930;
    public static final int consoleProhibitRoom = 931;
    public static final int ChatRecordTimeOut = 932;
    public static final int LocationRoom = 933;
    public static final int ModifyNotice = 934;
    public static final int ModifyEncryptType = 935;
    public static final int RemoveLiveRoom = 936;
    public static final int PRAISE = 301;
    public static final int COMMENT = 302;
    public static final int CANCELPRAISE = 303;
    public static final int REMIND = 304;
    public static final Set<Integer> liveRoomType = new HashSet<Integer>(){
        {
            this.add(910);
            this.add(911);
            this.add(912);
            this.add(913);
            this.add(914);
            this.add(927);
            this.add(928);
            this.add(929);
            this.add(936);
        }
    };
    private static ApplicationContext context;
    private static final Logger log;
    @Autowired(required=false)
    private KApplicationProperties.XMPPConfig xmppConfig;
    @Autowired(required=false)
    @Qualifier(value="dsForTigase")
    private Datastore dsForTigase;
    private XMPPTCPConnection connection;
    private XMPPTCPConnectionConfiguration config;

    public static KXMPPServiceImpl getInstance() {
        return (KXMPPServiceImpl)context.getBean(KXMPPServiceImpl.class);
    }

    public void send(MessageBean messageBean) {
        if (StringUtil.isEmpty(messageBean.getMessageId())) {
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        try {
            SendResult result = this.rocketMQTemplate.syncSend("xmppMessage", (Object)messageBean.toString());
            if (SendStatus.SEND_OK != result.getSendStatus()) {
                System.out.println("\u53d1\u9001\u5931\u8d25   " + result.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(MessageBean messageBean, List<Integer> userIdList) {
        if (StringUtil.isEmpty(messageBean.getMessageId())) {
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        for (Integer i : userIdList) {
            messageBean.setToUserId(i.toString());
            messageBean.setToUserName(SKBeanUtils.getUserManager().getNickName(i));
            messageBean.setMsgType(0);
            this.send(messageBean);
        }
    }

    private synchronized XMPPTCPConnectionConfiguration getConfig() {
        if (null == this.config) {
            SmackConfiguration.setDefaultReplyTimeout((int)15000);
            AccountManager.sensitiveOperationOverInsecureConnectionDefault((boolean)true);
            PingManager.setDefaultPingInterval((int)10);
            try {
                this.config = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setCompressionEnabled(true).setSendPresence(false)).setXmppDomain(this.xmppConfig.getServerName())).setHostAddress(InetAddress.getByName(this.xmppConfig.getHost()))).setPort(this.xmppConfig.getPort())).setResource((CharSequence)"Smack")).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.config;
    }

    public synchronized XMPPTCPConnection getAdminConnection() {
        XMPPTCPConnection conn = null;
        try {
            conn = new XMPPTCPConnection(this.getConfig());
            conn.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public void register() {
        Object conn = null;
        try {
            if (!conn.isConnected()) {
                conn.connect();
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("username", this.xmppConfig.getUsername());
            attributes.put("password", Md5Util.md5Hex(this.xmppConfig.getPassword()));
            Registration reg = new Registration(attributes);
            reg.setType(IQ.Type.set);
            reg.setTo((Jid)conn.getXMPPServiceDomain());
            Stanza nextResultOrThrow = conn.createStanzaCollectorAndSend((StanzaFilter)new StanzaIdFilter(reg.getStanzaId()), (Stanza)reg).nextResultOrThrow();
            System.out.println(nextResultOrThrow.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerSystemNo(String userId, String password) throws Exception {
        String user_id;
        BasicDBObject query;
        DBCollection collection = this.dsForTigase.getDB().getCollection("tig_users");
        if (null != collection.findOne((DBObject)(query = new BasicDBObject("user_id", (Object)(user_id = userId + "@" + this.xmppConfig.getServerName()))))) {
            System.out.println(userId + "  \u5df2\u7ecf\u6ce8\u518c\u4e86!");
            return;
        }
        this.registerAndXmppVersion(userId, password);
        System.out.println("  \u6ce8\u518c\u5230 Tigase  " + this.xmppConfig.getServerName() + "," + userId + "," + password);
    }

    public void registerAndXmppVersion(String userId, String password) {
    }

    @Deprecated
    public void updateToTig(String userId, String password) {
    }

    public void changePassword(String username, String password, String newPassword) {
    }

    public void deleteXmppUser(String username) {
    }

    public void joinMucRoom(String roomJid, String userName, String password) {
    }

    public void destroyMucRoom(String userId, String password, String roomJid) {
    }

    public void joinMucRoom(String roomJid) {
    }

    public void sendMsgToMucRoom(MessageBean messageBean, String ... roomJidArr) {
        Object message = null;
        if (StringUtil.isEmpty(messageBean.getMessageId())) {
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        for (String jid : roomJidArr) {
            try {
                messageBean.setMsgType(1);
                messageBean.setRoomJid(jid);
                messageBean.setTo(jid);
                SendResult result = this.rocketMQTemplate.syncSend("xmppMessage", (Object)messageBean.toString());
                if (SendStatus.SEND_OK == result.getSendStatus()) continue;
                System.out.println(result.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String createMucRoom(String password, String userId, String roomName, String roomSubject, String roomDesc) {
        String roomId = UUID.randomUUID().toString().replaceAll("-", "");
        return roomId;
    }

    public String createChatRoom(String nickName, String roomName, String subject, String max) {
        String jid = UUID.randomUUID().toString().replaceAll("-", "");
        return jid;
    }

    public String getMucChatServiceName(XMPPTCPConnection connection) {
        return "@muc." + connection.getXMPPServiceDomain();
    }

    public void sendMsgToGroupByJid(final String jid, final MessageBean messageBean) throws Exception {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.this.sendMsgToMucRoom(messageBean, jid);
            }
        });
    }

    public void sendManyMsgToGroupByJid(String jid, List<MessageBean> messageList) {
        try {
            for (MessageBean messageBean : messageList) {
                this.sendMsgToMucRoom(messageBean, jid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(final List<Integer> userIdList, final List<MessageBean> messageList) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                try {
                    for (MessageBean messageBean : messageList) {
                        Iterator iterator = userIdList.iterator();
                        while (iterator.hasNext()) {
                            int userId = (Integer)iterator.next();
                            messageBean.setMsgType(0);
                            if (!messageBean.getToUserId().equals(String.valueOf(userId))) continue;
                            KXMPPServiceImpl.this.send(messageBean);
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.out.println("\u53d1\u9001\u63a8\u9001\u5931\u8d25!");
                }
            }
        });
    }

    public void pushAuthLoginDeviceMessage(Integer userId, String strKey) {
        try {
            MessageBean messageBean = new MessageBean();
            messageBean.setType(810);
            messageBean.setTo(userId.toString());
            messageBean.setFromUserId(userId.toString());
            messageBean.setFromUserName("localhost");
            messageBean.setMsgType(0);
            messageBean.setContent(strKey);
            messageBean.setMessageId(StringUtil.randomUUID());
            this.send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    private byte[] generateId(String username) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(username.getBytes());
    }

    static {
        log = Logger.getLogger(KXMPPServiceImpl.class.getName());
    }

    public static class MessageBean {
        private Object content;
        private String fileName;
        private String fromUserId = "10005";
        private String fromUserName = "10005";
        private Object objectId;
        private long timeSend = System.currentTimeMillis();
        private String toUserId;
        private String toUserName;
        private int fileSize;
        private int type;
        private String messageId;
        private String other;
        private int msgType;
        private String roomJid;
        private String to;

        public Object getContent() {
            return this.content;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFromUserId() {
            return this.fromUserId;
        }

        public String getFromUserName() {
            return this.fromUserName;
        }

        public Object getObjectId() {
            return this.objectId;
        }

        public long getTimeSend() {
            return this.timeSend;
        }

        public String getToUserId() {
            return this.toUserId;
        }

        public String getToUserName() {
            return this.toUserName;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        public int getType() {
            return this.type;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFromUserId(String fromUserId) {
            this.fromUserId = fromUserId;
        }

        public void setFromUserName(String fromUserName) {
            this.fromUserName = fromUserName;
        }

        public void setObjectId(Object objectId) {
            this.objectId = objectId;
        }

        public void setTimeSend(long timeSend) {
            this.timeSend = timeSend;
        }

        public void setToUserId(String toUserId) {
            this.toUserId = toUserId;
        }

        public void setToUserName(String toUserName) {
            this.toUserName = toUserName;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public void setMsgType(int msgType) {
            this.msgType = msgType;
        }

        public String getRoomJid() {
            return this.roomJid;
        }

        public void setRoomJid(String roomJid) {
            this.roomJid = roomJid;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }
}

