/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.service;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.jedis.RedisCRUD;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.HttpUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.utils.SMSVerificationUtils;
import cn.xyz.mianshi.vo.Config;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KSMSServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(KSMSServiceImpl.class);
    private String app_id = "";
    private String app_secret = "";
    private String app_template_id_invite = "";
    private String app_template_id_random = "";
    public static final String SMS_ALI = "aliyun";
    public static final String SMS_TTGJ = "ttgj";
    public static final String vaildTimes = "vaildTimes";

    public static RedisCRUD getRedisCRUD() {
        return SKBeanUtils.getRedisCRUD();
    }

    public String getSmsCode(String telephone) {
        String key = String.format("KSMSService:randcode:%s", telephone);
        String _randcode = KSMSServiceImpl.getRedisCRUD().get(key);
        JSONObject parseObject = JSONObject.parseObject((String)_randcode);
        if (null == parseObject) {
            throw new ServiceException(1040104);
        }
        return parseObject.getString(telephone);
    }

    public boolean isAvailable(String telephone, String randcode) {
        String key = String.format("KSMSService:randcode:%s", telephone);
        String _randcode = KSMSServiceImpl.getRedisCRUD().get(key);
        JSONObject parseObject = JSONObject.parseObject((String)_randcode);
        if (null == parseObject) {
            throw new ServiceException(1040104);
        }
        Object effectiveCode = parseObject.get((Object)telephone);
        int codeTimes = (Integer)parseObject.get((Object)vaildTimes);
        ConcurrentMap codeMap = Maps.newConcurrentMap();
        if (--codeTimes < 0) {
            KSMSServiceImpl.getRedisCRUD().del(key);
            throw new ServiceException(1040104);
        }
        codeMap.put(vaildTimes, codeTimes);
        codeMap.put(telephone, effectiveCode);
        KSMSServiceImpl.getRedisCRUD().setObject(key, JSONObject.toJSONString((Object)codeMap), 180);
        return randcode.equals(effectiveCode);
    }

    public void deleteSMSCode(String telephone) {
        String key = String.format("KSMSService:randcode:%s", telephone);
        KSMSServiceImpl.getRedisCRUD().del(key);
    }

    public boolean checkImgCode(String telephone, String imgCode) {
        String key = String.format("KSMSService:imgcode:%s", telephone);
        String cached = KSMSServiceImpl.getRedisCRUD().get(key);
        return imgCode.toUpperCase().equals(cached);
    }

    public String sendSmsToInternational(String telephone, String areaCode, String language) {
        Config config = SKBeanUtils.getAdminManager().getConfig();
        String key = String.format("KSMSService:randcode:%s", telephone);
        Long ttl = KSMSServiceImpl.getRedisCRUD().ttl(key);
        String code = KSMSServiceImpl.getRedisCRUD().get(key);
        if (ttl > 120L) {
            String msg = ConstantUtil.getMsgByCode("1040106", language);
            msg = MessageFormat.format(msg, ttl - 120L);
            log.info("msg : " + msg);
            throw new ServiceException(msg);
        }
        if (null == code) {
            code = StringUtil.randomCode();
        } else {
            JSONObject parseObject = JSONObject.parseObject((String)code);
            code = parseObject.getString(telephone);
            log.info(" redis code is : {}", (Object)code);
        }
        String smsCode = code;
        ThreadUtil.executeInThread(obj -> {
            log.info("SMSCONFIG:" + JSONObject.toJSONString((Object)SKBeanUtils.getSmsConfig()) + "  smsCode : " + smsCode);
            if (1 == SKBeanUtils.getSmsConfig().getOpenSMS()) {
                if (SMS_ALI.equals(config.getSMSType())) {
                    this.aliSMS(telephone, language, smsCode, areaCode, key);
                } else if (SMS_TTGJ.equals(config.getSMSType())) {
                    this.ttgjSMS(telephone, areaCode, language, smsCode, key);
                }
            } else {
                ConcurrentMap map = Maps.newConcurrentMap();
                map.put(telephone, smsCode);
                map.put(vaildTimes, 3);
                String jsonString = JSONObject.toJSONString((Object)map);
                KSMSServiceImpl.getRedisCRUD().setObject(key, jsonString, 180);
            }
        });
        return code;
    }

    public void ttgjSMS(String telephone, String areaCode, String language, String smsCode, String key) {
        String msgId = SMSVerificationUtils.sendSmsToMs360(telephone, areaCode, smsCode);
        if (!StringUtil.isEmpty(msgId)) {
            if ("-".equals(msgId.substring(0, 1))) {
                log.info("    \u53d1\u9001\u77ed\u4fe1\u9519\u8bef      msgId=====>" + msgId);
                throw new ServiceException(1040105, language);
            }
        } else {
            throw new ServiceException(1040105, language);
        }
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put(telephone, smsCode);
        map.put(vaildTimes, 3);
        String jsonString = JSONObject.toJSONString((Object)map);
        KSMSServiceImpl.getRedisCRUD().setObject(key, jsonString, 180);
    }

    public void aliSMS(String telephone, String language, String smsCode, String areaCode, String key) {
        try {
            SendSmsResponse sendSms = SMSVerificationUtils.sendSms(telephone, smsCode, areaCode);
            if (null != sendSms && "OK".equals(sendSms.getCode())) {
                ConcurrentMap map = Maps.newConcurrentMap();
                map.put(telephone, smsCode);
                map.put(vaildTimes, 3);
                String jsonString = JSONObject.toJSONString((Object)map);
                KSMSServiceImpl.getRedisCRUD().setObject(key, jsonString, 180);
            }
            if (!StringUtil.isEmpty(sendSms.getCode()) && !"OK".equals(sendSms.getCode())) {
                throw new ServiceException(sendSms.getCode(), sendSms.getMessage(), language);
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    public JSONMessage applyVerify(String telephone) {
        JSONMessage jMessage;
        String key = MessageFormat.format("randcode:{0}", telephone);
        Long ttl = KSMSServiceImpl.getRedisCRUD().ttl(key);
        if (ttl > 0L) {
            throw new ServiceException("\u8bf7\u4e0d\u8981\u9891\u7e41\u8bf7\u6c42\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u7b49\u5f85" + ttl + "\u79d2\u540e\u518d\u6b21\u8bf7\u6c42");
        }
        try {
            String param1 = StringUtil.randomCode();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("param1", param1);
            Result result = this.sendSms(this.app_template_id_random, telephone, params);
            if ("0".equals(result.getRes_code())) {
                HashMap<String, String> data = new HashMap<String, String>(1);
                data.put("randcode", param1);
                jMessage = JSONMessage.success(null, data);
                KSMSServiceImpl.getRedisCRUD().setObject(key, param1, 120);
            } else {
                jMessage = JSONMessage.failure(result.getRes_message());
            }
        }
        catch (Exception e) {
            jMessage = JSONMessage.failureByErrCode(1020101);
        }
        return jMessage;
    }

    public String getApp_id() {
        return this.app_id;
    }

    public String getApp_secret() {
        return this.app_secret;
    }

    public String getApp_template_id_invite() {
        return this.app_template_id_invite;
    }

    public String getApp_template_id_random() {
        return this.app_template_id_random;
    }

    public String getToken() throws Exception {
        Result result;
        String token = KSMSServiceImpl.getRedisCRUD().get("open.189.access_token");
        if (StringUtil.isNullOrEmpty(token) && "0".equals((result = this.getTokenObj()).getRes_code())) {
            KSMSServiceImpl.getRedisCRUD().setWithExpireTime("open.189.access_token", result.getAccess_token(), result.getExpires_in());
            token = result.getAccess_token();
        }
        return token;
    }

    public Result getTokenObj() throws Exception {
        HttpUtil.Request request = new HttpUtil.Request();
        request.setSpec("https://oauth.api.189.cn/emp/oauth2/v3/access_token");
        request.setMethod(HttpUtil.RequestMethod.POST);
        request.getData().put("grant_type", "client_credentials");
        request.getData().put("app_id", this.app_id);
        request.getData().put("app_secret", this.app_secret);
        Result result = (Result)HttpUtil.asBean(request, Result.class);
        return result;
    }

    public JSONMessage sendInvite(String telephone, String companyName, String username, String password) {
        JSONMessage jMessage;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("param1", companyName);
            params.put("param2", username);
            params.put("param3", password);
            Result result = this.sendSms(this.app_template_id_invite, telephone, params);
            jMessage = "0".equals(result.getRes_code()) ? JSONMessage.success() : JSONMessage.failure(result.getRes_message());
        }
        catch (Exception e) {
            jMessage = JSONMessage.failureByErrCode(1020101);
        }
        return jMessage;
    }

    private Result sendSms(String template_id, String telephone, Map<String, String> params) throws Exception {
        HttpUtil.Request request = new HttpUtil.Request();
        request.setSpec("http://api.189.cn/v2/emp/templateSms/sendSms");
        request.setMethod(HttpUtil.RequestMethod.POST);
        request.getData().put("app_id", this.app_id);
        request.getData().put("access_token", this.getToken());
        request.getData().put("acceptor_tel", telephone);
        request.getData().put("template_id", template_id);
        request.getData().put("template_param", JSON.toJSONString(params));
        request.getData().put("timestamp", DateUtil.getFullString());
        return (Result)HttpUtil.asBean(request, Result.class);
    }

    public static class Result {
        private String access_token;
        private Integer expires_in;
        private String idertifier;
        private String res_code;
        private String res_message;

        public String getAccess_token() {
            return this.access_token;
        }

        public Integer getExpires_in() {
            return this.expires_in;
        }

        public String getIdertifier() {
            return this.idertifier;
        }

        public String getRes_code() {
            return this.res_code;
        }

        public String getRes_message() {
            return this.res_message;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public void setExpires_in(Integer expires_in) {
            this.expires_in = expires_in;
        }

        public void setIdertifier(String idertifier) {
            this.idertifier = idertifier;
        }

        public void setRes_code(String res_code) {
            this.res_code = res_code;
        }

        public void setRes_message(String res_message) {
            this.res_message = res_message;
        }
    }
}

