/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.service;

import cn.xyz.commons.utils.LoginPassword;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.KSession;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.shiku.utils.Base64;
import com.shiku.utils.ParamsSign;
import com.shiku.utils.encrypt.AES;
import com.shiku.utils.encrypt.MAC;
import com.shiku.utils.encrypt.MD5;
import com.shiku.utils.encrypt.RSA;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServiceUtils {
    private static String apiKey = null;
    private static Logger logger = LoggerFactory.getLogger(AuthServiceUtils.class);

    public static String getApiKey() {
        if (null == apiKey) {
            apiKey = SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getAppConfig().getApiKey();
        }
        return apiKey;
    }

    private static boolean checkMacSign(String mac, String serverMac, byte[] decode) {
        try {
            return Arrays.equals(Base64.decode((String)mac), MAC.encode((byte[])serverMac.getBytes(), (byte[])decode));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkMacSignBase64(String mac, String serverMac, String macKey) {
        try {
            return Arrays.equals(Base64.decode((String)mac), MAC.encode((byte[])serverMac.getBytes(), (byte[])Base64.decode((String)macKey)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkMacSign(String mac, StringBuffer serverMac, String macKey) {
        return AuthServiceUtils.checkMacSign(mac, serverMac.toString(), macKey.getBytes());
    }

    private static boolean checkMacSign(String mac, StringBuffer serverMac, byte[] macKey) {
        return AuthServiceUtils.checkMacSign(mac, serverMac.toString(), macKey);
    }

    private static JSONObject checkMacSign(JSONObject jsonObject, String mac, StringBuffer serverMac, byte[] macKey) {
        if (AuthServiceUtils.checkMacSign(mac, serverMac.toString(), macKey)) {
            return jsonObject;
        }
        return null;
    }

    public static boolean authOpenApiByMac(Map<String, String> paramMap) {
        String mac = paramMap.remove("secret");
        if (StringUtil.isEmpty(mac)) {
            return false;
        }
        String salt = paramMap.remove("salt");
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        String apiKey = AuthServiceUtils.getApiKey();
        macStrBuf.append(apiKey).append(paramStr).append(salt);
        return AuthServiceUtils.checkMacSign(mac, macStrBuf.toString(), MD5.encrypt((String)apiKey));
    }

    public static boolean authRequestApiByMac(Map<String, String> paramMap) {
        String mac = paramMap.remove("secret");
        if (StringUtil.isEmpty(mac)) {
            return false;
        }
        String salt = paramMap.remove("salt");
        String accessToken = paramMap.remove("access_token");
        KSession session = SKBeanUtils.getRedisService().queryUserSesson(accessToken);
        if (null == session) {
            return false;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(session.getUserId()).append(accessToken).append(paramStr).append(salt);
        ReqUtil.setLoginedUserId(session.getUserId());
        return AuthServiceUtils.checkMacSignBase64(mac, macStrBuf.toString(), session.getHttpKey());
    }

    public static JSONObject authApiKeyCheckSign(String data, String salt) {
        byte[] deCode = MD5.encrypt((String)AuthServiceUtils.getApiKey());
        JSONObject jsonObject = AuthServiceUtils.decodeDataToJson(data, deCode);
        Map<String, String> paramMap = AuthServiceUtils.jsonObjToStrMap(jsonObject);
        String mac = paramMap.remove("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(paramStr).append(salt);
        return AuthServiceUtils.checkMacSign(jsonObject, mac, macStrBuf, deCode);
    }

    public static JSONObject decodeApiKeyDataJson(String data) {
        String jsonStr;
        try {
            jsonStr = AES.decryptStringFromBase64((String)data, (byte[])MD5.encrypt((String)AuthServiceUtils.getApiKey()));
        }
        catch (Exception e) {
            logger.error("AES \u89e3\u5bc6\u5931\u8d25  ====\u300b  {}", (Object)e.getMessage());
            return null;
        }
        logger.info(jsonStr);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        String sign = jsonObj.getString("mac");
        if (StringUtil.isEmpty(sign)) {
            return null;
        }
        return jsonObj;
    }

    public static boolean authTransactiongetCode(String userId, String token, String salt, String mac, String payPwd) {
        String macValue = AuthServiceUtils.getApiKey() + userId + token + salt;
        return AuthServiceUtils.checkMacSign(mac, macValue, payPwd.getBytes());
    }

    public static boolean authLogingetCode(String account, String salt, String mac, String password, int userId) {
        String macValue = AuthServiceUtils.getApiKey() + account + salt;
        boolean flag = false;
        flag = AuthServiceUtils.checkMacSign(mac, macValue, password.getBytes());
        if (!flag && (flag = AuthServiceUtils.checkMacSign(mac, macValue, (password = LoginPassword.encodeFromOldPassword(password)).getBytes()))) {
            SKBeanUtils.getUserManager().resetPassword(userId, password);
        }
        return flag;
    }

    public static JSONObject authUserLoginCheck(int userId, String data, String salt, String password, byte[] deCode) {
        JSONObject jsonObj = AuthServiceUtils.decodeDataToJson(data, deCode);
        if (null == jsonObj) {
            return null;
        }
        Map<String, String> paramMap = AuthServiceUtils.jsonObjToStrMap(jsonObj);
        if (null == paramMap) {
            return null;
        }
        String mac = paramMap.remove("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(paramStr).append(salt).append(password);
        if (AuthServiceUtils.checkMacSign(mac, macStrBuf.toString(), deCode)) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authUserAutoLoginCheck(int userId, String loginToken, String loginKey, String salt, String data) {
        byte[] decode = Base64.decode((String)loginKey);
        JSONObject jsonObj = AuthServiceUtils.decodeDataToJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        Map<String, String> paramMap = AuthServiceUtils.jsonObjToStrMap(jsonObj);
        if (null == paramMap) {
            return null;
        }
        String mac = paramMap.remove("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(loginToken).append(paramStr).append(salt);
        if (Arrays.equals(Base64.decode((String)mac), MAC.encode((byte[])macStrBuf.toString().getBytes(), (byte[])decode))) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authSmsLoginCheck(String account, byte[] decode, String data, String salt) {
        JSONObject jsonObj = AuthServiceUtils.decodeDataToJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        Map<String, String> paramMap = AuthServiceUtils.jsonObjToStrMap(jsonObj);
        if (null == paramMap) {
            return null;
        }
        String mac = paramMap.remove("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(account).append(paramStr).append(salt);
        return AuthServiceUtils.checkMacSign(jsonObj, mac, macStrBuf, decode);
    }

    public static JSONObject authWxLoginCheck(JSONObject jsonObj, String data, String salt) {
        byte[] decode = MD5.encrypt((String)AuthServiceUtils.getApiKey());
        Map<String, String> paramMap = AuthServiceUtils.jsonObjToStrMap(jsonObj);
        if (null == paramMap) {
            return null;
        }
        String mac = paramMap.remove("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        String paramStr = ParamsSign.joinValues(paramMap);
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(paramStr).append(salt);
        return AuthServiceUtils.checkMacSign(jsonObj, mac, macStrBuf, decode);
    }

    public static boolean authUploadLoginKeyPair(String account, String publicKey, String privateKey, String salt, String mac, String password) {
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(account).append(privateKey).append(publicKey).append(salt);
        return AuthServiceUtils.checkMacSign(mac, macStrBuf, password.getBytes());
    }

    public static boolean checkResetPayPassWordSign(int userId, String token, String mac, String salt, String smsCode) {
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token).append(salt);
        try {
            return Arrays.equals(Base64.decode((String)mac), MAC.encode((byte[])macStrBuf.toString().getBytes(), (byte[])MD5.encrypt((String)smsCode)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkUserUploadPayKeySign(String privateKey, String publicKey, String macKey, String payPwd) {
        byte[] priKeyArr = Base64.decode((String)privateKey);
        byte[] pubKeyArr = Base64.decode((String)publicKey);
        byte[] macVue = Arrays.copyOf(priKeyArr, priKeyArr.length + pubKeyArr.length);
        System.arraycopy(pubKeyArr, 0, macVue, priKeyArr.length, pubKeyArr.length);
        try {
            return Arrays.equals(Base64.decode((String)macKey), MAC.encode((byte[])macVue, (String)payPwd));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkUserUploadMsgKeySign(String mac, String telephone, String password) {
        try {
            byte[] bytesMD5 = Base64.decode((String)password);
            byte[] key = AES.encrypt((byte[])AuthServiceUtils.getApiKey().getBytes(), (byte[])bytesMD5);
            System.out.println(Base64.encode((byte[])key));
            Base64.encode((byte[])MAC.encode((byte[])key, (byte[])telephone.getBytes()));
            return Arrays.equals(Base64.decode((String)mac), MAC.encode((byte[])key, (byte[])telephone.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] getPayCodeById(int userId, String codeId) {
        String code = SKBeanUtils.getRedisService().queryTransactionSignCode(userId, codeId);
        if (StringUtil.isEmpty(code)) {
            return null;
        }
        SKBeanUtils.getRedisService().cleanTransactionSignCode(userId, codeId);
        return Base64.decode((String)code);
    }

    public static Map<String, String> jsonObjToStrMap(JSONObject jsonObject) {
        return jsonObject.getInnerMap().entrySet().stream().collect(Collectors.toMap(obj -> (String)obj.getKey(), obj -> obj.getValue().toString()));
    }

    public static Map<String, String> objMapToStrMap(Map<String, Object> objMap) {
        return objMap.entrySet().stream().collect(Collectors.toMap(obj -> (String)obj.getKey(), obj -> obj.getValue().toString()));
    }

    public static JSONObject decodeDataToJson(String data, byte[] decode) {
        String jsonStr;
        try {
            jsonStr = AES.decryptStringFromBase64((String)data, (byte[])decode);
        }
        catch (Exception e) {
            logger.error("AES \u89e3\u5bc6\u5931\u8d25  ====\u300b  {}", (Object)e.getMessage());
            return null;
        }
        logger.info(jsonStr);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        return jsonObj;
    }

    private static JSONObject decodePayDataJson(String data, byte[] decode) {
        String jsonStr;
        try {
            jsonStr = AES.decryptStringFromBase64((String)data, (byte[])decode);
        }
        catch (Exception e) {
            logger.error("AES \u89e3\u5bc6\u5931\u8d25  ====\u300b  {}", (Object)e.getMessage());
            return null;
        }
        logger.info(jsonStr);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        String sign = jsonObj.getString("mac");
        if (StringUtil.isEmpty(sign)) {
            return null;
        }
        return jsonObj;
    }

    public static Map<String, String> decodePayDataJsonToMap(String data, byte[] decode) {
        String jsonStr;
        try {
            jsonStr = AES.decryptStringFromBase64((String)data, (byte[])decode);
        }
        catch (Exception e) {
            logger.error("AES \u89e3\u5bc6\u5931\u8d25  ====\u300b  {}", (Object)e.getMessage());
            return null;
        }
        logger.info(jsonStr);
        return (Map)JSONObject.parseObject((String)jsonStr, (Type)new TypeReference<Map<String, String>>(){}.getType(), (Feature[])new Feature[0]);
    }

    private static JSONObject checkAuthRSA(JSONObject jsonObj, StringBuffer macStrBuf, String payPwd, String publicKey, byte[] decode) {
        String sign = jsonObj.getString("mac");
        macStrBuf.append(jsonObj.get((Object)"time")).append(payPwd);
        if (RSA.verifyFromBase64((String)macStrBuf.toString(), (byte[])Base64.decode((String)publicKey), (String)sign)) {
            return jsonObj;
        }
        return null;
    }

    private static JSONObject checkAuthMac(JSONObject jsonObj, StringBuffer macStrBuf, String payPwd, byte[] decode) {
        String mac = jsonObj.getString("mac");
        if (StringUtil.isEmpty(mac)) {
            return null;
        }
        macStrBuf.append(jsonObj.get((Object)"time")).append(payPwd);
        return AuthServiceUtils.checkMacSign(jsonObj, mac, macStrBuf, decode);
    }

    public static JSONObject authSendRedPacketByMac(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        int type = jsonObj.getIntValue("type");
        int count = jsonObj.getIntValue("count");
        String moneyStr = jsonObj.getString("moneyStr");
        String greetings = jsonObj.getString("greetings");
        String roomJid = jsonObj.getString("roomJid");
        int toUserId = jsonObj.getIntValue("toUserId");
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(type).append(moneyStr).append(count).append(greetings);
        if (!StringUtil.isEmpty(roomJid)) {
            macStrBuf.append(roomJid);
        } else {
            macStrBuf.append(toUserId);
        }
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null == jsonObj) {
            return null;
        }
        jsonObj.put("money", (Object)moneyStr);
        return jsonObj;
    }

    public static JSONObject authSendTransfer(int userId, String token, String data, String codeId, String payPwd) {
        String publicKey;
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"toUserId")).append(jsonObj.get((Object)"money"));
        if (!StringUtil.isEmpty(jsonObj.getString("remark"))) {
            macStrBuf.append(jsonObj.getString("remark"));
        }
        if (null != (jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId), decode))) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authQrCodeTransfer(int userId, String token, String data, String codeId, String payPwd) {
        String publicKey;
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"toUserId")).append(jsonObj.get((Object)"money"));
        if (!StringUtil.isEmpty(jsonObj.getString("desc"))) {
            macStrBuf.append(jsonObj.getString("desc"));
        }
        if (null != (jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId), decode))) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authOrderPay(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"appId")).append(jsonObj.get((Object)"prepayId"));
        macStrBuf.append(jsonObj.getString("sign")).append(jsonObj.getString("money"));
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authPayGetQrKey(int userId, String token, String data, byte[] decode, String payPwd) {
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }

    public static boolean authPayVerifyQrKey(int userId, String token, byte[] qrKey, String salt, String mac) {
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token).append(salt);
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        return AuthServiceUtils.checkMacSign(mac, macStrBuf.toString(), qrKey);
    }

    public static JSONObject authBindWxopenid(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"code"));
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authBindAliUserId(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"aliUserId"));
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authWxWithdrawalPay(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"amount"));
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }

    public static JSONObject authAliWithdrawalPay(int userId, String token, String data, String codeId, String payPwd) {
        byte[] decode = AuthServiceUtils.getPayCodeById(userId, codeId);
        if (null == decode) {
            return null;
        }
        JSONObject jsonObj = AuthServiceUtils.decodePayDataJson(data, decode);
        if (null == jsonObj) {
            return null;
        }
        StringBuffer macStrBuf = new StringBuffer();
        macStrBuf.append(AuthServiceUtils.getApiKey()).append(userId).append(token);
        macStrBuf.append(jsonObj.get((Object)"amount"));
        String publicKey = SKBeanUtils.getLocalSpringBeanManager().getAuthKeysService().getPayPublicKey(userId);
        jsonObj = AuthServiceUtils.checkAuthRSA(jsonObj, macStrBuf, payPwd, publicKey, decode);
        if (null != jsonObj) {
            return jsonObj;
        }
        return null;
    }
}

