/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.service;

import cn.xyz.commons.constants.KConstants;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.Md5Util;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServiceOldUtils {
    private static String apiKey = null;
    private static Logger logger = LoggerFactory.getLogger(AuthServiceOldUtils.class);

    public static String getApiKey() {
        if (null == apiKey) {
            apiKey = SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getAppConfig().getApiKey();
        }
        return apiKey;
    }

    public static boolean authRequestTime(long time) {
        long currTime = DateUtil.currentTimeSeconds();
        if (currTime - time < 180L && currTime - time > -180L) {
            return true;
        }
        System.out.println(String.format("====> authRequestTime error server > %s client %s", currTime, time));
        return false;
    }

    public static boolean authOpenApiSecret(long time, String secret) {
        if (0 == SKBeanUtils.getSystemConfig().getIsAuthApi()) {
            return true;
        }
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        String key = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).toString();
        return secret.equals(Md5Util.md5Hex(key));
    }

    public static boolean authOpenApiSecret(long time, String secret, String requestUri) {
        if (KConstants.filterSet.contains(requestUri)) {
            return true;
        }
        return AuthServiceOldUtils.authOpenApiSecret(time, secret);
    }

    public static boolean authRequestApi(String userId, long time, String token, String secret, String url) {
        if (KConstants.filterSet.contains(url)) {
            return true;
        }
        if (0 == SKBeanUtils.getSystemConfig().getIsAuthApi()) {
            return true;
        }
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getRequestApiSecret(userId, time, token);
        return secretKey.equals(secret);
    }

    public static String getRequestApiSecret(String userId, long time, String token) {
        String key = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).append(userId).append(token).toString();
        return Md5Util.md5Hex(key);
    }

    public static boolean authSendTelMsgSecret(String userId, long time, String secret) {
        String key = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).append(userId).toString();
        return secret.equals(Md5Util.md5Hex(key));
    }

    public static boolean authRedPacket(String payPassword, String userId, String token, long time, String secret) {
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        if (StringUtil.isEmpty(payPassword)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getRedPacketSecret(payPassword, userId, token, time);
        return secretKey.equals(secret);
    }

    public static boolean authRedPacketV1(String payPassword, String userId, String token, long time, String money, String secret) {
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        if (StringUtil.isEmpty(payPassword)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getRedPacketSecretV1(payPassword, userId, token, time, money);
        return secretKey.equals(secret);
    }

    public static boolean authRedPacket(String userId, String token, long time, String secret) {
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getRedPacketSecret(userId, token, time);
        return secretKey.equals(secret);
    }

    public static String getRedPacketSecret(String payPassword, String userId, String token, long time) {
        String apiKey_time = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).toString();
        String userid_token = new StringBuffer().append(userId).append(token).toString();
        String md5payPassword = payPassword;
        String md5ApiKey_time = Md5Util.md5Hex(apiKey_time);
        String key = new StringBuffer().append(md5ApiKey_time).append(userid_token).append(md5payPassword).toString();
        return Md5Util.md5Hex(key);
    }

    public static String getRedPacketSecretV1(String payPassword, String userId, String token, long time, String money) {
        String apiKey_time_money = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).append(money).toString();
        String userid_token = new StringBuffer().append(userId).append(token).toString();
        String md5payPassword = payPassword;
        String md5ApiKey_time_money = Md5Util.md5Hex(apiKey_time_money);
        String key = new StringBuffer().append(md5ApiKey_time_money).append(userid_token).append(md5payPassword).toString();
        return Md5Util.md5Hex(key);
    }

    public static String getRedPacketSecret(String userId, String token, long time) {
        String apiKey_time = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).toString();
        String userid_token = new StringBuffer().append(userId).append(token).toString();
        String md5ApiKey_time = Md5Util.md5Hex(apiKey_time);
        String key = new StringBuffer().append(md5ApiKey_time).append(userid_token).toString();
        return Md5Util.md5Hex(key);
    }

    public static boolean authSendMsg(String userId, long time, String content, String secret) {
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        String key = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(userId).append(time).append(content).toString();
        String secretKey = Md5Util.md5Hex(key);
        return secretKey.equals(secret);
    }

    public static boolean authWxTransferPay(String payPassword, String userId, String token, String amount, String openid, long time, String secret) {
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(secret)) {
            return false;
        }
        if (StringUtil.isEmpty(payPassword)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getWxTransferPaySecret(payPassword, userId, token, amount, openid, time);
        return secretKey.equals(secret);
    }

    public static String getWxTransferPaySecret(String payPassword, String userId, String token, String amount, String openid, long time) {
        String apiKey_openid_userId = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(openid).append(userId).toString();
        String token_amount_time = new StringBuffer().append(token).append(amount).append(time).toString();
        String md5Token = Md5Util.md5Hex(token_amount_time);
        String md5PayPassword = payPassword;
        String key = new StringBuffer().append(apiKey_openid_userId).append(md5Token).append(md5PayPassword).toString();
        return Md5Util.md5Hex(key);
    }

    public static boolean getAppAuthorization(String appId, String appSecret, long time, String secret) {
        boolean flag = false;
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return flag;
        }
        if (StringUtil.isEmpty(appId)) {
            return flag;
        }
        if (StringUtil.isEmpty(appSecret)) {
            return flag;
        }
        String secretKey = AuthServiceOldUtils.getAppAuthorizationSecret(appId, time, appSecret);
        if (!secretKey.equals(secret)) {
            return flag;
        }
        return !flag;
    }

    public static boolean getAuthInterface(String appId, String userId, String token, long time, String appSecret, String secret) {
        boolean flag = false;
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return flag;
        }
        if (StringUtil.isEmpty(appId)) {
            return flag;
        }
        if (StringUtil.isEmpty(appSecret)) {
            return flag;
        }
        String secretKey = AuthServiceOldUtils.getAuthInterfaceSecret(appId, userId, token, time, appSecret);
        if (!secretKey.equals(secret)) {
            return flag;
        }
        return !flag;
    }

    public static String getAppAuthorizationSecret(String appId, long time, String appSecret) {
        String times = new StringBuffer().append(time).toString();
        String md5Time = Md5Util.md5Hex(times);
        String AppIdMd5time = new StringBuffer().append(appId).append(md5Time).toString();
        String md5AppSecret = Md5Util.md5Hex(appSecret);
        String secret = new StringBuffer().append(AppIdMd5time).append(md5AppSecret).toString();
        String key = Md5Util.md5Hex(secret);
        return key;
    }

    public static String getAuthInterfaceSecret(String appId, String userId, String token, long time, String appSecret) {
        String md5AppSecret = Md5Util.md5Hex(appSecret);
        String tokenTime = new StringBuffer().append(token).append(time).toString();
        String md5TokenTime = Md5Util.md5Hex(tokenTime);
        String apiKeyAppIdUserId = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(appId).append(userId).toString();
        String secret = new StringBuffer().append(apiKeyAppIdUserId).append(md5TokenTime).append(md5AppSecret).toString();
        String key = Md5Util.md5Hex(secret);
        return key;
    }

    public static boolean authPaymentCode(String paymentCode, String userId, String money, String token, long time, String secret) {
        if (StringUtil.isEmpty(paymentCode)) {
            return false;
        }
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        if (StringUtil.isEmpty(money)) {
            return false;
        }
        if (StringUtil.isEmpty(token)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getPaymentCodeSecret(paymentCode, userId, money, token, time);
        return secretKey.equals(secret);
    }

    public static String getPaymentCodeSecret(String paymentCode, String userId, String money, String token, long time) {
        String Apikey_time_money_paymentCode = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).append(money).append(paymentCode).toString();
        String md5Apikey_time_money_paymentCode = Md5Util.md5Hex(Apikey_time_money_paymentCode);
        String userId_token = new StringBuffer().append(userId).append(token).toString();
        String secret = new StringBuffer().append(md5Apikey_time_money_paymentCode).append(userId_token).toString();
        String key = Md5Util.md5Hex(secret);
        return key;
    }

    public static boolean authQRCodeReceipt(String userId, String token, String money, long time, String payPassword, String secret) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        if (StringUtil.isEmpty(token)) {
            return false;
        }
        if (StringUtil.isEmpty(money)) {
            return false;
        }
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(payPassword)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getQRCodeReceiptSecret(userId, token, money, time, payPassword);
        return secretKey.equals(secret);
    }

    public static String getQRCodeReceiptSecret(String userId, String token, String money, long time, String payPassword) {
        String apiKey_time_money_payPassword = new StringBuffer().append(AuthServiceOldUtils.getApiKey()).append(time).append(money).append(payPassword).toString();
        String md5Apikey_time_money_payPassword = Md5Util.md5Hex(apiKey_time_money_payPassword);
        String userId_token = new StringBuffer().append(userId).append(token).toString();
        String secret = new StringBuffer().append(md5Apikey_time_money_payPassword).append(userId_token).toString();
        String key = Md5Util.md5Hex(secret);
        return key;
    }

    public static boolean authPaymentSecret(String userId, String token, String payPassword, long time, String secret) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        if (StringUtil.isEmpty(token)) {
            return false;
        }
        if (!AuthServiceOldUtils.authRequestTime(time)) {
            return false;
        }
        if (StringUtil.isEmpty(payPassword)) {
            return false;
        }
        String secretKey = AuthServiceOldUtils.getPaymentSecret(userId, token, time, payPassword);
        return secretKey.equals(secret);
    }

    public static String getPaymentSecret(String userId, String token, long time, String payPassword) {
        String userId_token = new StringBuffer().append(userId).append(token).toString();
        String apiKey_time_payPassword = new StringBuffer().append(apiKey).append(time).append(payPassword).toString();
        String Md5ApiKey_time_payPassword = Md5Util.md5Hex(apiKey_time_payPassword);
        String secret = new StringBuffer().append(userId_token).append(Md5ApiKey_time_payPassword).toString();
        String key = Md5Util.md5Hex(secret);
        return key;
    }
}

