/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ValueUtil;
import cn.xyz.mianshi.model.LoginExample;
import cn.xyz.mianshi.model.UserExample;
import cn.xyz.mianshi.model.UserQueryExample;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Comment;
import cn.xyz.mianshi.vo.LiveRoom;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.Praise;
import cn.xyz.mianshi.vo.Role;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.UserRepository;
import cn.xyz.repository.mongo.MongoRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateOpsImpl;
import org.springframework.stereotype.Service;

@Service
public class UserRepositoryImpl
extends MongoRepository<User, Integer>
implements UserRepository {
    public Class<User.LoginDevices> getLoginDevicesClass() {
        return User.LoginDevices.class;
    }

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<User> getEntityClass() {
        return User.class;
    }

    public static UserRepositoryImpl getInstance() {
        return new UserRepositoryImpl();
    }

    @Override
    public synchronized Map<String, Object> addUser(int userId, UserExample example) {
        example.setAccount(userId + StringUtil.randomCode());
        BasicDBObject jo = new BasicDBObject();
        jo.put((Object)"_id", (Object)userId);
        jo.put((Object)"userKey", (Object)DigestUtils.md5Hex((String)example.getPhone()));
        jo.put((Object)"username", (Object)"");
        jo.put((Object)"password", (Object)example.getPassword());
        jo.put((Object)"payPassword", (Object)example.getPayPassWord());
        jo.put((Object)"userType", (Object)ValueUtil.parse(example.getUserType()));
        jo.put((Object)"telephone", (Object)example.getTelephone());
        jo.put((Object)"phone", (Object)example.getPhone());
        jo.put((Object)"account", (Object)example.getAccount());
        jo.put((Object)"areaCode", (Object)example.getAreaCode());
        jo.put((Object)"name", (Object)ValueUtil.parse(example.getName()));
        if (10000 == userId) {
            jo.put((Object)"nickname", (Object)"\u5ba2\u670d\u516c\u4f17\u53f7");
        } else {
            jo.put((Object)"nickname", (Object)ValueUtil.parse(example.getNickname()));
        }
        jo.put((Object)"description", (Object)ValueUtil.parse(example.getDescription()));
        jo.put((Object)"birthday", (Object)ValueUtil.parse(example.getBirthday()));
        jo.put((Object)"sex", (Object)ValueUtil.parse(example.getSex()));
        jo.put((Object)"loc", (Object)new BasicDBObject("lng", (Object)example.getLongitude()).append("lat", (Object)example.getLatitude()));
        jo.put((Object)"countryId", (Object)ValueUtil.parse(example.getCountryId()));
        jo.put((Object)"provinceId", (Object)ValueUtil.parse(example.getProvinceId()));
        jo.put((Object)"cityId", (Object)ValueUtil.parse(example.getCityId()));
        jo.put((Object)"areaId", (Object)ValueUtil.parse(example.getAreaId()));
        jo.put((Object)"money", (Object)0.0);
        jo.put((Object)"moneyTotal", (Object)0.0);
        jo.put((Object)"balance", (Object)0.0);
        jo.put((Object)"totalRecharge", (Object)0.0);
        jo.put((Object)"level", (Object)0);
        jo.put((Object)"vip", (Object)0);
        jo.put((Object)"friendsCount", (Object)0);
        jo.put((Object)"fansCount", (Object)0);
        jo.put((Object)"attCount", (Object)0);
        jo.put((Object)"msgNum", (Object)0);
        jo.put((Object)"createTime", (Object)DateUtil.currentTimeSeconds());
        jo.put((Object)"modifyTime", (Object)DateUtil.currentTimeSeconds());
        jo.put((Object)"idcard", (Object)"");
        jo.put((Object)"idcardUrl", (Object)"");
        jo.put((Object)"isAuth", (Object)(example.getIsSmsRegister() == 1 ? 1 : 0));
        jo.put((Object)"status", (Object)1);
        jo.put((Object)"onlinestate", (Object)0);
        jo.put((Object)"regInviteCode", (Object)example.getInviteCode());
        jo.put((Object)"settings", (Object)User.UserSettings.getDefault());
        this.getDatastore().getDB().getCollection("user").save((DBObject)jo);
        this.initUserLogin(userId, example);
        try {
            Map<String, Object> data = KSessionUtil.loginSaveAccessToken(userId, userId, null);
            data.put("userId", userId);
            data.put("nickname", jo.getString("nickname"));
            data.put("name", jo.getString("name"));
            data.put("createTime", jo.getLong("createTime"));
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initUserLogin(int userId, UserExample example) {
        User.UserLoginLog loginLog = new User.UserLoginLog();
        loginLog.setUserId(userId);
        User.LoginLog log = User.UserLoginLog.init(example, true);
        loginLog.setLoginLog(log);
        loginLog.setDeviceMap(Maps.newHashMap());
        this.getDatastore().save((Object)loginLog);
    }

    @Override
    public void addUser(User user) {
        this.getDatastore().save((Object)user);
    }

    @Override
    public void addUser(int userId, String password) {
        BasicDBObject jo = new BasicDBObject();
        jo.put((Object)"_id", (Object)userId);
        if (null != this.getDatastore().getCollection(this.getEntityClass()).findOne((DBObject)jo)) {
            return;
        }
        jo.put((Object)"userKey", (Object)DigestUtils.md5Hex((String)(userId + "")));
        jo.put((Object)"username", (Object)String.valueOf(userId));
        jo.put((Object)"password", (Object)DigestUtils.md5Hex((String)password));
        if (userId == 10000) {
            jo.put((Object)"userType", (Object)ValueUtil.parse(2));
            Role role = new Role(userId, String.valueOf(userId), 2, 1, 0L);
            this.getDatastore().save((Object)role);
        } else {
            jo.put((Object)"userType", (Object)ValueUtil.parse(1));
        }
        jo.put((Object)"telephone", (Object)("86" + String.valueOf(userId)));
        jo.put((Object)"areaCode", (Object)"86");
        jo.put((Object)"name", (Object)String.valueOf(userId));
        if (10000 == userId) {
            jo.put((Object)"nickname", (Object)"\u5ba2\u670d\u516c\u4f17\u53f7");
            jo.put((Object)"phone", (Object)userId);
        } else if (1100 == userId) {
            jo.put((Object)"nickname", (Object)"\u7cfb\u7edf\u901a\u77e5");
        } else {
            jo.put((Object)"nickname", (Object)String.valueOf(userId));
        }
        jo.put((Object)"description", (Object)String.valueOf(userId));
        jo.put((Object)"birthday", (Object)ValueUtil.parse(userId));
        jo.put((Object)"sex", (Object)ValueUtil.parse(userId));
        jo.put((Object)"loc", (Object)new BasicDBObject("lng", (Object)10.0).append("lat", (Object)10.0));
        jo.put((Object)"countryId", (Object)ValueUtil.parse(0));
        jo.put((Object)"provinceId", (Object)ValueUtil.parse(0));
        jo.put((Object)"cityId", (Object)ValueUtil.parse(400300));
        jo.put((Object)"areaId", (Object)ValueUtil.parse(0));
        jo.put((Object)"money", (Object)0);
        jo.put((Object)"moneyTotal", (Object)0);
        jo.put((Object)"level", (Object)0);
        jo.put((Object)"vip", (Object)0);
        jo.put((Object)"friendsCount", (Object)0);
        jo.put((Object)"fansCount", (Object)0);
        jo.put((Object)"attCount", (Object)0);
        jo.put((Object)"createTime", (Object)DateUtil.currentTimeSeconds());
        jo.put((Object)"modifyTime", (Object)DateUtil.currentTimeSeconds());
        jo.put((Object)"idcard", (Object)"");
        jo.put((Object)"idcardUrl", (Object)"");
        jo.put((Object)"isAuth", (Object)0);
        jo.put((Object)"status", (Object)1);
        jo.put((Object)"onlinestate", (Object)1);
        jo.put((Object)"settings", (Object)User.UserSettings.getDefault());
        this.getDatastore().getDB().getCollection("user").save((DBObject)jo);
    }

    @Override
    public List<User> findByTelephone(List<String> telephoneList) {
        Query query = this.getDatastore().createQuery(this.getEntityClass()).filter("telephone in", telephoneList);
        return query.asList();
    }

    @Override
    public List<User> searchUsers(int pageIndex, int pageSize, String strKeyworld, short onlinestate, short userType) {
        ArrayList<User> users = new ArrayList<User>();
        List robots = ((Query)this.getDatastore().createQuery(Role.class).field("role").equal((Object)userType)).order("-createTime").offset(pageIndex * pageSize).limit(pageSize).asList();
        robots.forEach(robot -> {
            User user = SKBeanUtils.getUserManager().getUser(robot.getUserId());
            if (null != user) {
                users.add(user);
            }
        });
        return users;
    }

    @Override
    public long getCount(String telephone) {
        return ((Query)this.getDatastore().createQuery(this.getEntityClass()).field("telephone").equal((Object)telephone)).countAll();
    }

    @Override
    public User.LoginLog getLogin(int userId) {
        User.UserLoginLog userLoginLog = (User.UserLoginLog)((Query)this.getDatastore().createQuery(User.UserLoginLog.class).field("_id").equal((Object)userId)).get();
        if (null == userLoginLog || null == userLoginLog.getLoginLog()) {
            User.UserLoginLog loginLog = new User.UserLoginLog();
            loginLog.setUserId(userId);
            loginLog.setLoginLog(new User.LoginLog());
            this.getDatastore().save((Object)loginLog);
            return loginLog.getLoginLog();
        }
        return userLoginLog.getLoginLog();
    }

    @Override
    public User.UserSettings getSettings(int userId) {
        User.UserSettings settings = null;
        User user = null;
        user = (User)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId)).get();
        if (null == user) {
            return null;
        }
        settings = user.getSettings();
        return null != settings ? settings : new User.UserSettings();
    }

    @Override
    public User getUser(int userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId);
        return (User)query.get();
    }

    @Override
    public User.LoginDevices getLoginDevices(int userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getLoginDevicesClass()).field("_id").equal((Object)userId);
        return (User.LoginDevices)query.get();
    }

    public void addLoginDevices(User.LoginDevices loginDevices) {
        this.getDatastore().save((Object)loginDevices);
    }

    @Override
    public User getUser(String telephone) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("telephone").equal((Object)telephone);
        return (User)query.get();
    }

    public boolean getUserByAccount(String account, Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").notEqual((Object)userId);
        query.or(new Criteria[]{(Criteria)query.criteria("account").equal((Object)account), (Criteria)query.criteria("phone").equal((Object)account)});
        return null == query.get();
    }

    public User getUserByAccount(String account) {
        return (User)this.findOne("account", account);
    }

    @Override
    public User getUser(String areaCode, String userKey, String password) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(areaCode)) {
            query.field("areaCode").equal((Object)areaCode);
        }
        if (!StringUtil.isEmpty(userKey)) {
            query.or(new Criteria[]{(Criteria)query.criteria("userKey").equal((Object)userKey), (Criteria)query.criteria("encryAccount").equal((Object)userKey)});
        }
        if (!StringUtil.isEmpty(password)) {
            query.field("password").equal((Object)password);
        }
        return (User)query.get();
    }

    @Override
    public User getUserv1(String userKey, String password) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(userKey)) {
            query.field("userKey").equal((Object)userKey);
        }
        if (!StringUtil.isEmpty(password)) {
            query.field("password").equal((Object)password);
        }
        return (User)query.get();
    }

    @Override
    public List<DBObject> queryUser(UserQueryExample example) {
        ArrayList list = Lists.newArrayList();
        BasicDBObject ref = new BasicDBObject();
        if (null != example.getUserId()) {
            ref.put("_id", (Object)new BasicDBObject("$lt", (Object)example.getUserId()));
        }
        if (!StringUtil.isEmpty(example.getNickname())) {
            ref.put("nickname", (Object)Pattern.compile(example.getNickname()));
        }
        if (null != example.getSex()) {
            ref.put("sex", (Object)example.getSex());
        }
        if (null != example.getStartTime()) {
            ref.put("birthday", (Object)new BasicDBObject("$gte", (Object)example.getStartTime()));
        }
        if (null != example.getEndTime()) {
            ref.put("birthday", (Object)new BasicDBObject("$lte", (Object)example.getEndTime()));
        }
        BasicDBObject fields = new BasicDBObject();
        fields.put("userKey", (Object)0);
        fields.put("password", (Object)0);
        fields.put("money", (Object)0);
        fields.put("moneyTotal", (Object)0);
        fields.put("status", (Object)0);
        DBCursor cursor = this.getDatastore().getDB().getCollection("user").find((DBObject)ref, (DBObject)fields).sort((DBObject)new BasicDBObject("_id", (Object)-1)).limit(example.getPageSize().intValue());
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            obj.put("userId", obj.get("_id"));
            obj.removeField("_id");
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<DBObject> findUser(int pageIndex, int pageSize) {
        ArrayList list = Lists.newArrayList();
        BasicDBObject fields = new BasicDBObject();
        fields.put("userKey", (Object)0);
        fields.put("password", (Object)0);
        fields.put("money", (Object)0);
        fields.put("moneyTotal", (Object)0);
        fields.put("status", (Object)0);
        DBCursor cursor = this.getDatastore().getDB().getCollection("user").find(null, (DBObject)fields).sort((DBObject)new BasicDBObject("_id", (Object)-1)).skip(pageIndex * pageSize).limit(pageSize);
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            obj.put("userId", obj.get("_id"));
            obj.removeField("_id");
            list.add(obj);
        }
        return list;
    }

    @Override
    public void updateLogin(int userId, String serial) {
        BasicDBObject value = new BasicDBObject();
        value.put("serial", (Object)serial);
        BasicDBObject q = new BasicDBObject("_id", (Object)userId);
        BasicDBObject o = new BasicDBObject("$set", (Object)new BasicDBObject("loginLog", (Object)value));
        this.getDatastore().getDB().getCollection("user").update((DBObject)q, (DBObject)o);
    }

    @Override
    public void updateLogin(int userId, LoginExample example) {
        BasicDBObject loc = new BasicDBObject(2);
        loc.put((Object)"loc.lng", (Object)example.getLongitude());
        loc.put((Object)"loc.lat", (Object)example.getLatitude());
        BasicDBObject values = new BasicDBObject();
        values.put("loc.lng", (Object)example.getLongitude());
        values.put("loc.lat", (Object)example.getLatitude());
        values.put("appId", (Object)example.getAppId());
        values.put("active", (Object)DateUtil.currentTimeSeconds());
        BasicDBObject q = new BasicDBObject("_id", (Object)userId);
        BasicDBObject o = new BasicDBObject("$set", (Object)values);
        this.getDatastore().getCollection(this.getEntityClass()).update((DBObject)q, (DBObject)o);
    }

    @Override
    public void updateUserLoginLog(int userId, LoginExample example) {
        BasicDBObject query = new BasicDBObject("_id", (Object)userId);
        BasicDBObject values = new BasicDBObject();
        DBObject object = this.getDatastore().getCollection(User.UserLoginLog.class).findOne((DBObject)query);
        if (null == object) {
            values.put("_id", (Object)userId);
        }
        BasicDBObject loginLog = new BasicDBObject("isFirstLogin", (Object)0);
        loginLog.put((Object)"loginTime", (Object)DateUtil.currentTimeSeconds());
        loginLog.put((Object)"apiVersion", (Object)example.getApiVersion());
        loginLog.put((Object)"osVersion", (Object)example.getOsVersion());
        loginLog.put((Object)"model", (Object)example.getModel());
        loginLog.put((Object)"serial", (Object)example.getSerial());
        loginLog.put((Object)"latitude", (Object)example.getLatitude());
        loginLog.put((Object)"longitude", (Object)example.getLongitude());
        loginLog.put((Object)"location", (Object)example.getLocation());
        loginLog.put((Object)"address", (Object)example.getAddress());
        values.put("loginLog", (Object)loginLog);
        this.getDatastore().getCollection(User.UserLoginLog.class).update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)values), true, false);
    }

    @Override
    public void updateLoginLogTime(int userId) {
        BasicDBObject query = new BasicDBObject("_id", (Object)userId);
        BasicDBObject values = new BasicDBObject();
        DBObject object = this.getDatastore().getCollection(User.UserLoginLog.class).findOne((DBObject)query);
        BasicDBObject loginLog = null;
        if (null == object || null == object.get("loginLog")) {
            values.put("_id", (Object)userId);
            loginLog = new BasicDBObject("isFirstLogin", (Object)0);
            loginLog.put((Object)"loginTime", (Object)DateUtil.currentTimeSeconds());
            values.put("loginLog", (Object)loginLog);
            this.getDatastore().getCollection(User.UserLoginLog.class).update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)values), true, false);
        } else {
            values.put("loginLog.loginTime", (Object)DateUtil.currentTimeSeconds());
            this.getDatastore().getCollection(User.UserLoginLog.class).update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)values), true, false);
        }
    }

    @Override
    public User updateUser(final int userId, final UserExample example) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        User oldUser = SKBeanUtils.getUserManager().getUser(userId);
        boolean updateName = false;
        List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
        if (null != example.getUserType()) {
            if (userRoles.size() == 0 || userRoles.contains(2) || userRoles.contains(0)) {
                boolean flag = userRoles.contains(2);
                if (example.getUserType() == 2 && !flag) {
                    ops.set("userType", (Object)example.getUserType());
                    Role role = new Role(userId, example.getPhone(), 2, 1, 0L);
                    this.getDatastore().save((Object)role);
                    SKBeanUtils.getRoleManager().updateFriend(userId, 2);
                } else if (example.getUserType() == 0) {
                    ops.set("userType", (Object)example.getUserType());
                    Query query = (Query)this.getDatastore().createQuery(Role.class).field("userId").equal((Object)userId);
                    if (null != query.get()) {
                        this.getDatastore().delete(query);
                    }
                }
                SKBeanUtils.getRoleManager().updateFriend(userId, example.getUserType());
            } else if (example.getUserType() == 2) {
                throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u6709\u5176\u4ed6\u89d2\u8272");
            }
        }
        if (!StringUtil.isEmpty(example.getAccount())) {
            if (0 < oldUser.getSetAccountCount()) {
                throw new ServiceException("\u8d26\u53f7\u53ea\u80fd\u4fee\u6539\u4e00\u6b21 ");
            }
            if (example.getAccount().length() > 18) {
                throw new ServiceException("\u901a\u8baf\u53f7\u6700\u957f\u5341\u516b\u4f4d");
            }
            boolean userByAccount = this.getUserByAccount(example.getAccount(), userId);
            if (!userByAccount) {
                throw new ServiceException("\u8d26\u53f7\u5df2\u5b58\u5728 ");
            }
            ops.set("account", (Object)example.getAccount());
            ops.inc("setAccountCount", (Number)1);
            ops.set("encryAccount", (Object)DigestUtils.md5Hex((String)example.getAccount()));
            ops.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
            User user = (User)this.getDatastore().findAndModify(q, ops);
            KSessionUtil.deleteUserByUserId(userId);
            return user;
        }
        if (!StringUtil.isEmpty(example.getNickname())) {
            ops.set("nickname", (Object)example.getNickname());
            updateName = true;
        }
        if (!StringUtil.isEmpty(example.getTelephone())) {
            ops.set("userKey", (Object)DigestUtils.md5Hex((String)example.getPhone()));
            ops.set("telephone", (Object)example.getTelephone());
        }
        if (!StringUtil.isEmpty(example.getPhone())) {
            ops.set("phone", (Object)example.getPhone());
        }
        if (!StringUtil.isEmpty(example.getPayPassWord())) {
            ops.set("payPassword", (Object)example.getPayPassWord());
        }
        if (!StringUtil.isEmpty(example.getMsgBackGroundUrl())) {
            ops.set("msgBackGroundUrl", (Object)example.getMsgBackGroundUrl());
        }
        if (!StringUtil.isEmpty(example.getDescription())) {
            ops.set("description", (Object)example.getDescription());
        }
        if (null != example.getBirthday()) {
            ops.set("birthday", (Object)example.getBirthday());
        }
        if (null != example.getSex()) {
            ops.set("sex", (Object)example.getSex());
        }
        if (null != example.getCountryId()) {
            ops.set("countryId", (Object)example.getCountryId());
        }
        if (null != example.getProvinceId()) {
            ops.set("provinceId", (Object)example.getProvinceId());
        }
        if (null != example.getCityId()) {
            ops.set("cityId", (Object)example.getCityId());
        }
        if (null != example.getAreaId()) {
            ops.set("areaId", (Object)example.getAreaId());
        }
        if (null != example.getName()) {
            ops.set("name", (Object)example.getName());
        }
        if (null != example.getIdcard()) {
            ops.set("idcard", (Object)example.getIdcard());
        }
        if (null != example.getIdcardUrl()) {
            ops.set("idcardUrl", (Object)example.getIdcardUrl());
        }
        if (-1 < example.getMultipleDevices()) {
            ops.set("multipleDevices", (Object)example.getMultipleDevices());
        }
        if (0.0 < example.getLongitude()) {
            ops.set("loc.lng", (Object)example.getLongitude());
        }
        if (0.0 < example.getLatitude()) {
            ops.set("loc.lat", (Object)example.getLatitude());
        }
        ops.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        User user = (User)this.getDatastore().findAndModify(q, ops);
        KSessionUtil.deleteUserByUserId(userId);
        if (updateName) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BasicDBObject quserId = new BasicDBObject().append("userId", (Object)userId);
                    BasicDBObject values = new BasicDBObject();
                    values.put("nickname", (Object)example.getNickname());
                    BasicDBObject q = new BasicDBObject("$set", (Object)values);
                    BasicDBObject qtoUserId = new BasicDBObject().append("toUserId", (Object)userId);
                    BasicDBObject values1 = new BasicDBObject();
                    values1.put("toNickname", (Object)example.getNickname());
                    BasicDBObject o = new BasicDBObject("$set", (Object)values1);
                    SKBeanUtils.getImRoomDatastore().getCollection(Room.class).update((DBObject)quserId, (DBObject)q, false, true);
                    SKBeanUtils.getFriendsManager().getFriendsMongoCollection(userId).updateOne((Bson)qtoUserId, (Bson)new Document("$set", (Object)values1));
                    BasicDBObject p = new BasicDBObject("$set", (Object)values);
                    UserRepositoryImpl.this.getDatastore().getCollection(Msg.class).update((DBObject)quserId, (DBObject)p, false, true);
                    UserRepositoryImpl.this.getDatastore().getCollection(Comment.class).update((DBObject)quserId, (DBObject)p, false, true);
                    UserRepositoryImpl.this.getDatastore().getCollection(Praise.class).update((DBObject)quserId, (DBObject)p, false, true);
                    BasicDBObject liveRoomValues = new BasicDBObject();
                    liveRoomValues.put("nickName", (Object)example.getNickname());
                    BasicDBObject liveQuery = new BasicDBObject("$set", (Object)liveRoomValues);
                    UserRepositoryImpl.this.getDatastore().getCollection(LiveRoom.class).update((DBObject)quserId, (DBObject)liveQuery, false, true);
                    UserRepositoryImpl.this.getDatastore().getCollection(LiveRoom.LiveRoomMember.class).update((DBObject)quserId, (DBObject)liveQuery, false, true);
                    UserRepositoryImpl.this.updateUserRelevantInfo(userId);
                }
            }).start();
        }
        return user;
    }

    public void updateUserRelevantInfo(Integer userId) {
        List<Integer> toUserIds = SKBeanUtils.getFriendsRepository().queryFansId(userId);
        toUserIds.forEach(toUserId -> SKBeanUtils.getRedisService().deleteFriends((Integer)toUserId));
        List<ObjectId> roomIdList = SKBeanUtils.getRoomManagerImplForIM().getRoomIdList(userId);
        roomIdList.forEach(str -> SKBeanUtils.getRedisService().deleteRoom(str.toString()));
        List<ObjectId> msgIds = SKBeanUtils.getMsgCommentRepository().getCommentIds(userId);
        msgIds.forEach(msgId -> SKBeanUtils.getRedisService().deleteMsgComment(msgId.toString()));
        List<ObjectId> strMsgIds = SKBeanUtils.getMsgPraiseRepository().getPraiseIds(userId);
        strMsgIds.forEach(msgId -> SKBeanUtils.getRedisService().deleteMsgPraise(msgId.toString()));
    }

    @Override
    public User updateSettings(int userId, User.UserSettings userSettings) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != new Integer(userSettings.getAllowAtt())) {
            ops.set("settings.allowAtt", (Object)userSettings.getAllowAtt());
        }
        if (null != new Integer(userSettings.getAllowGreet())) {
            ops.set("settings.allowGreet", (Object)userSettings.getAllowGreet());
        }
        if (-1 != userSettings.getFriendsVerify()) {
            ops.set("settings.friendsVerify", (Object)userSettings.getFriendsVerify());
        }
        if (null != new Integer(userSettings.getAllowAtt())) {
            ops.set("settings.openService", (Object)userSettings.getOpenService());
        }
        if (null != new Integer(userSettings.getCloseTelephoneFind())) {
            ops.set("settings.closeTelephoneFind", (Object)userSettings.getCloseTelephoneFind());
        }
        if (!"0".equals(userSettings.getChatRecordTimeOut())) {
            ops.set("settings.chatRecordTimeOut", (Object)userSettings.getChatRecordTimeOut());
        }
        if (0.0 != userSettings.getChatSyncTimeLen()) {
            ops.set("settings.chatSyncTimeLen", (Object)userSettings.getChatSyncTimeLen());
            SKBeanUtils.getUserManager().multipointLoginDataSync(userId, ((User)q.get()).getNickname(), "sync_private_settings");
        }
        if (-1 != userSettings.getIsEncrypt()) {
            ops.set("settings.isEncrypt", (Object)userSettings.getIsEncrypt());
            SKBeanUtils.getUserManager().multipointLoginDataSync(userId, ((User)q.get()).getNickname(), "sync_private_settings");
        }
        if (-1 != userSettings.getIsTyping()) {
            ops.set("settings.isTyping", (Object)userSettings.getIsTyping());
            SKBeanUtils.getUserManager().multipointLoginDataSync(userId, ((User)q.get()).getNickname(), "sync_private_settings");
        }
        if (-1 != userSettings.getIsUseGoogleMap()) {
            ops.set("settings.isUseGoogleMap", (Object)userSettings.getIsUseGoogleMap());
        }
        if (-1 != userSettings.getIsVibration()) {
            ops.set("settings.isVibration", (Object)userSettings.getIsVibration());
            SKBeanUtils.getUserManager().multipointLoginDataSync(userId, ((User)q.get()).getNickname(), "sync_private_settings");
        }
        if (-1 != userSettings.getMultipleDevices()) {
            ops.set("settings.multipleDevices", (Object)userSettings.getMultipleDevices());
        }
        if (-1 != userSettings.getIsKeepalive()) {
            ops.set("settings.isKeepalive", (Object)userSettings.getIsKeepalive());
        }
        if (-1 != userSettings.getPhoneSearch()) {
            ops.set("settings.phoneSearch", (Object)userSettings.getPhoneSearch());
        }
        if (-1 != userSettings.getNameSearch()) {
            ops.set("settings.nameSearch", (Object)userSettings.getNameSearch());
        }
        if (0 != userSettings.getShowLastLoginTime()) {
            ops.set("settings.showLastLoginTime", (Object)userSettings.getShowLastLoginTime());
        }
        if (0 != userSettings.getShowTelephone()) {
            ops.set("settings.showTelephone", (Object)userSettings.getShowTelephone());
        }
        if (null != userSettings.getFriendFromList()) {
            ops.set("settings.friendFromList", (Object)userSettings.getFriendFromList());
        }
        if (null != userSettings.getFilterCircleUserIds()) {
            ops.set("settings.filterCircleUserIds", userSettings.getFilterCircleUserIds());
        }
        if (null != userSettings.getNotSeeFilterCircleUserIds()) {
            ops.set("settings.notSeeFilterCircleUserIds", userSettings.getNotSeeFilterCircleUserIds());
        }
        if (null != userSettings.getAuthSwitch()) {
            ops.set("settings.authSwitch", (Object)userSettings.getAuthSwitch());
        }
        return (User)this.getDatastore().findAndModify(q, ops);
    }

    public User.UserSettings getUserSetting(Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(User.UserSettings.class).field("userId").equal((Object)userId);
        return (User.UserSettings)query.get();
    }

    @Override
    public User updateUser(User user) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)user.getUserId());
        UpdateOpsImpl ops = (UpdateOpsImpl)this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (!StringUtil.isNullOrEmpty(user.getTelephone())) {
            ops.set("userKey", (Object)DigestUtils.md5Hex((String)user.getTelephone()));
            ops.set("telephone", (Object)user.getTelephone());
        }
        if (!StringUtil.isNullOrEmpty(user.getUsername())) {
            ops.set("username", (Object)user.getUsername());
        }
        if (null != user.getUserType()) {
            ops.set("userType", (Object)user.getUserType());
        }
        if (!StringUtil.isNullOrEmpty(user.getName())) {
            ops.set("name", (Object)user.getName());
        }
        if (!StringUtil.isNullOrEmpty(user.getNickname())) {
            ops.set("nickname", (Object)user.getNickname());
        }
        if (!StringUtil.isNullOrEmpty(user.getDescription())) {
            ops.set("description", (Object)user.getDescription());
        }
        if (null != user.getBirthday()) {
            ops.set("birthday", (Object)user.getBirthday());
        }
        if (null != user.getSex()) {
            ops.set("sex", (Object)user.getSex());
        }
        if (null != user.getCountryId()) {
            ops.set("countryId", (Object)user.getCountryId());
        }
        if (null != user.getProvinceId()) {
            ops.set("provinceId", (Object)user.getProvinceId());
        }
        if (null != user.getCityId()) {
            ops.set("cityId", (Object)user.getCityId());
        }
        if (null != user.getAreaId()) {
            ops.set("areaId", (Object)user.getAreaId());
        }
        if (null != user.getLevel()) {
            ops.set("level", (Object)user.getLevel());
        }
        if (null != user.getVip()) {
            ops.set("vip", (Object)user.getVip());
        }
        ops.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        if (!StringUtil.isNullOrEmpty(user.getIdcard())) {
            ops.set("idcard", (Object)user.getIdcard());
        }
        if (!StringUtil.isNullOrEmpty(user.getIdcardUrl())) {
            ops.set("idcardUrl", (Object)user.getIdcardUrl());
        }
        if (null != user.getIsAuth()) {
            ops.set("isAuth", (Object)user.getIsAuth());
        }
        if (null != user.getStatus()) {
            ops.set("status", (Object)user.getStatus());
        }
        return (User)this.getDatastore().findAndModify(q, (UpdateOperations)ops);
    }

    @Override
    public void updatePassword(String telephone, String password) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("telephone").equal((Object)telephone);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("password", (Object)password);
        this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public void updatePassowrd(int userId, String password) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("password", (Object)password);
        this.getDatastore().findAndModify(q, ops);
        KSessionUtil.deleteUserByUserId(userId);
    }
}

