/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.model.AddMsgParam;
import cn.xyz.mianshi.model.MessageExample;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Comment;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.mianshi.vo.Givegift;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.Praise;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgRepository;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainer;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class MsgRepositoryImpl
extends MongoRepository<Msg, ObjectId>
implements MsgRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Msg> getEntityClass() {
        return Msg.class;
    }

    @Override
    public Msg add(final int userId, final AddMsgParam param) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        final Msg entity = Msg.build(user, param);
        this.getDatastore().save((Object)entity);
        if (!StringUtil.isEmpty(param.getMusicId())) {
            SKBeanUtils.getLocalSpringBeanManager().getMusicManager().updateUseCount(new ObjectId(param.getMusicId()));
        }
        if (null != param.getUserRemindLook()) {
            if (null != param.getUserNotLook()) {
                List collect = param.getUserRemindLook().stream().filter(item -> param.getUserNotLook().contains(item)).collect(Collectors.toList());
                param.getUserRemindLook().removeAll(collect);
                if (null == param.getUserRemindLook()) {
                    return entity;
                }
            }
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    for (int i = 0; i < param.getUserRemindLook().size(); ++i) {
                        MsgRepositoryImpl.this.push(userId, param.getUserRemindLook().get(i), entity.getMsgId());
                    }
                }
            });
        }
        return entity;
    }

    private void push(int userId, int toUserId, ObjectId msgId) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        Query q = this.getDatastore().createQuery(this.getEntityClass());
        Msg msg = (Msg)q.filter("msgId", (Object)msgId).get();
        int type = msg.getBody().getType();
        String url = null;
        if (type == 1) {
            url = msg.getBody().getText();
        } else if (type == 2) {
            url = msg.getBody().getImages().get(0).getTUrl();
        } else if (type == 3) {
            url = msg.getBody().getAudios().get(0).getOUrl();
        } else if (type == 4) {
            url = msg.getBody().getImages().get(0).getOUrl();
        }
        String t = String.valueOf(type);
        String u = String.valueOf(msgId);
        String mm = u + "," + t + "," + url;
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(304);
        messageBean.setFromUserId(String.valueOf(userId));
        messageBean.setFromUserName(user.getNickname());
        messageBean.setContent("");
        messageBean.setObjectId(mm);
        messageBean.setToUserId(String.valueOf(toUserId));
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean delete(final String ... msgIds) {
        for (final String msgId : msgIds) {
            final ObjectId objMsgId = new ObjectId(msgId);
            Query query = this.getDatastore().createQuery(this.getEntityClass());
            query.field("_id").equal((Object)objMsgId);
            final Msg msg = (Msg)query.get();
            Msg.Body body = null;
            if (null == msg) {
                throw new ServiceException(10102);
            }
            body = msg.getBody();
            try {
                this.getDatastore().delete(query);
                if (null != body) {
                    if (null != body.getImages()) {
                        this.deleteResource(body.getImages());
                    }
                    if (null != body.getAudios()) {
                        this.deleteResource(body.getAudios());
                    }
                    if (null != body.getVideos()) {
                        this.deleteResource(body.getVideos());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    if (null != msg) {
                        MsgRepositoryImpl.this.getDatastore().delete((Query)MsgRepositoryImpl.this.getDatastore().createQuery(Comment.class).field("msgId").equal((Object)objMsgId));
                        MsgRepositoryImpl.this.getDatastore().delete((Query)MsgRepositoryImpl.this.getDatastore().createQuery(Praise.class).field("msgId").equal((Object)objMsgId));
                        MsgRepositoryImpl.this.getDatastore().delete((Query)MsgRepositoryImpl.this.getDatastore().createQuery(Givegift.class).field("msgId").equal((Object)objMsgId));
                    }
                    SKBeanUtils.getRedisService().deleteMsgComment(msgId);
                    SKBeanUtils.getRedisService().deleteMsgPraise(msgId);
                    SKBeanUtils.getRedisCRUD().delete(String.format("s_msg:msg_msgId:%s", msgIds));
                }
            });
        }
        return true;
    }

    public List<Msg.Resource> deleteResource(List<Msg.Resource> resources) {
        for (Msg.Resource resource : resources) {
            try {
                ConstantUtil.deleteFile(resource.getOUrl());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resources;
    }

    private List<Msg> fetchAndAttach(int userId, Query<Msg> query) {
        List msgList = query.asList();
        msgList.forEach(msg -> {
            if (null != msg.getBody() && msg.getBody().getType() == 5 && null != msg.getBody().getFiles() && null != msg.getBody().getFiles().get(0)) {
                msg.setFileName(msg.getBody().getFiles().get(0).getoFileName());
            }
            msg.setComments(this.getComments(msg.getMsgId().toString()));
            msg.setPraises(this.getPraises(msg.getMsgId().toString()));
            msg.setGifts(SKBeanUtils.getMsgGiftRepository().find(msg.getMsgId(), null, 0, 10));
            msg.setIsPraise(SKBeanUtils.getMsgPraiseRepository().exists(ReqUtil.getUserId(), msg.getMsgId()) ? 1 : 0);
            msg.setIsCollect(SKBeanUtils.getMsgPraiseRepository().existsCollect(ReqUtil.getUserId(), msg.getMsgId()) ? 1 : 0);
        });
        return msgList;
    }

    private List<Comment> getComments(String msgId) {
        List<Comment> msgComment = SKBeanUtils.getRedisService().getMsgComment(msgId);
        if (null != msgComment && msgComment.size() > 0) {
            return msgComment;
        }
        List<Comment> commonListMsg = SKBeanUtils.getMsgCommentRepository().find(new ObjectId(msgId), null, 0, 20);
        if (null != commonListMsg && commonListMsg.size() > 0) {
            SKBeanUtils.getRedisService().saveMsgComment(msgId, commonListMsg);
        }
        return commonListMsg;
    }

    private List<Praise> getPraises(String msgId) {
        List<Praise> msgPraise = SKBeanUtils.getRedisService().getMsgPraise(msgId);
        if (null != msgPraise && msgPraise.size() > 0) {
            return msgPraise;
        }
        List<Praise> praiseListMsg = SKBeanUtils.getMsgPraiseRepository().find(new ObjectId(msgId), null, 0, 20);
        if (null != praiseListMsg && praiseListMsg.size() > 0) {
            SKBeanUtils.getRedisService().saveMsgPraise(msgId, praiseListMsg);
        }
        return praiseListMsg;
    }

    @Override
    public List<Msg> findByExample(int userId, MessageExample example) {
        List<Integer> userIdList = SKBeanUtils.getFriendsManager().queryFollowId(userId);
        userIdList.add(userId);
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(example.getBodyTitle())) {
            query.field("body.title").contains(example.getBodyTitle());
        }
        if (0 != example.getCityId()) {
            query.field("cityId").equal((Object)example.getCityId());
        }
        if (0 != example.getFlag()) {
            query.field("flag").equal((Object)example.getFlag());
        }
        if (ObjectId.isValid((String)example.getMsgId())) {
            query.field("_id").lessThan((Object)new ObjectId(example.getMsgId()));
        }
        query.filter("userId in", userIdList);
        query.field("visible").greaterThan((Object)0);
        query.order("-_id").limit(example.getPageSize());
        return this.fetchAndAttach(userId, (Query<Msg>)query);
    }

    @Override
    public List<Msg> gets(int userId, String ids) {
        ArrayList idList = Lists.newArrayList();
        JSON.parseArray((String)ids, String.class).forEach(id -> idList.add(new ObjectId(id)));
        Query query = this.getDatastore().createQuery(this.getEntityClass()).filter("_id in", (Object)idList);
        query.order("-_id").asList();
        return this.fetchAndAttach(userId, (Query<Msg>)query);
    }

    @Override
    public List<Msg> getUserMsgList(Integer userId, Integer toUserId, ObjectId msgId, Integer pageSize) {
        User toUser = SKBeanUtils.getUserManager().getUser(toUserId);
        if (null != toUser.getSettings().getNotSeeFilterCircleUserIds() && toUser.getSettings().getNotSeeFilterCircleUserIds().contains(userId)) {
            throw new ServiceException(100219);
        }
        User user = SKBeanUtils.getUserManager().getUser(userId);
        if (null != user.getSettings().getFilterCircleUserIds() && user.getSettings().getFilterCircleUserIds().contains(toUserId)) {
            return null;
        }
        List<Object> list = Lists.newArrayList();
        if (null == toUserId || userId.intValue() == toUserId.intValue()) {
            list = this.findByUser(userId, toUserId, msgId, pageSize);
        } else {
            Friends friends = SKBeanUtils.getFriendsManager().getFriends(new Friends(toUserId, userId));
            if (null == friends || 0 == friends.getBlacklist() && 0 == friends.getStatus()) {
                list = this.findByUser(userId, toUserId, msgId, 10);
            } else if (0 == friends.getBlacklist()) {
                list = this.findByUser(userId, toUserId, msgId, pageSize);
            }
        }
        return list;
    }

    @Override
    public List<Msg> findByUser(Integer userId, Integer toUserId, ObjectId msgId, Integer pageSize) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)toUserId);
        if (null != msgId) {
            query.field("_id").lessThan((Object)msgId);
        }
        ArrayList<Integer> users = new ArrayList<Integer>();
        users.add(userId);
        Query query2 = this.getDatastore().createQuery(this.getEntityClass());
        Query query3 = this.getDatastore().createQuery(this.getEntityClass());
        Query query4 = this.getDatastore().createQuery(this.getEntityClass());
        CriteriaContainer criteria1 = (CriteriaContainer)((CriteriaContainerImpl)query.criteria("visible").equal((Object)1)).criteria("userNotLook").hasNoneOf(users);
        CriteriaContainer criteria2 = (CriteriaContainer)query2.criteria("userId").equal((Object)userId);
        CriteriaContainer criteria3 = (CriteriaContainer)((CriteriaContainerImpl)query3.criteria("visible").equal((Object)3)).criteria("userLook").hasAnyOf(users);
        CriteriaContainer criteria4 = (CriteriaContainer)((CriteriaContainerImpl)query4.criteria("visible").equal((Object)4)).criteria("userNotLook").hasNoneOf(users);
        query.or(new Criteria[]{criteria1, criteria2, criteria3, criteria4});
        query.order("-_id").limit(pageSize.intValue());
        return this.fetchAndAttach(userId, (Query<Msg>)query);
    }

    @Override
    public List<Msg> getUserMsgIdList(int userId, int toUserId, ObjectId msgId, int pageSize) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).retrievedFields(true, new String[]{"userId", "nickname"}).field("userId").equal((Object)userId);
        if (null != msgId) {
            query.field("_id").lessThan((Object)msgId);
        }
        query.order("-_id").limit(pageSize);
        return query.asList();
    }

    @Override
    public boolean forwarding(Integer userId, AddMsgParam param) {
        return true;
    }

    @Override
    public Msg get(int userId, ObjectId msgId) {
        Msg msg;
        String text;
        String key = String.format("s_msg:msg_msgId:%s", msgId.toString());
        boolean exists = SKBeanUtils.getRedisCRUD().keyExists(key);
        if (!exists) {
            Msg msg2 = (Msg)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)msgId)).get();
            if (null == msg2) {
                return msg2;
            }
            if (0 == userId) {
                return msg2;
            }
            String value = msg2.toString();
            SKBeanUtils.getRedisCRUD().setWithExpireTime(key, value, 43200);
        }
        if (null == (text = SKBeanUtils.getRedisCRUD().get(key)) || "".equals(text)) {
            msg = (Msg)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)msgId)).get();
            if (null == msg) {
                return msg;
            }
        } else {
            try {
                msg = (Msg)new ObjectMapper().readValue(text, this.getEntityClass());
            }
            catch (Exception e) {
                throw new ServiceException(101004);
            }
        }
        msg.setComments(SKBeanUtils.getMsgCommentRepository().find(msg.getMsgId(), null, 0, 20));
        msg.setPraises(SKBeanUtils.getMsgPraiseRepository().find(msg.getMsgId(), null, 0, 20));
        msg.setGifts(SKBeanUtils.getMsgGiftRepository().find(msg.getMsgId(), null, 0, 20));
        msg.setIsPraise(SKBeanUtils.getMsgPraiseRepository().exists(userId, msg.getMsgId()) ? 1 : 0);
        msg.setIsCollect(SKBeanUtils.getMsgPraiseRepository().existsCollect(ReqUtil.getUserId(), msg.getMsgId()) ? 1 : 0);
        return msg;
    }

    @Override
    public List<Msg> getMsgIdList(int userId, int toUserId, ObjectId msgId, int pageSize) {
        List<Integer> userIdList = SKBeanUtils.getFriendsManager().queryFollowId(userId);
        userIdList.add(userId);
        Query query = this.getDatastore().createQuery(this.getEntityClass()).retrievedFields(true, new String[]{"userId", "nickname"}).filter("userId in", userIdList);
        if (null != msgId) {
            query.field("_id").lessThan((Object)msgId);
        }
        query.order("-_id").limit(pageSize);
        return query.asList();
    }

    @Override
    public List<Msg> getMsgList(Integer userId, ObjectId msgId, Integer pageSize, Integer pageIndex) {
        User user2;
        List<Integer> userIdList;
        List<Integer> friendsUserIds = SKBeanUtils.getRedisService().getFriendsUserIdsList(userId);
        if (null != friendsUserIds && friendsUserIds.size() > 0) {
            userIdList = friendsUserIds;
        } else {
            userIdList = SKBeanUtils.getFriendsManager().queryFansId(userId);
            SKBeanUtils.getRedisService().saveFriendsUserIdsList(userId, userIdList);
        }
        userIdList.add(userId);
        ArrayList<Integer> users = new ArrayList<Integer>();
        users.add(userId);
        Query query1 = (Query)this.getDatastore().createQuery(this.getEntityClass()).filter("userId in", userIdList).field("state").notEqual((Object)1);
        Query userQuery = (Query)this.getDatastore().createQuery(User.class).field("settings.notSeeFilterCircleUserIds").hasThisOne((Object)userId);
        List asList = userQuery.asList();
        ArrayList userNotLookList = new ArrayList();
        if (null != asList && asList.size() > 0) {
            asList.forEach(user -> userNotLookList.add(user.getUserId()));
            query1.field("userId").notIn(userNotLookList);
        }
        if (null != (user2 = SKBeanUtils.getUserManager().getUser(userId)).getSettings() && null != user2.getSettings().getFilterCircleUserIds()) {
            query1.field("userId").notIn(user2.getSettings().getFilterCircleUserIds());
        }
        List<Friends> blackList = SKBeanUtils.getFriendsManager().queryBlacklist(userId, 0, 10);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Friends friends : blackList) {
            list.add(friends.getToUserId());
        }
        if (0 != list.size()) {
            query1.field("userId").notIn(list);
        }
        if (null != msgId) {
            query1.field("_id").lessThan((Object)msgId);
        }
        Query query2 = this.getDatastore().createQuery(this.getEntityClass());
        Query query3 = this.getDatastore().createQuery(this.getEntityClass());
        Query query4 = this.getDatastore().createQuery(this.getEntityClass());
        CriteriaContainer criteria1 = (CriteriaContainer)((CriteriaContainerImpl)query1.criteria("visible").equal((Object)1)).criteria("userNotLook").hasNoneOf(users);
        CriteriaContainer criteria2 = (CriteriaContainer)query2.criteria("userId").equal((Object)userId);
        CriteriaContainer criteria3 = (CriteriaContainer)((CriteriaContainerImpl)query3.criteria("visible").equal((Object)3)).criteria("userLook").hasAnyOf(users);
        CriteriaContainer criteria4 = (CriteriaContainer)((CriteriaContainerImpl)query4.criteria("visible").equal((Object)4)).criteria("userNotLook").hasNoneOf(users);
        query1.or(new Criteria[]{criteria1, criteria2, criteria3, criteria4});
        query1.order("-_id").offset(pageIndex * pageSize).limit(pageSize.intValue());
        return this.fetchAndAttach(userId, (Query<Msg>)query1);
    }

    public PageResult<Msg> getMsgList(Integer page, Integer limit, String nickname, Integer userId) {
        PageResult<Msg> result = new PageResult<Msg>();
        try {
            Query query = this.getDatastore().createQuery(this.getEntityClass()).order("-time");
            if (!StringUtil.isEmpty(nickname)) {
                query.criteria("nickname").contains(nickname);
            } else if (0 != userId) {
                query.field("userId").equal((Object)userId);
            }
            List msgList = query.asList(this.pageFindOption(page, limit, 1));
            for (final Msg msg : msgList) {
                User user = (User)SKBeanUtils.getUserManager().get(msg.getUserId());
                if (null == user) {
                    ThreadUtil.executeInThread(new Callback(){

                        @Override
                        public void execute(Object obj) {
                            Query erryQuery = (Query)MsgRepositoryImpl.this.getDatastore().createQuery(MsgRepositoryImpl.this.getEntityClass()).field("userId").equal((Object)msg.getUserId());
                            MsgRepositoryImpl.this.getDatastore().delete(erryQuery);
                        }
                    });
                    continue;
                }
                msg.setUserStatus(user.getStatus());
            }
            result.setCount(query.count());
            result.setData(msgList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Msg> getPureVideo(Integer pageIndex, Integer pageSize, String lable) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        User user = SKBeanUtils.getUserManager().getUser(ReqUtil.getUserId());
        if (null != user.getSettings() && null != user.getSettings().getFilterCircleUserIds()) {
            query.field("userId").notIn(user.getSettings().getFilterCircleUserIds());
        }
        query.field("visible").notEqual((Object)2);
        query.field("body.videos").notEqual(null);
        if (!StringUtil.isEmpty(lable) && "8".equals(lable)) {
            query.field("body.lable").equal(null);
        } else if (!StringUtil.isEmpty(lable)) {
            query.field("body.lable").equal((Object)lable);
        }
        List data = query.order("-time").asList(this.pageFindOption(pageIndex, pageSize, 0));
        return data;
    }

    @Override
    public List<Msg> getSquareMsgList(int userId, ObjectId msgId, Integer pageSize) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (null != msgId) {
            query.field("_id").lessThan((Object)msgId);
        }
        query.order("-_id").limit(pageSize.intValue());
        return query.asList();
    }

    @Override
    public synchronized void update(ObjectId msgId, Msg.Op op, int activeValue) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)msgId);
        Msg msg = (Msg)q.get();
        if (null == msg) {
            return;
        }
        if (-1 == activeValue && (Msg.Op.Comment.getKey().equals(op.getKey()) ? 0L >= msg.getCount().getComment() : (Msg.Op.Praise.getKey().equals(op.getKey()) ? 0L >= msg.getCount().getPraise() : Msg.Op.Collect.getKey().equals(op.getKey()) && 0L >= msg.getCount().getCollect()))) {
            throw new ServiceException(100509);
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass()).inc(op.getKey(), (Number)activeValue).inc("count.total", (Number)activeValue);
        this.getDatastore().update(q, ops);
    }

    public void lockingMsg(ObjectId msgId, int state) {
        Query query = this.getDatastore().createQuery(this.getEntityClass()).filter("msgId", (Object)msgId);
        if (null == query) {
            throw new ServiceException("Msg is null, msgId:" + msgId);
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("state", (Object)state);
        this.getDatastore().update(query, ops);
    }

    public PageResult<Comment> commonListMsg(ObjectId msgId, Integer page, Integer limit) {
        PageResult<Comment> result = new PageResult<Comment>();
        Query query = this.getDatastore().createQuery(Comment.class).filter("msgId", (Object)msgId).order("time");
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(page, limit, 1)));
        return result;
    }

    public PageResult<Praise> praiseListMsg(ObjectId msgId, Integer page, Integer limit) {
        PageResult<Praise> result = new PageResult<Praise>();
        Query query = this.getDatastore().createQuery(Praise.class).filter("msgId", (Object)msgId);
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(page, limit, 1)));
        return result;
    }
}

