/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Collect;
import cn.xyz.mianshi.vo.Emoji;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.Praise;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgPraiseRepository;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MsgPraiseRepositoryImpl
extends MongoRepository<Praise, ObjectId>
implements MsgPraiseRepository {
    private final String s_praise = "s_praise";

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Praise> getEntityClass() {
        return Praise.class;
    }

    @Override
    public ObjectId add(final int userId, final ObjectId msgId) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        if (!this.exists(userId, msgId)) {
            Praise entity = new Praise(ObjectId.get(), msgId, user.getUserId(), user.getNickname(), DateUtil.currentTimeSeconds());
            SKBeanUtils.getRedisService().deleteMsgPraise(msgId.toString());
            this.getDatastore().save((Object)entity);
            SKBeanUtils.getMsgRepository().update(msgId, Msg.Op.Praise, 1);
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    MsgPraiseRepositoryImpl.this.push(userId, msgId, 301);
                }
            });
            return entity.getPraiseId();
        }
        return null;
    }

    private void push(int userId, ObjectId msgId, int msgType) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        Query q = this.getDatastore().createQuery(Msg.class);
        Msg msg = (Msg)q.filter("msgId", (Object)msgId).get();
        int type = msg.getBody().getType();
        String url = null;
        if (null != msg.getBody()) {
            if (type == 1) {
                url = msg.getBody().getText();
            } else if (type == 2) {
                url = msg.getBody().getImages().get(0).getTUrl();
            } else if (type == 3) {
                url = msg.getBody().getAudios().get(0).getOUrl();
            } else if (type == 4) {
                url = msg.getBody().getVideos().get(0).getOUrl();
            }
        }
        String t = String.valueOf(type);
        String u = String.valueOf(msgId);
        String mm = u + "," + t + "," + url;
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(msgType);
        messageBean.setFromUserId(String.valueOf(userId));
        messageBean.setFromUserName(user.getNickname());
        messageBean.setContent("");
        messageBean.setObjectId(mm);
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            List praiseuserIdlist = new ArrayList();
            BasicDBObject d = new BasicDBObject("msgId", (Object)msgId);
            praiseuserIdlist = this.distinct("s_praise", "userId", (DBObject)d);
            List<Integer> userIdlist = new ArrayList();
            userIdlist = this.distinct("s_comment", "userId", (DBObject)d);
            userIdlist.addAll(praiseuserIdlist);
            userIdlist.add(msg.getUserId());
            HashSet hs = new HashSet(userIdlist);
            ArrayList<Integer> list = new ArrayList<Integer>(hs);
            for (int i = 0; i < list.size(); ++i) {
                if (!((Integer)list.get(i)).equals(userId)) continue;
                list.remove(i);
            }
            KXMPPServiceImpl.getInstance().send(messageBean, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean delete(int userId, ObjectId msgId) {
        Query q = (Query)((Query)this.getDatastore().createQuery(Praise.class).field("msgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        if (null != q.get()) {
            this.getDatastore().findAndDelete(q);
            SKBeanUtils.getRedisService().deleteMsgPraise(msgId.toString());
            SKBeanUtils.getMsgRepository().update(msgId, Msg.Op.Praise, -1);
            ThreadUtil.executeInThread(obj -> this.push(userId, msgId, 303));
            return true;
        }
        throw new ServiceException(10102);
    }

    public void deleteCollect(int userId, String msgId) {
        Query q = (Query)((Query)this.getDatastore().createQuery(Collect.class).field("msgId").equal((Object)new ObjectId(msgId))).field("userId").equal((Object)userId);
        this.getDatastore().delete(q);
        final Query query = (Query)((Query)this.getDatastore().createQuery(Emoji.class).field("collectMsgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        this.getDatastore().delete(query);
        SKBeanUtils.getRedisService().deleteUserCollectCommon(userId);
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                if (null != query.get()) {
                    ConstantUtil.deleteFile(((Emoji)query.get()).getUrl());
                }
            }
        });
    }

    @Override
    public List<Praise> find(ObjectId msgId, ObjectId praiseId, int pageIndex, int pageSize) {
        List praiseList = null != praiseId ? ((Query)this.getDatastore().find(Praise.class).field("praiseId").equal((Object)praiseId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList() : ((Query)this.getDatastore().find(Praise.class).field("msgId").equal((Object)msgId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList();
        return praiseList;
    }

    public List<ObjectId> getPraiseIds(Integer userId) {
        List msgIds = this.distinct("s_praise", "msgId", (DBObject)new BasicDBObject("userId", (Object)userId));
        return msgIds;
    }

    @Override
    public boolean exists(int userId, ObjectId msgId) {
        Query q = (Query)((Query)this.getDatastore().createQuery(Praise.class).field("msgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        long count = q.countAll();
        return 0L != count;
    }

    public boolean existsCollect(int userId, ObjectId msgId) {
        Query q = (Query)((Query)this.getDatastore().createQuery(Collect.class).field("msgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        long count = q.countAll();
        return 0L != count;
    }
}

