/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.PlayAmount;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgPlayAmountRepository;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MsgPlayAmountRepositoryImpl
extends MongoRepository<PlayAmount, ObjectId>
implements MsgPlayAmountRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<PlayAmount> getEntityClass() {
        return PlayAmount.class;
    }

    @Override
    public void addPlayAmount(int userId, String msgId) {
        User user = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(userId));
        PlayAmount playAmount = new PlayAmount(ObjectId.get(), msgId, userId, user.getNickname(), DateUtil.currentTimeMilliSeconds());
        SKBeanUtils.getRedisService().deleteMsgPlay(msgId);
        this.getDatastore().save((Object)playAmount);
        SKBeanUtils.getMsgRepository().update(new ObjectId(msgId), Msg.Op.Play, 1);
    }

    @Override
    public boolean exists(int userId, String msgId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(PlayAmount.class).field("msgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        long count = query.countAll();
        return 0L != count;
    }

    @Override
    public List<PlayAmount> find(ObjectId msgId, ObjectId playAmountId, int pageIndex, int pageSize) {
        List list = null;
        list = null != playAmountId ? ((Query)this.getDatastore().find(PlayAmount.class).field("_id").equal((Object)playAmountId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList() : ((Query)this.getDatastore().find(PlayAmount.class).field("msgId").equal((Object)msgId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList();
        return list;
    }
}

