/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.mianshi.model.AddGiftParam;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Givegift;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgGiftRepository;
import cn.xyz.repository.mongo.MongoRepository;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class MsgGiftRepositoryImpl
extends MongoRepository<Givegift, ObjectId>
implements MsgGiftRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Givegift> getEntityClass() {
        return Givegift.class;
    }

    @Override
    public List<ObjectId> add(Integer userId, ObjectId msgId, List<AddGiftParam> paramList) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        ArrayList giftIdList = Lists.newArrayList();
        ArrayList entities = Lists.newArrayList();
        int activeValue = 0;
        for (AddGiftParam param : paramList) {
            Double price = 1.0;
            activeValue = (int)((double)activeValue + price * (double)param.getCount().intValue());
            Givegift gift = new Givegift(param.getCount(), ObjectId.get(), msgId, user.getNickname(), price, DateUtil.currentTimeSeconds(), user.getUserId(), user.getUserId());
            giftIdList.add(gift.getGiftId());
            entities.add(gift);
        }
        RedissonClient redissonClient = SKBeanUtils.getLocalSpringBeanManager().getRedissonClient();
        try {
            String key = String.format("msg:%1$s:gift", msgId.toString());
            for (Givegift gift : entities) {
                String string = gift.toString();
                redissonClient.getQueue(key).add((Object)string);
            }
            redissonClient.getList(key).trim(0, 500);
            redissonClient.getBucket(key).expire(43200L, TimeUnit.SECONDS);
            redissonClient.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDatastore().save((Iterable)entities);
        SKBeanUtils.getMsgRepository().update(msgId, Msg.Op.Gift, activeValue);
        return giftIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBObject> findByGift(ObjectId msgId) {
        ArrayList objList = Lists.newArrayList();
        StringBuffer sbMap = new StringBuffer();
        sbMap.append(" function() { ");
        sbMap.append(" \temit({ ");
        sbMap.append(" \t\tid : this.id ");
        sbMap.append(" \t}, { ");
        sbMap.append(" \t\tcount : this.count ");
        sbMap.append(" \t}); ");
        sbMap.append(" } ");
        StringBuffer sbReduce = new StringBuffer();
        sbReduce.append(" function (key, values) { ");
        sbReduce.append(" \tvar total = 0; ");
        sbReduce.append(" \tfor (var i = 0; i < values.length; i++) { ");
        sbReduce.append(" \t\ttotal += values[i].count; ");
        sbReduce.append(" \t} ");
        sbReduce.append(" \treturn total; ");
        sbReduce.append(" } ");
        DBCollection inputCollection = this.getDatastore().getDB().getCollection("gift");
        String map = sbMap.toString();
        String reduce = sbReduce.toString();
        BasicDBObject query = new BasicDBObject("msgId", (Object)msgId);
        DBCursor cursor = inputCollection.mapReduce(map, reduce, "resultCollection", (DBObject)query).getOutputCollection().find();
        try {
            while (cursor.hasNext()) {
                DBObject tObj = cursor.next();
                BasicDBObject dbObj = (BasicDBObject)tObj.get("_id");
                dbObj.put("count", tObj.get("value"));
                objList.add(dbObj);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return objList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBObject> findByUser(ObjectId msgId) {
        ArrayList objList = Lists.newArrayList();
        StringBuffer sbMap = new StringBuffer();
        sbMap.append(" function() { ");
        sbMap.append(" \temit({ ");
        sbMap.append(" \t\tuserId : this.userId, ");
        sbMap.append(" \t\tnickname : this.nickname ");
        sbMap.append(" \t}, { ");
        sbMap.append(" \t\tprice : this.price, ");
        sbMap.append(" \t\tcount : this.count ");
        sbMap.append(" \t}); ");
        sbMap.append(" } ");
        StringBuffer sbReduce = new StringBuffer();
        sbReduce.append(" function (key, values) { ");
        sbReduce.append(" \tvar result = 0; ");
        sbReduce.append(" \tfor (var i = 0; i < values.length; i++) { ");
        sbReduce.append(" \t\tresult += values[i].price * values[i].count; ");
        sbReduce.append(" \t} ");
        sbReduce.append(" \treturn result; ");
        sbReduce.append(" } ");
        DBCollection inputCollection = this.getDatastore().getDB().getCollection("gift");
        String map = sbMap.toString();
        String reduce = sbReduce.toString();
        BasicDBObject query = new BasicDBObject("msgId", (Object)msgId);
        DBCursor cursor = inputCollection.mapReduce(map, reduce, "resultCollection", (DBObject)query).getOutputCollection().find();
        try {
            while (cursor.hasNext()) {
                DBObject tObj = cursor.next();
                BasicDBObject dbObj = (BasicDBObject)tObj.get("_id");
                dbObj.put("money", tObj.get("value"));
                objList.add(dbObj);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return objList;
    }

    @Override
    public List<Givegift> find(ObjectId msgId, ObjectId giftId, int pageIndex, int pageSize) {
        List giftList = ((Query)this.getDatastore().find(this.getEntityClass()).field("msgId").equal((Object)msgId)).order("-_id").offset(pageIndex * pageSize).limit(pageSize).asList();
        return giftList;
    }
}

