/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ForwardAmount;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgForwardAmountRepository;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MsgForwardAmountRepositoryImpl
extends MongoRepository<ForwardAmount, ObjectId>
implements MsgForwardAmountRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<ForwardAmount> getEntityClass() {
        return ForwardAmount.class;
    }

    @Override
    public void addForwardAmount(int userId, String msgId) {
        User user = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(userId));
        ForwardAmount forwardAmount = new ForwardAmount(ObjectId.get(), msgId, userId, user.getNickname(), DateUtil.currentTimeMilliSeconds());
        SKBeanUtils.getRedisService().deleteMsgForward(msgId);
        this.getDatastore().save((Object)forwardAmount);
        SKBeanUtils.getMsgRepository().update(new ObjectId(msgId), Msg.Op.Forwarding, 1);
    }

    @Override
    public boolean exists(int userId, String msgId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(ForwardAmount.class).field("msgId").equal((Object)msgId)).field("userId").equal((Object)userId);
        long count = query.countAll();
        return 0L != count;
    }

    @Override
    public List<ForwardAmount> find(ObjectId msgId, ObjectId forwardId, int pageIndex, int pageSize) {
        List list = null;
        list = null != forwardId ? ((Query)this.getDatastore().find(ForwardAmount.class).field("_id").equal((Object)forwardId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList() : ((Query)this.getDatastore().find(ForwardAmount.class).field("msgId").equal((Object)msgId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList();
        return list;
    }
}

