/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.model.AddCommentParam;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Comment;
import cn.xyz.mianshi.vo.Msg;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.MsgCommentRepository;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MsgCommentRepositoryImpl
extends MongoRepository<Msg, ObjectId>
implements MsgCommentRepository {
    private final String s_comment = "s_comment";

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Msg> getEntityClass() {
        return Msg.class;
    }

    @Override
    public ObjectId add(final int userId, final AddCommentParam param) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        ObjectId commentId = ObjectId.get();
        Comment entity = new Comment(commentId, new ObjectId(param.getMessageId()), user.getUserId(), user.getNickname(), param.getBody(), param.getToUserId(), param.getToNickname(), param.getToBody(), DateUtil.currentTimeSeconds());
        SKBeanUtils.getRedisService().deleteMsgComment(param.getMessageId());
        this.getDatastore().save((Object)entity);
        SKBeanUtils.getMsgRepository().update(new ObjectId(param.getMessageId()), Msg.Op.Comment, 1);
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                MsgCommentRepositoryImpl.this.tack(userId, param);
            }
        });
        return entity.getCommentId();
    }

    private void tack(int userId, AddCommentParam param) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        Query q = this.getDatastore().createQuery(this.getEntityClass());
        Msg msg = (Msg)q.filter("msgId", (Object)new ObjectId(param.getMessageId())).get();
        int type = msg.getBody().getType();
        String url = null;
        if (type == 1) {
            url = msg.getBody().getText();
        } else if (type == 2) {
            url = msg.getBody().getImages().get(0).getTUrl();
        } else if (type == 3) {
            url = msg.getBody().getAudios().get(0).getOUrl();
        } else if (type == 4) {
            url = msg.getBody().getVideos().get(0).getOUrl();
        }
        String u = String.valueOf(type);
        String us = param.getMessageId() + "," + u + "," + url;
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(302);
        messageBean.setFromUserId(String.valueOf(userId));
        messageBean.setFromUserName(user.getNickname());
        messageBean.setObjectId(us);
        messageBean.setContent(param.getBody());
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            List praiseuserIdlist = new ArrayList();
            BasicDBObject d = new BasicDBObject("msgId", (Object)new ObjectId(param.getMessageId()));
            praiseuserIdlist = this.distinct("s_praise", "userId", (DBObject)d);
            List<Integer> userIdlist = new ArrayList();
            userIdlist = this.distinct("s_comment", "userId", (DBObject)d);
            userIdlist.addAll(praiseuserIdlist);
            userIdlist.add(msg.getUserId());
            HashSet hs = new HashSet(userIdlist);
            ArrayList list = new ArrayList(hs);
            for (int i = 0; i < list.size(); ++i) {
                if (!((Integer)list.get(i)).equals(userId)) continue;
                list.remove(i);
            }
            for (Integer toUserId : list) {
                messageBean.setToUserId(toUserId.toString());
                if (!StringUtil.isEmpty(param.getToNickname())) {
                    messageBean.setToUserName(param.getToNickname());
                }
                KXMPPServiceImpl.getInstance().send(messageBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean delete(ObjectId msgId, String commentId) {
        try {
            String[] commentIds;
            for (String commId : commentIds = StringUtil.getStringList(commentId)) {
                if (!ObjectId.isValid((String)commId)) continue;
                Query query = (Query)this.getDatastore().createQuery(Comment.class).field("_id").equal((Object)new ObjectId(commId));
                if (null != query.get()) {
                    this.getDatastore().findAndDelete(query);
                    SKBeanUtils.getMsgRepository().update(msgId, Msg.Op.Comment, -1);
                    continue;
                }
                throw new ServiceException(10102);
            }
            SKBeanUtils.getRedisService().deleteMsgComment(msgId.toString());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Comment> find(ObjectId msgId, ObjectId commentId, int pageIndex, int pageSize) {
        List commentList = null != commentId ? ((Query)this.getDatastore().find(Comment.class).field("commentId").equal((Object)commentId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList() : ((Query)this.getDatastore().find(Comment.class).field("msgId").equal((Object)msgId)).order("-time").offset(pageIndex * pageSize).limit(pageSize).asList();
        return commentList;
    }

    public List<ObjectId> getCommentIds(Integer userId) {
        List msgIds = this.distinct("s_comment", "msgId", (DBObject)new BasicDBObject("userId", (Object)userId));
        return msgIds;
    }
}

