/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.IMongoDAO;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.shiku.mongodb.morphia.MorphiaRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.mapping.MappedClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoRepository<T, ID extends Serializable>
extends MorphiaRepository<T, ID>
implements IMongoDAO<T, ID> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected Morphia morphia;

    public Morphia getMorphia() {
        return this.morphia;
    }

    public abstract Datastore getDatastore();

    public abstract Class<T> getEntityClass();

    public MongoClient getMongoClient() {
        return SKBeanUtils.getLocalSpringBeanManager().getMongoClient();
    }

    public String getCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public String getCollectionName(ObjectId id) {
        if (null == id) {
            this.logger.info(" ====  getCollectionName ObjectId is null  ====");
            throw new ServiceException("ObjectId  is  null !");
        }
        int remainder = 0;
        int counter = id.getCounter();
        remainder = counter / 10000;
        return String.valueOf(remainder);
    }

    public static MongoCollection<Document> getCollection(MongoDatabase database, int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return database.getCollection(String.valueOf(remainder));
    }

    public static String getRemainderName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public MongoCollection<Document> getMongoCollection(MongoDatabase database, int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return database.getCollection(String.valueOf(remainder));
    }

    public String getCollectionName(int userId, int remainder) {
        if (userId > 100000) {
            remainder = userId / remainder;
        }
        return String.valueOf(remainder);
    }

    public String getCollectionName() {
        MappedClass mappedClass = this.morphia.getMapper().getMappedClass(this.getEntityClass());
        if (null == mappedClass) {
            return null;
        }
        return mappedClass.getCollectionName();
    }

    public DBObject objectToDBObject(Object entity) {
        return this.morphia.toDBObject(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> containsIgnoreCase(String name, String key, ObjectId roomId) {
        ArrayList<Document> list = new ArrayList<Document>();
        Pattern pattern = Pattern.compile("^.*" + name + ".*$", 2);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"roomId", (Object)roomId);
        query.put((Object)key, (Object)pattern);
        FindIterable findIterable = this.getCollection(roomId).find((Bson)query);
        MongoCursor mongoCursor = findIterable.iterator();
        Document document = null;
        try {
            while (mongoCursor.hasNext()) {
                document = (Document)mongoCursor.next();
                list.add(document);
            }
        }
        finally {
            if (null != mongoCursor) {
                mongoCursor.close();
            }
        }
        return list;
    }
}

