/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.DocumentToJavaBean;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.model.PageVO;
import cn.xyz.mianshi.service.impl.FriendsManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.repository.FriendsRepository;
import cn.xyz.repository.mongo.MongoRepository;
import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.springframework.stereotype.Service;

@Service
public class FriendsRepositoryImpl
extends MongoRepository<Friends, ObjectId>
implements FriendsRepository {
    @Override
    public Class<Friends> getEntityClass() {
        return Friends.class;
    }

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    private static FriendsManagerImpl getFriendsManagerImpl() {
        return SKBeanUtils.getFriendsManager();
    }

    private MongoCollection<DBObject> getFriendsMongoCollection(int userId) {
        return FriendsRepositoryImpl.getFriendsManagerImpl().getDBObjectCollection(userId);
    }

    @Override
    public void deleteFriends(int userId) {
        this.getFriendsMongoCollection(userId).deleteMany((Bson)new Document("userId", (Object)userId));
    }

    @Override
    public void deleteFriends(int userId, int toUserId) {
        this.getFriendsMongoCollection(userId).deleteOne((Bson)new Document("userId", (Object)userId).append("toUserId", (Object)toUserId));
    }

    @Override
    public Friends getFriends(int userId, int toUserId) {
        MongoCollection<DBObject> userCollection = this.getFriendsMongoCollection(userId);
        DBObject first = (DBObject)userCollection.find((Bson)new Document("userId", (Object)userId).append("toUserId", (Object)toUserId)).first();
        if (null == first) {
            return null;
        }
        Friends userfriends = null;
        try {
            userfriends = DocumentToJavaBean.dbObject2Bean(first, new Friends());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        MongoCollection<DBObject> toUserCollection = this.getFriendsMongoCollection(toUserId);
        first = (DBObject)toUserCollection.find((Bson)new Document("userId", (Object)toUserId).append("toUserId", (Object)userId)).first();
        if (null != first) {
            Friends toUserfriends = null;
            try {
                toUserfriends = DocumentToJavaBean.dbObject2Bean(first, new Friends());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (null == userfriends) {
                return userfriends;
            }
            if (null == toUserfriends) {
                userfriends.setIsBeenBlack(0);
            } else {
                userfriends.setIsBeenBlack(toUserfriends.getBlacklist());
            }
        }
        return userfriends;
    }

    @Override
    public List<Friends> queryBlacklist(int userId, int pageIndex, int pageSize) {
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        for (DBObject dbObject : this.getFriendsMongoCollection(userId).find((Bson)new Document("userId", (Object)userId).append("blacklist", (Object)1)).skip(pageIndex * pageSize).limit(pageSize)) {
            try {
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                if (null == friends) continue;
                friendList.add(friends);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return friendList;
    }

    public PageVO queryBlacklistWeb(int userId, int pageIndex, int pageSize) {
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        MongoCollection<DBObject> friendsCollection = this.getFriendsMongoCollection(userId);
        long count = friendsCollection.count((Bson)new Document("userId", (Object)userId).append("blacklist", (Object)1));
        for (DBObject dbObject : friendsCollection.find((Bson)new Document("userId", (Object)userId).append("blacklist", (Object)1)).skip(pageIndex * pageSize).limit(pageSize)) {
            try {
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                if (null == friends) continue;
                friendList.add(friends);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        PageVO pageVO = new PageVO(friendList, count, pageIndex, pageSize);
        return new PageVO(friendList, count, pageIndex, pageSize);
    }

    @Override
    public List<Integer> queryFansId(int userId) {
        ArrayList result = Lists.newArrayList();
        Document query = new Document("userId", (Object)userId);
        query.put("status", (Object)2);
        query.put("isBeenBlack", (Object)0);
        query.put("blacklist", (Object)0);
        MongoCursor iterator = this.getFriendsMongoCollection(userId).distinct("toUserId", (Bson)query, Integer.class).iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public List<Friends> queryFollow(int userId, int status) {
        Document document = new Document("userId", (Object)userId).append("status", (Object)new Document("$ne", (Object)0));
        if (0 < status) {
            document.append("status", (Object)status);
        }
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        for (DBObject dbObject : this.getFriendsMongoCollection(userId).find((Bson)document)) {
            try {
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                if (null == friends) continue;
                friendList.add(friends);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return friendList;
    }

    public PageResult<Friends> consoleQueryFollow(int userId, int toUserId, int status, int page, int limit) throws IllegalAccessException, InvocationTargetException {
        MongoCollection<DBObject> collection = this.getFriendsMongoCollection(userId);
        PageResult<Friends> result = new PageResult<Friends>();
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        Document document = new Document("userId", (Object)userId).append("status", (Object)new Document("$ne", (Object)0)).append("toUserId", (Object)new Document("$gt", (Object)10100));
        if (0 < status) {
            document.append("status", (Object)status);
        }
        if (0 != toUserId) {
            document.append("toUserId", (Object)toUserId);
        }
        for (DBObject dbObject : collection.find((Bson)document).skip((page - 1) * limit).limit(limit).sort((Bson)new Document("createTime", (Object)-1))) {
            Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
            if (null == friends) continue;
            friendList.add(friends);
        }
        result.setCount(collection.count((Bson)document));
        result.setData(friendList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Friends> allFriendsInfo(int userId) {
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        try (MongoCursor iterator = this.getFriendsMongoCollection(userId).find((Bson)new Document("userId", (Object)userId).append("toUserId", (Object)new Document("$ne", (Object)10000)).append("status", (Object)new Document("$ne", (Object)0))).iterator();){
            while (iterator.hasNext()) {
                DBObject dbObject = (DBObject)iterator.next();
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                friendList.add(friends);
            }
        }
        return friendList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> queryFollowId(int userId) {
        ArrayList result = Lists.newArrayList();
        try (MongoCursor iterator = this.getFriendsMongoCollection(userId).distinct("toUserId", (Bson)new Document("userId", (Object)userId).append("status", (Object)new Document("$ne", (Object)0)), Integer.class).iterator();){
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result;
    }

    @Override
    public List<Friends> queryFriends(int userId) {
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        for (DBObject dbObject : this.getFriendsMongoCollection(userId).find((Bson)new Document("userId", (Object)userId).append("status", (Object)2).append("blacklist", (Object)new Document("$ne", (Object)"1")))) {
            try {
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                if (null == friends) continue;
                friendList.add(friends);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return friendList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Friends> friendsOrBlackList(int userId, String type) {
        ArrayList<Friends> friendList;
        block12: {
            Document document = new Document("userId", (Object)userId);
            if ("friendList".equals(type)) {
                document.append("status", (Object)new Document("$ne", (Object)0)).append("blacklist", (Object)new Document("$ne", (Object)1));
            } else if ("blackList".equals(type)) {
                document.append("blacklist", (Object)1);
            }
            friendList = new ArrayList<Friends>();
            MongoCursor iterator = this.getFriendsMongoCollection(userId).find((Bson)document).iterator();
            block7: while (true) {
                try {
                    while (iterator.hasNext()) {
                        DBObject dbObject = (DBObject)iterator.next();
                        try {
                            Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                            friendList.add(friends);
                            continue block7;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break block12;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block12;
                }
            }
            finally {
                iterator.close();
            }
        }
        return friendList;
    }

    @Override
    public Object saveFriends(Friends friends) {
        String chatRecordTimeOut = SKBeanUtils.getUserManager().getSettings(friends.getUserId()).getChatRecordTimeOut();
        friends.setChatRecordTimeOut(Double.valueOf(chatRecordTimeOut));
        DBObject friendsDbObj = this.objectToDBObject(friends);
        this.getFriendsMongoCollection(friends.getUserId()).insertOne((Object)friendsDbObj);
        return friends;
    }

    @Override
    public Friends updateFriends(Friends friends) {
        MongoCollection<DBObject> friendsMongoCollection = this.getFriendsMongoCollection(friends.getUserId());
        Document document = new Document("modifyTime", (Object)DateUtil.currentTimeSeconds());
        if (null != friends.getBlacklist()) {
            document.append("blacklist", (Object)friends.getBlacklist());
        }
        if (null != friends.getIsBeenBlack()) {
            document.append("isBeenBlack", (Object)friends.getIsBeenBlack());
        }
        if (null != friends.getStatus()) {
            document.append("status", (Object)friends.getStatus());
        }
        if (!StringUtil.isEmpty(friends.getToNickname())) {
            document.append("toNickname", (Object)friends.getToNickname());
        }
        if (!StringUtil.isEmpty(friends.getRemarkName())) {
            document.append("remarkName", (Object)friends.getRemarkName());
        }
        if (0.0 != friends.getChatRecordTimeOut()) {
            document.append("chatRecordTimeOut", (Object)friends.getChatRecordTimeOut());
        }
        if (null != friends.getToFriendsRole()) {
            document.append("toFriendsRole", friends.getToFriendsRole());
        }
        if (0 != friends.getToUserType()) {
            document.append("toUserType", (Object)friends.getToUserType());
        }
        if (0 != friends.getFromAddType()) {
            document.append("fromAddType", (Object)friends.getFromAddType());
        }
        friendsMongoCollection.updateOne((Bson)new Document("userId", (Object)friends.getUserId()).append("toUserId", (Object)friends.getToUserId()), (Bson)new Document("$set", (Object)document));
        return this.getFriends(friends.getUserId(), friends.getToUserId());
    }

    public Friends updateFriendRemarkName(Integer userId, Integer toUserId, String remarkName, String describe) {
        MongoCollection<DBObject> collection = this.getFriendsMongoCollection(userId);
        Friends friends = this.getFriends(userId, toUserId);
        if (null == friends) {
            friends = new Friends();
            friends.setUserId(userId);
            friends.setToUserId(toUserId);
            friends.setRemarkName(remarkName);
            friends.setStatus(0);
            friends.setCreateTime(DateUtil.currentTimeSeconds());
            friends.setDescribe(describe);
            DBObject dbObj = this.objectToDBObject(friends);
            collection.insertOne((Object)dbObj);
            return friends;
        }
        Document document = new Document("modifyTime", (Object)DateUtil.currentTimeSeconds());
        if (null == remarkName) {
            document.append("remarkName", (Object)friends.getRemarkName());
        } else {
            document.append("remarkName", (Object)remarkName);
        }
        document.append("describe", (Object)describe);
        MongoCollection<DBObject> friendsMongoCollection = this.getFriendsMongoCollection(friends.getUserId());
        friendsMongoCollection.updateOne((Bson)new Document("userId", (Object)friends.getUserId()).append("toUserId", (Object)friends.getToUserId()), (Bson)new Document("$set", (Object)document));
        SKBeanUtils.getRedisService().deleteFriends(userId);
        return this.getFriends(userId, toUserId);
    }

    @Override
    public void updateToFriendUserType(int toUserId, int userType, List<Integer> roles) {
        List collectionList = this.getCollectionList();
        Document query = new Document("toUserId", (Object)toUserId);
        Document values = new Document("$set", (Object)new Document("toFriendsRole", roles).append("toUserType", (Object)userType));
        collectionList.forEach(name -> this.getMongoCollection((String)name).updateMany((Bson)query, (Bson)values));
    }

    @Override
    public void updateFriendsEncryptType(int userId, int toUserId, byte type) {
        Document query = new Document("userId", (Object)userId);
        query.append("toUserId", (Object)toUserId);
        this.getCollection(userId).updateOne((Bson)query, (Bson)new Document("$set", (Object)new Document("encryptType", (Object)type)));
    }
}

