/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.NumberUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Department;
import cn.xyz.mianshi.vo.Employee;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.EmployeeRepository;
import cn.xyz.repository.mongo.MongoRepository;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class EmployeeRepositoryImpl
extends MongoRepository<Employee, ObjectId>
implements EmployeeRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Employee> getEntityClass() {
        return Employee.class;
    }

    @Override
    public ObjectId addEmployee(Employee employee) {
        employee.setId(new ObjectId());
        this.getDatastore().save((Object)employee);
        return employee.getId();
    }

    @Override
    public List<Employee> addEmployees(List<Integer> userId, ObjectId companyId, ObjectId departmentId) {
        for (Integer uId : userId) {
            Employee emp = new Employee();
            emp.setDepartmentId(departmentId);
            emp.setCompanyId(companyId);
            emp.setRole((byte)0);
            emp.setUserId(uId);
            this.getDatastore().save((Object)emp);
        }
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("departmentId").equal((Object)departmentId);
        return query.asList();
    }

    @Override
    public Employee modifyEmployees(Employee employee) {
        int userId = employee.getUserId();
        ObjectId companyId = employee.getCompanyId();
        if (userId == 0 || companyId == null) {
            return null;
        }
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId)).field("companyId").equal((Object)companyId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != employee.getDepartmentId()) {
            ops.set("departmentId", (Object)employee.getDepartmentId());
        }
        if (0 <= employee.getRole() && employee.getRole() <= 3) {
            ops.set("role", (Object)employee.getRole());
        }
        if (null != employee.getPosition() && employee.getPosition() != "") {
            ops.set("position", (Object)employee.getPosition());
        }
        if (0 <= employee.getChatNum() && employee.getChatNum() <= 5) {
            ops.set("chatNum", (Object)employee.getChatNum());
        }
        if (!StringUtil.isEmpty(String.valueOf(employee.getIsPause()))) {
            ops.set("isPause", (Object)employee.getIsPause());
        }
        ops.set("isCustomer", (Object)employee.getIsCustomer());
        Employee emp = (Employee)this.getDatastore().findAndModify(query, ops);
        return emp;
    }

    @Override
    public List<Employee> findByUserId(int userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
        if (query == null) {
            return null;
        }
        List employees = query.asList();
        return employees;
    }

    @Override
    public List<Employee> findByRole(ObjectId companyId, int role) {
        Query query = ((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).filter("role", (Object)role);
        if (query == null) {
            return null;
        }
        return query.asList();
    }

    @Override
    public void delEmpByDeptId(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("departmentId").equal((Object)departmentId);
        if (query != null) {
            this.getDatastore().delete(query);
        }
    }

    @Override
    public void deleteAllEmployee(ObjectId companyId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId);
        this.getDatastore().delete(query);
    }

    @Override
    public void deleteEmployee(List<Integer> userIds, ObjectId departmentId) {
        for (Integer userId : userIds) {
            Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId)).field("departmentId").equal((Object)departmentId);
            if (query == null) continue;
            this.getDatastore().delete(query);
        }
    }

    @Override
    public void delEmpByUserId(Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
        this.getDatastore().delete(query);
    }

    @Override
    public List<Employee> compEmployeeList(ObjectId companyId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId);
        if (query == null) {
            return null;
        }
        List employees = query.asList();
        return employees;
    }

    @Override
    public List<Employee> departEmployeeList(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("departmentId").equal((Object)departmentId);
        if (query == null) {
            return null;
        }
        List emps = query.asList();
        return emps;
    }

    @Override
    public Employee findById(ObjectId employeeId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)employeeId);
        return (Employee)query.get();
    }

    @Override
    public byte findRole(ObjectId companyId, int userId) {
        Object role = this.queryOneField("role", (DBObject)new BasicDBObject("companyId", (Object)companyId).append("userId", (Object)userId));
        if (role != null && NumberUtil.isNumeric(role.toString())) {
            return ((Integer)role).byteValue();
        }
        return -1;
    }

    @Override
    public byte findRoleByDepartmentId(ObjectId departmentId, int userId) {
        Department department = SKBeanUtils.getDepartmentRepository().findDepartmentById(departmentId);
        if (department != null) {
            return this.findRole(department.getCompanyId(), userId);
        }
        return -1;
    }

    @Override
    public void delEmpByCompId(ObjectId companyId, int userId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).field("userId").equal((Object)userId);
        if (query != null) {
            this.getDatastore().delete(query);
        }
    }

    @Override
    public Employee modifyEmployeesByuserId(int userId) {
        Employee employeeInfo = new Employee();
        if (!StringUtil.isEmpty(String.valueOf(userId))) {
            Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
            UpdateOperations uo = this.getDatastore().createUpdateOperations(this.getEntityClass());
            List employeeList = query.asList();
            for (Employee employee2 : employeeList) {
                if (null != employee2 && !"".equals(employee2)) {
                    if (!StringUtil.isEmpty(String.valueOf(employee2.getChatNum()))) {
                        uo.set("chatNum", (Object)0);
                    }
                    if (!StringUtil.isEmpty(String.valueOf(employee2.getIsPause()))) {
                        uo.set("isPause", (Object)0);
                    }
                }
                this.getDatastore().update((Object)employee2, uo);
            }
        }
        return employeeInfo;
    }

    @Override
    public Employee findEmployee(Employee employee, User.UserSettings userSettings) {
        Query query = (Query)((Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)employee.getUserId())).field("departmentId").equal((Object)employee.getDepartmentId())).field("companyId").equal((Object)employee.getCompanyId());
        Employee employeeInfo = (Employee)query.get();
        return employeeInfo;
    }

    @Override
    public Employee findEmployee(Employee employee) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)employee.getUserId());
        if (null != employee.getDepartmentId()) {
            query.field("departmentId").equal((Object)employee.getDepartmentId());
        }
        if (null != employee.getCompanyId()) {
            query.field("companyId").equal((Object)employee.getCompanyId());
        }
        Employee employeeInfo = (Employee)query.get();
        return employeeInfo;
    }

    @Override
    public Employee getEmployeeByUserId(ObjectId companyId, int userId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).field("userId").equal((Object)userId);
        return (Employee)query.get();
    }

    @Override
    public Map<Integer, Integer> findWaiter(ObjectId companyId, ObjectId departmentId) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Query query = (Query)((Query)((Query)this.getDatastore().createQuery(Employee.class).field("companyId").equal((Object)companyId)).field("departmentId").equal((Object)departmentId)).field("isPause").equal((Object)1);
        if (query == null) {
            return null;
        }
        List emps = query.asList();
        for (Employee emp : emps) {
            map.put(emp.getUserId(), emp.getChatNum());
        }
        return map;
    }

    @Override
    public List<Employee> compEmployeeList(ObjectId employeeId, int pageSize, int pageIndex) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("departmentId").equal((Object)employeeId);
        List employee = query.offset(pageIndex * pageSize).limit(pageSize).asList();
        employee.forEach(emp -> {
            User user = SKBeanUtils.getUserManager().getUser(emp.getUserId());
        });
        return employee;
    }

    public List<Employee> employeeList(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("departmentId").equal((Object)departmentId);
        return query.asList();
    }
}

