/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Department;
import cn.xyz.repository.DepartmentRepository;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class DepartmentRepositoryImpl
extends MongoRepository<Department, ObjectId>
implements DepartmentRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Department> getEntityClass() {
        return Department.class;
    }

    @Override
    public ObjectId addDepartment(Department department) {
        ObjectId departmentId = (ObjectId)this.getDatastore().save((Object)department).getId();
        return departmentId;
    }

    @Override
    public Department modifyDepartment(Department department) {
        ObjectId departmentId = department.getId();
        if (departmentId == null) {
            return null;
        }
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)departmentId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != department.getDepartName()) {
            ops.set("departName", (Object)department.getDepartName());
        }
        if (0 <= department.getEmpNum()) {
            ops.set("empNum", (Object)department.getEmpNum());
        }
        if (null != department.getParentId()) {
            ops.set("parentId", (Object)department.getParentId());
        }
        Department depart = (Department)this.getDatastore().findAndModify(query, ops);
        return depart;
    }

    @Override
    public Department updateDepartment(ObjectId deptId, int type) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)deptId);
        Department department = (Department)query.get();
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (type == 1) {
            ops.set("empNum", (Object)(department.getEmpNum() + 1));
        } else if (type == -1) {
            ops.set("empNum", (Object)(department.getEmpNum() - 1));
        }
        return (Department)this.getDatastore().findAndModify(query, ops);
    }

    @Override
    public Department findDepartmentById(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)departmentId);
        return (Department)query.get();
    }

    @Override
    public void deleteDepartment(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)departmentId);
        if (query != null) {
            this.getDatastore().delete(query);
        }
    }

    @Override
    public void deleteAllDepartment(ObjectId companyId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId);
        this.getDatastore().delete(query);
    }

    @Override
    public List<Department> departmentList(ObjectId companyId, int pageSize, int pageIndex) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId);
        List departments = query.offset(pageIndex * pageSize).limit(pageSize).asList();
        return departments;
    }

    @Override
    public Department findById(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)departmentId);
        return (Department)query.get();
    }

    @Override
    public List<Department> departmentList(ObjectId companyId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId);
        return query.order("createTime").asList();
    }

    @Override
    public Department modifyRootDepartByCompId(ObjectId companyId, Department depart) {
        Query dQuery = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).field("type").equal((Object)1);
        depart.setId(((Department)dQuery.get()).getId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != depart.getDepartName()) {
            ops.set("departName", (Object)depart.getDepartName());
        }
        if (0 <= depart.getEmpNum()) {
            ops.set("empNum", (Object)depart.getEmpNum());
        }
        this.getDatastore().findAndModify(dQuery, ops);
        return null;
    }

    @Override
    public Department findOneByName(ObjectId companyId, String departName) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).field("departName").equal((Object)departName);
        return (Department)query.get();
    }

    @Override
    public ObjectId getCompanyId(ObjectId departmentId) {
        Query dQuery = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)departmentId);
        return ((Department)dQuery.get()).getCompanyId();
    }

    @Override
    public List<Department> findByType(ObjectId companyId, int type) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyId").equal((Object)companyId)).field("type").equal((Object)type);
        return query.asList();
    }

    @Override
    public List<Department> findChildDepartmeny(ObjectId departmentId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("parentId").equal((Object)departmentId);
        return query.asList();
    }
}

