/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.CommonText;
import cn.xyz.mianshi.vo.Company;
import cn.xyz.mianshi.vo.Customer;
import cn.xyz.mianshi.vo.Employee;
import cn.xyz.repository.CustomerRepository;
import cn.xyz.repository.mongo.MongoRepository;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class CustomerRepositoryImpl
extends MongoRepository<Company, ObjectId>
implements CustomerRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Company> getEntityClass() {
        return Company.class;
    }

    public static CustomerRepositoryImpl getInstance() {
        return new CustomerRepositoryImpl();
    }

    @Override
    public Map<String, Object> addCustomer(Customer customer) {
        BasicDBObject jo = new BasicDBObject();
        jo.put((Object)"customerId", (Object)customer.getCustomerId());
        jo.put((Object)"userKey", (Object)DigestUtils.md5Hex((String)customer.getIp()));
        jo.put((Object)"ip", (Object)customer.getIp());
        jo.put((Object)"macAddress", (Object)"");
        jo.put((Object)"createTime", (Object)DateUtil.currentTimeSeconds());
        jo.put((Object)"companyId", (Object)customer.getCompanyId());
        this.getDatastore().getDB().getCollection("customer").save((DBObject)jo);
        try {
            Map<String, Object> data = KSessionUtil.loginSaveAccessToken(customer.getCustomerId(), customer.getCustomerId(), null);
            data.put("customerId", customer.getCustomerId());
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer findUserByIp(String ip) {
        Query query = this.getDatastore().createQuery(Customer.class);
        if (!StringUtil.isEmpty(ip)) {
            query.field("userKey").equal((Object)DigestUtils.md5Hex((String)ip));
        }
        if (query.get() != null) {
            return ((Customer)query.get()).getCustomerId();
        }
        return null;
    }

    @Override
    public Map<Integer, Integer> findWaiter(ObjectId companyId, ObjectId departmentId) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Query query = (Query)((Query)((Query)this.getDatastore().createQuery(Employee.class).field("companyId").equal((Object)companyId)).field("departmentId").equal((Object)departmentId)).field("isPause").equal((Object)1);
        if (query == null) {
            return null;
        }
        List emps = query.asList();
        for (Employee emp : emps) {
            map.put(emp.getUserId(), emp.getChatNum());
        }
        return map;
    }

    @Override
    public CommonText commonTextAdd(CommonText commonText) {
        commonText.setCreateTime(DateUtil.currentTimeSeconds());
        commonText.setCreateUserId(ReqUtil.getUserId());
        commonText.setModifyUserId(ReqUtil.getUserId());
        this.getDatastore().save((Object)commonText);
        return commonText;
    }

    @Override
    public boolean deleteCommonText(String commonTextId) {
        ObjectId commonTextIds = new ObjectId(commonTextId);
        Query query = this.getDatastore().createQuery(CommonText.class).filter("_id", (Object)commonTextIds);
        this.getDatastore().delete(query);
        return true;
    }

    @Override
    public List<CommonText> commonTextGetByCommpanyId(String companyId, int page, int limit) {
        ObjectId companyIds = new ObjectId(companyId);
        Query query = this.getDatastore().createQuery(CommonText.class);
        query.filter("companyId", (Object)companyIds);
        List commonTextList = query.asList(SKBeanUtils.getCustomerRepository().pageFindOption(page, limit, 0));
        return commonTextList;
    }

    @Override
    public List<CommonText> commonTextGetByUserId(int userId, int page, int limit) {
        Query query = this.getDatastore().createQuery(CommonText.class);
        query.filter("companyId", (Object)"0").filter("createUserId", (Object)userId);
        List commonTextList = query.asList(SKBeanUtils.getCustomerRepository().pageFindOption(page, limit, 0));
        return commonTextList;
    }

    @Override
    public CommonText commonTextModify(CommonText commonText) {
        if (!StringUtil.isEmpty(commonText.getId().toString())) {
            Query query = (Query)this.getDatastore().createQuery(CommonText.class).field("_id").equal((Object)commonText.getId());
            UpdateOperations uo = this.getDatastore().createUpdateOperations(CommonText.class);
            if (null != commonText.getContent()) {
                uo.set("content", (Object)commonText.getContent());
            }
            uo.set("modifyUserId", (Object)ReqUtil.getUserId());
            uo.set("createTime", (Object)DateUtil.currentTimeSeconds());
            commonText = (CommonText)this.getDatastore().findAndModify(query, uo);
        }
        return commonText;
    }
}

