/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.repository.mongo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Company;
import cn.xyz.repository.CompanyRepository;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class CompanyRepositoryImpl
extends MongoRepository<Company, ObjectId>
implements CompanyRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Company> getEntityClass() {
        return Company.class;
    }

    public static CompanyRepositoryImpl getInstance() {
        return new CompanyRepositoryImpl();
    }

    @Override
    public Company addCompany(String companyName, int createUserId, ObjectId rootDpartId) {
        Company company = new Company();
        ArrayList<ObjectId> list = new ArrayList<ObjectId>();
        list.add(rootDpartId);
        company.setCompanyName(companyName);
        company.setCreateUserId(createUserId);
        company.setDeleteUserId(0);
        company.setCreateTime(DateUtil.currentTimeSeconds());
        company.setRootDpartId(list);
        company.setNoticeContent("");
        company.setDeleteTime(0L);
        company.setNoticeTime(0L);
        company.setEmpNum(1);
        ObjectId companyId = (ObjectId)this.getDatastore().save((Object)company).getId();
        company.setId(companyId);
        return company;
    }

    @Override
    public Company findCompanyByCreaterUserId(int createUserId) {
        Query query = ((Query)this.getDatastore().createQuery(this.getEntityClass()).field("createUserId").equal((Object)createUserId)).filter("deleteUserId  ==", (Object)0);
        return (Company)query.get();
    }

    @Override
    public Company modifyCompany(Company company) {
        ObjectId companyId = company.getId();
        if (companyId == null) {
            return null;
        }
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)companyId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != company.getCompanyName()) {
            ops.set("companyName", (Object)company.getCompanyName());
        }
        if (0 != company.getCreateUserId()) {
            ops.set("createUserId", (Object)company.getCreateUserId());
        }
        if (0 != company.getDeleteUserId()) {
            ops.set("deleteUserId", (Object)company.getDeleteUserId());
        }
        if (null != company.getRootDpartId()) {
            ops.set("rootDpartId", company.getRootDpartId());
        }
        if (0L != company.getCreateTime()) {
            ops.set("createTime", (Object)company.getCreateTime());
        }
        if (null != company.getNoticeContent()) {
            ops.set("noticeContent", (Object)company.getNoticeContent());
            ops.set("noticeTime", (Object)DateUtil.currentTimeSeconds());
        }
        if (0L != company.getDeleteTime()) {
            ops.set("deleteTime", (Object)company.getDeleteTime());
        }
        if (0 != company.getEmpNum()) {
            ops.set("empNum", (Object)company.getEmpNum());
        }
        Company comp = (Company)this.getDatastore().findAndModify(query, ops);
        return comp;
    }

    @Override
    public List<Company> findCompanyByName(String keyworld) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        query.criteria("companyName").containsIgnoreCase(keyworld);
        List companys = query.asList();
        Iterator iter = companys.iterator();
        while (iter.hasNext()) {
            Company company = (Company)iter.next();
            if (company.getDeleteUserId() == 0) continue;
            iter.remove();
        }
        return companys;
    }

    @Override
    public Company findById(ObjectId companyId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)companyId);
        if (query == null) {
            return null;
        }
        return (Company)query.get();
    }

    @Override
    public List<Company> companyList(int pageSize, int pageIndex) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("deleteUserId").equal((Object)0);
        List companys = query.offset(pageIndex * pageSize).limit(pageSize).asList();
        return companys;
    }

    @Override
    public Company findOneByName(String companyName) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("companyName").equal((Object)companyName)).field("deleteUserId").equal((Object)0);
        return (Company)query.get();
    }

    @Override
    public List<Company> findByType(int type) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("type").equal((Object)type);
        return query.asList();
    }
}

