/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.vo;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Config;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Indexes;

@Entity(value="shiku_room", noClassnameStored=true)
@Indexes(value={@Index(value="userId"), @Index(value="jid"), @Index(value="userId,jid")})
public class Room {
    @Id
    private ObjectId id;
    private String jid;
    private String name;
    private String desc;
    private String subject;
    private Integer category;
    private List<String> tags;
    private String call;
    private String videoMeetingNo;
    private Notice notice;
    private List<Notice> notices;
    private Integer userSize;
    private Integer maxUserSize = 1000;
    private Member member;
    private List<Member> members;
    private Integer countryId;
    private Integer provinceId;
    private Integer cityId;
    private Integer areaId;
    private Double longitude;
    private Double latitude;
    private Integer userId;
    private String nickname;
    private Long createTime;
    private Integer modifier;
    private Long modifyTime;
    private byte s;
    private byte isLook = 1;
    private byte showRead = 0;
    private byte isNeedVerify = 0;
    private byte showMember = 1;
    private byte allowSendCard = 1;
    private byte allowHostUpdate = 1;
    private byte allowInviteFriend = 1;
    private byte allowUploadFile = 1;
    private byte allowConference = 1;
    private byte allowSpeakCourse = 1;
    private byte isAttritionNotice = 1;
    private long talkTime;
    private double chatRecordTimeOut = -1.0;
    private String labelName;
    private String promotionUrl;
    private byte isSecretGroup = 0;
    private byte encryptType = 0;

    public void initRoomConfig(int createrId, String createrNickName) {
        if (null == this.getId()) {
            this.setId(ObjectId.get());
        }
        this.setCall(String.valueOf(SKBeanUtils.getUserManager().createCall()));
        this.setVideoMeetingNo(String.valueOf(SKBeanUtils.getUserManager().createvideoMeetingNo()));
        this.setSubject("");
        this.setTags(Lists.newArrayList());
        this.setNotice(new Notice());
        this.setNotices(Lists.newArrayList());
        this.setUserSize(0);
        this.setMembers(Lists.newArrayList());
        this.setUserId(createrId);
        this.setNickname(createrNickName);
        this.setCreateTime(DateUtil.currentTimeSeconds());
        this.setModifyTime(this.getCreateTime());
        this.setS((byte)1);
        Config config = SKBeanUtils.getSystemConfig();
        if (config.getMaxUserSize() > 0) {
            this.setMaxUserSize(config.getMaxUserSize());
        }
        this.setIsAttritionNotice(config.getIsAttritionNotice());
        this.setIsLook(config.getIsLook());
        this.setShowRead(config.getShowRead());
        this.setIsNeedVerify(config.getIsNeedVerify());
        this.setShowMember(config.getShowMember());
        this.setAllowSendCard(config.getAllowSendCard());
        this.setAllowInviteFriend(config.getAllowInviteFriend());
        this.setAllowUploadFile(config.getAllowUploadFile());
        this.setAllowConference(config.getAllowConference());
        this.setAllowSpeakCourse(config.getAllowSpeakCourse());
    }

    public synchronized void addMember(Member member) {
        if (null == this.members || 0 == this.members.size()) {
            this.members = new ArrayList<Member>();
            this.members.add(member);
        } else {
            boolean contains = false;
            for (Member mem : this.members) {
                if (!mem.userId.equals(member.getUserId())) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.members.add(member);
            }
        }
    }

    public synchronized void removeMember(Member member) {
        if (null != this.members || 0 < this.members.size()) {
            this.members.remove(member);
        }
    }

    public synchronized void removeMember(int userId) {
        if (null != this.members || 0 < this.members.size()) {
            Member member = null;
            for (Member mem : this.members) {
                if (!mem.userId.equals(userId)) continue;
                member = mem;
                break;
            }
            if (null != member) {
                this.members.remove(member);
            }
        }
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSubject() {
        return this.subject;
    }

    public Integer getCategory() {
        return this.category;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getCall() {
        return this.call;
    }

    public String getVideoMeetingNo() {
        return this.videoMeetingNo;
    }

    public Notice getNotice() {
        return this.notice;
    }

    public List<Notice> getNotices() {
        return this.notices;
    }

    public Integer getUserSize() {
        return this.userSize;
    }

    public Integer getMaxUserSize() {
        return this.maxUserSize;
    }

    public Member getMember() {
        return this.member;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public Integer getCountryId() {
        return this.countryId;
    }

    public Integer getProvinceId() {
        return this.provinceId;
    }

    public Integer getCityId() {
        return this.cityId;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Integer getModifier() {
        return this.modifier;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public byte getS() {
        return this.s;
    }

    public byte getIsLook() {
        return this.isLook;
    }

    public byte getShowRead() {
        return this.showRead;
    }

    public byte getIsNeedVerify() {
        return this.isNeedVerify;
    }

    public byte getShowMember() {
        return this.showMember;
    }

    public byte getAllowSendCard() {
        return this.allowSendCard;
    }

    public byte getAllowHostUpdate() {
        return this.allowHostUpdate;
    }

    public byte getAllowInviteFriend() {
        return this.allowInviteFriend;
    }

    public byte getAllowUploadFile() {
        return this.allowUploadFile;
    }

    public byte getAllowConference() {
        return this.allowConference;
    }

    public byte getAllowSpeakCourse() {
        return this.allowSpeakCourse;
    }

    public byte getIsAttritionNotice() {
        return this.isAttritionNotice;
    }

    public long getTalkTime() {
        return this.talkTime;
    }

    public double getChatRecordTimeOut() {
        return this.chatRecordTimeOut;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public String getPromotionUrl() {
        return this.promotionUrl;
    }

    public byte getIsSecretGroup() {
        return this.isSecretGroup;
    }

    public byte getEncryptType() {
        return this.encryptType;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setCall(String call) {
        this.call = call;
    }

    public void setVideoMeetingNo(String videoMeetingNo) {
        this.videoMeetingNo = videoMeetingNo;
    }

    public void setNotice(Notice notice) {
        this.notice = notice;
    }

    public void setNotices(List<Notice> notices) {
        this.notices = notices;
    }

    public void setUserSize(Integer userSize) {
        this.userSize = userSize;
    }

    public void setMaxUserSize(Integer maxUserSize) {
        this.maxUserSize = maxUserSize;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public void setCountryId(Integer countryId) {
        this.countryId = countryId;
    }

    public void setProvinceId(Integer provinceId) {
        this.provinceId = provinceId;
    }

    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifier(Integer modifier) {
        this.modifier = modifier;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setS(byte s) {
        this.s = s;
    }

    public void setIsLook(byte isLook) {
        this.isLook = isLook;
    }

    public void setShowRead(byte showRead) {
        this.showRead = showRead;
    }

    public void setIsNeedVerify(byte isNeedVerify) {
        this.isNeedVerify = isNeedVerify;
    }

    public void setShowMember(byte showMember) {
        this.showMember = showMember;
    }

    public void setAllowSendCard(byte allowSendCard) {
        this.allowSendCard = allowSendCard;
    }

    public void setAllowHostUpdate(byte allowHostUpdate) {
        this.allowHostUpdate = allowHostUpdate;
    }

    public void setAllowInviteFriend(byte allowInviteFriend) {
        this.allowInviteFriend = allowInviteFriend;
    }

    public void setAllowUploadFile(byte allowUploadFile) {
        this.allowUploadFile = allowUploadFile;
    }

    public void setAllowConference(byte allowConference) {
        this.allowConference = allowConference;
    }

    public void setAllowSpeakCourse(byte allowSpeakCourse) {
        this.allowSpeakCourse = allowSpeakCourse;
    }

    public void setIsAttritionNotice(byte isAttritionNotice) {
        this.isAttritionNotice = isAttritionNotice;
    }

    public void setTalkTime(long talkTime) {
        this.talkTime = talkTime;
    }

    public void setChatRecordTimeOut(double chatRecordTimeOut) {
        this.chatRecordTimeOut = chatRecordTimeOut;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public void setPromotionUrl(String promotionUrl) {
        this.promotionUrl = promotionUrl;
    }

    public void setIsSecretGroup(byte isSecretGroup) {
        this.isSecretGroup = isSecretGroup;
    }

    public void setEncryptType(byte encryptType) {
        this.encryptType = encryptType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Room)) {
            return false;
        }
        Room other = (Room)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectId this$id = this.getId();
        ObjectId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$jid = this.getJid();
        String other$jid = other.getJid();
        if (this$jid == null ? other$jid != null : !this$jid.equals(other$jid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        Integer this$category = this.getCategory();
        Integer other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$call = this.getCall();
        String other$call = other.getCall();
        if (this$call == null ? other$call != null : !this$call.equals(other$call)) {
            return false;
        }
        String this$videoMeetingNo = this.getVideoMeetingNo();
        String other$videoMeetingNo = other.getVideoMeetingNo();
        if (this$videoMeetingNo == null ? other$videoMeetingNo != null : !this$videoMeetingNo.equals(other$videoMeetingNo)) {
            return false;
        }
        Notice this$notice = this.getNotice();
        Notice other$notice = other.getNotice();
        if (this$notice == null ? other$notice != null : !this$notice.equals(other$notice)) {
            return false;
        }
        List<Notice> this$notices = this.getNotices();
        List<Notice> other$notices = other.getNotices();
        if (this$notices == null ? other$notices != null : !((Object)this$notices).equals(other$notices)) {
            return false;
        }
        Integer this$userSize = this.getUserSize();
        Integer other$userSize = other.getUserSize();
        if (this$userSize == null ? other$userSize != null : !((Object)this$userSize).equals(other$userSize)) {
            return false;
        }
        Integer this$maxUserSize = this.getMaxUserSize();
        Integer other$maxUserSize = other.getMaxUserSize();
        if (this$maxUserSize == null ? other$maxUserSize != null : !((Object)this$maxUserSize).equals(other$maxUserSize)) {
            return false;
        }
        Member this$member = this.getMember();
        Member other$member = other.getMember();
        if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
            return false;
        }
        List<Member> this$members = this.getMembers();
        List<Member> other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        Integer this$countryId = this.getCountryId();
        Integer other$countryId = other.getCountryId();
        if (this$countryId == null ? other$countryId != null : !((Object)this$countryId).equals(other$countryId)) {
            return false;
        }
        Integer this$provinceId = this.getProvinceId();
        Integer other$provinceId = other.getProvinceId();
        if (this$provinceId == null ? other$provinceId != null : !((Object)this$provinceId).equals(other$provinceId)) {
            return false;
        }
        Integer this$cityId = this.getCityId();
        Integer other$cityId = other.getCityId();
        if (this$cityId == null ? other$cityId != null : !((Object)this$cityId).equals(other$cityId)) {
            return false;
        }
        Integer this$areaId = this.getAreaId();
        Integer other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !((Object)this$areaId).equals(other$areaId)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Integer this$modifier = this.getModifier();
        Integer other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !((Object)this$modifier).equals(other$modifier)) {
            return false;
        }
        Long this$modifyTime = this.getModifyTime();
        Long other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        if (this.getS() != other.getS()) {
            return false;
        }
        if (this.getIsLook() != other.getIsLook()) {
            return false;
        }
        if (this.getShowRead() != other.getShowRead()) {
            return false;
        }
        if (this.getIsNeedVerify() != other.getIsNeedVerify()) {
            return false;
        }
        if (this.getShowMember() != other.getShowMember()) {
            return false;
        }
        if (this.getAllowSendCard() != other.getAllowSendCard()) {
            return false;
        }
        if (this.getAllowHostUpdate() != other.getAllowHostUpdate()) {
            return false;
        }
        if (this.getAllowInviteFriend() != other.getAllowInviteFriend()) {
            return false;
        }
        if (this.getAllowUploadFile() != other.getAllowUploadFile()) {
            return false;
        }
        if (this.getAllowConference() != other.getAllowConference()) {
            return false;
        }
        if (this.getAllowSpeakCourse() != other.getAllowSpeakCourse()) {
            return false;
        }
        if (this.getIsAttritionNotice() != other.getIsAttritionNotice()) {
            return false;
        }
        if (this.getTalkTime() != other.getTalkTime()) {
            return false;
        }
        if (Double.compare(this.getChatRecordTimeOut(), other.getChatRecordTimeOut()) != 0) {
            return false;
        }
        String this$labelName = this.getLabelName();
        String other$labelName = other.getLabelName();
        if (this$labelName == null ? other$labelName != null : !this$labelName.equals(other$labelName)) {
            return false;
        }
        String this$promotionUrl = this.getPromotionUrl();
        String other$promotionUrl = other.getPromotionUrl();
        if (this$promotionUrl == null ? other$promotionUrl != null : !this$promotionUrl.equals(other$promotionUrl)) {
            return false;
        }
        if (this.getIsSecretGroup() != other.getIsSecretGroup()) {
            return false;
        }
        return this.getEncryptType() == other.getEncryptType();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Room;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $jid = this.getJid();
        result = result * 59 + ($jid == null ? 43 : $jid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        Integer $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $call = this.getCall();
        result = result * 59 + ($call == null ? 43 : $call.hashCode());
        String $videoMeetingNo = this.getVideoMeetingNo();
        result = result * 59 + ($videoMeetingNo == null ? 43 : $videoMeetingNo.hashCode());
        Notice $notice = this.getNotice();
        result = result * 59 + ($notice == null ? 43 : $notice.hashCode());
        List<Notice> $notices = this.getNotices();
        result = result * 59 + ($notices == null ? 43 : ((Object)$notices).hashCode());
        Integer $userSize = this.getUserSize();
        result = result * 59 + ($userSize == null ? 43 : ((Object)$userSize).hashCode());
        Integer $maxUserSize = this.getMaxUserSize();
        result = result * 59 + ($maxUserSize == null ? 43 : ((Object)$maxUserSize).hashCode());
        Member $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        List<Member> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        Integer $countryId = this.getCountryId();
        result = result * 59 + ($countryId == null ? 43 : ((Object)$countryId).hashCode());
        Integer $provinceId = this.getProvinceId();
        result = result * 59 + ($provinceId == null ? 43 : ((Object)$provinceId).hashCode());
        Integer $cityId = this.getCityId();
        result = result * 59 + ($cityId == null ? 43 : ((Object)$cityId).hashCode());
        Integer $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : ((Object)$areaId).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Integer $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : ((Object)$modifier).hashCode());
        Long $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        result = result * 59 + this.getS();
        result = result * 59 + this.getIsLook();
        result = result * 59 + this.getShowRead();
        result = result * 59 + this.getIsNeedVerify();
        result = result * 59 + this.getShowMember();
        result = result * 59 + this.getAllowSendCard();
        result = result * 59 + this.getAllowHostUpdate();
        result = result * 59 + this.getAllowInviteFriend();
        result = result * 59 + this.getAllowUploadFile();
        result = result * 59 + this.getAllowConference();
        result = result * 59 + this.getAllowSpeakCourse();
        result = result * 59 + this.getIsAttritionNotice();
        long $talkTime = this.getTalkTime();
        result = result * 59 + (int)($talkTime >>> 32 ^ $talkTime);
        long $chatRecordTimeOut = Double.doubleToLongBits(this.getChatRecordTimeOut());
        result = result * 59 + (int)($chatRecordTimeOut >>> 32 ^ $chatRecordTimeOut);
        String $labelName = this.getLabelName();
        result = result * 59 + ($labelName == null ? 43 : $labelName.hashCode());
        String $promotionUrl = this.getPromotionUrl();
        result = result * 59 + ($promotionUrl == null ? 43 : $promotionUrl.hashCode());
        result = result * 59 + this.getIsSecretGroup();
        result = result * 59 + this.getEncryptType();
        return result;
    }

    public String toString() {
        return "Room(id=" + this.getId() + ", jid=" + this.getJid() + ", name=" + this.getName() + ", desc=" + this.getDesc() + ", subject=" + this.getSubject() + ", category=" + this.getCategory() + ", tags=" + this.getTags() + ", call=" + this.getCall() + ", videoMeetingNo=" + this.getVideoMeetingNo() + ", notice=" + this.getNotice() + ", notices=" + this.getNotices() + ", userSize=" + this.getUserSize() + ", maxUserSize=" + this.getMaxUserSize() + ", member=" + this.getMember() + ", members=" + this.getMembers() + ", countryId=" + this.getCountryId() + ", provinceId=" + this.getProvinceId() + ", cityId=" + this.getCityId() + ", areaId=" + this.getAreaId() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", userId=" + this.getUserId() + ", nickname=" + this.getNickname() + ", createTime=" + this.getCreateTime() + ", modifier=" + this.getModifier() + ", modifyTime=" + this.getModifyTime() + ", s=" + this.getS() + ", isLook=" + this.getIsLook() + ", showRead=" + this.getShowRead() + ", isNeedVerify=" + this.getIsNeedVerify() + ", showMember=" + this.getShowMember() + ", allowSendCard=" + this.getAllowSendCard() + ", allowHostUpdate=" + this.getAllowHostUpdate() + ", allowInviteFriend=" + this.getAllowInviteFriend() + ", allowUploadFile=" + this.getAllowUploadFile() + ", allowConference=" + this.getAllowConference() + ", allowSpeakCourse=" + this.getAllowSpeakCourse() + ", isAttritionNotice=" + this.getIsAttritionNotice() + ", talkTime=" + this.getTalkTime() + ", chatRecordTimeOut=" + this.getChatRecordTimeOut() + ", labelName=" + this.getLabelName() + ", promotionUrl=" + this.getPromotionUrl() + ", isSecretGroup=" + this.getIsSecretGroup() + ", encryptType=" + this.getEncryptType() + ")";
    }

    @Entity(value="shiku_room_share", noClassnameStored=true)
    public static class Share {
        @Id
        private ObjectId shareId;
        @Indexed
        private ObjectId roomId;
        private String name;
        private String url;
        private long time;
        @Indexed
        private Integer userId;
        private String nickname;
        private int type;
        private float size;

        public Share() {
        }

        public Share(ObjectId shareId, ObjectId roomId, String name, String url, long time, Integer userId, String nickname, int type, float size) {
            this.shareId = shareId;
            this.roomId = roomId;
            this.name = name;
            this.url = url;
            this.time = time;
            this.userId = userId;
            this.nickname = nickname;
            this.type = type;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ObjectId getShareId() {
            return this.shareId;
        }

        public void setShareId(ObjectId shareId) {
            this.shareId = shareId;
        }

        public ObjectId getRoomId() {
            return this.roomId;
        }

        public void setRoomId(ObjectId roomId) {
            this.roomId = roomId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float size) {
            this.size = size;
        }
    }

    @Entity(value="shiku_room_member", noClassnameStored=true)
    @Indexes(value={@Index(value="roomId"), @Index(value="userId"), @Index(value="roomId,userId"), @Index(value="userId,role")})
    public static class Member {
        @Id
        @JSONField(serialize=false)
        private ObjectId id;
        @JSONField(serialize=false)
        private ObjectId roomId;
        private Integer userId;
        private String nickname;
        private String remarkName;
        private int role = 3;
        private Integer sub;
        private String call;
        private String videoMeetingNo;
        private Integer offlineNoPushMsg = 0;
        private Long talkTime;
        private Long active;
        private Long createTime;
        private Long modifyTime;
        private byte isOpenTopChat = 0;
        private long openTopChatTime = 0L;
        private String chatKeyGroup;

        public Member() {
        }

        public Member(ObjectId roomId, Integer userId, String nickname) {
            this.active = DateUtil.currentTimeSeconds();
            this.roomId = roomId;
            this.userId = userId;
            this.nickname = nickname;
            this.role = 3;
            this.sub = 1;
            this.talkTime = 0L;
            this.createTime = this.active;
            this.modifyTime = this.active;
        }

        public ObjectId getId() {
            return this.id;
        }

        public String getCall() {
            return this.call;
        }

        public void setCall(String call) {
            this.call = call;
        }

        public String getVideoMeetingNo() {
            return this.videoMeetingNo;
        }

        public void setVideoMeetingNo(String videoMeetingNo) {
            this.videoMeetingNo = videoMeetingNo;
        }

        public void setId(ObjectId id) {
            this.id = id;
        }

        public ObjectId getRoomId() {
            return this.roomId;
        }

        public void setRoomId(ObjectId roomId) {
            this.roomId = roomId;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public int getRole() {
            return this.role;
        }

        public void setRole(int role) {
            this.role = role;
        }

        public Integer getOfflineNoPushMsg() {
            return this.offlineNoPushMsg;
        }

        public void setOfflineNoPushMsg(Integer offlineNoPushMsg) {
            this.offlineNoPushMsg = offlineNoPushMsg;
        }

        public Integer getSub() {
            return this.sub;
        }

        public void setSub(Integer sub) {
            this.sub = sub;
        }

        public Long getTalkTime() {
            return this.talkTime;
        }

        public void setTalkTime(Long talkTime) {
            this.talkTime = talkTime;
        }

        public Long getActive() {
            return this.active;
        }

        public void setActive(Long active) {
            this.active = active;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(Long modifyTime) {
            this.modifyTime = modifyTime;
        }

        public String getRemarkName() {
            return this.remarkName;
        }

        public void setRemarkName(String remarkName) {
            this.remarkName = remarkName;
        }

        public byte getIsOpenTopChat() {
            return this.isOpenTopChat;
        }

        public void setIsOpenTopChat(byte isOpenTopChat) {
            this.isOpenTopChat = isOpenTopChat;
        }

        public long getOpenTopChatTime() {
            return this.openTopChatTime;
        }

        public void setOpenTopChatTime(long openTopChatTime) {
            this.openTopChatTime = openTopChatTime;
        }

        public String getChatKeyGroup() {
            return this.chatKeyGroup;
        }

        public void setChatKeyGroup(String chatKeyGroup) {
            this.chatKeyGroup = chatKeyGroup;
        }
    }

    @Entity(value="shiku_room_notice", noClassnameStored=true)
    @Indexes(value={@Index(value="roomId")})
    public static class Notice {
        @Id
        private ObjectId id;
        private ObjectId roomId;
        private String text;
        private Integer userId;
        private String nickname;
        private long time;
        private long modifyTime;

        public ObjectId getId() {
            return this.id;
        }

        public void setId(ObjectId id) {
            this.id = id;
        }

        public ObjectId getRoomId() {
            return this.roomId;
        }

        public void setRoomId(ObjectId roomId) {
            this.roomId = roomId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public long getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(long modifyTime) {
            this.modifyTime = modifyTime;
        }

        public Notice() {
        }

        public Notice(ObjectId id, ObjectId roomId, String text, Integer userId, String nickname) {
            this.id = id;
            this.roomId = roomId;
            this.text = text;
            this.userId = userId;
            this.nickname = nickname;
            this.time = DateUtil.currentTimeSeconds();
        }
    }
}

