/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.vo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.JSONUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.AddMsgParam;
import cn.xyz.mianshi.vo.Comment;
import cn.xyz.mianshi.vo.ForwardAmount;
import cn.xyz.mianshi.vo.Givegift;
import cn.xyz.mianshi.vo.PlayAmount;
import cn.xyz.mianshi.vo.Praise;
import cn.xyz.mianshi.vo.User;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.Indexes;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Transient;

@Entity(value="s_msg", noClassnameStored=true)
@Indexes(value={@Index(value="cityId,flag,userId,visible,body.title")})
public class Msg {
    private Body body;
    private int cityId;
    private String cityName;
    private Count count;
    private Integer flag;
    private Double latitude;
    private String location;
    private Double longitude;
    private String model;
    @Id
    private ObjectId msgId;
    private String nickname;
    private Long time;
    private Integer userId;
    private String lable;
    private Integer visible = 1;
    private List<Integer> userLook;
    private List<Integer> userNotLook;
    private List<Integer> userRemindLook;
    @Reference
    private List<Comment> comments;
    @Reference
    private List<Givegift> gifts;
    @Reference
    private List<Praise> praises;
    @Reference
    private List<ForwardAmount> forwardAmount;
    @Reference
    private List<PlayAmount> playAmount;
    @Transient
    private int isPraise;
    @Transient
    private int isCollect;
    private int state;
    private int isAllowComment;
    @NotSaved
    private Integer userStatus;
    private String fileName;

    public int getIsCollect() {
        return this.isCollect;
    }

    public void setIsCollect(int isCollect) {
        this.isCollect = isCollect;
    }

    public Body getBody() {
        return this.body;
    }

    public int getCityId() {
        return this.cityId;
    }

    public String getCityName() {
        return this.cityName;
    }

    public Count getCount() {
        return this.count;
    }

    public Integer getFlag() {
        return this.flag;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public String getLocation() {
        return this.location;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getModel() {
        return this.model;
    }

    public ObjectId getMsgId() {
        return this.msgId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Long getTime() {
        return this.time;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public Integer getVisible() {
        return this.visible;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public void setCount(Count count) {
        this.count = count;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMsgId(ObjectId msgId) {
        this.msgId = msgId;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setVisible(Integer visible) {
        this.visible = visible;
    }

    public List<Integer> getUserLook() {
        return this.userLook;
    }

    public void setUserLook(List<Integer> userLook) {
        this.userLook = userLook;
    }

    public List<Integer> getUserNotLook() {
        return this.userNotLook;
    }

    public void setUserNotLook(List<Integer> userNotLook) {
        this.userNotLook = userNotLook;
    }

    public List<Integer> getUserRemindLook() {
        return this.userRemindLook;
    }

    public void setUserRemindLook(List<Integer> userRemindLook) {
        this.userRemindLook = userRemindLook;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Givegift> getGifts() {
        return this.gifts;
    }

    public void setGifts(List<Givegift> gifts) {
        this.gifts = gifts;
    }

    public List<Praise> getPraises() {
        return this.praises;
    }

    public void setPraises(List<Praise> praises) {
        this.praises = praises;
    }

    public List<ForwardAmount> getForwardAmount() {
        return this.forwardAmount;
    }

    public void setForwardAmount(List<ForwardAmount> forwardAmount) {
        this.forwardAmount = forwardAmount;
    }

    public List<PlayAmount> getPlayAmount() {
        return this.playAmount;
    }

    public void setPlayAmount(List<PlayAmount> playAmount) {
        this.playAmount = playAmount;
    }

    public int getIsPraise() {
        return this.isPraise;
    }

    public void setIsPraise(int isPraise) {
        this.isPraise = isPraise;
    }

    public static Msg build(User user, AddMsgParam param) {
        Body body = new Body();
        body.title = param.getTitle();
        body.text = param.getText();
        if (!StringUtil.isEmpty(param.getLable())) {
            body.lable = param.getLable();
        }
        body.type = param.getType();
        if (2 == param.getType() || 4 == param.getType()) {
            body.images = JSON.parseArray((String)param.getImages(), Resource.class);
            if (null != body.images && 0 == body.images.size()) {
                throw new ServiceException("\u8bf7\u4e0a\u4f20\u6709\u6548\u56fe\u7247");
            }
        }
        body.audios = JSON.parseArray((String)param.getAudios(), Resource.class);
        body.videos = JSON.parseArray((String)param.getVideos(), Resource.class);
        body.files = JSON.parseArray((String)param.getFiles(), Resource.class);
        body.time = param.getTime();
        body.address = param.getAddress();
        body.remark = param.getRemark();
        body.sdkUrl = param.getSdkUrl();
        body.sdkIcon = param.getSdkIcon();
        body.sdkTitle = param.getSdkTitle();
        Count count = new Count();
        count.play = 0L;
        count.forward = 0L;
        count.share = 0L;
        count.collect = 0L;
        count.praise = 0L;
        count.comment = 0L;
        count.money = 0L;
        count.total = 0L;
        Msg entity = new Msg();
        entity.msgId = ObjectId.get();
        entity.userId = user.getUserId();
        entity.nickname = 10000 == user.getUserId() ? "\u5ba2\u670d\u516c\u4f17\u53f7" : user.getNickname();
        entity.flag = param.getFlag();
        if (0 == param.getVisible()) {
            param.setVisible(1);
        }
        entity.visible = param.getVisible();
        entity.userLook = param.getUserLook();
        entity.userNotLook = param.getUserNotLook();
        entity.userRemindLook = param.getUserRemindLook();
        entity.body = body;
        entity.count = count;
        entity.time = DateUtil.currentTimeSeconds();
        entity.model = param.getModel();
        entity.cityId = param.getCityId();
        entity.cityName = param.getCityName();
        entity.latitude = param.getLatitude();
        entity.longitude = param.getLongitude();
        entity.location = param.getLocation();
        entity.isAllowComment = param.getIsAllowComment();
        return entity;
    }

    public String toString() {
        return JSONUtil.toJSONString(this);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Integer getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(Integer userStatus) {
        this.userStatus = userStatus;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLable() {
        return this.lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }

    public int getIsAllowComment() {
        return this.isAllowComment;
    }

    public void setIsAllowComment(int isAllowComment) {
        this.isAllowComment = isAllowComment;
    }

    public static class Resource {
        private int length;
        @JsonProperty(value="oUrl")
        @JSONField(name="oUrl")
        private String oUrl;
        @JsonProperty(value="tUrl")
        @JSONField(name="tUrl")
        private String tUrl;
        @JsonProperty(value="oFileName")
        @JSONField(name="oFileName")
        private String oFileName;
        private long size;

        public long getLength() {
            return this.length;
        }

        public String getOUrl() {
            return this.oUrl;
        }

        public long getSize() {
            return this.size;
        }

        public String getTUrl() {
            return this.tUrl;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setOUrl(String oUrl) {
            this.oUrl = oUrl;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setTUrl(String tUrl) {
            this.tUrl = tUrl;
        }

        public String getoFileName() {
            return this.oFileName;
        }

        public void setoFileName(String oFileName) {
            this.oFileName = oFileName;
        }
    }

    public static enum Op {
        Collect("count.collect"),
        Comment("count.comment"),
        Forwarding("count.forward"),
        Gift("count.gift"),
        Play("count.play"),
        Praise("count.praise"),
        Share("count.share");

        private String key;

        private Op(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class Count {
        private long collect;
        private long comment;
        private long forward;
        private long money;
        private long play;
        private long praise;
        private long share;
        private long total;

        public long getCollect() {
            return this.collect;
        }

        public long getComment() {
            return this.comment;
        }

        public long getForward() {
            return this.forward;
        }

        public long getMoney() {
            return this.money;
        }

        public long getPlay() {
            return this.play;
        }

        public long getPraise() {
            return this.praise;
        }

        public long getShare() {
            return this.share;
        }

        public long getTotal() {
            return this.total;
        }

        public void setCollect(long collect) {
            this.collect = collect;
        }

        public void setComment(long comment) {
            this.comment = comment;
        }

        public void setForward(long forward) {
            this.forward = forward;
        }

        public void setMoney(long money) {
            this.money = money;
        }

        public void setPlay(long play) {
            this.play = play;
        }

        public void setPraise(long praise) {
            this.praise = praise;
        }

        public void setShare(long share) {
            this.share = share;
        }

        public void setTotal(long total) {
            this.total = total;
        }
    }

    public static class Body {
        private String address;
        private List<Resource> audios;
        private List<Resource> images;
        private String remark;
        private String text;
        private long time;
        private String title;
        private int type;
        private String lable;
        private String sdkUrl;
        private String sdkIcon;
        private String sdkTitle;
        private List<Resource> videos;
        private List<Resource> files;

        public String getAddress() {
            return this.address;
        }

        public List<Resource> getAudios() {
            return this.audios;
        }

        public List<Resource> getImages() {
            return this.images;
        }

        public String getRemark() {
            return this.remark;
        }

        public String getText() {
            return this.text;
        }

        public long getTime() {
            return this.time;
        }

        public String getTitle() {
            return this.title;
        }

        public int getType() {
            return this.type;
        }

        public List<Resource> getVideos() {
            return this.videos;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setAudios(List<Resource> audios) {
            this.audios = audios;
        }

        public void setImages(List<Resource> images) {
            this.images = images;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setVideos(List<Resource> videos) {
            this.videos = videos;
        }

        public List<Resource> getFiles() {
            return this.files;
        }

        public void setFiles(List<Resource> files) {
            this.files = files;
        }

        public String getSdkUrl() {
            return this.sdkUrl;
        }

        public void setSdkUrl(String sdkUrl) {
            this.sdkUrl = sdkUrl;
        }

        public String getSdkIcon() {
            return this.sdkIcon;
        }

        public void setSdkIcon(String sdkIcon) {
            this.sdkIcon = sdkIcon;
        }

        public String getSdkTitle() {
            return this.sdkTitle;
        }

        public void setSdkTitle(String sdkTitle) {
            this.sdkTitle = sdkTitle;
        }

        public String getLable() {
            return this.lable;
        }

        public void setLable(String lable) {
            this.lable = lable;
        }
    }
}

