/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.utils;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.HttpClientUtil;
import cn.xyz.commons.utils.WebNetEncode;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.SmsRecord;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SMSVerificationUtils {
    protected static Logger smsLogger = LoggerFactory.getLogger((String)"SMSVerificationUtils");
    public static final String SMSFORMAT = "00";

    public static KApplicationProperties.SmsConfig getSmsConfig() {
        return SKBeanUtils.getSmsConfig();
    }

    public static SendSmsResponse sendSms(String telephone, String code, String areaCode) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)SMSVerificationUtils.getSmsConfig().getAccesskeyid(), (String)SMSVerificationUtils.getSmsConfig().getAccesskeysecret());
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)SMSVerificationUtils.getSmsConfig().getProduct(), (String)SMSVerificationUtils.getSmsConfig().getDomain());
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        smsLogger.info("\u683c\u5f0f\u5316\u624b\u673a\u53f7 :  00 + \u56fd\u9645\u533a\u53f7 + \u53f7\u7801   ==========>   SMSFORMAT :00  areaCode: " + areaCode);
        request.setPhoneNumbers(SMSFORMAT + telephone);
        request.setSignName(SMSVerificationUtils.getSmsConfig().getSignname());
        request.setTemplateCode(SMSVerificationUtils.getSmsConfig().getEnglish_templetecode());
        if ("86".equals(areaCode) || "886".equals(areaCode) || "852".equals(areaCode)) {
            request.setTemplateCode(SMSVerificationUtils.getSmsConfig().getChinase_templetecode());
        }
        request.setTemplateParam("{\"code\":\"" + code + "\"}");
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        smsLogger.info("\u963f\u91cc\u4e91\u77ed\u4fe1\u670d\u52a1\u56de\u6267\u8be6\u60c5\uff1a" + JSONObject.toJSONString((Object)sendSmsResponse));
        if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            smsLogger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
            SMSVerificationUtils.saveSMSToDB(request.getPhoneNumbers(), areaCode, code, request.getSignName() + request.getTemplateCode(), sendSmsResponse.getRequestId());
        } else {
            smsLogger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
        return sendSmsResponse;
    }

    public static String sendSmsToMs360(String telephone, String areaCode, String code) {
        String msgId = null;
        try {
            String ip = SMSVerificationUtils.getSmsConfig().getHost();
            int port = SMSVerificationUtils.getSmsConfig().getPort();
            HttpClientUtil util = new HttpClientUtil(ip, port, SMSVerificationUtils.getSmsConfig().getApi());
            String user = SMSVerificationUtils.getSmsConfig().getUsername();
            String pwd = SMSVerificationUtils.getSmsConfig().getPassword();
            String ServiceID = "SEND";
            String dest = telephone;
            String sender = "";
            String templateEnglishSMS = new String(SMSVerificationUtils.getSmsConfig().getTemplateEnglishSMS().getBytes("ISO-8859-1"), "utf-8");
            String msg = templateEnglishSMS + code;
            if ("86".equals(areaCode) || "886".equals(areaCode) || "852".equals(areaCode)) {
                String templateChineseSMS = new String(SMSVerificationUtils.getSmsConfig().getTemplateChineseSMS().getBytes("ISO-8859-1"), "utf-8");
                msg = templateChineseSMS + code;
            }
            String hex = WebNetEncode.encodeHexStr(8, msg);
            hex = hex.trim() + "&codec=8";
            msgId = util.sendGetMessage(user, pwd, ServiceID, dest, sender, hex);
            smsLogger.info("msgid =  " + msgId + "    msg = " + msg);
            SMSVerificationUtils.saveSMSToDB(telephone, areaCode, code, msg, msgId);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return msgId;
    }

    public static void saveSMSToDB(String telephone, String areaCode, String code, String content, String msgId) {
        SmsRecord sms = ConstantUtil.getSmsPrice(areaCode);
        if (null == sms) {
            sms = new SmsRecord();
        }
        sms.setAreaCode(areaCode);
        sms.setTelephone(telephone);
        sms.setCode(code);
        sms.setContent(content);
        sms.setMsgId(msgId);
        sms.setTime(DateUtil.currentTimeSeconds());
        ConstantUtil.dsForRW.save((Object)sms);
    }
}

