/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.utils;

import cn.xyz.commons.support.jedis.RedisCRUD;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ClientConfig;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.User;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KSessionUtil {
    private static final Logger log = LoggerFactory.getLogger(KSessionUtil.class);
    public static final String GET_USERID_BYTOKEN = "loginToken:userId:%s";
    public static final String GET_ACCESS_TOKEN_BY_USER_ID = "loginToken:token:%s";
    public static final String GET_ACCESS_TOKEN_BY_USERDEVICEID = "loginToken:token:%s:%s";
    public static final String GET_API_TOKEN_BY_USER_ID = "apiToken:%s";
    public static final String GET_ADMIN_USERID_BYTOKEN = "adminToken:userId:%s";
    public static final String GET_ADMIN_TOKEN_BY_USER_ID = "adminToken:token:%s";
    public static final String GET_SESSION_BY_ACCESS_TOKEN = "login:%s:session";
    public static final String GET_USER_BY_USERID = "user:%s:data";
    public static final String GET_CONFIG = "app:config";
    public static final String GET_CLIENTCONFIG = "clientConfig";
    public static final String GET_APNS_KEY = "apns:%s:token";
    public static final String GET_PUSH_IOS_KEY = "impush:ios:%s";
    public static final String GET_PUSH_Android_KEY = "impush:andoird:%s";
    public static final String GET_USER_MsgNum = "userMsgNum:%s";
    public static final String GET_ADDRESS_BYIP = "clientIp:%s";

    public static RedisCRUD getRedisCRUD() {
        return SKBeanUtils.getRedisCRUD();
    }

    public static void setConfig(Config config) {
        KSessionUtil.getRedisCRUD().set(GET_CONFIG, config.toString());
    }

    public static Config getConfig() {
        String config = KSessionUtil.getRedisCRUD().get(GET_CONFIG);
        return StringUtil.isEmpty(config) ? null : (Config)JSON.parseObject((String)config, Config.class);
    }

    public static void setClientConfig(ClientConfig clientConfig) {
        KSessionUtil.getRedisCRUD().set(GET_CLIENTCONFIG, clientConfig.toString());
    }

    public static ClientConfig getClientConfig() {
        String config = KSessionUtil.getRedisCRUD().get(GET_CLIENTCONFIG);
        return StringUtil.isEmpty(config) ? null : (ClientConfig)JSON.parseObject((String)config, ClientConfig.class);
    }

    public static Map<String, Object> loginSaveAccessToken(Object userKey, Object userId, String accessToken) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            int expire = 3024000;
            String atKey = String.format(GET_ACCESS_TOKEN_BY_USER_ID, userKey);
            if (StringUtil.isEmpty(accessToken)) {
                accessToken = SKBeanUtils.getRedisCRUD().get(atKey);
            }
            if (StringUtil.isEmpty(accessToken)) {
                accessToken = StringUtil.randomUUID();
            }
            SKBeanUtils.getRedisCRUD().setWithExpireTime(atKey, accessToken, expire);
            String userIdKey = String.format(GET_USERID_BYTOKEN, accessToken);
            SKBeanUtils.getRedisCRUD().setWithExpireTime(userIdKey, String.valueOf(userId), expire);
            data.put("access_token", accessToken);
            data.put("expires_in", expire);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return data;
        }
    }

    public static void loginSaveAccessTokenByDeviceId(int userId, String deviceId, String accessToken) {
        try {
            int expire = 2592000;
            String atKey = String.format(GET_ACCESS_TOKEN_BY_USERDEVICEID, userId, deviceId);
            if (StringUtil.isEmpty(accessToken)) {
                accessToken = StringUtil.randomUUID();
            }
            String oldToken = SKBeanUtils.getRedisCRUD().get(atKey);
            SKBeanUtils.getRedisCRUD().setWithExpireTime(atKey, accessToken, expire);
            String userIdKey = String.format(GET_USERID_BYTOKEN, accessToken);
            if (!StringUtil.isEmpty(oldToken)) {
                SKBeanUtils.getRedisCRUD().del(String.format(GET_USERID_BYTOKEN, oldToken));
                SKBeanUtils.getRedisService().cleanUserSesson(oldToken);
            }
            SKBeanUtils.getRedisCRUD().setWithExpireTime(userIdKey, String.valueOf(userId), expire);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeAccessTokenByDeviceId(int userId, String deviceId) {
        String key = String.format(GET_ACCESS_TOKEN_BY_USERDEVICEID, userId, deviceId);
        String access_token = SKBeanUtils.getRedisCRUD().get(key);
        if (!StringUtil.isEmpty(access_token)) {
            KSessionUtil.getRedisCRUD().delete(key);
        }
        if (!StringUtil.isEmpty(access_token)) {
            String userIdKey = String.format(GET_USERID_BYTOKEN, access_token);
            SKBeanUtils.getRedisCRUD().del(userIdKey);
        }
    }

    public static Map<String, Object> adminLoginSaveToken(Object userId, String adminToken) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            int expire = 1800;
            String userIdKey = String.format(GET_ADMIN_TOKEN_BY_USER_ID, userId);
            if (StringUtil.isEmpty(adminToken)) {
                adminToken = SKBeanUtils.getRedisCRUD().get(userIdKey);
            }
            if (StringUtil.isEmpty(adminToken)) {
                adminToken = StringUtil.randomUUID();
            }
            SKBeanUtils.getRedisCRUD().setWithExpireTime(userIdKey, adminToken, expire);
            String tokenKey = String.format(GET_ADMIN_USERID_BYTOKEN, adminToken);
            SKBeanUtils.getRedisCRUD().setWithExpireTime(tokenKey, String.valueOf(userId), expire);
            data.put("access_Token", adminToken);
            data.put("expires_in", expire);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return data;
        }
    }

    public static void removeAdminToken(Object userKey) {
        log.info(" removeAdminToken ===== userKey ===== :" + userKey);
        String key = String.format(GET_ADMIN_TOKEN_BY_USER_ID, userKey);
        String admin_token = SKBeanUtils.getRedisCRUD().get(key);
        if (!StringUtil.isEmpty(admin_token)) {
            KSessionUtil.getRedisCRUD().delete(key);
        }
        if (!StringUtil.isEmpty(admin_token)) {
            String userIdKey = String.format(GET_ADMIN_USERID_BYTOKEN, admin_token);
            SKBeanUtils.getRedisCRUD().del(userIdKey);
        }
    }

    public static void removeAccessToken(Object userKey) {
        log.info("  removeAccessToken  =====  userKey  ======= :" + userKey);
        String key = String.format(GET_ACCESS_TOKEN_BY_USER_ID, userKey);
        String access_token = SKBeanUtils.getRedisCRUD().get(key);
        if (!StringUtil.isEmpty(access_token)) {
            KSessionUtil.getRedisCRUD().delete(key);
        }
        if (!StringUtil.isEmpty(access_token)) {
            String userIdKey = String.format(GET_USERID_BYTOKEN, access_token);
            SKBeanUtils.getRedisCRUD().del(userIdKey);
        }
    }

    public static String getAccess_token(long userId) {
        String key = String.format(GET_ACCESS_TOKEN_BY_USER_ID, userId);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static String getUserIdBytoken(String token) {
        String key = String.format(GET_USERID_BYTOKEN, token);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static String getAdminToken(long userId) {
        String key = String.format(GET_ADMIN_TOKEN_BY_USER_ID, userId);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static String getAdminUserIdByToken(String token) {
        String key = String.format(GET_ADMIN_USERID_BYTOKEN, token);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static User getUserByUserId(Integer userId) {
        String key = String.format(GET_USER_BY_USERID, userId);
        String value = KSessionUtil.getRedisCRUD().get(key);
        User user = null;
        try {
            user = (User)JSON.parseObject((String)value, User.class);
        }
        catch (JSONException e) {
            return null;
        }
        return user;
    }

    public static void saveUserByUserId(Integer userId, User user) {
        String key = String.format(GET_USER_BY_USERID, userId);
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, user.toString(), 86400);
    }

    public static void deleteUserByUserId(Integer userId) {
        String key = String.format(GET_USER_BY_USERID, userId);
        KSessionUtil.getRedisCRUD().del(key);
    }

    public static void saveIosPushToken(Integer userId, User.DeviceInfo info) {
        String key = String.format(GET_PUSH_IOS_KEY, userId);
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, info.toString(), 3024000);
    }

    public static User.DeviceInfo getIosPushToken(Integer userId) {
        String key = String.format(GET_PUSH_IOS_KEY, userId);
        String value = KSessionUtil.getRedisCRUD().get(key);
        return StringUtil.isEmpty(value) ? null : (User.DeviceInfo)JSON.parseObject((String)value, User.DeviceInfo.class);
    }

    public static void removeIosPushToken(Integer userId) {
        String key = String.format(GET_PUSH_IOS_KEY, userId);
        KSessionUtil.getRedisCRUD().del(key);
    }

    public static void saveAndroidPushToken(Integer userId, User.DeviceInfo info) {
        String key = String.format(GET_PUSH_Android_KEY, userId);
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, info.toString(), 604800);
    }

    public static User.DeviceInfo getAndroidPushToken(Integer userId) {
        String key = String.format(GET_PUSH_Android_KEY, userId);
        String value = KSessionUtil.getRedisCRUD().get(key);
        return StringUtil.isEmpty(value) ? null : (User.DeviceInfo)JSON.parseObject((String)value, User.DeviceInfo.class);
    }

    public static void removeAndroidPushToken(Integer userId) {
        String key = String.format(GET_PUSH_Android_KEY, userId);
        KSessionUtil.getRedisCRUD().del(key);
    }

    public static void saveAPNSToken(String regId, Integer userId) {
        String key = String.format(GET_APNS_KEY, String.valueOf(userId));
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, regId, 604800);
    }

    public static String getAPNSToken(Integer userId) {
        String key = String.format(GET_APNS_KEY, userId);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static synchronized void saveUserMsgNum(Integer userId, Integer num) {
        String key = String.format(GET_USER_MsgNum, String.valueOf(userId));
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, num.toString(), 259200);
    }

    public static synchronized Integer getUserMsgNum(Integer userId) {
        String key = String.format(GET_USER_MsgNum, userId);
        try {
            return Integer.valueOf(KSessionUtil.getRedisCRUD().get(key));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getAddressByIp(String ip) {
        String key = String.format(GET_ADDRESS_BYIP, ip);
        return KSessionUtil.getRedisCRUD().get(key);
    }

    public static void setAddressByIp(String ip, String address) {
        String key = String.format(GET_ADDRESS_BYIP, ip);
        KSessionUtil.getRedisCRUD().setWithExpireTime(key, address, 43200);
    }
}

