/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.utils;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.FileUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.vo.Areas;
import cn.xyz.mianshi.vo.Constant;
import cn.xyz.mianshi.vo.ErrorMessage;
import cn.xyz.mianshi.vo.Language;
import cn.xyz.mianshi.vo.SmsRecord;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ConstantUtil
implements ApplicationContextAware {
    private static Map<String, Map<String, String>> errorMsgMap = Maps.newHashMap();
    public static Datastore dsForRW;
    @Resource(name="dsForRW")
    private Datastore ds;
    public static KApplicationProperties.AppConfig appConfig;
    @Autowired(required=false)
    private KApplicationProperties.AppConfig appConf;
    public static BasicDBObject staticProjection;
    public static final String defLanguage = "zh";

    public static int getAppDefDistance() {
        return appConfig.getDistance();
    }

    public static void deleteFile(String ... paths) {
        try {
            String domain = appConfig.getUploadDomain();
            FileUtil.deleteFileToUploadDomain(domain, paths);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static String copyFile(int validTime, String ... paths) {
        String url = null;
        String domain = appConfig.getUploadDomain();
        try {
            url = FileUtil.copyFileToUploadDomain(domain, validTime, paths);
        }
        catch (ServiceException e) {
            throw new ServiceException("\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
        }
        return url;
    }

    public static Constant getCityName(Integer id, String language) {
        DBCollection collection = dsForRW.getDB().getCollection("tb_areas");
        if (StringUtil.isEmpty(language)) {
            language = defLanguage;
        }
        BasicDBObject query = new BasicDBObject("id", (Object)id);
        BasicDBObject projection = staticProjection;
        projection.append(language, (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        Constant constant = new Constant();
        constant.setId(obj.getInt("id"));
        if (!StringUtil.isEmpty(obj.getString(language))) {
            constant.setValue(obj.getString(language));
        } else {
            constant.setValue(obj.getString(defLanguage));
        }
        constant.setName(obj.getString(defLanguage));
        return constant;
    }

    public static Areas getAreasByName(String name) {
        DBCollection collection = dsForRW.getDB().getCollection("tb_areas");
        BasicDBObject query = new BasicDBObject(defLanguage, (Object)name);
        BasicDBObject projection = staticProjection;
        projection.append("type", (Object)1);
        projection.append("code", (Object)1);
        projection.append("ab", (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        Areas areas = new Areas();
        areas.setId(obj.getInt("id"));
        areas.setType(obj.getInt("type"));
        areas.setValue(obj.getString(defLanguage));
        areas.setCode(obj.getString("code"));
        areas.setAb(obj.getString("ab"));
        areas.setName(areas.getValue());
        return areas;
    }

    public static Areas getAreasByCode(String code) {
        DBCollection collection = dsForRW.getDB().getCollection("tb_areas");
        BasicDBObject query = new BasicDBObject("code", (Object)code);
        query.append("type", (Object)1);
        BasicDBObject projection = staticProjection;
        projection.append("type", (Object)1);
        projection.append("code", (Object)1);
        projection.append("ab", (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        Areas areas = new Areas();
        areas.setId(obj.getInt("id"));
        areas.setType(obj.getInt("type"));
        areas.setValue(obj.getString(defLanguage));
        areas.setCode(obj.getString("code"));
        areas.setAb(obj.getString("ab"));
        areas.setName(areas.getValue());
        return areas;
    }

    public static Areas getAreasById(Integer id) {
        DBCollection collection = dsForRW.getDB().getCollection("tb_areas");
        BasicDBObject query = new BasicDBObject("id", (Object)id);
        query.append("type", (Object)1);
        BasicDBObject projection = staticProjection;
        projection.append("type", (Object)1);
        projection.append("code", (Object)1);
        projection.append("ab", (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        Areas areas = new Areas();
        areas.setId(obj.getInt("id"));
        areas.setType(obj.getInt("type"));
        areas.setValue(obj.getString(defLanguage));
        areas.setCode(obj.getString("code"));
        areas.setAb(obj.getString("ab"));
        areas.setName(areas.getValue());
        return areas;
    }

    public static Areas getAreasByCountry(String country) {
        DBCollection collection = dsForRW.getDB().getCollection("tb_areas");
        BasicDBObject query = new BasicDBObject("ab", (Object)country);
        query.append("type", (Object)1);
        BasicDBObject projection = staticProjection;
        projection.append("type", (Object)1);
        projection.append("code", (Object)1);
        projection.append("ab", (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        Areas areas = new Areas();
        areas.setId(obj.getInt("id"));
        areas.setType(obj.getInt("type"));
        areas.setValue(obj.getString(defLanguage));
        areas.setCode(obj.getString("code"));
        areas.setAb(obj.getString("ab"));
        areas.setName(areas.getValue());
        return areas;
    }

    public static String getMsgByCode(String code) {
        return ConstantUtil.getMsgByCode(code, defLanguage);
    }

    public static String getMsgByCode(String code, String language) {
        Map<String, String> map;
        if (StringUtil.isEmpty(language)) {
            language = defLanguage;
        }
        if (null != (map = errorMsgMap.get(code))) {
            if (StringUtil.isEmpty(map.get(language))) {
                return map.get(defLanguage);
            }
            return map.get(language);
        }
        DBCollection collection = dsForRW.getDB().getCollection("message");
        BasicDBObject query = new BasicDBObject("code", (Object)code);
        BasicDBObject projection = new BasicDBObject(language, (Object)1);
        projection.append("code", (Object)1);
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)query, (DBObject)projection);
        if (null == obj) {
            return null;
        }
        if (StringUtil.isEmpty(obj.getString(language))) {
            return obj.getString(defLanguage);
        }
        return obj.getString(language);
    }

    public static List<Constant> getMsgByType(String type, String language) {
        ArrayList list = Lists.newArrayList();
        DBCollection collection = dsForRW.getDB().getCollection("message");
        if (StringUtil.isEmpty(language)) {
            language = defLanguage;
        }
        BasicDBObject query = new BasicDBObject("type", (Object)type);
        BasicDBObject projection = new BasicDBObject(language, (Object)1);
        projection.append("code", (Object)1);
        DBCursor cursor = collection.find((DBObject)query, (DBObject)projection);
        if (null == cursor) {
            return null;
        }
        Constant constant = null;
        BasicDBObject obj = null;
        while (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            constant = new Constant();
            constant.setCode(obj.getString("code"));
            if (!StringUtil.isEmpty(obj.getString(language))) {
                constant.setValue(obj.getString(language));
            } else {
                constant.setValue(obj.getString(defLanguage));
            }
            constant.setName(obj.getString(defLanguage));
            list.add(constant);
        }
        return list;
    }

    public static Map<String, String> getMsgMapByType(String type, String language) {
        HashMap map = Maps.newHashMap();
        DBCollection collection = dsForRW.getDB().getCollection("message");
        if (StringUtil.isEmpty(language)) {
            language = defLanguage;
        }
        BasicDBObject query = new BasicDBObject("type", (Object)type);
        BasicDBObject projection = new BasicDBObject(language, (Object)1);
        projection.append("code", (Object)1);
        DBCursor cursor = collection.find((DBObject)query, (DBObject)projection);
        if (null == cursor) {
            return null;
        }
        BasicDBObject obj = null;
        String value = null;
        while (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            value = !StringUtil.isEmpty(obj.getString(language)) ? obj.getString(language) : obj.getString(defLanguage);
            map.put(obj.getString("code"), value);
        }
        return map;
    }

    public static SmsRecord getSmsPrice(String areaCode) {
        DBCollection collection = dsForRW.getDB().getCollection("sms_country");
        BasicDBObject query = new BasicDBObject("prefix", (Object)areaCode);
        BasicDBObject projection = new BasicDBObject("price", (Object)1);
        projection.append(defLanguage, (Object)1);
        DBCursor cursor = collection.find((DBObject)query, (DBObject)projection);
        if (null == cursor) {
            return null;
        }
        BasicDBObject obj = null;
        SmsRecord record = null;
        while (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            record = new SmsRecord();
            record.setPrice(obj.getDouble("price"));
            record.setCountry(obj.getString(defLanguage));
        }
        return record;
    }

    public static String format(Long milliseconds, String pattern) {
        Date date = new Date(milliseconds * 1000L);
        String dateStr = new SimpleDateFormat(pattern).format(date);
        return dateStr;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        System.out.println(" ConstantUtil----init--- Start");
        dsForRW = this.ds;
        appConfig = this.appConf;
    }

    public static void updateErrorMessage(String code, Map<String, String> map) {
        errorMsgMap.put(code, map);
    }

    public static void deleteErrorMessage(String code) {
        errorMsgMap.remove(code);
    }

    public static void initMsgMap() {
        System.out.println(" ConstantUtil----MsgMap--- init");
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                DBCursor cursor = dsForRW.getDB().getCollection("message").find();
                ErrorMessage errorMessage = null;
                BasicDBObject result = null;
                HashMap map = null;
                while (cursor.hasNext()) {
                    result = (BasicDBObject)cursor.next();
                    errorMessage = new ErrorMessage();
                    map = Maps.newHashMap();
                    for (Language language : appConfig.getLanguages()) {
                        map.put(language.getKey(), result.getString(language.getKey()));
                    }
                    errorMessage.setMap(map);
                    errorMsgMap.put(result.getString("code"), map);
                }
                System.out.println(" ConstantUtil----MsgMap--- End");
            }
        });
    }

    static {
        staticProjection = new BasicDBObject("id", (Object)1);
        staticProjection.append(defLanguage, (Object)1);
        staticProjection.append(defLanguage, (Object)1);
        staticProjection.append("_id", (Object)0);
    }
}

