/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.constants.KConstants;
import cn.xyz.commons.constants.MsgType;
import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.LoginPassword;
import cn.xyz.commons.utils.Md5Util;
import cn.xyz.commons.utils.MoneyUtils;
import cn.xyz.commons.utils.RandomUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.utils.ValueUtil;
import cn.xyz.commons.utils.WXUserUtils;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.model.KSession;
import cn.xyz.mianshi.model.LoginExample;
import cn.xyz.mianshi.model.NearbyUser;
import cn.xyz.mianshi.model.PageVO;
import cn.xyz.mianshi.model.UserExample;
import cn.xyz.mianshi.model.UserLoginTokenKey;
import cn.xyz.mianshi.model.UserQueryExample;
import cn.xyz.mianshi.service.UserManager;
import cn.xyz.mianshi.service.impl.AuthKeysServiceImpl;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AuthKeys;
import cn.xyz.mianshi.vo.Collect;
import cn.xyz.mianshi.vo.Company;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.Course;
import cn.xyz.mianshi.vo.CourseMessage;
import cn.xyz.mianshi.vo.Department;
import cn.xyz.mianshi.vo.Emoji;
import cn.xyz.mianshi.vo.Employee;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.mianshi.vo.InviteCode;
import cn.xyz.mianshi.vo.OfflineOperation;
import cn.xyz.mianshi.vo.PushInfo;
import cn.xyz.mianshi.vo.Report;
import cn.xyz.mianshi.vo.Role;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.SdkLoginInfo;
import cn.xyz.mianshi.vo.User;
import cn.xyz.mianshi.vo.UserStatusCount;
import cn.xyz.mianshi.vo.WxUser;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.repository.mongo.UserRepositoryImpl;
import cn.xyz.service.KSMSServiceImpl;
import cn.xyz.service.KXMPPServiceImpl;
import cn.xyz.service.RedisServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.shiku.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="UserManagerImpl")
public class UserManagerImpl
extends MongoRepository<User, Integer>
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private static final String userIdLockKey = "userIdLock";
    private static final String INCREASE_USERID = "increaseUserId";
    public static final String BEAN_ID = "UserManagerImpl";
    @Autowired
    AuthKeysServiceImpl authKeysService;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getLocalSpringBeanManager().getDatastore();
    }

    @Override
    public Class<User> getEntityClass() {
        return User.class;
    }

    private static UserRepositoryImpl getUserRepository() {
        return SKBeanUtils.getUserRepository();
    }

    private static RedisServiceImpl getRedisServiceImpl() {
        return SKBeanUtils.getRedisService();
    }

    @Override
    public User createUser(String telephone, String password) {
        User user = new User();
        user.setUserId(this.createUserId());
        user.setUserKey(DigestUtils.md5Hex((String)telephone));
        user.setPassword(DigestUtils.md5Hex((String)password));
        user.setTelephone(telephone);
        UserManagerImpl.getUserRepository().addUser(user);
        return user;
    }

    @Override
    public void createUser(User user) {
        UserManagerImpl.getUserRepository().addUser(user);
    }

    @Override
    public User.UserSettings getSettings(int userId) {
        User.UserSettings settings = null;
        User user = null;
        user = this.getUser(userId);
        if (null == user) {
            return null;
        }
        settings = user.getSettings();
        return null != settings ? settings : new User.UserSettings();
    }

    public User getUserFromDB(int userId) {
        User user = UserManagerImpl.getUserRepository().getUser(userId);
        if (null == user) {
            System.out.println("id\u4e3a" + userId + "\u7684\u7528\u6237\u4e0d\u5b58\u5728");
            SKBeanUtils.getFriendsManager().deleteFansAndFriends(userId);
            return null;
        }
        KSessionUtil.saveUserByUserId(userId, user);
        return user;
    }

    @Override
    public User getUser(int userId) {
        User user = KSessionUtil.getUserByUserId(userId);
        if (null == user) {
            user = UserManagerImpl.getUserRepository().getUser(userId);
            if (null == user) {
                log.info("\u8be5\u7528\u6237\u4e0d\u5b58\u5728, userId: {}", (Object)userId);
                SKBeanUtils.getFriendsManager().deleteFansAndFriends(userId);
                return null;
            }
            KSessionUtil.saveUserByUserId(userId, user);
        }
        return user;
    }

    public User getUserByAccount(String account) {
        User user = SKBeanUtils.getRedisService().queryUserByAccount(account);
        if (null == user) {
            user = (User)UserManagerImpl.getUserRepository().queryOne("account", account);
            if (null == user) {
                log.info("\u8be5\u7528\u6237\u4e0d\u5b58\u5728, account: {}", (Object)account);
                return null;
            }
            SKBeanUtils.getRedisService().saveUserByAccount(account, user);
        }
        return user;
    }

    @Override
    public String getNickName(int userId) {
        String nickName = SKBeanUtils.getRedisService().queryUserNickName(userId);
        if (!StringUtil.isEmpty(nickName)) {
            return nickName;
        }
        return (String)this.queryOneFieldById("nickname", Integer.valueOf(userId));
    }

    public synchronized int getMsgNum(int userId) {
        int userMsgNum = KSessionUtil.getUserMsgNum(userId);
        if (0 != userMsgNum) {
            return userMsgNum;
        }
        userMsgNum = (Integer)this.queryOneFieldById("msgNum", Integer.valueOf(userId));
        KSessionUtil.saveUserMsgNum(userId, userMsgNum);
        return userMsgNum;
    }

    public synchronized void changeMsgNum(int userId, int num) {
        KSessionUtil.saveUserMsgNum(userId, num);
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("msgNum", (Object)num);
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public void changeStatus(int userId, int status) {
        UpdateOperations operations = UserManagerImpl.getUserRepository().createUpdateOperations();
        operations.set("status", (Object)status);
        UserManagerImpl.getUserRepository().updateAttributeByOps(Integer.valueOf(userId), operations);
        KSessionUtil.removeAccessToken(userId);
        KSessionUtil.deleteUserByUserId(userId);
    }

    @Override
    public User getUser(int userId, int toUserId) {
        User user = this.getUser(toUserId);
        if (null != user) {
            Friends friends = SKBeanUtils.getFriendsManager().getFriends(new Friends(userId, toUserId));
            user.setFriends(null == friends ? null : friends);
            if (userId == toUserId) {
                List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
                user.setRole(userRoles);
            }
        } else {
            throw new ServiceException(100211);
        }
        this.setUserSettingInfo(user, userId, toUserId);
        return user;
    }

    private void setUserSettingInfo(User user, Integer userId, Integer toUserId) {
        User userInfo;
        String phone = this.getUser(userId).getPhone();
        if (!StringUtil.isEmpty(phone) && !phone.equals("18938880001")) {
            User.UserLoginLog loginLog = (User.UserLoginLog)((Query)this.getDatastore().createQuery(User.UserLoginLog.class).field("userId").equal((Object)toUserId)).get();
            if (null != user.getSettings()) {
                boolean flag;
                if (-1 != user.getSettings().getShowLastLoginTime()) {
                    flag = SKBeanUtils.getFriendsManager().isAddressBookOrFriends(userId, toUserId, user.getSettings().getShowLastLoginTime());
                    if (flag && null != loginLog && null != loginLog.getLoginLog()) {
                        user.setShowLastLoginTime(loginLog.getLoginLog().getLoginTime());
                    }
                } else if (-1 == user.getSettings().getShowLastLoginTime() && userId.equals(toUserId) && null != loginLog && null != loginLog.getLoginLog()) {
                    user.setShowLastLoginTime(loginLog.getLoginLog().getLoginTime());
                }
                if (-1 == user.getSettings().getShowTelephone() && !userId.equals(toUserId)) {
                    user.setAreaCode("");
                    user.setTelephone("");
                    user.setPhone("");
                } else if (2 == user.getSettings().getShowTelephone() || 3 == user.getSettings().getShowTelephone()) {
                    if (userId.equals(toUserId)) {
                        return;
                    }
                    flag = SKBeanUtils.getFriendsManager().isAddressBookOrFriends(userId, toUserId, user.getSettings().getShowTelephone());
                    if (!flag) {
                        user.setAreaCode("");
                        user.setTelephone("");
                        user.setPhone("");
                    }
                }
            }
        }
        if (null != (userInfo = this.getUser(userId)).getSettings().getNotSeeFilterCircleUserIds()) {
            if (userInfo.getSettings().getNotSeeFilterCircleUserIds().contains(toUserId)) {
                user.setNotLetSeeHim(true);
            }
            user.getSettings().setNotSeeFilterCircleUserIds(null);
        } else {
            user.setNotLetSeeHim(false);
        }
        if (null != userInfo.getSettings().getFilterCircleUserIds()) {
            if (userInfo.getSettings().getFilterCircleUserIds().contains(toUserId)) {
                user.setNotSeeHim(true);
            }
            user.getSettings().setFilterCircleUserIds(null);
        } else {
            user.setNotSeeHim(false);
        }
    }

    @Override
    public User getUser(String telephone) {
        User user = UserManagerImpl.getUserRepository().getUser(telephone);
        if (null == user) {
            throw new ServiceException(100211);
        }
        return user;
    }

    public Map<String, User.DeviceInfo> getLoginDeviceMap(Integer userId) {
        Query query = this.getDatastore().createQuery(User.UserLoginLog.class);
        User.UserLoginLog userLoginLog = (User.UserLoginLog)query.filter("_id", (Object)userId).get();
        if (null == userLoginLog) {
            return null;
        }
        return userLoginLog.getDeviceMap();
    }

    @Override
    public int getUserId(String accessToken) {
        return 0;
    }

    @Override
    public boolean isRegister(String telephone) {
        return 1L == UserManagerImpl.getUserRepository().getCount(telephone);
    }

    @Override
    public User login(String telephone, String password) {
        String userKey = DigestUtils.md5Hex((String)telephone);
        User user = UserManagerImpl.getUserRepository().getUserv1(userKey, null);
        if (null == user) {
            throw new ServiceException(1040101);
        }
        user.setPayPassword("");
        String _md5 = DigestUtils.md5Hex((String)password);
        if (password.equals(user.getPassword()) || _md5.equals(user.getPassword())) {
            return user;
        }
        throw new ServiceException(1040102);
    }

    public User mpLogin(String telephone, String password) {
        String userKey = DigestUtils.md5Hex((String)telephone);
        User user = UserManagerImpl.getUserRepository().getUserv1(userKey, null);
        if (null == user) {
            throw new ServiceException(1040101);
        }
        if (2 != user.getUserType()) {
            throw new ServiceException(10111);
        }
        user.setPayPassword("");
        if (!password.equals(user.getPassword()) && !(password = LoginPassword.encodeFromOldPassword(password)).equals(user.getPassword())) {
            throw new ServiceException(1040102);
        }
        return user;
    }

    public Map<String, Object> loginV1(LoginExample example) {
        Map<String, Object> map;
        User user = null;
        user = (User)this.get(Integer.valueOf(example.getUserId()));
        if (user.getSettings().getAuthSwitch() == 1 && !StringUtil.isEmpty(example.getSerial()) && (map = this.findAuto(user, example.getSerial(), example.getDeviceType())) != null) {
            return map;
        }
        return this.loginSuccessV1(user, example);
    }

    public KSession createAutoLoginSesson(UserLoginTokenKey loginTokenKey, String language, String token) {
        KSession session;
        if (StringUtil.isEmpty(loginTokenKey.getDeviceId()) || StringUtil.isEmpty(token)) {
            token = KSessionUtil.getAccess_token(loginTokenKey.getUserId());
        }
        if (!StringUtil.isEmpty(token) && null != (session = SKBeanUtils.getRedisService().queryUserSesson(token))) {
            return session;
        }
        session = new KSession(loginTokenKey.getUserId(), language, loginTokenKey.getDeviceId());
        session.setLoginToken(loginTokenKey.getLoginToken());
        session.setAccessToken(StringUtil.randomUUID());
        session.setHttpKey(Base64.encode((byte[])RandomUtils.nextBytes((int)16)));
        session.setMessageKey(Base64.encode((byte[])RandomUtils.nextBytes((int)16)));
        session.setPayKey(Base64.encode((byte[])RandomUtils.nextBytes((int)16)));
        KSessionUtil.loginSaveAccessTokenByDeviceId(session.getUserId(), session.getDeviceId(), session.getAccessToken());
        SKBeanUtils.getRedisService().saveUserSesson(session);
        return session;
    }

    public Map<String, Object> createAutoLoginResultMap(KSession session) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("access_token", session.getAccessToken());
        result.put("httpKey", session.getHttpKey());
        result.put("messageKey", session.getMessageKey());
        result.put("payKey", session.getPayKey());
        return result;
    }

    public Map<String, Object> loginAutoV1(LoginExample example, UserLoginTokenKey userLoginToken, String token) {
        int userId = example.getUserId();
        KSession session = null;
        if (null != userLoginToken) {
            session = this.createAutoLoginSesson(userLoginToken, example.getLanguage(), token);
        } else {
            userLoginToken = new UserLoginTokenKey();
            userLoginToken.setUserId(userId);
            userLoginToken.setDeviceId("shikuim");
            session = this.createAutoLoginSesson(userLoginToken, example.getLanguage(), token);
        }
        if (null == session) {
            throw new ServiceException(1030112);
        }
        User user = this.getUser(userId);
        if (null == user) {
            throw new ServiceException(1040101);
        }
        if (-1 == user.getStatus()) {
            throw new ServiceException(1040304);
        }
        User.LoginLog loginLog = UserManagerImpl.getUserRepository().getLogin(userId);
        int serialStatus = 1;
        if (null != example && null != example.getSerial() && null != loginLog && null != loginLog.getSerial()) {
            serialStatus = null == loginLog ? 1 : (example.getSerial().equals(loginLog.getSerial()) ? 2 : 3);
        }
        try {
            String payPwd;
            Map<String, Object> result = this.createAutoLoginResultMap(session);
            result.put("serialStatus", serialStatus);
            result.put("tokenExists", true);
            result.put("userId", userId);
            result.put("nickname", user.getNickname());
            result.put("name", user.getName());
            result.put("login", loginLog);
            result.put("settings", this.getSettings(userId));
            result.put("serialStatus", serialStatus);
            result.put("multipleDevices", user.getSettings().getMultipleDevices());
            List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
            if (null != userRoles && userRoles.size() > 0) {
                result.put("role", 0 == userRoles.size() ? "" : userRoles);
            }
            if (StringUtil.isEmpty(payPwd = this.authKeysService.getPayPassword(userId))) {
                result.put("payPassword", "0");
            } else {
                result.put("payPassword", "1");
            }
            InviteCode myInviteCode = SKBeanUtils.getAdminManager().findUserPopulInviteCode(user.getUserId());
            result.put("myInviteCode", myInviteCode == null ? "" : myInviteCode.getInviteCode());
            this.updateLoc(example.getLatitude(), example.getLongitude(), userId);
            UserManagerImpl.getUserRepository().updateLoginLogTime(userId);
            this.destroyMsgRecord(userId);
            return result;
        }
        catch (NullPointerException e) {
            throw new ServiceException(1040101);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public Map<String, Object> loginSuccessV1(User user, LoginExample example) {
        if (0 == example.getUserId()) {
            example.setUserId(user.getUserId());
        }
        UserLoginTokenKey loginKey = new UserLoginTokenKey(example.getUserId(), example.getDeviceId());
        loginKey.setLoginKey(Base64.encode((byte[])RandomUtils.nextBytes((int)16)));
        loginKey.setLoginToken(StringUtil.randomUUID());
        SKBeanUtils.getRedisService().saveLoginTokenKeys(loginKey);
        KSession session = this.createAutoLoginSesson(loginKey, "zh", null);
        Map<String, Object> data = this.createAutoLoginResultMap(session);
        User.LoginLog login = UserManagerImpl.getUserRepository().getLogin(user.getUserId());
        UserManagerImpl.getUserRepository().updateUserLoginLog(user.getUserId(), example);
        data.put("loginKey", loginKey.getLoginKey());
        data.put("loginToken", loginKey.getLoginToken());
        data.put("userId", user.getUserId());
        data.put("nickname", user.getNickname());
        String payPwd = this.authKeysService.getPayPassword(user.getUserId());
        if (StringUtil.isEmpty(payPwd)) {
            data.put("payPassword", 0);
        } else {
            data.put("payPassword", 1);
        }
        if (example.getIsSdkLogin() == 1) {
            data.put("telephone", user.getPhone());
            data.put("areaCode", user.getAreaCode());
            data.put("password", user.getPassword());
        }
        if (1 == example.getLoginType()) {
            data.put("password", user.getPassword());
        }
        data.put("sex", user.getSex());
        data.put("birthday", user.getBirthday());
        data.put("offlineNoPushMsg", user.getOfflineNoPushMsg());
        data.put("multipleDevices", user.getSettings().getMultipleDevices());
        data.put("login", login);
        data.put("settings", this.getSettings(user.getUserId()));
        if (StringUtil.isEmpty(login.getSerial())) {
            data.put("isupdate", 1);
        } else if (!login.getSerial().equals(example.getSerial())) {
            data.put("isupdate", 1);
        } else {
            data.put("isupdate", 0);
        }
        Query q = (Query)this.getDatastore().createQuery(Friends.class).field("userId").equal((Object)user.getUserId());
        data.put("friendCount", q.countAll());
        List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(user.getUserId());
        if (null != userRoles && userRoles.size() > 0) {
            data.put("role", 0 == userRoles.size() ? "" : userRoles);
        }
        this.destroyMsgRecord(user.getUserId());
        user.setArea(example.getArea());
        User.Loc loc = new User.Loc(example.getLongitude(), example.getLatitude());
        user.setLoc(loc);
        if (null == user.getAccount()) {
            user.setAccount(user.getUserId() + StringUtil.randomCode());
            user.setEncryAccount(DigestUtils.md5Hex((String)user.getAccount()));
        }
        if (null == user.getEncryAccount()) {
            user.setEncryAccount(DigestUtils.md5Hex((String)user.getAccount()));
        }
        this.save(user);
        InviteCode myInviteCode = SKBeanUtils.getAdminManager().findUserPopulInviteCode(user.getUserId());
        data.put("myInviteCode", myInviteCode == null ? "" : myInviteCode.getInviteCode());
        return data;
    }

    @Override
    public Map<String, Object> login(LoginExample example) {
        User user = null;
        user = 0 != example.getUserId() ? UserManagerImpl.getUserRepository().getUser(example.getUserId()) : UserManagerImpl.getUserRepository().getUser(example.getAreaCode(), example.getTelephone(), null);
        this.loginLogic(user, example);
        return this.loginSuccessV1(user, example);
    }

    public Map<String, Object> findAuto(User user, String serial, String deviceType) {
        User.LoginDevices loginDevices = UserManagerImpl.getUserRepository().getLoginDevices(user.getUserId());
        HashMap<String, String> mapResultStatus = null;
        if (null != loginDevices) {
            boolean flag = false;
            for (User.LoginDevice loginDevice : loginDevices.getDeviceList()) {
                if (loginDevice.getDeviceType() == null && serial.equals(loginDevice.getSerial())) {
                    flag = true;
                    break;
                }
                if (!serial.equals(loginDevice.getSerial()) || !loginDevice.getDeviceType().equals(deviceType)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                String key = StringUtil.randomUUID();
                HashMap<String, Object> authMessage = new HashMap<String, Object>();
                authMessage.put("serial", serial);
                authMessage.put("deviceType", deviceType);
                authMessage.put("status", "0");
                SKBeanUtils.getRedisService().savaAuthKey(key, authMessage);
                Map maps1 = (Map)SKBeanUtils.getRedisService().queryAuthKey(key);
                if (null != maps1) {
                    System.out.println(maps1.toString());
                }
                Map maps = (Map)SKBeanUtils.getRedisService().queryAuthKey(key);
                System.out.println("\u53d1\u9001\u4fe1\u606f\u4e86\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                SKBeanUtils.getXmppService().pushAuthLoginDeviceMessage(user.getUserId(), key);
                mapResultStatus = new HashMap<String, String>();
                mapResultStatus.put("authKey", key);
            }
        } else {
            this.savaDeviceMessage(user.getUserId(), serial, deviceType);
        }
        return mapResultStatus;
    }

    public void savaDeviceMessage(int userId, String serial, String deviceType) {
        System.out.println("\u7528\u6237\u4e3a\u7a7a,\u52a0\u5165\u8bbe\u5907\u53f7\uff01\uff01\uff01");
        User.LoginDevices lds = new User.LoginDevices();
        lds.setUserId(userId);
        lds.setCreateTime(System.currentTimeMillis());
        User.LoginDevice loginDevice = new User.LoginDevice();
        loginDevice.setSerial(serial);
        loginDevice.setAuthTime(DateUtil.currentTimeSeconds());
        loginDevice.setDeviceType(deviceType);
        loginDevice.setStatus((byte)0);
        lds.getDeviceList().add(loginDevice);
        UserManagerImpl.getUserRepository().addLoginDevices(lds);
        User.LoginDevices l = UserManagerImpl.getUserRepository().getLoginDevices(userId);
        if (l != null) {
            System.out.println(l.toString());
        }
    }

    public Map<String, Object> updateStatus(int userId, String authKey) {
        Map map = (Map)SKBeanUtils.getRedisService().queryAuthKey(authKey);
        if (null != map) {
            map.put("status", "1");
            System.out.println(map.get("status"));
            SKBeanUtils.getRedisService().savaAuthKey(authKey, map);
            System.out.println(map.get("status"));
            SKBeanUtils.getRedisService().savaAuthKey(authKey, map);
            Map mappp = (Map)SKBeanUtils.getRedisService().queryAuthKey(authKey);
            User.LoginDevices loginDevices = new User.LoginDevices();
            loginDevices = UserManagerImpl.getUserRepository().getLoginDevices(userId);
            User.LoginDevice loginDevice = new User.LoginDevice();
            loginDevice.setSerial((String)map.get("serial"));
            loginDevice.setDeviceType((String)map.get("deviceType"));
            loginDevice.setAuthTime(DateUtil.currentTimeMilliSeconds());
            loginDevice.setStatus((byte)0);
            loginDevices.getDeviceList().add(loginDevice);
            UserManagerImpl.getUserRepository().addLoginDevices(loginDevices);
        }
        return map;
    }

    public boolean loginLogic(User user, LoginExample example) {
        if (null == user) {
            throw new ServiceException(1040101);
        }
        if (-1 == user.getStatus()) {
            throw new ServiceException(1040304);
        }
        if (0 == example.getLoginType()) {
            String password = example.getPassword();
            if (!password.equals(user.getPassword()) && !(password = LoginPassword.encodeFromOldPassword(password)).equals(user.getPassword())) {
                throw new ServiceException(1040102);
            }
        } else if (1 == example.getLoginType()) {
            KSMSServiceImpl smsService = SKBeanUtils.getSMSService();
            if (null == example.getVerificationCode()) {
                throw new ServiceException(100216);
            }
            if (!smsService.isAvailable(user.getTelephone(), example.getVerificationCode())) {
                throw new ServiceException(1040104);
            }
            smsService.deleteSMSCode(user.getTelephone());
        }
        if (null == user.getUserId()) {
            throw new ServiceException(100207);
        }
        User.UserSettings settings = user.getSettings();
        settings.setOpenService(0);
        user.setSettings(settings);
        SKBeanUtils.getUserManager().updateSettings(user.getUserId(), user.getSettings());
        SKBeanUtils.getCompanyManager().modifyEmployeesByuserId(user.getUserId());
        return true;
    }

    public Map<String, Object> smsLogin(LoginExample example) {
        AuthKeys authKeys;
        Map<String, Object> map;
        User user = this.getUser(example.getTelephone());
        if (user.getSettings().getAuthSwitch() == 1 && !StringUtil.isEmpty(example.getSerial()) && (map = this.findAuto(user, example.getSerial(), example.getDeviceType())) != null) {
            return map;
        }
        SKBeanUtils.getSMSService().deleteSMSCode(example.getTelephone());
        Map<String, Object> result = this.loginSuccessV1(user, example);
        if (null != result && null != (authKeys = this.authKeysService.getAuthKeys(example.getUserId())) && null != authKeys.getMsgDHKeyPair() && !StringUtil.isEmpty(authKeys.getMsgDHKeyPair().getPrivateKey())) {
            result.put("isSupportSecureChat", 1);
        }
        return result;
    }

    private void updateLoc(double latitude, double longitude, Integer userId) {
        User.Loc loc = new User.Loc(longitude, latitude);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("active", (Object)DateUtil.currentTimeSeconds());
        ops.set("loc", (Object)loc);
        this.updateAttributeByOps(userId, ops);
    }

    public void savePushToken(Integer userId, User.DeviceInfo info) {
        Query query1 = UserManagerImpl.getUserRepository().getDatastore().createQuery(PushInfo.class);
        query1.filter("pushServer", (Object)info.getPushServer());
        query1.filter("pushToken", (Object)info.getPushToken());
        query1.filter("deviceKey", (Object)info.getDeviceKey());
        PushInfo pushInfo = (PushInfo)query1.get();
        if (null != pushInfo) {
            UpdateOperations ops;
            if (!userId.equals(pushInfo.getUserId())) {
                this.cleanPushToken(pushInfo.getUserId(), info.getDeviceKey());
                ops = UserManagerImpl.getUserRepository().getDatastore().createUpdateOperations(PushInfo.class);
                ops.set("userId", (Object)userId);
                ops.set("time", (Object)DateUtil.currentTimeSeconds());
                UserManagerImpl.getUserRepository().getDatastore().update(query1, ops);
            } else {
                ops = UserManagerImpl.getUserRepository().getDatastore().createUpdateOperations(PushInfo.class);
                ops.set("time", (Object)DateUtil.currentTimeSeconds());
                UserManagerImpl.getUserRepository().getDatastore().update(query1, ops);
            }
        } else {
            pushInfo = new PushInfo();
            pushInfo.setUserId(userId);
            pushInfo.setPushServer(info.getPushServer());
            pushInfo.setPushToken(info.getPushToken());
            pushInfo.setDeviceKey(info.getDeviceKey());
            pushInfo.setTime(DateUtil.currentTimeSeconds());
            UserManagerImpl.getUserRepository().getDatastore().save((Object)pushInfo);
        }
        Query query = UserManagerImpl.getUserRepository().getDatastore().createQuery(User.UserLoginLog.class);
        query.filter("_id", (Object)userId);
        UpdateOperations ops = UserManagerImpl.getUserRepository().getDatastore().createUpdateOperations(User.UserLoginLog.class);
        try {
            if (!StringUtil.isEmpty(info.getDeviceKey())) {
                ops.set("deviceMap." + info.getDeviceKey() + ".pushServer", (Object)info.getPushServer());
                ops.set("deviceMap." + info.getDeviceKey() + ".pushToken", (Object)info.getPushToken());
            }
            if ("ios".equals(info.getDeviceKey()) && !StringUtil.isEmpty(info.getAppId())) {
                ops.set("deviceMap." + info.getDeviceKey() + ".appId", (Object)info.getAppId());
            }
            UserManagerImpl.getUserRepository().getDatastore().update(query, ops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveVoipPushToken(Integer userId, String token) {
        User.DeviceInfo deviceInfo = KSessionUtil.getIosPushToken(userId);
        if (null != deviceInfo) {
            deviceInfo.setVoipToken(token);
            KSessionUtil.saveIosPushToken(userId, deviceInfo);
        }
    }

    public void saveIosAppId(Integer userId, String appId) {
        if (StringUtil.isEmpty(appId)) {
            return;
        }
        Query query = this.getDatastore().createQuery(User.UserLoginLog.class);
        query.filter("_id", (Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(User.UserLoginLog.class);
        try {
            ops.set("deviceMap.ios.appId", (Object)appId);
            this.getDatastore().update(query, ops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanPushToken(Integer userId, String devicekey) {
        Query query = this.getDatastore().createQuery(User.UserLoginLog.class);
        query.field("_id").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(User.UserLoginLog.class);
        ops.set("loginLog.offlineTime", (Object)DateUtil.currentTimeSeconds());
        try {
            if ("android".equals(devicekey)) {
                KSessionUtil.removeAndroidPushToken(userId);
            } else if ("ios".equals(devicekey)) {
                KSessionUtil.removeIosPushToken(userId);
            }
            if (!StringUtil.isEmpty(devicekey)) {
                ops.set("deviceMap." + devicekey + ".pushServer", (Object)"");
                ops.set("deviceMap." + devicekey + ".pushToken", (Object)"");
            }
            this.getDatastore().update(query, ops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void logout(String access_token, String areaCode, String userKey, String devicekey) {
        this.cleanPushToken(ReqUtil.getUserId(), devicekey);
        KSession session = SKBeanUtils.getRedisService().queryUserSesson(access_token);
        SKBeanUtils.getRedisService().cleanUserSesson(access_token);
        if (null != session) {
            SKBeanUtils.getRedisService().cleanLoginTokenKeys(session.getLoginToken());
        }
    }

    @Override
    public List<DBObject> query(UserQueryExample param) {
        return UserManagerImpl.getUserRepository().queryUser(param);
    }

    public List<User> queryPublicUser(int page, int limit, String keyWorld) {
        Query query = this.createQuery();
        query.filter("userType", (Object)2);
        if (null != keyWorld && keyWorld.length() > 0) {
            if (StringUtil.isNumeric(keyWorld)) {
                if (keyWorld.length() < 9) {
                    int userId = Integer.valueOf(keyWorld);
                    query.or(new Criteria[]{(Criteria)query.criteria("_id").equal((Object)userId), (Criteria)query.criteria("nickname").containsIgnoreCase(keyWorld)});
                } else {
                    query.or(new Criteria[]{(Criteria)query.criteria("nickname").containsIgnoreCase(keyWorld), (Criteria)query.criteria("telephone").containsIgnoreCase(keyWorld)});
                }
            } else {
                query.criteria("nickname").containsIgnoreCase(keyWorld);
            }
        }
        return query.offset(page * limit).limit(limit).asList();
    }

    @Override
    public Map<String, Object> register(UserExample example) {
        if (this.isRegister(example.getTelephone())) {
            throw new ServiceException(1040107);
        }
        Integer userId = this.createUserId();
        Map<String, Object> data = UserManagerImpl.getUserRepository().addUser((int)userId, example);
        if (null != data) {
            return data;
        }
        throw new ServiceException(100206);
    }

    @Override
    public Map<String, Object> registerIMUser(UserExample example) throws Exception {
        if (this.isRegister(example.getTelephone())) {
            throw new ServiceException(1040107);
        }
        Integer userId = this.createUserId();
        example.setUserId(userId);
        this.checkInviteCode(example, userId);
        Map<String, Object> data = UserManagerImpl.getUserRepository().addUser((int)userId, example);
        if (null == UserManagerImpl.getUserRepository().getLoginDevices(userId) && !StringUtil.isEmpty(example.getSerial())) {
            this.savaDeviceMessage(userId, example.getSerial(), example.getDeviceType());
        }
        if (null != data) {
            try {
                SKBeanUtils.getFriendsManager().addFriends(userId, 10000);
                this.defaultTelephones(example, userId);
                SKBeanUtils.getCompanyManager().autoJoinCompany(userId);
                SKBeanUtils.getFriendGroupManager().autoCreateGroup(userId);
                if (example.getUserType() != null && example.getUserType() == 3) {
                    SKBeanUtils.getRoomManager().join(userId, new ObjectId("5a2606854adfdc0cd071485e"), 3);
                }
                Object creteTime = data.get("createTime");
                String valueOf = String.valueOf(creteTime);
                Long time = Long.valueOf(valueOf);
                SKBeanUtils.getLocalSpringBeanManager().getAddressBookManger().notifyBook(example.getTelephone(), userId, example.getNickname(), time);
                SKBeanUtils.getRedisService().deleteNoSystemNumUserIds();
                SKBeanUtils.getSMSService().deleteSMSCode(example.getTelephone());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            if (example.getUserType() != null && example.getUserType() == 2) {
                Role role = new Role(userId, example.getTelephone(), 2, 1, 0L);
                this.getDatastore().save((Object)role);
                SKBeanUtils.getRoleManager().updateFriend(userId, 2);
            }
            LoginExample loginExample = new LoginExample();
            loginExample.setUserId(example.getUserId());
            loginExample.setDeviceId(loginExample.getDeviceId());
            return this.loginSuccessV1(this.getUser(example.getUserId()), loginExample);
        }
        throw new ServiceException(100206);
    }

    @Override
    public Map<String, Object> registerIMUserBySdk(UserExample example, int type) throws Exception {
        String wxAccount = example.getAccount();
        Map<String, Object> resultMap = this.registerUser(example);
        SdkLoginInfo entity = new SdkLoginInfo();
        entity.setUserId(example.getUserId());
        entity.setType(type);
        entity.setLoginInfo(wxAccount);
        this.getDatastore().save((Object)entity);
        return resultMap;
    }

    private Map<String, Object> registerUser(UserExample example) throws Exception {
        if (this.isRegister(example.getTelephone())) {
            throw new ServiceException(1040107);
        }
        Integer userId = this.createUserId();
        example.setUserId(userId);
        this.checkInviteCode(example, userId);
        Map<String, Object> data = UserManagerImpl.getUserRepository().addUser((int)userId, example);
        if (null == data) {
            throw new ServiceException(100206);
        }
        SKBeanUtils.getFriendsManager().followUser(userId, 10000, 0);
        this.defaultTelephones(example, userId);
        SKBeanUtils.getCompanyManager().autoJoinCompany(userId);
        SKBeanUtils.getFriendGroupManager().autoCreateGroup(userId);
        if (example.getUserType() != null && example.getUserType() == 3) {
            SKBeanUtils.getRoomManager().join(userId, new ObjectId("5a2606854adfdc0cd071485e"), 3);
        }
        Object creteTime = data.get("createTime");
        String valueOf = String.valueOf(creteTime);
        Long time = Long.valueOf(valueOf);
        SKBeanUtils.getLocalSpringBeanManager().getAddressBookManger().notifyBook(example.getTelephone(), userId, example.getNickname(), time);
        SKBeanUtils.getRedisService().deleteNoSystemNumUserIds();
        SKBeanUtils.getSMSService().deleteSMSCode(example.getTelephone());
        if (example.getUserType() != null && example.getUserType() == 2) {
            Role role = new Role(userId, example.getTelephone(), 2, 1, 0L);
            this.getDatastore().save((Object)role);
            SKBeanUtils.getRoleManager().updateFriend(userId, 2);
        }
        LoginExample loginExample = new LoginExample();
        loginExample.setUserId(example.getUserId());
        loginExample.setDeviceId(loginExample.getDeviceId());
        return this.loginSuccessV1(this.getUser(example.getUserId()), loginExample);
    }

    public void filterCircleUser(int toUserId, int type) {
        Integer userId = ReqUtil.getUserId();
        User.UserSettings settings = this.getSettings(userId);
        if (-1 == type) {
            if (null == settings.getFilterCircleUserIds()) {
                settings.setFilterCircleUserIds(new HashSet<Integer>());
            }
            settings.getFilterCircleUserIds().add(toUserId);
        } else if (1 == type) {
            if (null == settings.getNotSeeFilterCircleUserIds()) {
                settings.setNotSeeFilterCircleUserIds(new HashSet<Integer>());
            }
            settings.getNotSeeFilterCircleUserIds().add(toUserId);
        }
        this.updateSettings(userId, settings);
    }

    public void cancelFilterCircleUser(int toUserId, int type) {
        Integer userId = ReqUtil.getUserId();
        User.UserSettings settings = this.getSettings(userId);
        if (-1 == type) {
            if (null != settings.getFilterCircleUserIds()) {
                settings.getFilterCircleUserIds().remove(toUserId);
            }
        } else if (1 == type && null != settings.getNotSeeFilterCircleUserIds()) {
            settings.getNotSeeFilterCircleUserIds().remove(toUserId);
        }
        this.updateSettings(userId, settings);
    }

    private void checkInviteCode(UserExample example, int userId) {
        byte inviteCodeMode = SKBeanUtils.getAdminManager().getConfig().getRegisterInviteCode();
        if (inviteCodeMode == 0) {
            return;
        }
        InviteCode inviteCode = SKBeanUtils.getAdminRepository().findInviteCodeByCode(example.getInviteCode());
        boolean isNeedUpdateInvateCode = false;
        if (inviteCodeMode == 1) {
            if (StringUtil.isEmpty(example.getInviteCode())) {
                throw new ServiceException("\u8bf7\u586b\u5199\u9080\u8bf7\u7801");
            }
            if (inviteCode == null || inviteCode.getTotalTimes() != 1 || inviteCode.getStatus() != 0) {
                throw new ServiceException("\u9080\u8bf7\u7801\u65e0\u6548\u6216\u5df2\u88ab\u4f7f\u7528");
            }
            isNeedUpdateInvateCode = true;
            String inviteCodeStr = RandomUtil.idToSerialCode(DateUtil.currentTimeSeconds() + (long)SKBeanUtils.getUserManager().createInviteCodeNo(1).intValue() + 1L);
            SKBeanUtils.getAdminRepository().savaInviteCode(new InviteCode(userId, inviteCodeStr, System.currentTimeMillis(), 1));
            example.setMyInviteCode(inviteCodeStr);
        } else if (inviteCodeMode == 2 && inviteCode != null && inviteCode.getTotalTimes() != 1) {
            isNeedUpdateInvateCode = true;
        }
        if (isNeedUpdateInvateCode) {
            inviteCode.setUsedTimes(inviteCode.getUsedTimes() + 1);
            inviteCode.setStatus((short)1);
            inviteCode.setLastuseTime(System.currentTimeMillis());
            SKBeanUtils.getAdminRepository().savaInviteCode(inviteCode);
        }
    }

    private void defaultTelephones(UserExample example, Integer userId) {
        ArrayList<Integer> idList = null;
        Room createRoom = null;
        JSONObject userKeys = null;
        byte registerCreateRoom = SKBeanUtils.getLocalSpringBeanManager().getAppConfig().getRegisterCreateRoom();
        if (1 == registerCreateRoom) {
            createRoom = new Room();
            createRoom.setName(example.getNickname() + "\u7684\u7fa4\u7ec4");
            createRoom.setJid(StringUtil.randomUUID());
            idList = new ArrayList<Integer>();
            userKeys = JSON.parseObject((String)"");
        }
        String telephones = SKBeanUtils.getSystemConfig().getDefaultTelephones();
        log.info(" config defaultTelephones : " + telephones);
        if (!StringUtil.isEmpty(telephones)) {
            String[] phones = StringUtil.getStringList(telephones);
            for (int i = 0; i < phones.length; ++i) {
                try {
                    System.out.println("defaule: " + phones[i]);
                    User user = this.getUser(phones[i]);
                    if (null == user) continue;
                    SKBeanUtils.getFriendsManager().addFriends(userId, user.getUserId());
                    if (1 != registerCreateRoom || null == user) continue;
                    idList.add(user.getUserId());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (1 == registerCreateRoom && idList.size() > 0) {
                SKBeanUtils.getRoomManagerImplForIM().add(SKBeanUtils.getUserManager().getUser(userId), createRoom, idList, userKeys);
            }
        }
    }

    public void autoCreateUserOrRoom(final int userNum, final String roomId, final int adminUserId) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                boolean isJoinRoom = false;
                ObjectId objRoomId = null;
                if (!roomId.isEmpty() && roomId != null) {
                    objRoomId = new ObjectId(roomId);
                    isJoinRoom = true;
                }
                UserManagerImpl.this.addRobot(userNum, isJoinRoom, objRoomId, adminUserId);
            }
        });
    }

    public List<Integer> addRobot(int userNum, boolean isJoinRoom, ObjectId objRoomId, Integer adminUserId) {
        Random rand = new Random();
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        UserExample userExample = new UserExample();
        userExample.setAreaCode("86");
        userExample.setBirthday(DateUtil.currentTimeSeconds());
        userExample.setCountryId(ValueUtil.parse(0));
        userExample.setProvinceId(ValueUtil.parse(0));
        userExample.setCityId(ValueUtil.parse(400300));
        userExample.setAreaId(ValueUtil.parse(0));
        int j = 0;
        for (int i = 1; i <= userNum; ++i) {
            Integer userId = this.createUserId();
            userIds.add(userId);
            String name = i % 3 == 0 ? RandomUtil.getRandomZh(rand.nextInt(3) + 2) : RandomUtil.getRandomEnAndNum(rand.nextInt(4) + 2);
            userExample.setPassword(DigestUtils.md5Hex((String)("" + (userId - 1000) / 2)));
            userExample.setTelephone("86" + String.valueOf(userId));
            userExample.setPhone(String.valueOf(userId));
            userExample.setName(name);
            userExample.setNickname(name);
            userExample.setDescription(String.valueOf(userId));
            userExample.setSex(userId % 2 == 0 ? 0 : 1);
            if (userId != 0 && UserManagerImpl.getUserRepository().addUser((int)userId, userExample) != null) {
                try {
                    KXMPPServiceImpl.getInstance().registerAndXmppVersion(userId.toString(), userExample.getPassword());
                    System.out.println("\u7b2c" + i + "\u6761\u7528\u6237\u6570\u636e\u5df2\u7ecf\u751f\u6210");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new ServiceException("\u81ea\u52a8\u751f\u6210\u7528\u6237\u6570\u636e\u5931\u8d25");
            }
            if (isJoinRoom) {
                long currentTime = DateUtil.currentTimeSeconds();
                currentTime += (long)(++j);
                try {
                    Integer userSize = SKBeanUtils.getRoomManager().getRoom(objRoomId, adminUserId).getUserSize();
                    int maxUserSize = SKBeanUtils.getSystemConfig().getMaxUserSize();
                    if (userSize + 1 > maxUserSize) {
                        log.info("\u7fa4\u4eba\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u80fd\u7ee7\u7eed\u52a0\u5165\u3002\u5f53\u524d\u4e0a\u9650\u4eba\u6570" + maxUserSize);
                        throw new ServiceException("\u7fa4\u4eba\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u80fd\u7ee7\u7eed\u52a0\u5165");
                    }
                    SKBeanUtils.getRoomManager().joinRoom(userId, name, objRoomId, currentTime, adminUserId);
                }
                catch (ServiceException e) {
                    log.error("addRobot error : ", (Object)e.getMessage());
                    throw new ServiceException(e.getMessage());
                }
            }
            Role role = new Role(userId, String.valueOf(userId), 3, 1, 0L);
            this.getDatastore().save((Object)role);
        }
        return userIds;
    }

    @Override
    public int resetPassword(String telephone, String newPassword) {
        User user = this.getUser(telephone);
        if (null == user) {
            throw new ServiceException(100211);
        }
        UserManagerImpl.getUserRepository().updatePassword(telephone, newPassword);
        SKBeanUtils.getRedisService().cleanUserAllLoginInfo(user.getUserId());
        KXMPPServiceImpl.getInstance().changePassword(user.getUserId() + "", user.getPassword(), newPassword);
        this.multipointLoginDataSync(user.getUserId(), user.getNickname(), "sync_login_password");
        return user.getUserId();
    }

    public void resetPassword(int userId, String newPassword) {
        User user = this.getUser(userId);
        this.authKeysService.updateLoginPassword(userId, newPassword);
        KSessionUtil.removeAccessToken(userId);
        SKBeanUtils.getRedisService().cleanUserAllLoginInfo(userId);
        KXMPPServiceImpl.getInstance().changePassword(userId + "", user.getPassword(), newPassword);
        this.multipointLoginDataSync(userId, user.getNickname(), "sync_login_password");
    }

    @Override
    public void updatePassword(int userId, String oldPassword, String newPassword) {
        User user = this.getUser(userId);
        String pwd = this.authKeysService.queryLoginPassword(userId);
        if (oldPassword.equals(newPassword)) {
            throw new ServiceException(100209);
        }
        if (!(oldPassword.equals(user.getPassword()) || LoginPassword.encodeFromOldPassword(oldPassword).equals(user.getPassword()) || oldPassword.equals(pwd))) {
            throw new ServiceException(1040103);
        }
        this.authKeysService.updateLoginPassword(userId, newPassword);
        KSessionUtil.removeAccessToken(userId);
        KXMPPServiceImpl.getInstance().changePassword(userId + "", user.getPassword(), newPassword);
        SKBeanUtils.getRedisService().cleanUserAllLoginInfo(userId);
        this.multipointLoginDataSync(userId, user.getNickname(), "sync_login_password");
    }

    public String queryPassword(int userId) {
        return (String)this.queryOneFieldById("password", Integer.valueOf(userId));
    }

    public void updatePayPassword(int userId, String newPassword) {
        this.updateAttribute(Integer.valueOf(userId), "payPassword", newPassword);
        this.multipointLoginDataSync(userId, null, "sync_pay_password");
        KSessionUtil.deleteUserByUserId(userId);
    }

    @Override
    public User updateSettings(int userId, User.UserSettings userSettings) {
        User user = UserManagerImpl.getUserRepository().updateSettings(userId, userSettings);
        KSessionUtil.deleteUserByUserId(userId);
        return user;
    }

    public void sendMessage(String jid, int chatType, int type, String content, String fileName) {
        Integer userId = ReqUtil.getUserId();
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(type);
        messageBean.setFromUserId(userId.toString());
        messageBean.setFromUserName(this.getNickName(userId));
        messageBean.setToUserId(jid);
        messageBean.setTo(jid);
        if (1 == chatType) {
            messageBean.setMsgType(0);
            messageBean.setToUserName(this.getNickName(Integer.valueOf(jid)));
        } else {
            messageBean.setMsgType(1);
            messageBean.setRoomJid(jid);
        }
        messageBean.setContent(content);
        messageBean.setFileName(fileName);
        messageBean.setTimeSend(DateUtil.currentTimeSeconds());
        messageBean.setMessageId(StringUtil.randomCode());
        KXMPPServiceImpl.getInstance().send(messageBean);
        messageBean.setMsgType(0);
        messageBean.setTo(userId.toString());
        KXMPPServiceImpl.getInstance().send(messageBean);
    }

    public Object bindWxopenid(int userId, String code) {
        if (StringUtil.isEmpty(code)) {
            return null;
        }
        JSONObject jsonObject = WXUserUtils.getWxOpenId(code);
        String openid = jsonObject.getString("openid");
        if (StringUtil.isEmpty(openid)) {
            return null;
        }
        this.updateAttribute(Integer.valueOf(userId), "openid", openid);
        return jsonObject;
    }

    public void bindAliUserId(int userId, String aliUserId) {
        if (StringUtil.isEmpty(aliUserId)) {
            return;
        }
        this.updateAttribute(Integer.valueOf(userId), "aliUserId", aliUserId);
    }

    @Override
    public User updateUser(int userId, UserExample param) {
        User user = UserManagerImpl.getUserRepository().updateUser(userId, param);
        String payPwd = this.authKeysService.getPayPassword(userId);
        if (StringUtil.isEmpty(payPwd)) {
            user.setPayPassword("0");
        } else {
            user.setPayPassword("1");
        }
        return user;
    }

    public void multipointLoginUpdateUserInfo(Integer userId, String nickName, Integer toUserId, String toNickName, int type) {
        Query query = (Query)this.getDatastore().createQuery(OfflineOperation.class).field("userId").equal((Object)userId);
        if (0 == type) {
            query.field("friendId").equal((Object)String.valueOf(userId));
        } else if (1 == type) {
            query.field("friendId").equal((Object)String.valueOf(toUserId));
        }
        if (null == query.get()) {
            this.getDatastore().save((Object)new OfflineOperation(userId, "friend", null == toUserId ? String.valueOf(userId) : String.valueOf(toUserId), DateUtil.currentTimeSeconds()));
        } else {
            UpdateOperations ops = this.getDatastore().createUpdateOperations(OfflineOperation.class);
            ops.set("operationTime", (Object)DateUtil.currentTimeSeconds());
            this.getDatastore().update(query, ops);
        }
        this.updatePersonalInfo(userId, nickName, toUserId, toNickName, type);
    }

    public List<User> findUserList(int pageIndex, int pageSize, final Integer notId) {
        Query query = this.createQuery();
        ArrayList<Integer> ids = new ArrayList<Integer>(){
            {
                this.add(10000);
                this.add(10005);
                this.add(10006);
                this.add(notId);
            }
        };
        query.field("_id").notIn((Iterable)ids);
        return query.order("-_id").offset(pageIndex * pageSize).limit(pageSize).asList();
    }

    public List<User> findUserList(int pageIndex, int pageSize, String keyworld, short onlinestate, short userType) throws ServiceException {
        return UserManagerImpl.getUserRepository().searchUsers(pageIndex, pageSize, keyworld, onlinestate, userType);
    }

    @Override
    public List<DBObject> findUser(int pageIndex, int pageSize) {
        return UserManagerImpl.getUserRepository().findUser(pageIndex, pageSize);
    }

    @Override
    public List<Integer> getAllUserId() {
        return this.getDatastore().getCollection(this.getClass()).distinct("_id");
    }

    @Override
    public void outtime(String access_token, int userId) {
        Query q = (Query)this.getDatastore().createQuery(User.UserLoginLog.class).field("_id").equal((Object)userId);
        User.UserLoginLog loginLog = (User.UserLoginLog)q.get();
        if (null == q.get()) {
            return;
        }
        if (null == loginLog.getLoginLog()) {
            return;
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(User.UserLoginLog.class);
        ops.set("loginLog.offlineTime", (Object)DateUtil.currentTimeSeconds());
        this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public void addUser(int userId, String password) {
        UserManagerImpl.getUserRepository().addUser(userId, password);
    }

    public void destroyMsgRecord(final int userId) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                MongoDatabase chatMsgDB = SKBeanUtils.getTigaseManager().getChatMsgDB();
                MongoDatabase lastMsgDB = SKBeanUtils.getTigaseManager().getLastMsgDB();
                MongoCollection dbCollection = null;
                MongoCollection lastdbCollection = null;
                MongoIterable listCollectionNames = chatMsgDB.listCollectionNames();
                System.out.println("=====> deleteChatMsgRecord " + DateUtil.TimeToStr(new Date()));
                try {
                    for (String str : listCollectionNames) {
                        if ("system.indexes".equals(str)) continue;
                        dbCollection = chatMsgDB.getCollection(str);
                        lastdbCollection = lastMsgDB.getCollection(str);
                        Document query = new Document();
                        Document lastquery = new Document();
                        query.append("sender", (Object)userId);
                        query.append("deleteTime", (Object)new Document("$gt", (Object)0).append("$lt", (Object)DateUtil.currentTimeSeconds())).append("isRead", (Object)1);
                        Document base = (Document)dbCollection.find((Bson)query).first();
                        BasicDBList queryOr = new BasicDBList();
                        if (base != null) {
                            queryOr.add((Object)new BasicDBObject("jid", (Object)String.valueOf(base.get((Object)"sender"))).append("userId", (Object)base.get((Object)"receiver").toString()));
                            queryOr.add((Object)new BasicDBObject("userId", (Object)String.valueOf(base.get((Object)"sender"))).append("jid", (Object)base.get((Object)"receiver").toString()));
                            lastquery.append("$or", (Object)queryOr);
                        }
                        query.append("contentType", (Object)new BasicDBObject("$in", MsgType.FileTypeArr));
                        DistinctIterable fileList = dbCollection.distinct("content", (Bson)query, String.class);
                        for (String url : fileList) {
                            ConstantUtil.deleteFile(url);
                        }
                        query.remove((Object)"contentType");
                        dbCollection.deleteMany((Bson)query);
                        ArrayList<Document> baslist = new ArrayList<Document>();
                        if (base != null) {
                            baslist.add(new Document("receiver", base.get((Object)"sender")));
                            baslist.add(new Document("sender", base.get((Object)"sender")));
                            query.append("$or", baslist);
                        }
                        query.remove((Object)"sender");
                        query.remove((Object)"deleteTime");
                        query.remove((Object)"isRead");
                        Document lastMsgObj = (Document)dbCollection.find((Bson)query).sort((Bson)new BasicDBObject("timeSend", (Object)-1)).first();
                        if (lastMsgObj != null) {
                            BasicDBObject values = new BasicDBObject();
                            values.put((Object)"messageId", lastMsgObj.get((Object)"messageId"));
                            values.put((Object)"timeSend", (Object)new Double(lastMsgObj.get((Object)"timeSend").toString()).longValue());
                            values.put((Object)"content", lastMsgObj.get((Object)"content"));
                            if (lastquery.isEmpty()) continue;
                            lastdbCollection.updateOne((Bson)lastquery, (Bson)new Document("$set", (Object)values));
                            continue;
                        }
                        if (lastquery.isEmpty()) continue;
                        lastdbCollection.deleteOne((Bson)lastquery);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public synchronized Double rechargeUserMoeny(Integer userId, Double money, int type) {
        return this.rechargeUserMoenyV1(userId, money, type);
    }

    public synchronized Double rechargeUserMoenyV1(Integer userId, Double money, int type) {
        try {
            UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
            double balance = this.getUserMoenyV1(userId);
            if (1 == type) {
                balance = StringUtil.addDouble(balance, money);
                ops.set("balanceSafe", (Object)MoneyUtils.encrypt(balance, userId.toString()));
            } else {
                if ((balance = StringUtil.subDouble(balance, money)) < 0.0) {
                    throw new ServiceException(104001);
                }
                ops.set("balanceSafe", (Object)MoneyUtils.encrypt(balance, userId.toString()));
            }
            Query q = this.getDatastore().createQuery(this.getEntityClass());
            q.field("_id").equal((Object)userId);
            this.getDatastore().update(q, ops);
            KSessionUtil.deleteUserByUserId(userId);
            return balance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Double getUserMoeny(Integer userId) {
        return this.getUserMoenyV1(userId);
    }

    public Double getUserMoenyV1(Integer userId) {
        try {
            Object field = this.queryOneFieldById("balanceSafe", userId);
            byte[] balanceSafe = null;
            if (null != field) {
                balanceSafe = (byte[])field;
            } else if (0 == SKBeanUtils.getLocalSpringBeanManager().getAppConfig().getBalanceVersion()) {
                Object oldBalance = this.queryOneFieldById("balance", userId);
                if (null == oldBalance) {
                    return 0.0;
                }
                balanceSafe = MoneyUtils.encrypt(Double.valueOf(oldBalance.toString()), userId.toString());
            } else {
                balanceSafe = MoneyUtils.encrypt(0.0, userId.toString());
            }
            return MoneyUtils.decrypt(balanceSafe, userId.toString());
        }
        catch (Exception e) {
            throw new ServiceException(104004);
        }
    }

    public int getOnlinestateByUserId(Integer userId) {
        return SKBeanUtils.getRedisService().queryUserOnline(userId);
    }

    public void report(Integer userId, Integer toUserId, int reason, String roomId, String webUrl) {
        if (toUserId == null && StringUtil.isEmpty(roomId) && StringUtil.isEmpty(webUrl)) {
            throw new ServiceException(1010101);
        }
        Report report = new Report();
        report.setUserId(userId.intValue());
        report.setToUserId(toUserId.intValue());
        report.setReason(reason);
        report.setRoomId(roomId);
        if (!StringUtil.isEmpty(webUrl)) {
            report.setWebUrl(webUrl);
        }
        report.setWebStatus(1);
        report.setTime(DateUtil.currentTimeSeconds());
        this.saveEntity(report);
    }

    public boolean checkReportUrlImpl(String webUrl) {
        try {
            URL requestUrl = new URL(webUrl);
            webUrl = requestUrl.getHost();
        }
        catch (Exception e) {
            throw new ServiceException(1010101);
        }
        this.logger.info("URL HOST :" + webUrl);
        List reportList = ((Query)this.getDatastore().createQuery(Report.class).field("webUrl").contains(webUrl)).asList();
        if (null != reportList && reportList.size() > 0) {
            reportList.forEach(report -> {
                if (null != report && -1 == report.getWebStatus()) {
                    throw new ServiceException(100203);
                }
            });
        }
        return true;
    }

    public Map<String, Object> getReport(int type, int sender, String receiver, int pageIndex, int pageSize) {
        ConcurrentMap dataMap = Maps.newConcurrentMap();
        List data = null;
        try {
            if (type == 0) {
                Query q = this.getDatastore().createQuery(Report.class);
                if (0 != sender) {
                    q.field("userId").equal((Object)sender);
                }
                if (!StringUtil.isEmpty(receiver)) {
                    q.field("toUserId").equal((Object)Long.valueOf(receiver));
                } else {
                    q.field("toUserId").notEqual((Object)0);
                }
                q.field("roomId").equal((Object)"");
                q.order("-time");
                q.offset(pageSize * pageIndex);
                data = q.limit(pageSize).asList();
                for (Report report : data) {
                    report.setUserName(this.getNickName((int)report.getUserId()));
                    report.setToUserName(this.getNickName((int)report.getToUserId()));
                    if (KConstants.ReportReason.reasonMap.containsKey(report.getReason())) {
                        report.setInfo(KConstants.ReportReason.reasonMap.get(report.getReason()));
                    }
                    if (null == this.getUser(Integer.valueOf(String.valueOf(report.getToUserId())))) {
                        report.setToUserStatus(-1);
                        continue;
                    }
                    Integer status = this.getUser(Integer.valueOf(String.valueOf(report.getToUserId()))).getStatus();
                    report.setToUserStatus(status);
                }
                dataMap.put("count", q.count());
            } else if (type == 1) {
                Query q = this.getDatastore().createQuery(Report.class);
                if (0 != sender) {
                    q.field("userId").equal((Object)sender);
                }
                if (!StringUtil.isEmpty(receiver)) {
                    q.field("roomId").equal((Object)receiver);
                }
                q.field("roomId").notEqual((Object)"");
                q.order("-time");
                q.offset(pageSize * pageIndex);
                for (Report report : q.asList()) {
                    report.setUserName(this.getNickName((int)report.getUserId()));
                    report.setRoomName(SKBeanUtils.getRoomManager().getRoomName(new ObjectId(report.getRoomId())));
                    Integer roomStatus = SKBeanUtils.getRoomManager().getRoomStatus(new ObjectId(report.getRoomId()));
                    if (null != roomStatus) {
                        report.setRoomStatus(roomStatus);
                    }
                    if (!KConstants.ReportReason.reasonMap.containsKey(report.getReason())) continue;
                    report.setInfo(KConstants.ReportReason.reasonMap.get(report.getReason()));
                }
                data = q.limit(pageSize).asList();
                dataMap.put("count", q.count());
            } else if (type == 2) {
                Query q = this.getDatastore().createQuery(Report.class);
                if (0 != sender) {
                    q.field("userId").equal((Object)sender);
                }
                if (!StringUtil.isEmpty(receiver)) {
                    q.field("webUrl").equal((Object)receiver);
                }
                q.field("webUrl").notEqual(null);
                q.field("toUserId").equal((Object)0);
                q.order("-time");
                for (Report report : q.asList()) {
                    report.setUserName(this.getNickName((int)report.getUserId()));
                    if (!KConstants.ReportReason.reasonMap.containsKey(report.getReason())) continue;
                    report.setInfo(KConstants.ReportReason.reasonMap.get(report.getReason()));
                }
                q.offset(pageSize * pageIndex);
                data = q.limit(pageSize).asList();
                dataMap.put("count", q.count());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dataMap.put("data", data);
        return dataMap;
    }

    public void delReport(Integer userId, String roomId) {
        Query query = this.getDatastore().createQuery(Report.class);
        if (null != userId) {
            query.or(new Criteria[]{(Criteria)query.criteria("userId").equal((Object)userId), (Criteria)query.criteria("toUserId").equal((Object)userId)});
        } else if (null != roomId) {
            query.field("roomId").equal((Object)roomId);
        }
        this.getDatastore().delete(query);
    }

    public void delRecord(Integer userId) {
        Query query = this.getDatastore().createQuery(ConsumeRecord.class);
        query.field("userId").equal((Object)userId);
        this.getDatastore().delete(query);
    }

    public void delCompany(Integer userId) {
        try {
            Query ownCompanyQuery = (Query)this.getDatastore().createQuery(Company.class).field("createUserId").equal((Object)userId);
            List companyList = ownCompanyQuery.asList();
            for (Company company : companyList) {
                this.getDatastore().delete((Object)company);
                Query departMentQuery = (Query)this.getDatastore().createQuery(Department.class).field("companyId").equal((Object)company.getId());
                this.getDatastore().delete(departMentQuery);
                Query ownEmployeeQuery = (Query)this.getDatastore().createQuery(Employee.class).field("companyId").equal((Object)company.getId());
                this.getDatastore().delete(ownEmployeeQuery);
            }
            Query employeeQuery = (Query)this.getDatastore().createQuery(Employee.class).field("userId").equal((Object)userId);
            List employees = employeeQuery.asList();
            for (Employee employee : employees) {
                Query departMentQuery = (Query)this.getDatastore().createQuery(Department.class).field("_id").equal((Object)employee.getDepartmentId());
                UpdateOperations ops = this.getDatastore().createUpdateOperations(Department.class);
                int empNum = ((Department)departMentQuery.get()).getEmpNum();
                int departEmpNum = empNum - 1;
                ops.set("empNum", (Object)departEmpNum);
                this.getDatastore().findAndModify(departMentQuery, ops);
                Query companyQuery = (Query)this.getDatastore().createQuery(Company.class).field("_id").equal((Object)employee.getCompanyId());
                int companyEmpNum = ((Company)companyQuery.get()).getEmpNum();
                UpdateOperations companyOps = this.getDatastore().createUpdateOperations(Company.class);
                int num = companyEmpNum - 1;
                companyOps.set("empNum", (Object)num);
                this.getDatastore().findAndModify(companyQuery, companyOps);
            }
            this.getDatastore().delete(employeeQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized Integer createUserId() {
        DBCollection collection = this.getDatastore().getDB().getCollection("idx_user");
        if (null == collection) {
            return this.createIdxUserCollection(collection, 0L);
        }
        DBObject obj = collection.findOne();
        if (null != obj) {
            Integer id = new Integer(obj.get("id").toString());
            id = id + 1;
            collection.update((DBObject)new BasicDBObject("_id", obj.get("_id")), (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject("id", (Object)1)));
            return id;
        }
        return this.createIdxUserCollection(collection, 0L);
    }

    public synchronized Integer createCall() {
        DBCollection collection = this.getDatastore().getDB().getCollection("idx_user");
        if (null == collection) {
            return this.createIdxUserCollection(collection, 0L);
        }
        DBObject obj = collection.findOne();
        if (null != obj) {
            if (obj.get("call") == null) {
                obj.put("call", (Object)300000);
            }
            Integer call = new Integer(obj.get("call").toString());
            if ((call = Integer.valueOf(call + 1)) > 349999) {
                call = 300000;
            }
            collection.update((DBObject)new BasicDBObject("_id", obj.get("_id")), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("call", (Object)call)));
            return call;
        }
        return this.createIdxUserCollection(collection, 0L);
    }

    public synchronized Integer createvideoMeetingNo() {
        DBCollection collection = this.getDatastore().getDB().getCollection("idx_user");
        if (null == collection) {
            return this.createIdxUserCollection(collection, 0L);
        }
        DBObject obj = collection.findOne();
        if (null != obj) {
            if (obj.get("videoMeetingNo") == null) {
                obj.put("videoMeetingNo", (Object)350000);
            }
            Integer videoMeetingNo = new Integer(obj.get("videoMeetingNo").toString());
            if ((videoMeetingNo = Integer.valueOf(videoMeetingNo + 1)) > 399999) {
                videoMeetingNo = 350000;
            }
            collection.update((DBObject)new BasicDBObject("_id", obj.get("_id")), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("videoMeetingNo", (Object)videoMeetingNo)));
            return videoMeetingNo;
        }
        return this.createIdxUserCollection(collection, 0L);
    }

    @Override
    public synchronized Integer createInviteCodeNo(int createNum) {
        DBObject obj;
        DBCollection collection = this.getDatastore().getDB().getCollection("idx_user");
        if (null == collection) {
            this.createIdxUserCollection(collection, 0L);
        }
        if (null != (obj = collection.findOne())) {
            if (obj.get("inviteCodeNo") == null) {
                obj.put("inviteCodeNo", (Object)1001);
            }
        } else {
            this.createIdxUserCollection(collection, 0L);
        }
        Integer inviteCodeNo = new Integer(obj.get("inviteCodeNo").toString());
        collection.update((DBObject)new BasicDBObject("_id", obj.get("_id")), (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject("inviteCodeNo", (Object)createNum)));
        return inviteCodeNo;
    }

    private Integer createIdxUserCollection(DBCollection collection, long userId) {
        if (null == collection) {
            collection = this.getDatastore().getDB().createCollection("idx_user", (DBObject)new BasicDBObject());
        }
        BasicDBObject init = new BasicDBObject();
        Integer id = this.getMaxUserId();
        if (0 == id || id < 100000) {
            id = new Integer("10000001");
        }
        id = id + 1;
        init.append("id", (Object)id);
        init.append("stub", (Object)"id");
        init.append("call", (Object)300000);
        init.append("videoMeetingNo", (Object)350000);
        init.append("inviteCodeNo", (Object)1001);
        collection.insert(new DBObject[]{init});
        return id;
    }

    public Integer getMaxUserId() {
        BasicDBObject projection = new BasicDBObject("_id", (Object)1);
        DBObject dbobj = this.getDatastore().getDB().getCollection("user").findOne(null, (DBObject)projection, (DBObject)new BasicDBObject("_id", (Object)-1));
        if (null == dbobj) {
            return 0;
        }
        Integer id = new Integer(dbobj.get("_id").toString());
        return id;
    }

    public Integer getServiceNo(String areaCode) {
        DBCollection collection = this.getDatastore().getDB().getCollection("sysServiceNo");
        BasicDBObject obj = (BasicDBObject)collection.findOne((DBObject)new BasicDBObject("areaCode", (Object)areaCode));
        if (null != obj) {
            return obj.getInt("userId");
        }
        return this.createServiceNo(areaCode);
    }

    private Integer getMaxServiceNo() {
        DBCollection collection = this.getDatastore().getDB().getCollection("sysServiceNo");
        BasicDBObject obj = (BasicDBObject)collection.findOne(null, (DBObject)new BasicDBObject("userId", (Object)1), (DBObject)new BasicDBObject("userId", (Object)-1));
        if (null != obj) {
            return obj.getInt("userId");
        }
        BasicDBObject query = new BasicDBObject("_id", (Object)new BasicDBObject("$lt", (Object)10200));
        query.append("_id", (Object)new BasicDBObject("$gt", (Object)10200));
        BasicDBObject projection = new BasicDBObject("_id", (Object)1);
        DBObject dbobj = this.getDatastore().getDB().getCollection("user").findOne((DBObject)query, (DBObject)projection, (DBObject)new BasicDBObject("_id", (Object)-1));
        if (null == dbobj) {
            return 10200;
        }
        Integer id = new Integer(dbobj.get("_id").toString());
        return id;
    }

    private Integer createServiceNo(String areaCode) {
        DBCollection collection = this.getDatastore().getDB().getCollection("sysServiceNo");
        Integer userId = this.getMaxServiceNo() + 1;
        BasicDBObject value = new BasicDBObject("areaCode", (Object)areaCode);
        value.append("userId", (Object)userId);
        collection.save((DBObject)value);
        this.addUser(userId, Md5Util.md5Hex(userId + ""));
        return userId;
    }

    @Override
    public User updataOfflineNoPushMsg(int userId, int OfflineNoPushMsg) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("OfflineNoPushMsg", (Object)OfflineNoPushMsg);
        User user = (User)this.getDatastore().findAndModify(q, ops);
        user.setPayPassword("");
        return user;
    }

    public Emoji addNewEmoji(String emoji) {
        Emoji newEmoji = null;
        if (StringUtil.isEmpty(emoji)) {
            throw new ServiceException("addNewEmoji emoji is null");
        }
        List emojiList = JSONObject.parseArray((String)emoji, Emoji.class);
        for (Emoji emojis : emojiList) {
            emojis.setUserId(ReqUtil.getUserId());
            Query query = (Query)((Query)((Query)this.getDatastore().createQuery(Emoji.class).field("msg").equal((Object)emojis.getMsg())).field("type").equal((Object)emojis.getType())).field("userId").equal((Object)emojis.getUserId());
            if (null != query.get()) {
                if (null != ((Emoji)query.get()).getMsgId() && ((Emoji)query.get()).getMsgId().equals(emojis.getMsgId())) {
                    throw new ServiceException(100509);
                }
                if (null != ((Emoji)query.get()).getCollectMsgId() && ((Emoji)query.get()).getCollectMsgId().equals(emojis.getCollectMsgId())) {
                    throw new ServiceException(100509);
                }
            }
            if (!StringUtil.isEmpty(emojis.getMsgId()) && 0 == emojis.getCollectType()) {
                newEmoji = this.newAddCollection(ReqUtil.getUserId(), emojis);
            } else if (StringUtil.isEmpty(emojis.getMsgId()) && 0 == emojis.getCollectType()) {
                newEmoji = this.newAddEmoji(ReqUtil.getUserId(), emojis);
            } else if (StringUtil.isEmpty(emojis.getMsgId()) && -1 == emojis.getCollectType()) {
                newEmoji = this.newAddCollection(ReqUtil.getUserId(), emojis);
            }
            if (StringUtil.isEmpty(emojis.getMsgId()) && 1 == emojis.getCollectType() && StringUtil.isEmpty(emojis.getTitle()) && StringUtil.isEmpty(emojis.getShareURL())) {
                newEmoji = this.msgCollect(ReqUtil.getUserId(), emojis, 0);
                this.saveCollect(new ObjectId(newEmoji.getCollectMsgId()), this.getNickName(emojis.getUserId()), emojis.getUserId());
                continue;
            }
            if (!StringUtil.isEmpty(emojis.getMsgId()) || 1 != emojis.getCollectType() || StringUtil.isEmpty(emojis.getTitle()) || StringUtil.isEmpty(emojis.getShareURL())) continue;
            newEmoji = this.msgCollect(ReqUtil.getUserId(), emojis, 1);
            this.saveCollect(new ObjectId(newEmoji.getCollectMsgId()), this.getNickName(emojis.getUserId()), emojis.getUserId());
        }
        return newEmoji;
    }

    private Emoji msgCollect(Integer userId, Emoji msgEmoji, int isShare) {
        StringBuffer buffer = new StringBuffer();
        if (msgEmoji.getType() != 5) {
            String[] msgs = msgEmoji.getMsg().split(",");
            String copyFile = "";
            String newCopyFile = null;
            for (int i = 0; i < msgs.length; ++i) {
                copyFile = ConstantUtil.copyFile(-1, msgs[i]);
                buffer.append(copyFile).append(",");
            }
            newCopyFile = buffer.deleteCharAt(buffer.length() - 1).toString();
            msgEmoji.setUrl(newCopyFile);
        }
        Emoji emoji = null;
        if (0 == isShare) {
            emoji = new Emoji(msgEmoji.getUserId(), msgEmoji.getType(), 5 == msgEmoji.getType() ? null : msgEmoji.getUrl(), msgEmoji.getMsg(), msgEmoji.getFileName(), msgEmoji.getFileSize(), msgEmoji.getFileLength(), msgEmoji.getCollectType(), msgEmoji.getCollectContent(), msgEmoji.getCollectMsgId());
        } else if (1 == isShare) {
            emoji = new Emoji(msgEmoji.getUserId(), msgEmoji.getType(), 5 == msgEmoji.getType() ? null : msgEmoji.getUrl(), msgEmoji.getMsg(), msgEmoji.getFileName(), msgEmoji.getFileSize(), msgEmoji.getFileLength(), msgEmoji.getCollectType(), msgEmoji.getCollectContent(), msgEmoji.getCollectMsgId(), msgEmoji.getTitle(), msgEmoji.getShareURL());
        }
        this.getDatastore().save(emoji);
        UserManagerImpl.getRedisServiceImpl().deleteUserCollectCommon(userId);
        return emoji;
    }

    public synchronized Emoji newAddCollection(Integer userId, Emoji emoji) {
        if (emoji.getType() != 5) {
            try {
                String copyFile = ConstantUtil.copyFile(-1, emoji.getMsg());
                emoji.setUrl(copyFile);
            }
            catch (ServiceException e) {
                throw new ServiceException(e.getMessage());
            }
        } else if (emoji.getType() == 5) {
            emoji.setCollectContent(emoji.getMsg());
        }
        JSONObject emojiMsg = this.emojiMsg(emoji);
        if (null != emojiMsg) {
            if (emoji.getType() != 5) {
                if (null != emojiMsg.get((Object)"fileName")) {
                    emoji.setFileName(emojiMsg.get((Object)"fileName").toString());
                }
                if (null != emojiMsg.get((Object)"fileSize")) {
                    emoji.setFileSize(Double.valueOf(emojiMsg.get((Object)"fileSize").toString()));
                }
            }
            if (emoji.getType() == 4) {
                emoji.setFileLength(Integer.valueOf(emojiMsg.get((Object)"fileTime").toString()));
            }
        }
        emoji.setUserId(userId);
        emoji.setCreateTime(DateUtil.currentTimeSeconds());
        this.getDatastore().save((Object)emoji);
        UserManagerImpl.getRedisServiceImpl().deleteUserCollectCommon(userId);
        return emoji;
    }

    private JSONObject emojiMsg(Emoji emoji) {
        byte isSaveMsg = SKBeanUtils.getSystemConfig().getIsSaveMsg();
        if (0 == isSaveMsg) {
            throw new ServiceException("\u5f53\u524d\u8bbe\u7f6e\u4e0d\u4fdd\u5b58\u5355\u804a\u804a\u5929\u8bb0\u5f55,\u6682\u4e0d\u652f\u6301\u6536\u85cf");
        }
        Document data = null;
        MongoCollection dbCollection = null;
        dbCollection = StringUtil.isEmpty(emoji.getRoomJid()) ? SKBeanUtils.getTigaseManager().getMongoCollection(SKBeanUtils.getTigaseManager().getChatMsgDB(), emoji.getUserId()) : SKBeanUtils.getTigaseManager().getImRoomDB().getCollection("mucmsg_" + emoji.getRoomJid());
        Document q = new Document();
        q.put("messageId", (Object)emoji.getMsgId());
        data = (Document)dbCollection.find((Bson)q).first();
        if (null == data) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)data.getString((Object)"message"));
        this.logger.info(" emojiMsg  \u6587\u4ef6\uff1a" + jsonObject);
        return jsonObject;
    }

    public Emoji newAddEmoji(Integer userId, Emoji emoji) {
        try {
            String copyFile = ConstantUtil.copyFile(-1, emoji.getUrl());
            emoji.setUserId(userId);
            emoji.setType(emoji.getType());
            if (!StringUtil.isEmpty(copyFile)) {
                emoji.setUrl(copyFile);
            } else {
                emoji.setUrl(emoji.getUrl());
            }
            emoji.setCreateTime(DateUtil.currentTimeSeconds());
            this.getDatastore().save((Object)emoji);
            UserManagerImpl.getRedisServiceImpl().deleteUserCollectEmoticon(userId);
        }
        catch (ServiceException e) {
            throw new ServiceException("\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6");
        }
        return emoji;
    }

    public void saveCollect(ObjectId msgId, String nickname, int userId) {
        Collect collect = new Collect(msgId, nickname, userId);
        this.getDatastore().save((Object)collect);
    }

    @Override
    public List<Object> addCollection(int userId, String roomJid, String msgId, String type) {
        byte isSaveMsg = SKBeanUtils.getSystemConfig().getIsSaveMsg();
        if (0 == isSaveMsg) {
            throw new ServiceException(100202);
        }
        Query query = null;
        Document data = null;
        ArrayList<Object> listEmoji = new ArrayList<Object>();
        List<Object> listMsgId = new ArrayList();
        List<Object> listType = new ArrayList();
        if (!StringUtil.isEmpty(msgId)) {
            listMsgId = Arrays.asList(msgId.split(","));
            listType = Arrays.asList(type.split(","));
            for (int i = 0; i < listMsgId.size(); ++i) {
                query = this.getDatastore().createQuery(Emoji.class).filter("userId", (Object)userId).filter("msgId", listMsgId.get(i));
                if (query.get() == null) {
                    Emoji emoji = new Emoji();
                    emoji.setUserId(userId);
                    emoji.setType(Integer.valueOf((String)listType.get(i)));
                    if (!StringUtil.isEmpty(roomJid)) {
                        emoji.setRoomJid(roomJid);
                    }
                    if (!StringUtil.isEmpty((String)listMsgId.get(i))) {
                        emoji.setMsgId((String)listMsgId.get(i));
                        MongoCollection dbCollection = null;
                        dbCollection = StringUtil.isEmpty(roomJid) ? SKBeanUtils.getTigaseManager().getMongoCollection(SKBeanUtils.getTigaseManager().getChatMsgDB(), userId) : SKBeanUtils.getTigaseManager().getImRoomDB().getCollection("mucmsg_" + emoji.getRoomJid());
                        Document q = new Document();
                        q.put("messageId", listMsgId.get(i));
                        data = (Document)dbCollection.find((Bson)q).first();
                        if (data == null) continue;
                    }
                    if (Integer.valueOf((String)listType.get(i)) != 5) {
                        JSONObject obj = JSONObject.parseObject((String)data.getString((Object)"message"));
                        try {
                            String copyFile = ConstantUtil.copyFile(-1, obj.get((Object)"content").toString());
                            data.replace((Object)"content", (Object)copyFile);
                            emoji.setUrl(copyFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    emoji.setMsg(data.toString());
                    emoji.setCreateTime(DateUtil.currentTimeSeconds());
                    this.getDatastore().save((Object)emoji);
                    listEmoji.add(emoji);
                    UserManagerImpl.getRedisServiceImpl().deleteUserCollectCommon(userId);
                    UserManagerImpl.getRedisServiceImpl().deleteUserCollectEmoticon(userId);
                    continue;
                }
                return null;
            }
        }
        return listEmoji;
    }

    @Override
    public Object addEmoji(int userId, String url, String type) {
        Query query = null;
        if (!StringUtil.isEmpty(url)) {
            query = this.getDatastore().createQuery(Emoji.class).filter("userId", (Object)userId).filter("url", (Object)url);
        }
        String copyFile = ConstantUtil.copyFile(-1, url);
        if (query.get() == null) {
            Emoji emoji = new Emoji();
            emoji.setUserId(userId);
            emoji.setType(Integer.valueOf(type));
            if (!StringUtil.isEmpty(copyFile)) {
                emoji.setUrl(copyFile);
            } else {
                emoji.setUrl(url);
            }
            emoji.setCreateTime(DateUtil.currentTimeSeconds());
            this.getDatastore().save((Object)emoji);
            UserManagerImpl.getRedisServiceImpl().deleteUserCollectEmoticon(userId);
            return emoji;
        }
        return null;
    }

    @Override
    public void deleteEmoji(Integer userId, String emojiId) {
        List<Object> list = new ArrayList();
        list = Arrays.asList(emojiId.split(","));
        Emoji dbObj = null;
        for (String string : list) {
            if (!ObjectId.isValid((String)string)) continue;
            Query query = (Query)((Query)this.getDatastore().createQuery(Emoji.class).field("_id").equal((Object)new ObjectId(string))).field("userId").equal((Object)userId);
            dbObj = (Emoji)query.get();
            if (null != dbObj) {
                if (dbObj.getCollectType() == 1) {
                    Query collectQuery = (Query)this.getDatastore().createQuery(Collect.class).field("msgId").equal((Object)new ObjectId(dbObj.getCollectMsgId()));
                    this.getDatastore().delete(collectQuery);
                }
                if (dbObj.getType() != 6) {
                    UserManagerImpl.getRedisServiceImpl().deleteUserCollectCommon(ReqUtil.getUserId());
                } else {
                    UserManagerImpl.getRedisServiceImpl().deleteUserCollectEmoticon(ReqUtil.getUserId());
                }
                this.getDatastore().delete(query);
                continue;
            }
            throw new ServiceException(10102);
        }
    }

    @Override
    public List<Emoji> emojiList(int userId, int type, int pageSize, int pageIndex) {
        List<Emoji> emojiLists = null;
        if (type != 0) {
            Query query = ((Query)this.getDatastore().createQuery(Emoji.class).field("userId").equal((Object)userId)).filter("type", (Object)new BasicDBObject("$lt", (Object)6)).order("-createTime");
            query.filter("type", (Object)type);
            emojiLists = query.asList();
            emojiLists = this.unescapeHtml3(emojiLists);
        } else {
            List<Emoji> userCollectCommon = UserManagerImpl.getRedisServiceImpl().getUserCollectCommon(userId);
            if (null != userCollectCommon && userCollectCommon.size() > 0) {
                emojiLists = userCollectCommon;
            } else {
                Query query = ((Query)this.getDatastore().createQuery(Emoji.class).field("userId").equal((Object)userId)).order("-createTime");
                query.or(new Criteria[]{(Criteria)query.criteria("type").lessThan((Object)6), (Criteria)query.criteria("type").equal((Object)7)});
                emojiLists = query.asList();
                emojiLists = this.unescapeHtml3(emojiLists);
                UserManagerImpl.getRedisServiceImpl().saveUserCollectCommon(userId, emojiLists);
            }
        }
        return emojiLists;
    }

    public List<Emoji> unescapeHtml3(List<Emoji> emojiLists) {
        if (null == emojiLists) {
            return null;
        }
        emojiLists.forEach(emojis -> {
            JSONObject emojiMsg;
            if (5 == emojis.getType() && null == emojis.getCollectContent() && null != (emojiMsg = this.emojiMsg((Emoji)emojis)) && null != emojiMsg.get((Object)"content")) {
                emojis.setMsg(emojiMsg.get((Object)"content").toString());
                log.info("\u65e7\u7248\u8f6c\u8bd1\u540e\u7684 content:" + emojiMsg.get((Object)"content").toString());
                emojis.setCollectContent(emojiMsg.get((Object)"content").toString());
            }
        });
        return emojiLists;
    }

    @Override
    public List<Emoji> emojiList(int userId) {
        List emojis = null;
        List userCollectEmoticon = UserManagerImpl.getRedisServiceImpl().getUserCollectEmoticon(userId);
        if (null != userCollectEmoticon && userCollectEmoticon.size() > 0) {
            emojis = userCollectEmoticon;
        } else {
            List emojiList;
            Query query = this.getDatastore().createQuery(Emoji.class).filter("userId", (Object)userId).filter("type", (Object)6);
            emojis = emojiList = query.order("-createTime").asList();
            UserManagerImpl.getRedisServiceImpl().saveUserCollectEmoticon(userId, emojis);
        }
        return emojis;
    }

    @Override
    public void addMessageCourse(final int userId, final List<String> messageIds, long createTime, String courseName, String roomJid) {
        final Course course = new Course();
        course.setUserId(userId);
        course.setMessageIds(messageIds);
        course.setCreateTime(createTime);
        course.setCourseName(courseName);
        course.setRoomJid(roomJid);
        this.saveEntity(course);
        ThreadUtil.executeInThread(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Object obj) {
                boolean num = false;
                MongoCollection dbCollection = null;
                dbCollection = course.getRoomJid().equals("0") ? SKBeanUtils.getTigaseManager().getMongoCollection(SKBeanUtils.getTigaseManager().getChatMsgDB(), userId) : SKBeanUtils.getTigaseManager().getImRoomDB().getCollection("mucmsg_" + course.getRoomJid());
                Document q = new Document();
                q.put("messageId", (Object)new Document("$in", (Object)messageIds));
                q.put("sender", (Object)(course.getUserId() + ""));
                CourseMessage courseMessage = null;
                try (MongoCursor iterator = dbCollection.find((Bson)q).iterator();){
                    while (iterator.hasNext()) {
                        Document dbObj = (Document)iterator.next();
                        courseMessage = new CourseMessage();
                        courseMessage.setCourseMessageId(new ObjectId());
                        courseMessage.setUserId(course.getUserId());
                        courseMessage.setCourseId(course.getCourseId().toString());
                        courseMessage.setCreateTime(String.valueOf(dbObj.get((Object)"timeSend")));
                        courseMessage.setMessage(String.valueOf(dbObj.getString((Object)"message")));
                        courseMessage.setMessageId(String.valueOf(dbObj.get((Object)"messageId")));
                        UserManagerImpl.this.saveEntity(courseMessage);
                    }
                }
            }
        });
    }

    @Override
    public List<Course> getCourseList(int userId) {
        Query query = this.getDatastore().createQuery(Course.class).filter("userId", (Object)userId);
        List list = query.order("createTime").asList();
        return list;
    }

    @Override
    public void updateCourse(Course course, String courseMessageId) {
        Query q = this.getDatastore().createQuery(Course.class).filter("courseId", (Object)course.getCourseId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(Course.class);
        if (null != course.getMessageIds()) {
            ops.set("messageIds", course.getMessageIds());
        }
        if (0L != course.getUpdateTime()) {
            ops.set("updateTime", (Object)course.getUpdateTime());
        }
        if (null != course.getCourseName()) {
            ops.set("courseName", (Object)course.getCourseName());
        }
        if (!StringUtil.isEmpty(courseMessageId)) {
            Query query = this.getDatastore().createQuery(CourseMessage.class).filter("messageId", (Object)courseMessageId);
            CourseMessage courseMessage = (CourseMessage)query.get();
            if (null == courseMessage) {
                Query oldQuery = this.getDatastore().createQuery(CourseMessage.class).filter("_id", (Object)new ObjectId(courseMessageId));
                courseMessage = (CourseMessage)oldQuery.get();
            }
            this.getDatastore().delete((Object)courseMessage);
            List<String> messageIds = ((Course)q.get()).getMessageIds();
            Iterator<String> iterator = messageIds.iterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (!next.equals(courseMessageId)) continue;
                iterator.remove();
            }
            if (0 == messageIds.size()) {
                this.getDatastore().delete(q);
                return;
            }
            ops.set("messageIds", messageIds);
        }
        this.getDatastore().update(q, ops);
    }

    @Override
    public boolean deleteCourse(Integer userId, ObjectId courseId) {
        Query query = this.getDatastore().createQuery(Course.class).filter("courseId", (Object)courseId);
        query.field("userId").equal((Object)userId);
        if (0L == this.getDatastore().getCount(query)) {
            return false;
        }
        Query q = this.getDatastore().createQuery(CourseMessage.class).filter("courseId", (Object)String.valueOf(courseId));
        q.field("userId").equal((Object)userId);
        List asList = q.asList();
        for (int i = 0; i < asList.size(); ++i) {
            this.getDatastore().delete(asList.get(i));
        }
        this.getDatastore().delete(query);
        return true;
    }

    @Override
    public List<CourseMessage> getCourse(String courseId) {
        ArrayList<CourseMessage> listMessage = new ArrayList();
        Query que = this.getDatastore().createQuery(CourseMessage.class).filter("courseId", (Object)courseId);
        listMessage = que.order("createTime").asList();
        return listMessage;
    }

    @Override
    public WxUser addwxUser(JSONObject jsonObject) {
        WxUser wxUser = new WxUser();
        Integer userId = this.createUserId();
        wxUser.setWxuserId(userId);
        wxUser.setOpenId(jsonObject.getString("openid"));
        try {
            wxUser.setNickname(new String(jsonObject.getString("nickname").getBytes("ISO-8859-1"), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        wxUser.setImgurl(jsonObject.getString("headimgurl"));
        wxUser.setSex(jsonObject.getIntValue("sex"));
        wxUser.setCity(jsonObject.getString("city"));
        wxUser.setCountry(jsonObject.getString("country"));
        wxUser.setProvince(jsonObject.getString("province"));
        wxUser.setCreatetime(DateUtil.currentTimeSeconds());
        this.getDatastore().save((Object)wxUser);
        return wxUser;
    }

    public List<Object> getUserRegisterCount(String startDate, String endDate, short timeUnit) {
        ArrayList<Object> countData = new ArrayList<Object>();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = timeUnit == 4 ? DateUtil.getTodayMorning().getTime() / 1000L : (timeUnit == 3 ? DateUtil.getLastMonth().getTime() / 1000L : DateUtil.getLastYear().getTime() / 1000L);
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime() / 1000L;
        endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gt", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        BasicDBObject query = new BasicDBObject("createTime", (Object)queryTime);
        DBCollection collection = SKBeanUtils.getDatastore().getCollection(this.getEntityClass());
        String mapStr = "function Map() { var date = new Date(this.createTime*1000);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (timeUnit == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (timeUnit == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (timeUnit == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (timeUnit == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,1);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        MapReduceCommand.OutputType type = MapReduceCommand.OutputType.INLINE;
        MapReduceCommand command = new MapReduceCommand(collection, mapStr, reduce, null, type, (DBObject)query);
        MapReduceOutput mapReduceOutput = collection.mapReduce(command);
        Iterable results = mapReduceOutput.results();
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (DBObject obj : results) {
            map.put((String)obj.get("_id"), (Double)obj.get("value"));
            countData.add(JSON.toJSON(map));
            map.clear();
        }
        return countData;
    }

    public List<Object> userOnlineStatusCount(String startDate, String endDate, short timeUnit) {
        ArrayList<Object> countData = new ArrayList<Object>();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = timeUnit == 4 ? DateUtil.getTodayMorning().getTime() / 1000L : (timeUnit == 3 ? DateUtil.getLastMonth().getTime() / 1000L : DateUtil.getLastYear().getTime() / 1000L);
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime() / 1000L;
        endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gte", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        short minute_sampling = 1;
        short hour_sampling = 2;
        short day_sampling = 3;
        BasicDBObject queryType = new BasicDBObject("$eq", (Object)day_sampling);
        if (1 == timeUnit) {
            queryType.append("$eq", (Object)day_sampling);
        } else if (2 == timeUnit) {
            queryType.append("$eq", (Object)day_sampling);
        } else if (timeUnit == 3) {
            queryType.append("$eq", (Object)hour_sampling);
        } else if (timeUnit == 4) {
            queryType.append("$eq", (Object)minute_sampling);
        }
        BasicDBObject query = new BasicDBObject("time", (Object)queryTime).append("type", (Object)queryType);
        DBCollection collection = SKBeanUtils.getDatastore().getCollection(UserStatusCount.class);
        String mapStr = "function Map() { var date = new Date(this.time*1000);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (timeUnit == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (timeUnit == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (timeUnit == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (timeUnit == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,this.count);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        MapReduceCommand.OutputType type = MapReduceCommand.OutputType.INLINE;
        MapReduceCommand command = new MapReduceCommand(collection, mapStr, reduce, null, type, (DBObject)query);
        MapReduceOutput mapReduceOutput = collection.mapReduce(command);
        Iterable results = mapReduceOutput.results();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DBObject obj : results) {
            map.put((String)obj.get("_id"), obj.get("value"));
            countData.add(JSON.toJSON(map));
            map.clear();
        }
        return countData;
    }

    public User updatemessagefree(int offlineNoPushMsg) {
        Query q = (Query)this.getDatastore().createQuery(User.class).field("_id").equal((Object)ReqUtil.getUserId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("offlineNoPushMsg", (Object)offlineNoPushMsg);
        User data = (User)this.getDatastore().findAndModify(q, ops);
        data.setPayPassword("");
        return data;
    }

    public WxUser getWxUser(String openid, Integer userId) {
        WxUser wxUser = null;
        if (!StringUtil.isEmpty(openid)) {
            wxUser = (WxUser)((Query)this.getDatastore().createQuery(WxUser.class).field("openId").equal((Object)openid)).get();
        } else if (null != userId) {
            wxUser = (WxUser)((Query)this.getDatastore().createQuery(WxUser.class).field("wxuserId").equal((Object)userId)).get();
        }
        return wxUser;
    }

    public List<User> getUserlimit(int pageIndex, int pageSize, int isAuth) {
        Query q = this.getDatastore().createQuery(User.class);
        if (1 == isAuth) {
            q.field("isAuth").equal((Object)isAuth);
        }
        q.order("-createTime");
        List dataList = q.offset(pageIndex * pageSize).limit(pageSize).asList();
        return dataList;
    }

    public List<User> nearbyUser(NearbyUser poi) {
        List data = null;
        try {
            Query q = this.getDatastore().createQuery(User.class);
            if (null != poi.getSex()) {
                q.field("sex").equal((Object)poi.getSex());
            }
            q.disableValidation();
            int distance = poi.getDistance();
            Double d = 0.0;
            if (0 == distance) {
                distance = ConstantUtil.getAppDefDistance();
            }
            d = (double)distance / 111.01;
            if (0.0 != poi.getLatitude() && 0.0 != poi.getLongitude()) {
                q.field("loc").near(poi.getLongitude(), poi.getLatitude(), d.doubleValue());
                q.field("_id").notEqual((Object)ReqUtil.getUserId());
            }
            if (!StringUtil.isEmpty(poi.getNickname())) {
                Config config = SKBeanUtils.getAdminManager().getConfig();
                if (0 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.field("account").equal((Object)poi.getNickname());
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                } else if (1 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0)});
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                } else if (2 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0)});
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                }
            } else if (0.0 == poi.getLatitude() && 0.0 == poi.getLongitude()) {
                return null;
            }
            if (null != poi.getUserId()) {
                q.field("_id").equal((Object)poi.getUserId());
            }
            if (null != poi.getSex()) {
                q.field("sex").equal((Object)poi.getSex());
            }
            if (null != poi.getActive() && 0L != poi.getActive()) {
                q.field("active").greaterThanOrEq((Object)(DateUtil.currentTimeSeconds() - poi.getActive() * 86400000L));
                q.field("active").lessThanOrEq((Object)DateUtil.currentTimeSeconds());
            }
            q.field("_id").greaterThan((Object)100050);
            q.project("sex", true).project("account", true).project("nickname", true).project("loc", true).project("createTime", true);
            q.offset(poi.getPageIndex() * poi.getPageSize()).limit(poi.getPageSize());
            data = q.asList();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return data;
        }
    }

    public PageVO nearbyUserWeb(NearbyUser poi) {
        List data = null;
        try {
            Query q = (Query)this.getDatastore().createQuery(User.class).field("_id").greaterThan((Object)100050);
            q.disableValidation();
            int distance = poi.getDistance();
            Double d = 0.0;
            if (0 == distance) {
                distance = ConstantUtil.getAppDefDistance();
            }
            d = (double)distance / 111.01;
            if (0.0 != poi.getLatitude() && 0.0 != poi.getLongitude()) {
                q.field("loc").near(poi.getLongitude(), poi.getLatitude(), d.doubleValue());
            }
            if (!StringUtil.isEmpty(poi.getNickname())) {
                Config config = SKBeanUtils.getAdminManager().getConfig();
                if (0 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.field("account").equal((Object)poi.getNickname());
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                } else if (1 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0)});
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").equal((Object)poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                } else if (2 == config.getTelephoneSearchUser()) {
                    if (0 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0)});
                    } else if (1 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").equal((Object)poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    } else if (2 == config.getNicknameSearchUser()) {
                        q.or(new Criteria[]{(Criteria)q.criteria("account").equal((Object)poi.getNickname()), (Criteria)((CriteriaContainerImpl)q.criteria("phone").containsIgnoreCase(poi.getNickname())).criteria("settings.phoneSearch").notEqual((Object)0), (Criteria)((CriteriaContainerImpl)q.criteria("nickname").containsIgnoreCase(poi.getNickname())).criteria("settings.nameSearch").notEqual((Object)0)});
                    }
                }
            } else {
                return null;
            }
            if (null != poi.getUserId()) {
                q.field("_id").equal((Object)poi.getUserId());
            }
            if (null != poi.getSex()) {
                q.field("sex").equal((Object)poi.getSex());
            }
            if (null != poi.getActive() && 0L != poi.getActive()) {
                q.field("active").greaterThanOrEq((Object)(DateUtil.currentTimeSeconds() - poi.getActive() * 86400000L));
                q.field("active").lessThanOrEq((Object)DateUtil.currentTimeSeconds());
            }
            q.offset(poi.getPageIndex() * poi.getPageSize()).limit(poi.getPageSize());
            q.project("sex", true).project("account", true).project("nickname", true).project("loc", true).project("createTime", true);
            data = q.asList();
            return new PageVO(data, q.count(), poi.getPageIndex(), poi.getPageSize());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void deleteUser(final Integer adminUserId, String ... userIds) {
        try {
            Integer systemUserId = 10005;
            for (String strUserId : userIds) {
                final Integer userId = Integer.valueOf(strUserId);
                if (userId.equals(1000) || userId.equals(1100) || userId.equals(10000)) {
                    log.info("\u8fc7\u6ee4\u5220\u9664\u7cfb\u7edf\u8d26\u53f7  \uff1a{}", (Object)userId);
                    continue;
                }
                if (0 == userId) continue;
                DBCollection tdbCollection = SKBeanUtils.getTigaseDatastore().getDB().getCollection("tig_users");
                String xmpphost = SKBeanUtils.getXMPPConfig().getServerName();
                tdbCollection.remove((DBObject)new BasicDBObject("user_id", (Object)(userId + "@" + xmpphost)));
                this.consoleDeleteUserXmpp(systemUserId, userId);
                try {
                    ThreadUtil.executeInThread(new Callback(){

                        @Override
                        public void execute(Object obj) {
                            try {
                                List<ObjectId> roomIdList = SKBeanUtils.getRoomManagerImplForIM().getRoomIdList(userId);
                                roomIdList.forEach(roomId -> SKBeanUtils.getRoomManagerImplForIM().deleteMember(UserManagerImpl.this.getUser(adminUserId), (ObjectId)roomId, userId));
                                SKBeanUtils.getFriendsManager().deleteFansAndFriends(userId);
                                SKBeanUtils.getAddressBookManger().deleteByUserId(userId, null);
                                UserManagerImpl.this.delReport(userId, null);
                                UserManagerImpl.this.delRecord(userId);
                                SKBeanUtils.getRoleManager().deleteAllRoles(userId);
                                UserManagerImpl.this.delCompany(userId);
                            }
                            catch (Exception e) {
                                UserManagerImpl.this.logger.error(e.getMessage(), (Throwable)e);
                            }
                            DBCollection dbCollection = UserManagerImpl.this.getDatastore().getCollection(User.class);
                            dbCollection.remove((DBObject)new BasicDBObject("_id", (Object)userId));
                            KSessionUtil.removeAccessToken(userId);
                            KSessionUtil.deleteUserByUserId(userId);
                            SKBeanUtils.getRedisService().deleteNoSystemNumUserIds();
                        }
                    });
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    throw new ServiceException(e.getResultCode());
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new ServiceException(e.getResultCode());
        }
    }

    private void consoleDeleteUserXmpp(Integer userId, Integer toUserId) {
        List<Integer> friendsUserIdsList;
        List<Integer> friendsUserIds = SKBeanUtils.getRedisService().getFriendsUserIdsList(toUserId);
        if (null != friendsUserIds && friendsUserIds.size() > 0) {
            friendsUserIdsList = friendsUserIds;
        } else {
            List<Integer> friendsUserIdsDB = SKBeanUtils.getFriendsManager().queryFansId(toUserId);
            friendsUserIdsList = friendsUserIdsDB;
        }
        log.info(" delete user  =====> userId : " + toUserId + "   \u597d\u53cbfriends : " + friendsUserIdsList);
        ThreadUtil.executeInThread(obj -> {
            List<KXMPPServiceImpl.MessageBean> messageBeans = Collections.synchronizedList(new ArrayList());
            friendsUserIdsList.forEach(strToUserId -> {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(512);
                messageBean.setFromUserId(userId.toString());
                messageBean.setFromUserName("10005".equals(userId) ? "\u540e\u53f0\u7ba1\u7406\u5458" : this.getNickName(userId));
                messageBean.setToUserId(strToUserId.toString());
                messageBean.setToUserName(this.getNickName((int)strToUserId));
                messageBean.setContent("\u540e\u53f0\u7ba1\u7406\u5458\u89e3\u9664\u4e86\u4f60\u4eec\u597d\u53cb\u5173\u7cfb");
                messageBean.setObjectId(toUserId);
                messageBean.setMessageId(StringUtil.randomUUID());
                messageBeans.add(messageBean);
                messageBean.setMsgType(0);
            });
            try {
                KXMPPServiceImpl.getInstance().send(friendsUserIdsList, messageBeans);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        });
    }

    @Override
    public SdkLoginInfo addSdkLoginInfo(int type, Integer userId, String loginInfo) {
        SdkLoginInfo entity = new SdkLoginInfo();
        entity.setType(type);
        entity.setLoginInfo(loginInfo);
        entity.setUserId(userId);
        entity.setCreateTime(DateUtil.currentTimeSeconds());
        this.getDatastore().save((Object)entity);
        return entity;
    }

    public List<SdkLoginInfo> getBindInfo(Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(SdkLoginInfo.class).field("userId").equal((Object)userId);
        return query.asList();
    }

    public JSONMessage unbind(int type, Integer userId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(SdkLoginInfo.class).field("type").equal((Object)type)).field("userId").equal((Object)userId);
        if (null != query.get()) {
            this.getDatastore().delete(query);
            return JSONMessage.success();
        }
        return JSONMessage.failureByErrCode(100208);
    }

    @Override
    public SdkLoginInfo findSdkLoginInfo(int type, String loginInfo) {
        Query query = (Query)((Query)this.getDatastore().createQuery(SdkLoginInfo.class).field("type").equal((Object)type)).field("loginInfo").equal((Object)loginInfo);
        return (SdkLoginInfo)query.get();
    }

    @Override
    public JSONObject getWxOpenId(String code) {
        if (StringUtil.isEmpty(code)) {
            return null;
        }
        JSONObject jsonObject = WXUserUtils.getWxOpenId(code);
        String openid = jsonObject.getString("openid");
        if (StringUtil.isEmpty(openid)) {
            return null;
        }
        return jsonObject;
    }

    public JSONObject getPublicWxOpenId(String code) {
        if (StringUtil.isEmpty(code)) {
            return null;
        }
        JSONObject jsonObject = WXUserUtils.getPublicWxOpenId(code);
        String openid = jsonObject.getString("openid");
        if (StringUtil.isEmpty(openid)) {
            return null;
        }
        return jsonObject;
    }

    @Override
    public String getWxToken() {
        JSONObject jsonObject = WXUserUtils.getWxToken();
        String token = jsonObject.getString("access_token");
        return token;
    }

    public String getPublicWxToken() {
        JSONObject jsonObject = WXUserUtils.getPublicWxToken();
        String token = jsonObject.getString("access_token");
        return token;
    }

    public boolean isOpenMultipleDevices(Integer userId) {
        boolean flag = false;
        User user = this.getUser(userId);
        if (null != user) {
            if (null == user.getSettings()) {
                return flag;
            }
            return 1 == user.getSettings().getMultipleDevices();
        }
        return flag;
    }

    public void multipointLoginDataSync(Integer userId, String nickName, String operationType) {
        ThreadUtil.executeInThread(obj -> {
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(800);
            String userName = nickName;
            if (StringUtil.isEmpty(userName)) {
                userName = this.getNickName(userId);
            }
            messageBean.setFromUserId(String.valueOf(userId));
            messageBean.setFromUserName(userName);
            messageBean.setToUserId(String.valueOf(userId));
            messageBean.setToUserName(nickName);
            messageBean.setObjectId(operationType);
            messageBean.setMessageId(StringUtil.randomUUID());
            try {
                KXMPPServiceImpl.getInstance().send(messageBean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void updatePersonalInfo(final Integer userId, final String nickName, final Integer toUserId, final String toNickName, final int type) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(801);
                messageBean.setFromUserId(String.valueOf(userId));
                messageBean.setFromUserName(nickName);
                if (1 == type) {
                    messageBean.setTo(String.valueOf(userId));
                }
                messageBean.setToUserId(null == toUserId ? String.valueOf(userId) : String.valueOf(toUserId));
                messageBean.setToUserName(StringUtil.isEmpty(toNickName) ? nickName : toNickName);
                messageBean.setMessageId(StringUtil.randomUUID());
                try {
                    KXMPPServiceImpl.getInstance().send(messageBean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public List<OfflineOperation> getOfflineOperation(Integer userId, long startTime) {
        Query query = this.getDatastore().createQuery(OfflineOperation.class);
        ((Query)query.field("userId").equal((Object)userId)).field("operationTime").greaterThanOrEq((Object)startTime);
        return query.asList();
    }
}

