/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.utils.CollectionUtil;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.NumberUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AliPayTransfersRecord;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.TransfersRecord;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.util.AliPayUtil;
import com.wxpay.utils.HttpUtils;
import com.wxpay.utils.PayUtil;
import com.wxpay.utils.WXNotify;
import com.wxpay.utils.WXPayUtil;
import com.wxpay.utils.XmlUtil;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransfersRecordManagerImpl
extends MongoRepository<TransfersRecord, ObjectId> {
    private static final String TRANSFERS_PAY = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    @Autowired(required=false)
    private KApplicationProperties.WXConfig wxConfig;
    private static final String transferLockKey = "transferLock:%s";

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<TransfersRecord> getEntityClass() {
        return TransfersRecord.class;
    }

    private void transfersToWXUser(TransfersRecord record) {
        try {
            ConsumeRecord entity = new ConsumeRecord();
            entity.setUserId(ReqUtil.getUserId());
            entity.setTime(DateUtil.currentTimeSeconds());
            entity.setType(2);
            entity.setDesc("\u5fae\u4fe1\u63d0\u73b0");
            entity.setStatus(1);
            entity.setTradeNo(record.getOutTradeNo());
            entity.setPayType(3);
            DecimalFormat df = new DecimalFormat("#.00");
            double total = Double.valueOf(record.getTotalFee());
            total = Double.valueOf(df.format(total));
            entity.setMoney(total);
            Double balance = SKBeanUtils.getUserManager().rechargeUserMoeny(record.getUserId(), total, 2);
            entity.setServiceCharge(Double.valueOf(record.getFee()));
            entity.setOperationAmount(Double.valueOf(record.getRealFee()));
            entity.setCurrentBalance(balance);
            SKBeanUtils.getConsumeRecordManager().saveConsumeRecord(entity);
            this.save(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transfersToAliPay(AliPayTransfersRecord record) {
        try {
            ConsumeRecord entity = new ConsumeRecord();
            entity.setUserId(ReqUtil.getUserId());
            entity.setTime(DateUtil.currentTimeSeconds());
            entity.setType(2);
            entity.setDesc("\u652f\u4ed8\u5b9d\u63d0\u73b0");
            entity.setStatus(1);
            entity.setTradeNo(record.getOutTradeNo());
            entity.setPayType(3);
            double total = Double.valueOf(record.getTotalFee());
            entity.setMoney(total);
            entity.setServiceCharge(Double.valueOf(record.getFee()));
            entity.setOperationAmount(Double.valueOf(record.getRealFee()));
            Double balance = SKBeanUtils.getUserManager().rechargeUserMoeny(record.getUserId(), total, 2);
            entity.setCurrentBalance(balance);
            SKBeanUtils.getConsumeRecordManager().save(entity);
            this.saveEntity(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONMessage wxWithdrawalPay(String amount, User user, String remoteAddr) {
        block9: {
            int userId = user.getUserId();
            String openid = user.getOpenid();
            DecimalFormat df = new DecimalFormat("#.00");
            double total = Double.valueOf(amount);
            if (0.5 > total) {
                return JSONMessage.failureByErrCode(104301);
            }
            double fee = Double.valueOf(df.format(total * 0.006));
            fee = 0.01 > fee ? 0.01 : NumberUtil.getCeil(fee, 2);
            Double totalFee = Double.valueOf(df.format(total - fee));
            Lock lock = SKBeanUtils.getRedisService().getLock(transferLockKey, 5L, new Object[]{userId});
            boolean lockResult = lock.tryLock(5L, TimeUnit.SECONDS);
            if (!lockResult) break block9;
            try {
                JSONMessage jSONMessage = this.transfersToWXOnLock(user, total, totalFee, fee, remoteAddr);
                lock.unlock();
                return jSONMessage;
            }
            catch (Exception e) {
                try {
                    try {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return JSONMessage.failureByErrCode(104302);
    }

    private JSONMessage transfersToWXOnLock(User user, double total, double totalFee, double fee, String remoteAddr) {
        int userId = user.getUserId();
        Double balance = SKBeanUtils.getUserManager().getUserMoenyV1(userId);
        if (totalFee > balance) {
            return JSONMessage.failureByErrCode(104001);
        }
        Double realFee = totalFee * 100.0;
        String realFeeStr = realFee.intValue() + "";
        this.logger.info(String.format("=== transferPay userid %s username %s \u63d0\u73b0\u91d1\u989d   %s \u624b\u7eed\u8d39   %s  \u5230\u8d26\u91d1\u989d   %s ", userId, user.getNickname(), total, fee, totalFee));
        Map restmap = null;
        TransfersRecord record = new TransfersRecord();
        try {
            record.setUserId(userId);
            record.setAppid(this.wxConfig.getAppid());
            record.setMchId(this.wxConfig.getMchid());
            record.setNonceStr(WXPayUtil.getNonceStr());
            record.setOutTradeNo(StringUtil.getOutTradeNo());
            record.setOpenid(user.getOpenid());
            record.setTotalFee(String.valueOf(total));
            record.setFee(fee + "");
            record.setRealFee(totalFee + "");
            record.setCreateTime(DateUtil.currentTimeSeconds());
            record.setStatus(0);
            HashMap<String, String> parm = new HashMap<String, String>();
            parm.put("mch_appid", this.wxConfig.getAppid());
            parm.put("mchid", this.wxConfig.getMchid());
            parm.put("nonce_str", record.getNonceStr());
            parm.put("partner_trade_no", record.getOutTradeNo());
            parm.put("openid", user.getOpenid());
            parm.put("check_name", "NO_CHECK");
            parm.put("amount", realFeeStr);
            parm.put("desc", "\u5373\u65f6\u901a\u8baf\u63d0\u73b0");
            parm.put("spbill_create_ip", remoteAddr);
            parm.put("sign", PayUtil.getSign(parm, this.wxConfig.getApiKey()));
            String restxml = HttpUtils.posts(TRANSFERS_PAY, XmlUtil.xmlFormat(parm, false));
            restmap = WXNotify.parseXmlToList2(restxml);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (CollectionUtil.isNotEmpty(restmap) && "SUCCESS".equals(restmap.get("result_code"))) {
            this.logger.info("\u63d0\u73b0\u6210\u529f\uff1a" + (String)restmap.get("result_code") + ":" + (String)restmap.get("return_code"));
            HashMap transferMap = new HashMap();
            transferMap.put("partner_trade_no", restmap.get("partner_trade_no"));
            transferMap.put("payment_no", restmap.get("payment_no"));
            transferMap.put("payment_time", restmap.get("payment_time"));
            record.setPayNo((String)restmap.get("payment_no"));
            record.setPayTime((String)restmap.get("payment_time"));
            record.setResultCode((String)restmap.get("result_code"));
            record.setReturnCode((String)restmap.get("return_code"));
            record.setStatus(1);
            this.transfersToWXUser(record);
            return JSONMessage.success(transferMap);
        }
        if (CollectionUtil.isNotEmpty(restmap)) {
            String resultMsg = (String)restmap.get("err_code") + ":" + (String)restmap.get("err_code_des");
            this.logger.error("\u63d0\u73b0\u5931\u8d25\uff1a \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 " + resultMsg);
            record.setErrCode((String)restmap.get("err_code"));
            record.setErrDes((String)restmap.get("err_code_des"));
            record.setStatus(-1);
            this.save(record);
            return JSONMessage.failure(resultMsg);
        }
        return JSONMessage.failureByErrCode(104302);
    }

    private JSONMessage transfersToAliPayOnLock(User user, String amount, double totalFee, double fee) {
        int userId = user.getUserId();
        Double balance = SKBeanUtils.getUserManager().getUserMoenyV1(userId);
        if (totalFee > balance) {
            return JSONMessage.failureByErrCode(104001);
        }
        String orderId = StringUtil.getOutTradeNo();
        AliPayTransfersRecord record = new AliPayTransfersRecord();
        record.setUserId(userId);
        record.setAppid(AliPayUtil.APP_ID);
        record.setOutTradeNo(orderId);
        record.setAliUserId(user.getAliUserId());
        record.setTotalFee(amount);
        record.setFee(fee + "");
        record.setRealFee(totalFee + "");
        record.setCreateTime(DateUtil.currentTimeSeconds());
        record.setStatus(0);
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        request.setBizContent("{    \"out_biz_no\":\"" + orderId + "\",    \"payee_type\":\"ALIPAY_USERID\",    \"payee_account\":\"" + user.getAliUserId() + "\",    \"amount\":\"" + totalFee + "\",    \"payer_show_name\":\"\u4f59\u989d\u63d0\u73b0\",    \"remark\":\"\u8f6c\u8d26\u5907\u6ce8\",  }");
        try {
            AlipayFundTransToaccountTransferResponse response = (AlipayFundTransToaccountTransferResponse)AliPayUtil.getAliPayClient().execute((AlipayRequest)request);
            System.out.println("\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c  " + response.getCode());
            if (response.isSuccess()) {
                record.setResultCode(response.getCode());
                record.setCreateTime(DateUtil.toTimestamp(response.getPayDate()));
                record.setStatus(1);
                this.transfersToAliPay(record);
                this.logger.info("\u652f\u4ed8\u5b9d\u63d0\u73b0\u6210\u529f");
                return JSONMessage.success();
            }
            record.setErrCode(response.getErrorCode());
            record.setErrDes(response.getMsg());
            record.setStatus(-1);
            this.saveEntity(record);
            this.logger.info("\u652f\u4ed8\u5b9d\u63d0\u73b0\u5931\u8d25");
            return JSONMessage.failureByErrCode(104302);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return JSONMessage.failureByErrCode(104302);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONMessage aliWithdrawalPay(User user, String amount) {
        block9: {
            int userId = user.getUserId();
            double total = Double.valueOf(amount);
            if (100.0 < total) {
                return JSONMessage.failureByErrCode(104306);
            }
            DecimalFormat df = new DecimalFormat("#.00");
            double fee = Double.valueOf(df.format(total * 0.006));
            fee = 0.01 > fee ? 0.01 : NumberUtil.getCeil(fee, 2);
            Double totalFee = Double.valueOf(df.format(total - fee));
            Lock lock = SKBeanUtils.getRedisService().getLock(transferLockKey, 5L, new Object[]{userId});
            boolean lockResult = lock.tryLock(5L, TimeUnit.SECONDS);
            if (!lockResult) break block9;
            try {
                JSONMessage jSONMessage = this.transfersToAliPayOnLock(user, amount, totalFee, fee);
                lock.unlock();
                return jSONMessage;
            }
            catch (Exception e) {
                try {
                    try {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return JSONMessage.failureByErrCode(104302);
    }
}

