/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.constants.MsgType;
import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.repository.mongo.MongoRepository;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoClient;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.MapReduceAction;
import com.shiku.mongodb.morphia.MongoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TigaseManagerImpl")
public class TigaseManagerImpl
extends MongoRepository<Object, ObjectId>
implements InitializingBean {
    public static final String BEAN_ID = "TigaseManagerImpl";
    @Autowired(required=false)
    private MongoClient tigMongoClient;
    private MongoDatabase chatMsgDB;
    private MongoDatabase lastMsgDB;
    private MongoDatabase imRoomDB;
    protected static final int DB_REMAINDER = 10000;
    @Autowired(required=false)
    private MongoConfig mongoConfig;

    public MongoDatabase getChatMsgDB() {
        return this.chatMsgDB;
    }

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Object> getEntityClass() {
        return null;
    }

    public MongoDatabase getLastMsgDB() {
        return this.lastMsgDB;
    }

    public MongoDatabase getImRoomDB() {
        return this.imRoomDB;
    }

    public void afterPropertiesSet() throws Exception {
        if (null != this.tigMongoClient) {
            this.chatMsgDB = this.tigMongoClient.getDatabase("shiku_msgs");
            this.lastMsgDB = this.tigMongoClient.getDatabase("shiku_lastChats");
            String roomDbName = this.mongoConfig.getRoomDbName();
            this.imRoomDB = this.tigMongoClient.getDatabase(roomDbName);
        }
    }

    @Override
    public MongoCollection<Document> getMongoCollection(MongoDatabase database, int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return database.getCollection(String.valueOf(remainder));
    }

    public DBCollection getCollection(String databaseName, int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return SKBeanUtils.getLocalSpringBeanManager().getTigMongoClient().getDB(databaseName).getCollection(String.valueOf(remainder));
    }

    public List<String> getCollectionList(String databaseName) {
        ArrayList<String> list = new ArrayList<String>();
        Set collectionNames = SKBeanUtils.getLocalSpringBeanManager().getTigMongoClient().getDB(databaseName).getCollectionNames();
        for (String s : collectionNames) {
            list.add(s);
        }
        list.remove("system.indexes");
        return list;
    }

    public List<String> getCollectionList(MongoDatabase database) {
        ArrayList<String> list = new ArrayList<String>();
        MongoIterable collectionNames = database.listCollectionNames();
        for (String s : collectionNames) {
            list.add(s);
        }
        list.remove("system.indexes");
        return list;
    }

    public void updateMsgIsReadStatus(int sender, String msgId) {
        if (null == msgId) {
            return;
        }
        Document query = new Document("messageId", (Object)msgId);
        this.getMongoCollection(this.getChatMsgDB(), sender).updateMany((Bson)query, (Bson)new Document("$set", (Object)new BasicDBObject("isRead", (Object)1)));
    }

    public void deleteLastMsg(int userId, String jid) {
        Document query = new Document("jid", (Object)jid);
        if (0 != userId) {
            query.append("userId", (Object)userId);
        }
        this.getMongoCollection(this.lastMsgDB, userId).deleteMany((Bson)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> queryChatMsgsList(String sender, String receiver, long startTime, long endTime, int pageIndex, int pageSize) {
        Document q = new Document();
        q.put("sender", (Object)sender);
        q.put("receiver", (Object)receiver);
        if (0L != startTime && 0L != endTime) {
            q.put("timeSend", (Object)new Document("$gte", (Object)startTime).append("$lte", (Object)endTime));
        } else if (0L != startTime || 0L != endTime) {
            if (0L != startTime) {
                q.put("timeSend", (Object)new Document("$gte", (Object)startTime));
            } else {
                q.put("timeSend", (Object)new Document("$lte", (Object)endTime));
            }
        }
        ArrayList result = Lists.newArrayList();
        int userId = new Integer(TigaseManagerImpl.parseBareUserId(sender));
        MongoCursor cursor = this.getMongoCollection(this.getChatMsgDB(), userId).find((Bson)q).sort((Bson)new Document("ts", (Object)-1)).skip(pageIndex * pageSize).limit(pageSize).iterator();
        try {
            while (cursor.hasNext()) {
                result.add(cursor.next());
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> queryMucMsgsList(String roomId, long startTime, long endTime, int pageIndex, int pageSize) {
        Room.Member member;
        Document q = new Document();
        ObjectId roomObjId = SKBeanUtils.getRoomManager().getRoomId(roomId);
        if (null != roomObjId && null != (member = SKBeanUtils.getRoomManager().getMember(roomObjId, ReqUtil.getUserId())) && startTime > 0L && null != member && startTime < member.getCreateTime()) {
            startTime = member.getCreateTime();
        }
        if (0L != startTime && 0L != endTime) {
            q.put("timeSend", (Object)new Document("$gte", (Object)startTime).append("$lte", (Object)endTime));
        } else if (0L != startTime || 0L != endTime) {
            if (0L != startTime) {
                q.put("timeSend", (Object)new Document("$gte", (Object)startTime));
            } else {
                q.put("timeSend", (Object)new Document("$lte", (Object)endTime));
            }
        }
        q.put("contentType", (Object)new BasicDBObject("$ne", (Object)83));
        ArrayList result = Lists.newArrayList();
        MongoCursor cursor = this.getImRoomDB().getCollection("mucmsg_" + roomId).find((Bson)q).sort((Bson)new BasicDBObject("ts", (Object)-1)).skip(pageIndex * pageSize).limit(pageSize).iterator();
        try {
            while (cursor.hasNext()) {
                result.add(cursor.next());
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> queryLastChatList(long startTime, long endTime, int pageSize) {
        Integer userId = ReqUtil.getUserId();
        ArrayList resultList = Lists.newArrayList();
        BasicDBObject query = new BasicDBObject();
        if (0L != startTime && 0L != endTime) {
            query.put((Object)"timeSend", (Object)new BasicDBObject("$gt", (Object)startTime).append("$lt", (Object)endTime));
        }
        if (0L != startTime || 0L != endTime) {
            if (0L != startTime) {
                query.put((Object)"timeSend", (Object)new BasicDBObject("$gt", (Object)startTime));
            } else {
                query.put((Object)"timeSend", (Object)new BasicDBObject("$lt", (Object)endTime));
            }
        }
        MongoCursor cursor = null;
        Document dbObj = null;
        Document sort = new Document("timeSend", (Object)-1);
        List<String> roomJidList = SKBeanUtils.getRoomManager().queryUserRoomsJidList(userId);
        if (null != roomJidList && 0 < roomJidList.size()) {
            query.append("jid", (Object)new BasicDBObject("$in", roomJidList));
            cursor = this.lastMsgDB.getCollection("lastChats_muc").find((Bson)query).sort((Bson)sort).limit(pageSize).iterator();
            try {
                while (cursor.hasNext()) {
                    dbObj = (Document)cursor.next();
                    resultList.add(dbObj);
                }
            }
            finally {
                if (null != cursor) {
                    cursor.close();
                }
            }
            query.remove((Object)"jid");
        }
        query.append("userId", (Object)userId.toString());
        cursor = this.getMongoCollection(this.lastMsgDB, userId).find((Bson)query).sort((Bson)sort).limit(pageSize).iterator();
        try {
            while (cursor.hasNext()) {
                dbObj = (Document)cursor.next();
                if ((Integer)dbObj.get((Object)"isRoom") != 1) {
                    String nickName = SKBeanUtils.getUserManager().getNickName(Integer.valueOf((String)dbObj.get((Object)"jid")));
                    dbObj.put("toUserName", (Object)nickName);
                }
                resultList.add(dbObj);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return resultList;
    }

    public static String parseBareUserId(String jid) {
        int slashIndex = jid.indexOf(47);
        if (slashIndex < 0) {
            return jid;
        }
        if (slashIndex == 0) {
            return "";
        }
        return jid.substring(0, slashIndex);
    }

    public long getMsgCountNum() {
        long count = 0L;
        MongoIterable listCollectionNames = this.getChatMsgDB().listCollectionNames();
        for (String string : listCollectionNames) {
            count += this.getChatMsgDB().getCollection(string).count();
        }
        return count;
    }

    public List<Object> getChatMsgCount(String startDate, String endDate, short counType) {
        ArrayList<Object> countData = new ArrayList();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = counType == 4 ? DateUtil.getTodayMorning().getTime() : (counType == 3 ? DateUtil.getLastMonth().getTime() : DateUtil.getLastYear().getTime());
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime();
        endTime = StringUtil.isEmpty(endDate) ? System.currentTimeMillis() : DateUtil.toDate(endDate).getTime();
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gt", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        BasicDBObject query = new BasicDBObject("ts", (Object)queryTime);
        String mapStr = "function Map() { var date = new Date(this.ts);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (counType == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (counType == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (counType == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (counType == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,1);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        HashMap<String, Double> map = new HashMap<String, Double>();
        MongoIterable collectionNames = this.getChatMsgDB().listCollectionNames();
        for (String str : collectionNames) {
            MongoCollection collection = this.getChatMsgDB().getCollection(str, DBObject.class);
            if (0L == collection.count((Bson)query)) continue;
            MongoCursor iterator = collection.mapReduce(mapStr, reduce, DBObject.class).iterator();
            Double value = null;
            String id = null;
            while (iterator.hasNext()) {
                DBObject obj = (DBObject)iterator.next();
                id = (String)obj.get("_id");
                value = (Double)obj.get("value");
                if (null != map.get(id)) {
                    map.put(id, (Double)map.get(id) + value);
                    continue;
                }
                map.put(id, value);
            }
        }
        countData = map.entrySet().stream().collect(Collectors.toList());
        map.clear();
        return countData;
    }

    public List<Object> getGroupMsgCount(String roomId, String startDate, String endDate, short counType) {
        DBCollection collection = SKBeanUtils.getImRoomDatastore().getDB().getCollection("mucmsg_" + roomId);
        if (collection == null || collection.count() == 0L) {
            System.out.println("\u6682\u65e0\u6570\u636e");
            throw new ServiceException("\u6682\u65e0\u6570\u636e");
        }
        ArrayList<Object> countData = new ArrayList<Object>();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = counType == 4 ? DateUtil.getTodayMorning().getTime() : (counType == 3 ? DateUtil.getLastMonth().getTime() : DateUtil.getLastYear().getTime());
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime();
        endTime = StringUtil.isEmpty(endDate) ? System.currentTimeMillis() : DateUtil.toDate(endDate).getTime();
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gt", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        BasicDBObject query = new BasicDBObject("ts", (Object)queryTime);
        String mapStr = "function Map() { var date = new Date(this.ts);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (counType == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (counType == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (counType == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (counType == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,1);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        MapReduceCommand.OutputType type = MapReduceCommand.OutputType.INLINE;
        MapReduceCommand command = new MapReduceCommand(collection, mapStr, reduce, null, type, (DBObject)query);
        MapReduceOutput mapReduceOutput = collection.mapReduce(command);
        Iterable results = mapReduceOutput.results();
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (DBObject obj : results) {
            map.put((String)obj.get("_id"), (Double)obj.get("value"));
            countData.add(JSON.toJSON(map));
            map.clear();
        }
        return countData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult chatLogsAll(long startTime, long endTime, int sender, int receiver, int page, int limit, String keyWord) throws Exception {
        MongoCollection dbCollection = this.getChatMsgDB().getCollection("1000");
        Document q = new Document();
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        q.put("direction", (Object)0);
        if (0 != receiver) {
            q.put("receiver", (Object)(receiver + ""));
        }
        if (0 != sender) {
            q.put("sender", (Object)(sender + ""));
        }
        if (!StringUtil.isEmpty(keyWord)) {
            q.put("content", (Object)new Document("$regex", (Object)keyWord));
        }
        if (0L != startTime) {
            q.put("ts", (Object)new Document("$gte", (Object)startTime));
        }
        if (0L != endTime) {
            q.put("ts", (Object)new Document("$lte", (Object)endTime));
        }
        long total = dbCollection.count((Bson)q);
        ArrayList pageData = Lists.newArrayList();
        PageResult result = new PageResult();
        try (MongoCursor iterator = dbCollection.find((Bson)q).sort((Bson)new Document("_id", (Object)-1)).skip((page - 1) * limit).limit(limit).iterator();){
            while (iterator.hasNext()) {
                Document dbObj = (Document)iterator.next();
                JSONObject body = JSONObject.parseObject((String)dbObj.getString((Object)"message"));
                if (null == body) continue;
                if (null != dbObj.get((Object)"isEncrypt") && dbObj.getBoolean((Object)"isEncrypt").booleanValue()) {
                    dbObj.put("isEncrypt", (Object)1);
                } else {
                    dbObj.put("isEncrypt", (Object)0);
                }
                try {
                    dbObj.put("sender_nickname", (Object)userManager.getNickName(Integer.valueOf(dbObj.getString((Object)"sender"))));
                }
                catch (Exception e) {
                    dbObj.put("sender_nickname", (Object)"\u672a\u77e5");
                }
                try {
                    dbObj.put("receiver_nickname", (Object)userManager.getNickName(Integer.valueOf(dbObj.getString((Object)"receiver"))));
                }
                catch (Exception e) {
                    dbObj.put("receiver_nickname", (Object)"\u672a\u77e5");
                }
                try {
                    dbObj.put("content", dbObj.get((Object)"content"));
                }
                catch (Exception e) {
                    dbObj.put("content", (Object)"--");
                }
                pageData.add(dbObj);
            }
        }
        result.setData(pageData);
        result.setCount(total);
        return result;
    }

    public void chatLogsAllDel(long startTime, long endTime, int sender, int receiver, int pageIndex, int pageSize) {
        List<String> collectionList = this.getCollectionList(this.getChatMsgDB());
        Document q = new Document();
        if (0 != sender) {
            q.put("sender", (Object)new BasicDBObject("$eq", (Object)sender));
        }
        if (0 != receiver) {
            q.put("receiver", (Object)new BasicDBObject("$eq", (Object)receiver));
        }
        if (0L != startTime) {
            q.put("ts", (Object)new BasicDBObject("$gte", (Object)startTime));
        }
        if (0L != endTime) {
            q.put("ts", (Object)new BasicDBObject("$lte", (Object)endTime));
        }
        for (String string : collectionList) {
            this.getChatMsgDB().getCollection(string).deleteMany((Bson)q);
        }
    }

    public void deleteChatMsgs(String msgId, int type) {
        MongoCollection collection = this.chatMsgDB.getCollection("1000");
        Document query = new Document();
        collection.createIndex((Bson)new Document("timeSend", (Object)-1));
        if (0 == type) {
            if (StringUtil.isEmpty(msgId)) {
                throw new ServiceException("\u53c2\u6570msgId\u9519\u8bef");
            }
            ArrayList<ObjectId> msgIdList = new ArrayList<ObjectId>();
            String[] msgIds = StringUtil.getStringList(msgId);
            for (String strMsgId : StringUtil.getStringList(msgId)) {
                msgIdList.add(new ObjectId(strMsgId));
            }
            query.append("_id", (Object)new Document("$in", msgIdList));
            this.joinFileUriToDelFielsCollection((MongoCollection<Document>)collection, query);
            collection.deleteMany((Bson)query);
        } else if (1 == type) {
            long onedayNextDay = DateUtil.getOnedayNextDay(DateUtil.currentTimeSeconds(), 30, 1);
            System.out.println("\u4e0a\u4e2a\u6708\u7684\u65f6\u95f4\uff1a" + onedayNextDay);
            query.put("timeSend", (Object)new BasicDBObject("$lte", (Object)onedayNextDay));
            this.joinFileUriToDelFielsCollection((MongoCollection<Document>)collection, query);
            collection.deleteMany((Bson)query);
        } else if (2 == type) {
            int num = 100000;
            long count = collection.count();
            if (count <= 100000L) {
                throw new ServiceException("\u6d88\u606f\u603b\u6570\u91cf\u6570\u91cf\u5c11\u4e8e100000\u6761");
            }
            Document first = (Document)collection.find().sort((Bson)new Document("timeSend", (Object)-1)).skip(100000).first();
            if (null == first) {
                return;
            }
            query.append("timeSend", (Object)new Document("$lt", (Object)first.getLong((Object)"timeSend")));
            this.joinFileUriToDelFielsCollection((MongoCollection<Document>)collection, query);
            collection.deleteMany((Bson)query);
        }
    }

    public void joinFileUriToDelFielsCollection(MongoCollection<Document> collection, Document query) {
        MapReduceIterable documents = collection.mapReduce("function Map() { emit(this.messageId,this.content);}", "function Reduce(key, values) {  return -1 != (''+values).indexOf('http') ? values.toString() : ''; }");
        documents.collectionName("del_files").databaseName("resources").action(MapReduceAction.MERGE);
        Document newQuery = query.append("contentType", (Object)new Document("$in", MsgType.FileTypeArr));
        documents.filter((Bson)newQuery);
        documents.toCollection();
        query.remove((Object)"contentType");
    }
}

