/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.Transfer;
import cn.xyz.mianshi.vo.TransferReceive;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class SkTransferManagerImpl
extends MongoRepository<Transfer, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    @Override
    public Class<Transfer> getEntityClass() {
        return Transfer.class;
    }

    public Transfer saveTransfer(Transfer entity) {
        ObjectId id = (ObjectId)this.save(entity).getId();
        entity.setId(id);
        return entity;
    }

    public JSONMessage getTransferById(Integer userId, ObjectId id) {
        Transfer transfer = (Transfer)this.get((Serializable)id);
        if (DateUtil.currentTimeSeconds() > transfer.getOutTime()) {
            return JSONMessage.failureByErrCode((Integer)100301, transfer);
        }
        if (transfer.getStatus() != 1) {
            return JSONMessage.failureByErrCode((Integer)100302, transfer);
        }
        return JSONMessage.success(transfer);
    }

    public synchronized JSONMessage sendTransfer(final Integer userId, String money, final Transfer transfer) {
        if (SKBeanUtils.getUserManager().getUserMoeny(userId) < Double.valueOf(money)) {
            return JSONMessage.failureByErrCode(104001);
        }
        transfer.setUserId(userId);
        transfer.setUserName(SKBeanUtils.getUserManager().getUser(userId).getNickname());
        long cuTime = DateUtil.currentTimeSeconds();
        transfer.setCreateTime(cuTime);
        transfer.setOutTime(cuTime + 86400L);
        if (StringUtil.isEmpty(transfer.getRemark())) {
            transfer.setRemark("");
        }
        Transfer data = SKBeanUtils.getSkTransferManager().saveTransfer(transfer);
        SKBeanUtils.getUserManager().rechargeUserMoeny(userId, transfer.getMoney(), 2);
        new ThreadUtil();
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                String tradeNo = StringUtil.getOutTradeNo();
                ConsumeRecord record = new ConsumeRecord();
                record.setUserId(userId);
                record.setToUserId(transfer.getToUserId());
                record.setTradeNo(tradeNo);
                record.setMoney(transfer.getMoney());
                record.setStatus(1);
                record.setType(7);
                record.setPayType(3);
                record.setDesc("\u8f6c\u8d26");
                record.setTime(DateUtil.currentTimeSeconds());
                SKBeanUtils.getConsumeRecordManager().save(record);
            }
        });
        return JSONMessage.success(data);
    }

    public synchronized JSONMessage receiveTransfer(final Integer userId, ObjectId id) {
        final Transfer transfer = (Transfer)this.get((Serializable)id);
        if (DateUtil.currentTimeSeconds() > transfer.getOutTime()) {
            return JSONMessage.failureByErrCode((Integer)100301, transfer);
        }
        if (transfer.getStatus() != 1) {
            return JSONMessage.failureByErrCode((Integer)100302, transfer);
        }
        if (!transfer.getToUserId().equals(userId)) {
            return JSONMessage.failureByErrCode((Integer)104203, transfer);
        }
        User user = SkTransferManagerImpl.getUserManager().getUser(userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(Transfer.class);
        ops.set("status", (Object)2);
        ops.set("receiptTime", (Object)DateUtil.currentTimeSeconds());
        this.updateAttributeByOps((Serializable)transfer.getId(), ops);
        TransferReceive receive = new TransferReceive();
        receive.setMoney(transfer.getMoney());
        receive.setSendId(transfer.getUserId());
        receive.setUserId(userId);
        receive.setSendName(transfer.getUserName());
        receive.setUserName(user.getNickname());
        receive.setTransferId(transfer.getId().toString());
        receive.setTime(DateUtil.currentTimeSeconds());
        this.getDatastore().save((Object)receive);
        SkTransferManagerImpl.getUserManager().rechargeUserMoeny(userId, transfer.getMoney(), 1);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(88);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(user.getNickname());
        messageBean.setContent(transfer.getId().toString());
        messageBean.setToUserId(transfer.getUserId().toString());
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String tradeNo = StringUtil.getOutTradeNo();
                ConsumeRecord record = new ConsumeRecord();
                record.setUserId(userId);
                record.setToUserId(transfer.getUserId());
                record.setTradeNo(tradeNo);
                record.setMoney(transfer.getMoney());
                record.setStatus(1);
                record.setType(8);
                record.setPayType(3);
                record.setDesc("\u63a5\u53d7\u8f6c\u8d26");
                record.setTime(DateUtil.currentTimeSeconds());
                SKBeanUtils.getConsumeRecordManager().save(record);
            }
        }).start();
        return JSONMessage.success(receive);
    }

    public List<Transfer> getTransferList(Integer userId, int pageIndex, int pageSize) {
        Query query = (Query)this.getDatastore().createQuery(Transfer.class).field("userId").equal((Object)userId);
        return query.order("-createTime").offset(pageIndex * pageSize).limit(pageSize).asList();
    }

    public List<TransferReceive> getTransferReceiveList(Integer userId, int pageIndex, int pageSize) {
        Query query = (Query)this.getDatastore().createQuery(TransferReceive.class).field("userId").equal((Object)userId);
        return query.order("-time").offset(pageIndex * pageSize).limit(pageSize).asList();
    }
}

