/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.constants.MsgType;
import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.DocumentToJavaBean;
import cn.xyz.commons.utils.ExcelUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.model.PageVO;
import cn.xyz.mianshi.model.RoomVO;
import cn.xyz.mianshi.service.RoomManager;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.GroupHelper;
import cn.xyz.mianshi.vo.Helper;
import cn.xyz.mianshi.vo.OfflineOperation;
import cn.xyz.mianshi.vo.Role;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import cn.xyz.service.RedisServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.HashedMap;
import org.apache.poi.ss.usermodel.Workbook;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="RoomManagerImpl")
public class RoomManagerImplForIM
extends MongoRepository<Room, ObjectId>
implements RoomManager {
    private MongoDatabase imRoomDatabase;
    @Qualifier(value="imRoomMongoClient")
    @Autowired(required=false)
    private MongoClient imRoomMongoClient;
    private MongoDatabase roomJidsDB;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getImRoomDatastore();
    }

    @Override
    public Class<Room> getEntityClass() {
        return Room.class;
    }

    public MongoDatabase getImRoomDatabase() {
        if (null == this.imRoomDatabase) {
            this.imRoomDatabase = this.imRoomMongoClient.getDatabase("imRoom");
        }
        return this.imRoomDatabase;
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    private static RedisServiceImpl getRedisServiceImpl() {
        return SKBeanUtils.getRedisService();
    }

    @Override
    public String getCollectionName() {
        MappedClass mappedClass = this.morphia.getMapper().getMappedClass(Room.Member.class);
        if (null == mappedClass) {
            return null;
        }
        return mappedClass.getCollectionName();
    }

    @Override
    public String getCollectionName(ObjectId id) {
        if (null == id) {
            this.logger.info(" ====  getCollectionName ObjectId is null  ====");
            throw new ServiceException("ObjectId  is  null !");
        }
        int remainder = 0;
        int counter = id.getCounter();
        remainder = counter / 10000;
        return String.valueOf(remainder);
    }

    @Override
    public String getCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public MongoCollection<Document> getCollection(int userId) {
        String collectionName = this.getCollectionName(userId);
        if (null == this.roomJidsDB) {
            this.roomJidsDB = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase("shiku_roomJids_userId");
        }
        return this.roomJidsDB.getCollection(collectionName);
    }

    private Datastore getRoomDatastore() {
        return SKBeanUtils.getImRoomDatastore();
    }

    @Override
    public Room add(User user, Room entity, List<Integer> memberUserIdList, JSONObject userKeys) {
        Config config = SKBeanUtils.getSystemConfig();
        user.setNum(user.getNum() + 1);
        entity.initRoomConfig(user.getUserId(), user.getNickname());
        List<Role> userRoles = SKBeanUtils.getRoleManager().getUserRoles(user.getUserId(), null, 0);
        if (null != userRoles && userRoles.size() > 0) {
            for (Role role : userRoles) {
                if (role.getRole() != 4) continue;
                entity.setPromotionUrl(role.getPromotionUrl());
            }
        }
        if (null == entity.getName()) {
            entity.setName("\u6211\u7684\u7fa4\u7ec4");
        }
        if (null == entity.getDesc()) {
            entity.setDesc("");
        }
        if (null == entity.getLongitude()) {
            entity.setLongitude(0.0);
        }
        if (null == entity.getLatitude()) {
            entity.setLatitude(0.0);
        }
        if (StringUtil.isEmpty(entity.getJid())) {
            entity.setJid(StringUtil.randomUUID());
        }
        this.getRoomDatastore().save((Object)entity);
        Room.Member member = new Room.Member();
        member.setActive(DateUtil.currentTimeSeconds());
        member.setCreateTime(member.getActive());
        member.setModifyTime(0L);
        member.setNickname(user.getNickname());
        member.setRole(1);
        member.setRoomId(entity.getId());
        member.setSub(1);
        member.setTalkTime(0L);
        member.setCall(entity.getCall());
        member.setVideoMeetingNo(entity.getVideoMeetingNo());
        member.setUserId(user.getUserId());
        if (userKeys != null) {
            member.setChatKeyGroup(userKeys.getString(user.getUserId() + ""));
        }
        ArrayList memberList = Lists.newArrayList((Object[])new Room.Member[]{member});
        if (null == memberUserIdList || memberUserIdList.isEmpty()) {
            this.sendToChatNewMemberMessage(user.getUserId(), entity, member);
            SKBeanUtils.getRedisService().deleteUserRoomJidList(user.getUserId());
            if (0 == SKBeanUtils.getUserManager().getOnlinestateByUserId(user.getUserId())) {
                SKBeanUtils.getRedisService().addRoomPushMember(entity.getJid(), user.getUserId());
            }
        } else if (null != memberUserIdList && !memberUserIdList.isEmpty()) {
            Long currentTimeSeconds = DateUtil.currentTimeSeconds();
            ObjectId roomId = entity.getId();
            memberUserIdList.add(user.getUserId());
            this.sendToChatNewMemberMessage(user.getUserId(), entity, member);
            Room.Member _member = null;
            for (int userId : memberUserIdList) {
                User _user = RoomManagerImplForIM.getUserManager().getUser(userId);
                if (userId != member.getUserId()) {
                    _member = new Room.Member();
                    _member.setActive(currentTimeSeconds);
                    _member.setCreateTime(currentTimeSeconds);
                    _member.setModifyTime(0L);
                    _member.setNickname(_user.getNickname());
                    _member.setRole(3);
                    _member.setRoomId(roomId);
                    _member.setSub(1);
                    _member.setCall(entity.getCall());
                    _member.setVideoMeetingNo(entity.getVideoMeetingNo());
                    _member.setTalkTime(0L);
                    _member.setUserId(_user.getUserId());
                    if (userKeys != null) {
                        _member.setChatKeyGroup(userKeys.getString(userId + ""));
                    }
                    memberList.add(_member);
                    this.sendNewMemberMessage(user.getUserId(), entity, _member);
                }
                SKBeanUtils.getRedisService().deleteUserRoomJidList(userId);
                if (0 != SKBeanUtils.getUserManager().getOnlinestateByUserId(userId)) continue;
                SKBeanUtils.getRedisService().addRoomPushMember(entity.getJid(), userId);
            }
        }
        ArrayList dbObjects = new ArrayList();
        memberList.forEach(memberss -> {
            DBObject dbObj = this.objectToDBObject(memberss);
            dbObjects.add(dbObj);
        });
        this.getDBObjectCollection(entity.getId()).insertMany(dbObjects);
        memberList.forEach(membersss -> this.saveJidsByUserId(membersss.getUserId(), entity.getJid(), entity.getId()));
        this.updateUserSize(entity.getId(), memberList.size());
        this.saveJidsByUserId(user.getUserId(), entity.getJid(), entity.getId());
        this.updateOfflineOperation(user.getUserId(), entity.getId(), null);
        return entity;
    }

    public void updateOfflineOperation(Integer userId, ObjectId roomId, String toUserIds) {
        this.logger.info("userId is : {} ,  toUserIds is : {}", (Object)userId, (Object)toUserIds);
        long currentTime = DateUtil.currentTimeSeconds();
        Datastore datastore = SKBeanUtils.getDatastore();
        Query query = (Query)((Query)datastore.createQuery(OfflineOperation.class).field("userId").equal((Object)userId)).field("friendId").equal((Object)String.valueOf(roomId));
        if (null == query.get()) {
            datastore.save((Object)new OfflineOperation(userId, "room", String.valueOf(roomId), currentTime));
        } else {
            UpdateOperations ops = datastore.createUpdateOperations(OfflineOperation.class);
            ops.set("operationTime", (Object)currentTime);
            datastore.update(query, ops);
        }
        if (!StringUtil.isEmpty(toUserIds)) {
            List<Integer> toUserIdList = StringUtil.getIntList(toUserIds, ",");
            toUserIdList.forEach(toUserId -> {
                Query toUserQuery = (Query)((Query)datastore.createQuery(OfflineOperation.class).field("userId").equal(toUserId)).field("friendId").equal((Object)String.valueOf(roomId));
                if (null == toUserQuery.get()) {
                    datastore.save((Object)new OfflineOperation((Integer)toUserId, "room", String.valueOf(roomId), currentTime));
                } else {
                    UpdateOperations ops = datastore.createUpdateOperations(OfflineOperation.class);
                    ops.set("operationTime", (Object)currentTime);
                    datastore.update(toUserQuery, ops);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getRoomPushUserIdList(ObjectId roomId) {
        Document query = new Document("roomId", (Object)roomId);
        query.append("offlineNoPushMsg", (Object)new Document("$ne", (Object)1));
        ArrayList<Integer> memberIdList = new ArrayList<Integer>();
        try (MongoCursor iterator = this.getCollection(roomId).distinct("userId", (Bson)query, Integer.class).iterator();){
            while (iterator.hasNext()) {
                Integer integer = (Integer)iterator.next();
                memberIdList.add(integer);
            }
        }
        return memberIdList;
    }

    @Override
    public void delete(final ObjectId roomId, final Integer userId) {
        final Query query = (Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId);
        Room room = (Room)query.get();
        if (null == room) {
            System.out.println("====> RoomManagerImplForIM > delete room is null ");
            return;
        }
        Room.Member member = this.getMember(roomId, userId);
        List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
        if (null != member ? !userRoles.contains(5) && !userRoles.contains(6) && 1 != member.getRole() : !userRoles.contains(5) && !userRoles.contains(6)) {
            throw new ServiceException(10111);
        }
        final String roomJid = room.getJid();
        if (room.getUserSize() > 0) {
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setFromUserId(room.getUserId() + "");
            messageBean.setFromUserName(this.getMemberNickname(roomId, room.getUserId()));
            messageBean.setType(903);
            messageBean.setObjectId(room.getJid());
            messageBean.setContent(room.getName());
            messageBean.setMessageId(StringUtil.randomUUID());
            this.sendChatGroupMsg(roomId, room.getJid(), messageBean);
        }
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                RoomManagerImplForIM.this.getRoomDatastore().delete(query);
                List<Integer> memberIdList = RoomManagerImplForIM.this.getMemberIdList(roomId);
                for (Integer id : memberIdList) {
                    SKBeanUtils.getRedisService().deleteUserRoomJidList(id);
                    RoomManagerImplForIM.this.delJidsByUserId(id, roomJid);
                }
                Document document = new Document().append("roomId", (Object)roomId);
                RoomManagerImplForIM.this.getCollection(roomId).deleteMany((Bson)document);
                SKBeanUtils.getImRoomDatastore().getDB().getCollection("mucmsg_" + roomJid).drop();
                Query notQuery = (Query)SKBeanUtils.getImRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId);
                SKBeanUtils.getImRoomDatastore().delete(notQuery);
                RoomManagerImplForIM.this.deleMucHistory(roomJid);
                RoomManagerImplForIM.this.destroyRoomMsgFileAndShare(roomId, roomJid);
                RoomManagerImplForIM.getUserManager().delReport(null, roomId.toString());
                User user = RoomManagerImplForIM.getUserManager().getUserFromDB(userId);
                RoomManagerImplForIM.this.destroyRoomToIM(user.getUserId() + "", user.getPassword(), roomJid);
                List<Room.Member> memberList = RoomManagerImplForIM.getRedisServiceImpl().getMemberList(roomId.toString());
                RoomManagerImplForIM.this.updateRoomInfoByRedis(roomId.toString());
                RoomManagerImplForIM.getRedisServiceImpl().deleteNoticeList(roomId.toString());
                RoomManagerImplForIM.this.deleteById((Serializable)roomId);
            }
        });
    }

    public void roomAllBanned(final ObjectId roomId, final long talkTime) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                Document query1 = new Document("roomId", (Object)roomId);
                RoomManagerImplForIM.this.getCollection(roomId).updateMany((Bson)query1, (Bson)new Document("$set", (Object)new Document("talkTime", (Object)talkTime)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONMessage update(User user, RoomVO roomVO, int isAdmin, int isConsole) {
        JSONMessage jsonMessage = JSONMessage.success();
        Query query = SKBeanUtils.getImRoomDatastore().createQuery(this.getEntityClass());
        query.filter("_id", (Object)roomVO.getRoomId());
        UpdateOperations operations = SKBeanUtils.getImRoomDatastore().createUpdateOperations(this.getEntityClass());
        Room room = this.getRoom(roomVO.getRoomId(), user.getUserId());
        if (0 == isConsole && null != room && room.getS() == -1) {
            throw new ServiceException(100401);
        }
        if (!StringUtil.isEmpty(roomVO.getRoomName()) && !room.getName().equals(roomVO.getRoomName())) {
            this.UpdateGroupNickname((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-2L < roomVO.getTalkTime()) {
            this.allBannedSpeak((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (!StringUtil.isEmpty(roomVO.getDesc())) {
            operations.set("desc", (Object)roomVO.getDesc());
        }
        if (!StringUtil.isEmpty(roomVO.getSubject())) {
            operations.set("subject", (Object)roomVO.getSubject());
        }
        try {
            if (!StringUtil.isEmpty(roomVO.getNotice())) {
                if (this.getMember(room.getId(), ReqUtil.getUserId()).getRole() == 3) {
                    return JSONMessage.failureByErrCode((Integer)10111, ReqUtil.getRequestLanguage());
                }
                String noticeId = this.newNotice((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
                HashedMap data = new HashedMap();
                data.put("noticeId", noticeId);
                return JSONMessage.success(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (-1 < roomVO.getShowRead() && room.getShowRead() != roomVO.getShowRead()) {
            this.alreadyReadNums((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getIsNeedVerify()) {
            this.groupVerification((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getIsLook()) {
            this.roomIsPublic((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (null != roomVO.getMaxUserSize() && roomVO.getMaxUserSize() >= 0) {
            if (roomVO.getMaxUserSize() < room.getUserSize()) {
                throw new ServiceException(100402);
            }
            int maxUserSize = SKBeanUtils.getAdminManager().getConfig().getMaxUserSize();
            if (roomVO.getMaxUserSize() > maxUserSize) {
                throw new ServiceException(100423);
            }
            operations.set("maxUserSize", (Object)roomVO.getMaxUserSize());
        }
        if (null != roomVO.getS() && 0 != roomVO.getS()) {
            this.roomIsLocking((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getShowMember()) {
            this.showMember((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowSendCard()) {
            this.roomAllowSendCard((Query<Room>)query, user, roomVO, isAdmin, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowInviteFriend()) {
            this.roomAllowInviteFriend((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowUploadFile()) {
            this.roomAllowUploadFile((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowConference()) {
            this.roomAllowConference((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowSpeakCourse()) {
            this.roomAllowSpeakCourse((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
            return jsonMessage;
        }
        if (-1 != roomVO.getAllowHostUpdate()) {
            operations.set("allowHostUpdate", (Object)roomVO.getAllowHostUpdate());
        }
        if (-2.0 != roomVO.getChatRecordTimeOut()) {
            this.ChatRecordTimeOut((Query<Room>)query, user, roomVO, room, (UpdateOperations<Room>)operations);
        }
        if (-1 != roomVO.getIsAttritionNotice()) {
            operations.set("isAttritionNotice", (Object)roomVO.getIsAttritionNotice());
        }
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        Query query2 = query;
        synchronized (query2) {
            this.getRoomDatastore().update(query, operations);
        }
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(roomVO.getRoomId().toString());
        return jsonMessage;
    }

    public void updateEncryptType(Room room, int encryptType) {
        this.updateAttribute((Serializable)room.getId(), "encryptType", encryptType);
        SKBeanUtils.getRedisService().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        try {
            messageBean.setFromUserId(room.getUserId() + "");
            messageBean.setFromUserName(RoomManagerImplForIM.getUserManager().getNickName(room.getUserId()));
            messageBean.setType(935);
            messageBean.setObjectId(room.getJid());
            messageBean.setContent(encryptType);
            messageBean.setMessageId(StringUtil.randomUUID());
            messageBean.setToUserId(room.getJid());
            this.sendGroupMsg(room.getJid(), messageBean);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void resetGroupChatKey(Room room, JSONObject jsonGroupKeys) {
        ThreadUtil.executeInThread(obj -> {
            try {
                DBCollection dbCollection = this.getRoomDatastore().getCollection(Room.Member.class);
                this.getRoomDatastore().getDB().getCollection("mucmsg_" + room.getJid()).drop();
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setFromUserId(room.getUserId() + "");
                messageBean.setFromUserName(RoomManagerImplForIM.getUserManager().getNickName(room.getUserId()));
                messageBean.setType(806);
                messageBean.setObjectId(room.getJid());
                messageBean.setToUserId(room.getJid());
                messageBean.setContent(room.getName());
                messageBean.setMessageId(StringUtil.randomUUID());
                this.sendGroupMsg(room.getJid(), messageBean);
                jsonGroupKeys.entrySet().stream().forEach(entny -> {
                    BasicDBObject query = new BasicDBObject().append("roomId", (Object)room.getId()).append("userId", (Object)Integer.valueOf((String)entny.getKey()));
                    BasicDBObject values = new BasicDBObject("$set", (Object)new BasicDBObject("chatKeyGroup", entny.getValue()));
                    dbCollection.update((DBObject)query, (DBObject)values);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void updateGroupChatKey(Room room, int userId, String key) {
        try {
            MongoCollection<Document> dbCollection = this.getCollection(userId);
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setFromUserId(room.getUserId() + "");
            messageBean.setFromUserName(RoomManagerImplForIM.getUserManager().getNickName(room.getUserId()));
            messageBean.setType(806);
            messageBean.setObjectId(room.getJid());
            messageBean.setToUserId(room.getJid());
            messageBean.setContent(room.getName());
            messageBean.setMessageId(StringUtil.randomUUID());
            this.sendGroupMsg(room.getJid(), messageBean);
            Document query = new Document().append("roomId", (Object)room.getId()).append("userId", (Object)userId);
            Document values = new Document("$set", (Object)new Document("chatKeyGroup", (Object)key));
            dbCollection.updateOne((Bson)query, (Bson)values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateRoomInfoByRedis(String roomId) {
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(roomId);
        RoomManagerImplForIM.getRedisServiceImpl().deleteMemberList(roomId);
    }

    public synchronized void UpdateGroupNickname(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("name", (Object)roomVO.getRoomName());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setFromUserId(user.getUserId() + "");
            messageBean.setFromUserName("10005".equals(user.getUserId().toString()) ? "\u540e\u53f0\u7ba1\u7406\u5458" : this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setType(902);
            messageBean.setObjectId(room.getJid());
            messageBean.setContent(roomVO.getRoomName());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void allBannedSpeak(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("talkTime", (Object)roomVO.getTalkTime());
        this.updateGroup(query, operations);
        this.roomAllBanned(roomVO.getRoomId(), roomVO.getTalkTime());
        this.updateRoomInfoByRedis(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(920);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getTalkTime()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public String newNotice(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        Room.Notice notice = new Room.Notice(new ObjectId(), roomVO.getRoomId(), roomVO.getNotice(), user.getUserId(), user.getNickname());
        operations.set("notice", (Object)notice);
        this.updateGroup(query, operations);
        this.getRoomDatastore().save((Object)notice);
        RoomManagerImplForIM.getRedisServiceImpl().deleteNoticeList(room.getId());
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setFromUserId(user.getUserId() + "");
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setType(905);
            messageBean.setObjectId(room.getJid());
            messageBean.setContent(roomVO.getNotice());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
        return notice.getId().toString();
    }

    public void alreadyReadNums(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("showRead", (Object)roomVO.getShowRead());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(915);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(String.valueOf(roomVO.getShowRead()));
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void groupVerification(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("isNeedVerify", (Object)roomVO.getIsNeedVerify());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(916);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(String.valueOf(roomVO.getIsNeedVerify()));
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomIsPublic(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("isLook", (Object)roomVO.getIsLook());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(917);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(String.valueOf(roomVO.getIsLook()));
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomIsLocking(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("s", (Object)roomVO.getS());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(931);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(roomVO.getS());
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendChatGroupMsg(roomVO.getRoomId(), room.getJid(), messageBean);
    }

    public void roomAllowSendCard(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("allowSendCard", (Object)roomVO.getAllowSendCard());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(919);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(String.valueOf(roomVO.getAllowSendCard()));
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void showMember(Query<Room> query, User user, RoomVO roomVO, int isAdmin, Room room, UpdateOperations<Room> operations) {
        operations.set("showMember", (Object)roomVO.getShowMember());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (1 == isAdmin) {
            messageBean.setType(918);
            messageBean.setFromUserId(user.getUserId().toString());
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
            messageBean.setContent(String.valueOf(roomVO.getShowMember()));
            messageBean.setObjectId(room.getJid());
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomAllowInviteFriend(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("allowInviteFriend", (Object)roomVO.getAllowInviteFriend());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(921);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getAllowInviteFriend()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(UUID.randomUUID().toString());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomAllowUploadFile(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("allowUploadFile", (Object)roomVO.getAllowUploadFile());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(922);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getAllowUploadFile()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomAllowConference(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("allowConference", (Object)roomVO.getAllowConference());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(923);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getAllowConference()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void roomAllowSpeakCourse(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("allowSpeakCourse", (Object)roomVO.getAllowSpeakCourse());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(924);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getAllowSpeakCourse()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public void ChatRecordTimeOut(Query<Room> query, User user, RoomVO roomVO, Room room, UpdateOperations<Room> operations) {
        operations.set("chatRecordTimeOut", (Object)roomVO.getChatRecordTimeOut());
        this.updateGroup(query, operations);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(room.getId().toString());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(932);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(room.getId(), user.getUserId()));
        messageBean.setContent(String.valueOf(roomVO.getChatRecordTimeOut()));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
    }

    public synchronized void updateGroup(Query<Room> query, UpdateOperations<Room> operations) {
        this.getRoomDatastore().update(query, operations);
    }

    public void sendGroupOne(Integer userIds, KXMPPServiceImpl.MessageBean messageBean) {
        try {
            messageBean.setMsgType(0);
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendGroupMsg(String jid, KXMPPServiceImpl.MessageBean messageBean) {
        try {
            KXMPPServiceImpl.getInstance().sendMsgToGroupByJid(jid, messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendChatToOneGroupMsg(Integer userIds, final String jid, final KXMPPServiceImpl.MessageBean messageBean) {
        try {
            messageBean.setMsgType(0);
            if (StringUtil.isEmpty(messageBean.getMessageId())) {
                messageBean.setMessageId(StringUtil.randomUUID());
            }
            KXMPPServiceImpl.getInstance().send(messageBean);
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    try {
                        KXMPPServiceImpl.getInstance().sendMsgToGroupByJid(jid, messageBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendChatGroupMsg(ObjectId roomId, final String jid, final KXMPPServiceImpl.MessageBean messageBean) {
        try {
            messageBean.setMsgType(0);
            messageBean.setMessageId(StringUtil.randomUUID());
            KXMPPServiceImpl.getInstance().send(messageBean, this.getMemberIdList(roomId));
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    try {
                        KXMPPServiceImpl.getInstance().sendMsgToGroupByJid(jid, messageBean);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Room transfer(Room room, Integer toUserId) {
        String nickName = RoomManagerImplForIM.getUserManager().getNickName(toUserId);
        Query roomQuery = this.getRoomDatastore().createQuery(this.getEntityClass()).filter("_id", (Object)room.getId());
        UpdateOperations roomOps = this.getRoomDatastore().createUpdateOperations(this.getEntityClass());
        roomOps.set("userId", (Object)toUserId);
        roomOps.set("nickname", (Object)nickName);
        this.getRoomDatastore().update(roomQuery, roomOps);
        MongoCollection collection = this.getCollection(room.getId());
        collection.updateOne((Bson)new Document("roomId", (Object)room.getId()).append("userId", (Object)room.getUserId()), (Bson)new Document("$set", (Object)new Document("role", (Object)3)));
        collection.updateOne((Bson)new Document("roomId", (Object)room.getId()).append("userId", (Object)toUserId), (Bson)new Document("$set", (Object)new Document("role", (Object)1)));
        this.updateRoomInfoByRedis(room.getId().toString());
        KXMPPServiceImpl.MessageBean message = new KXMPPServiceImpl.MessageBean();
        message.setType(925);
        message.setFromUserId(room.getUserId().toString());
        message.setFromUserName(this.getMemberNickname(room.getId(), room.getUserId()));
        message.setObjectId(room.getJid());
        message.setToUserId(toUserId.toString());
        message.setToUserName(RoomManagerImplForIM.getUserManager().getNickName(toUserId));
        message.setMessageId(StringUtil.randomUUID());
        this.sendChatToOneGroupMsg(toUserId, room.getJid(), message);
        return (Room)this.get((Serializable)room.getId());
    }

    @Override
    public Room get(ObjectId roomId, Integer pageIndex, Integer pageSize) {
        Room redisRoom = SKBeanUtils.getRedisService().queryRoom(roomId);
        if (null != redisRoom) {
            if (-1 == redisRoom.getS()) {
                throw new ServiceException(100401);
            }
            Room specialRoom = this.specialHandleByRoom(redisRoom, roomId, pageIndex, pageSize);
            return specialRoom;
        }
        Room room = (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId)).get();
        if (null != room && -1 == room.getS()) {
            throw new ServiceException(100401);
        }
        if (null == room) {
            throw new ServiceException(100411);
        }
        Room specialRoom = this.specialHandleByRoom(room, roomId, pageIndex, pageSize);
        return specialRoom;
    }

    public Room getRoomByJid(String roomJid) {
        return (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("jid").equal((Object)roomJid)).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Room specialHandleByRoom(Room room, ObjectId roomId, Integer pageIndex, Integer pageSize) {
        Room.Member member = SKBeanUtils.getRoomManagerImplForIM().getMember(roomId, ReqUtil.getUserId());
        if (null == member) {
            Room joinRoom = this.getRoom(roomId);
            List<Room.Member> members = this.getHeadMemberListByPageImpls(roomId, pageSize, 0);
            joinRoom.setMembers(members);
            return joinRoom;
        }
        int role = member.getRole();
        ArrayList<Room.Member> members = new ArrayList<Room.Member>();
        if (1 != member.getRole()) {
            if (role > 1 && role < 4) {
                long count = this.getCollection(roomId).count((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lt", (Object)4)));
                try (MongoCursor iterator = this.getCollection(roomId).find((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lt", (Object)4))).iterator();){
                    Room.Member docMember = null;
                    while (iterator.hasNext()) {
                        Document document = (Document)iterator.next();
                        try {
                            docMember = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
                            if (null == document) continue;
                            members.add(docMember);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (role == 4 || role == 5) {
                ArrayList<Document> documents = new ArrayList<Document>();
                documents.add(new Document("role", (Object)new Document("$lt", (Object)4)));
                documents.add(new Document("userId", (Object)ReqUtil.getUserId()));
                Document query = new Document("roomId", (Object)roomId).append("$or", documents);
                FindIterable find = this.getCollection(roomId).find((Bson)query);
                try (MongoCursor iterator = find.iterator();){
                    while (iterator.hasNext()) {
                        Room.Member docMember = new Room.Member();
                        Document document = (Document)iterator.next();
                        docMember = DocumentToJavaBean.setFieldValue(docMember, document);
                        members.add(docMember);
                    }
                }
            }
            room.setUserSize(members.size());
            room.setMembers(members);
        } else {
            List<Room.Member> membersList = this.getHeadMemberListByPageImpls(roomId, pageSize, member.getRole());
            room.setMembers(membersList);
        }
        List<Room.Notice> noticesCache = RoomManagerImplForIM.getRedisServiceImpl().getNoticeList(roomId);
        if (null != noticesCache && noticesCache.size() > 0) {
            room.setNotices(noticesCache);
        } else {
            List noticesDB = ((Query)this.getRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId)).order("-time").asList();
            room.setNotices(noticesDB);
            RoomManagerImplForIM.getRedisServiceImpl().saveNoticeList(roomId, noticesDB);
        }
        return room;
    }

    public List<Room.Member> getMembers(ObjectId roomId) {
        List<Room.Member> members = null;
        List<Room.Member> memberList = RoomManagerImplForIM.getRedisServiceImpl().getMemberList(roomId.toString());
        if (null != memberList && memberList.size() > 0) {
            members = memberList;
        } else {
            List<Room.Member> membersDB = this.getMemberList(roomId, null);
            members = membersDB;
            RoomManagerImplForIM.getRedisServiceImpl().saveMemberList(roomId.toString(), membersDB);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Room.Member> getHeadMemberListByPageImpls(ObjectId roomId, Integer pageSize, int role) {
        List<Room.Member> members = this.getAdministrationMemberList(roomId);
        MongoCollection collection = this.getCollection(roomId);
        int adminSize = members.size();
        Document query = new Document("roomId", (Object)roomId);
        query.append("role", (Object)new Document("$gt", (Object)2));
        if (1 != role) {
            query.append("role", (Object)new Document("$ne", (Object)4));
        }
        if (adminSize < pageSize) {
            MongoCursor iterator = collection.find((Bson)query).sort((Bson)new Document("createTime", (Object)1)).limit(pageSize - adminSize).iterator();
            Document document = null;
            Room.Member member = null;
            try {
                while (iterator.hasNext()) {
                    document = (Document)iterator.next();
                    member = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
                    if (null == member) continue;
                    members.add(member);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                iterator.close();
            }
        } else {
            Document document = (Document)collection.find((Bson)query).sort((Bson)new Document("createTime", (Object)1)).first();
            Room.Member member = null;
            if (null != document) {
                member = new Room.Member();
                if (null != (member = DocumentToJavaBean.setFieldValue(member, document))) {
                    members.add(member);
                }
            }
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room specialRole(int role, Room room, ObjectId roomId) {
        MongoCollection collection = this.getCollection(roomId);
        ArrayList<Room.Member> members = new ArrayList<Room.Member>();
        if (role > 1 && role < 4) {
            long count = collection.count((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lt", (Object)4)));
            try (MongoCursor iterator = collection.find((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lt", (Object)4))).iterator();){
                Room.Member docMember = null;
                while (iterator.hasNext()) {
                    Document document = (Document)iterator.next();
                    docMember = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
                    if (null == docMember) continue;
                    members.add(docMember);
                }
            }
            room.setUserSize((int)((long)room.getUserSize().intValue() - count));
        } else if (role == 4) {
            try (MongoCursor iterator = collection.find((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lte", (Object)4))).iterator();){
                while (iterator.hasNext()) {
                    Room.Member docMember = new Room.Member();
                    Document document = (Document)iterator.next();
                    docMember = DocumentToJavaBean.setFieldValue(docMember, document);
                    members.add(docMember);
                }
            }
            room.setUserSize(members.size());
        } else if (role == 5) {
            try (MongoCursor iterator = collection.find((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$lt", (Object)5)).append("role", (Object)new Document("$ne", (Object)5))).iterator();){
                while (iterator.hasNext()) {
                    Room.Member docMember = new Room.Member();
                    Document document = (Document)iterator.next();
                    docMember = DocumentToJavaBean.setFieldValue(docMember, document);
                    members.add(docMember);
                }
            }
            room.setUserSize(members.size());
        }
        room.setMembers(members);
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Room.Member> getMemberListByPageImpl(ObjectId roomId, long joinTime, Integer pageSize, int role) {
        if (0L == joinTime) {
            return this.getHeadMemberListByPageImpls(roomId, pageSize, role);
        }
        Document query = new Document("roomId", (Object)roomId).append("role", (Object)new Document("$gt", (Object)2)).append("createTime", (Object)new Document("$gte", (Object)joinTime));
        if (1 != role) {
            query.append("role", (Object)new Document("$ne", (Object)4));
        }
        MongoCursor iterator = this.getCollection(roomId).find((Bson)query).sort((Bson)new Document("createTime", (Object)1)).limit(pageSize.intValue()).iterator();
        Document document = null;
        Room.Member member = null;
        ArrayList<Room.Member> members = new ArrayList<Room.Member>();
        try {
            while (iterator.hasNext()) {
                document = (Document)iterator.next();
                member = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
                if (null == member) continue;
                members.add(member);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            iterator.close();
        }
        return members;
    }

    public Room consoleGetRoom(ObjectId roomId) {
        Room room = (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId)).get();
        if (null != room) {
            List members = ((Query)this.getRoomDatastore().createQuery(Room.Member.class).field("roomId").equal((Object)roomId)).order("createTime").order("role").asList();
            List notices = ((Query)this.getRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId)).order("-time").asList();
            room.setMembers(members);
            room.setNotices(notices);
            if (0 == room.getUserSize()) {
                room.setUserSize(members.size());
                BasicDBObject q = new BasicDBObject("_id", (Object)roomId);
                BasicDBObject o = new BasicDBObject("$set", (Object)new BasicDBObject("userSize", (Object)members.size()));
                this.getRoomDatastore().getCollection(this.getEntityClass()).update((DBObject)q, (DBObject)o);
            }
        }
        return room;
    }

    public Room getRoom(ObjectId roomId) {
        return this.getRoom(roomId, ReqUtil.getUserId());
    }

    public Room getRoom(ObjectId roomId, int userId) {
        Room room = null;
        Room roomCache = RoomManagerImplForIM.getRedisServiceImpl().queryRoom(roomId);
        if (null != roomCache) {
            room = roomCache;
        } else {
            Room roomDB = (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId)).get();
            if (null == roomDB) {
                throw new ServiceException(100411);
            }
            room = roomDB;
            RoomManagerImplForIM.getRedisServiceImpl().saveRoom(room);
        }
        room.setMembers(this.getAdministrationMemberList(roomId));
        int userRole = SKBeanUtils.getRoleManager().getUserRoleByUserId(userId);
        Room.Member member = null;
        int role = 0;
        member = this.getMember(roomId, userId);
        if (null == member) {
            return room;
        }
        role = member.getRole();
        if (5 != userRole && 6 != userRole) {
            member = this.getMember(roomId, userId);
            if (null == member) {
                throw new ServiceException(100409);
            }
            role = member.getRole();
        }
        if (1 < role && role < 4) {
            long invisibleCustodyCount = this.getCollection(roomId).count((Bson)new Document("roomId", (Object)roomId).append("role", (Object)new Document("$gte", (Object)4)));
            int userSize = (int)((long)room.getUserSize().intValue() - invisibleCustodyCount);
            room.setUserSize(userSize);
        } else if (4 == role || 5 == role) {
            ArrayList<Document> documents = new ArrayList<Document>();
            documents.add(new Document("role", (Object)new Document("$lt", (Object)4)));
            documents.add(new Document("userId", (Object)userId));
            long userCount = this.getCollection(roomId).count((Bson)new Document("roomId", (Object)roomId).append("$or", documents));
            room.setUserSize((int)userCount);
        }
        return room;
    }

    public Integer getCreateUserId(ObjectId roomId) {
        return (Integer)this.queryOneField("userId", (DBObject)new BasicDBObject("_id", (Object)roomId));
    }

    public ObjectId getRoomId(String jid) {
        return (ObjectId)this.queryOneField("_id", (DBObject)new BasicDBObject("jid", (Object)jid));
    }

    public String queryRoomJid(ObjectId roomId) {
        return (String)this.queryOneFieldById("jid", (Serializable)roomId);
    }

    public Integer queryRoomStatus(ObjectId roomId) {
        return (Integer)this.queryOneFieldById("s", (Serializable)roomId);
    }

    public String getRoomName(String jid) {
        return (String)this.queryOneField("name", (DBObject)new BasicDBObject("jid", (Object)jid));
    }

    public String getRoomName(ObjectId roomId) {
        return (String)this.queryOneField("name", (DBObject)new BasicDBObject("_id", (Object)roomId));
    }

    public Integer getRoomStatus(ObjectId roomId) {
        return (Integer)this.queryOneField("s", (DBObject)new BasicDBObject("_id", (Object)roomId));
    }

    @Override
    public List<Room> selectList(int pageIndex, int pageSize, String roomName) {
        Query q = this.getRoomDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(roomName)) {
            q.or(new Criteria[]{(Criteria)q.criteria("name").containsIgnoreCase(roomName), (Criteria)q.criteria("desc").containsIgnoreCase(roomName)});
        }
        q.filter("isLook", (Object)0);
        q.field("isSecretGroup").notEqual((Object)1);
        List roomList = q.offset(pageIndex * pageSize).limit(pageSize).order("-_id").asList();
        return roomList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryUserRoomsJidList(int userId) {
        ArrayList<String> jids = new ArrayList<String>();
        try (MongoCursor iterator = this.getCollection(userId).distinct("jid", (Bson)new Document("userId", (Object)userId), String.class).iterator();){
            while (iterator.hasNext()) {
                String jid = (String)iterator.next();
                if (null == jid) continue;
                jids.add(jid);
            }
        }
        return jids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryUserNoPushJidList(int userId) {
        Document query = new Document("userId", (Object)userId).append("offlineNoPushMsg", (Object)1);
        ArrayList<String> jids = new ArrayList<String>();
        try (MongoCursor iterator = this.getCollection(userId).distinct("jid", (Bson)query, String.class).iterator();){
            while (iterator.hasNext()) {
                String jid = (String)iterator.next();
                if (null == jid) continue;
                jids.add(jid);
            }
        }
        return jids;
    }

    public List<ObjectId> queryUserRoomsIdList(int userId) {
        return this.getRoomIdList(userId);
    }

    @Override
    public Object selectHistoryList(int userId, int type, int pageIndex, int pageSize) {
        List<ObjectId> roomIds = this.queryUserRoomsIdList(userId);
        if (roomIds.isEmpty()) {
            return null;
        }
        Query limit = ((Query)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").in(roomIds)).field("s").equal((Object)1)).order("-_id").offset(pageIndex * pageSize).limit(pageSize);
        List historyList = limit.asList();
        historyList.forEach(room -> {
            Room.Member member = this.getMember(room.getId(), userId);
            room.setMember(member);
        });
        return historyList;
    }

    @Override
    public void deleteMember(User user, ObjectId roomId, int userId) {
        Room.Member member;
        Room room = this.getRoom(roomId, user.getUserId());
        if (-1 == room.getS()) {
            throw new ServiceException("\u8be5\u7fa4\u5df2\u7ecf\u88ab\u9501\u5b9a\uff01");
        }
        Room.Member roomMember = null;
        if (null != user) {
            roomMember = this.getMember(roomId, user.getUserId());
        }
        if ((member = this.getMember(roomId, userId)) == null) {
            throw new ServiceException(100409);
        }
        if (room.getUserId().equals(userId)) {
            this.delete(roomId, userId);
            return;
        }
        if (null == roomMember) {
            Query roleQuery = (Query)SKBeanUtils.getDatastore().createQuery(Role.class).field("userId").equal((Object)user.getUserId());
            if (null != roleQuery.get() && (5 == ((Role)roleQuery.get()).getRole() || 6 == ((Role)roleQuery.get()).getRole())) {
                if (-1 == ((Role)roleQuery.get()).getStatus()) {
                    throw new ServiceException(100422);
                }
                if (room.getUserId().equals(userId)) {
                    throw new ServiceException(100410);
                }
            }
        } else if (!user.getUserId().equals(userId)) {
            if (roomMember.getRole() >= 3) {
                throw new ServiceException("\u6682\u65e0\u8e22\u4eba\u6743\u9650");
            }
            if (room.getUserId().equals(userId)) {
                throw new ServiceException("\u4e0d\u80fd\u79fb\u51fa\u7fa4\u4e3b");
            }
            if (member.getRole() != 1 && member.getRole() != 3 && 2 == roomMember.getRole()) {
                throw new ServiceException("\u7ba1\u7406\u5458\u4e0d\u80fd\u8e22\u51fa" + (2 == member.getRole() ? "\u7ba1\u7406\u5458" : (4 == member.getRole() ? "\u9690\u8eab\u4eba" : "\u76d1\u62a4\u4eba")));
            }
        }
        User toUser = RoomManagerImplForIM.getUserManager().getUser(userId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setFromUserId(user.getUserId() + "");
        messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
        messageBean.setType(904);
        messageBean.setObjectId(room.getJid());
        if (user.getUserId().equals(userId)) {
            messageBean.setTo(room.getUserId() + "");
        }
        messageBean.setToUserId(userId + "");
        messageBean.setToUserName(toUser.getNickname());
        messageBean.setContent(room.getName());
        messageBean.setMessageId(StringUtil.randomUUID());
        if (1 == room.getIsAttritionNotice()) {
            if (4 != member.getRole() && 5 != member.getRole()) {
                this.sendChatToOneGroupMsg(userId, room.getJid(), messageBean);
            } else {
                this.sendGroupOne(userId, messageBean);
            }
        } else {
            this.sendGroupOne(userId, messageBean);
        }
        Document query = new Document().append("roomId", (Object)roomId).append("userId", (Object)userId);
        this.delJidsByUserId(userId, room.getJid());
        this.getCollection(roomId).deleteOne((Bson)query);
        this.updateUserSize(roomId, -1);
        SKBeanUtils.getRedisService().deleteUserRoomJidList(userId);
        SKBeanUtils.getRedisService().removeRoomPushMember(room.getJid(), userId);
        this.updateRoomInfoByRedis(roomId.toString());
        this.updateOfflineOperation(user.getUserId(), roomId, null);
    }

    public void sendNewMemberMessage(int fromUserId, Room room, Room.Member member) {
        KXMPPServiceImpl.MessageBean messageBean = this.createNewMemberMessage(fromUserId, room, member);
        this.sendChatToOneGroupMsg(member.getUserId(), room.getJid(), messageBean);
    }

    public void sendToChatNewMemberMessage(int fromUserId, Room room, Room.Member member) {
        KXMPPServiceImpl.MessageBean messageBean = this.createNewMemberMessage(fromUserId, room, member);
        messageBean.setMsgType(0);
        if (StringUtil.isEmpty(messageBean.getMessageId())) {
            messageBean.setMessageId(StringUtil.randomUUID());
        }
        KXMPPServiceImpl.getInstance().send(messageBean);
    }

    private KXMPPServiceImpl.MessageBean createNewMemberMessage(int fromUserId, Room room, Room.Member member) {
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(907);
        messageBean.setObjectId(room.getJid());
        messageBean.setFromUserId(fromUserId + "");
        messageBean.setFromUserName(RoomManagerImplForIM.getUserManager().getNickName(fromUserId));
        messageBean.setToUserId(member.getUserId() + "");
        messageBean.setToUserName(member.getNickname());
        messageBean.setFileSize(room.getShowRead());
        messageBean.setContent(room.getName());
        messageBean.setFileName(room.getId().toString());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("showRead", (Object)room.getShowRead());
        jsonObject.put("lsLook", (Object)room.getIsLook());
        jsonObject.put("isNeedVerify", (Object)room.getIsNeedVerify());
        jsonObject.put("showMember", (Object)room.getShowMember());
        jsonObject.put("allowSendCard", (Object)room.getAllowSendCard());
        jsonObject.put("maxUserSize", (Object)room.getMaxUserSize());
        jsonObject.put("isSecretGroup", (Object)room.getIsSecretGroup());
        jsonObject.put("chatKeyGroup", (Object)member.getChatKeyGroup());
        messageBean.setOther(jsonObject.toJSONString());
        messageBean.setMessageId(StringUtil.randomUUID());
        return messageBean;
    }

    @Override
    public void updateMember(User user, ObjectId roomId, List<Integer> userIdList, JSONObject userKeys) {
        Room room = (Room)this.get((Serializable)roomId);
        Room.Member invitationMember = this.getMember(roomId, user.getUserId());
        if (null != invitationMember && 4 == invitationMember.getRole()) {
            throw new ServiceException("\u9690\u8eab\u4eba\u4e0d\u53ef\u4ee5\u9080\u8bf7\u7528\u6237\u52a0\u7fa4");
        }
        if (room.getMaxUserSize() < room.getUserSize() + userIdList.size()) {
            throw new ServiceException("\u7fa4\u4eba\u6570\u5feb\u5230\u4e0a\u9650  \u6700\u591a\u8fd8\u53ef\u4ee5\u9080\u8bf7  " + (room.getMaxUserSize() - room.getUserSize()) + "\u4eba");
        }
        ArrayList list = new ArrayList();
        for (int userId : userIdList) {
            User _user = RoomManagerImplForIM.getUserManager().getUser(userId);
            if (null == _user) continue;
            Room.Member _member = new Room.Member();
            if (-1 < this.findMemberAndRole(roomId, userId)) {
                this.logger.info(" \u7528\u6237   {}   \u5df2\u7ecf\u52a0\u5165\u7fa4\u7ec4   ", (Object)userId);
                continue;
            }
            _member.setUserId(userId);
            _member.setRole(3);
            this.updateMember(user, roomId, _member);
        }
        this.updateUserSize(roomId, list.size());
        list.stream().forEach(member -> {
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(907);
            messageBean.setObjectId(room.getJid());
            messageBean.setFromUserId(user.getUserId() + "");
            messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
            messageBean.setToUserId(member.getUserId() + "");
            messageBean.setToUserName(member.getNickname());
            messageBean.setFileSize(room.getShowRead());
            messageBean.setContent(room.getName());
            messageBean.setFileName(room.getId().toString());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("showRead", (Object)room.getShowRead());
            jsonObject.put("lsLook", (Object)room.getIsLook());
            jsonObject.put("isNeedVerify", (Object)room.getIsNeedVerify());
            jsonObject.put("showMember", (Object)room.getShowMember());
            jsonObject.put("allowSendCard", (Object)room.getAllowSendCard());
            jsonObject.put("maxUserSize", (Object)room.getMaxUserSize());
            messageBean.setOther(jsonObject.toJSONString());
            messageBean.setMessageId(StringUtil.randomUUID());
            this.sendChatToOneGroupMsg(member.getUserId(), room.getJid(), messageBean);
            this.saveJidsByUserId(member.getUserId(), room.getJid(), room.getId());
            SKBeanUtils.getRedisService().deleteUserRoomJidList(member.getUserId());
            if (0 == SKBeanUtils.getUserManager().getOnlinestateByUserId(member.getUserId())) {
                SKBeanUtils.getRedisService().addRoomPushMember(room.getJid(), member.getUserId());
            }
        });
        this.updateRoomInfoByRedis(roomId.toString());
        this.updateOfflineOperation(user.getUserId(), roomId, StringUtil.getIntegerByList(userIdList, ","));
    }

    @Override
    public void updateMember(User user, ObjectId roomId, Room.Member member) {
        Room room = this.getRoom(roomId, user.getUserId());
        if (null != room && room.getS() == -1) {
            throw new ServiceException(100401);
        }
        Room.Member oldMember = this.getMember(roomId, member.getUserId());
        User toUser = RoomManagerImplForIM.getUserManager().getUser(member.getUserId());
        if (null != oldMember) {
            KXMPPServiceImpl.MessageBean messageBean;
            Document document = new Document();
            if (!member.getUserId().equals(user.getUserId()) && 0 != member.getRole()) {
                document.append("role", (Object)member.getRole());
            }
            if (null != member.getSub()) {
                document.append("sub", (Object)member.getSub());
            }
            if (null != member.getTalkTime()) {
                document.append("talkTime", (Object)member.getTalkTime());
            }
            if (!StringUtil.isEmpty(member.getNickname())) {
                document.append("nickname", (Object)member.getNickname());
            }
            if (!StringUtil.isEmpty(member.getRemarkName())) {
                document.append("remarkName", (Object)member.getRemarkName());
            }
            document.append("modifyTime", (Object)DateUtil.currentTimeSeconds());
            document.append("call", (Object)room.getCall());
            document.append("videoMeetingNo", (Object)room.getVideoMeetingNo());
            this.updateRoomMemberToDB(roomId, member.getUserId(), document);
            if (!StringUtil.isEmpty(member.getNickname()) && !oldMember.getNickname().equals(member.getNickname())) {
                messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(901);
                messageBean.setObjectId(room.getJid());
                messageBean.setFromUserId(user.getUserId() + "");
                messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
                messageBean.setToUserId(toUser.getUserId() + "");
                messageBean.setToUserName(oldMember.getNickname());
                messageBean.setContent(member.getNickname());
                messageBean.setMessageId(StringUtil.randomUUID());
                this.sendGroupMsg(room.getJid(), messageBean);
            }
            if (null != member.getTalkTime()) {
                messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(906);
                messageBean.setObjectId(room.getJid());
                messageBean.setFromUserId(user.getUserId() + "");
                messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
                messageBean.setToUserId(toUser.getUserId() + "");
                messageBean.setToUserName(oldMember.getNickname());
                messageBean.setContent(member.getTalkTime() + "");
                messageBean.setMessageId(StringUtil.randomUUID());
                this.sendChatToOneGroupMsg(toUser.getUserId(), room.getJid(), messageBean);
            }
        } else {
            Room.Member invitationMember = this.getMember(roomId, user.getUserId());
            if (null != invitationMember && 4 == invitationMember.getRole()) {
                throw new ServiceException("\u9690\u8eab\u4eba\u4e0d\u53ef\u4ee5\u9080\u8bf7\u7528\u6237\u52a0\u7fa4");
            }
            if (room.getMaxUserSize() < room.getUserSize() + 1) {
                throw new ServiceException("\u7fa4\u4eba\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u4e0d\u80fd\u7ee7\u7eed\u52a0\u5165");
            }
            User _user = RoomManagerImplForIM.getUserManager().getUser(member.getUserId());
            Room.Member _member = new Room.Member();
            _member.setActive(DateUtil.currentTimeSeconds());
            _member.setCreateTime(_member.getActive());
            _member.setModifyTime(0L);
            _member.setNickname(_user.getNickname());
            _member.setRole(member.getRole());
            _member.setRoomId(roomId);
            _member.setSub(1);
            _member.setTalkTime(0L);
            _member.setUserId(_user.getUserId());
            _member.setRole(3);
            DBObject dbObj = this.objectToDBObject(_member);
            this.getDBObjectCollection(roomId).insertOne((Object)dbObj);
            this.updateUserSize(roomId, 1);
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(907);
            messageBean.setObjectId(room.getJid());
            messageBean.setFromUserId(user.getUserId() + "");
            messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
            messageBean.setToUserId(toUser.getUserId() + "");
            messageBean.setToUserName(toUser.getNickname());
            messageBean.setFileSize(room.getShowRead());
            messageBean.setContent(room.getName());
            messageBean.setFileName(room.getId().toString());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("showRead", (Object)room.getShowRead());
            jsonObject.put("lsLook", (Object)room.getIsLook());
            jsonObject.put("isNeedVerify", (Object)room.getIsNeedVerify());
            jsonObject.put("showMember", (Object)room.getShowMember());
            jsonObject.put("allowSendCard", (Object)room.getAllowSendCard());
            jsonObject.put("maxUserSize", (Object)room.getMaxUserSize());
            messageBean.setOther(jsonObject.toJSONString());
            messageBean.setMessageId(StringUtil.randomUUID());
            this.sendChatToOneGroupMsg(toUser.getUserId(), room.getJid(), messageBean);
            this.saveJidsByUserId(toUser.getUserId(), room.getJid(), roomId);
            SKBeanUtils.getRedisService().deleteUserRoomJidList(member.getUserId());
            if (0 == SKBeanUtils.getUserManager().getOnlinestateByUserId(member.getUserId())) {
                SKBeanUtils.getRedisService().addRoomPushMember(room.getJid(), member.getUserId());
            }
        }
        this.updateRoomInfoByRedis(roomId.toString());
        this.updateOfflineOperation(user.getUserId(), roomId, null);
    }

    @Override
    public Room.Member getMember(ObjectId roomId, int userId) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document("roomId", (Object)roomId).append("userId", (Object)userId);
        Document document = (Document)collection.find((Bson)query).first();
        Room.Member member = null;
        if (null == document) {
            return null;
        }
        member = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
        return member;
    }

    public void updateRoomMemberToDB(ObjectId roomId, int userId, Document values) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document("roomId", (Object)roomId).append("userId", (Object)userId);
        collection.updateOne((Bson)query, (Bson)new Document("$set", (Object)values));
    }

    public int findMemberAndRole(ObjectId roomId, int userId) {
        MongoCollection collection = this.getCollection(roomId);
        Document projection = new Document("role", (Object)1);
        Document query = new Document("roomId", (Object)roomId);
        query.append("userId", (Object)userId);
        Document first = (Document)collection.find((Bson)query).projection((Bson)projection).first();
        int role = -1;
        if (null != first) {
            role = first.getInteger((Object)"role");
        }
        return role;
    }

    @Override
    public void Memberset(Integer offlineNoPushMsg, ObjectId roomId, int userId, int type) {
        String jid = this.queryRoomJid(roomId);
        long currentTime = DateUtil.currentTimeSeconds();
        Document values = new Document("modifyTime", (Object)currentTime);
        if (0 == type) {
            if (1 == offlineNoPushMsg) {
                SKBeanUtils.getRedisService().addToRoomNOPushJids(userId, jid);
            } else {
                SKBeanUtils.getRedisService().removeToRoomNOPushJids(userId, jid);
            }
            values.append("offlineNoPushMsg", (Object)offlineNoPushMsg);
        } else if (1 == type) {
            values.append("openTopChatTime", (Object)(offlineNoPushMsg == 0 ? 0L : currentTime));
        }
        this.getCollection(roomId).updateOne((Bson)new Document("roomId", (Object)roomId).append("userId", (Object)userId), (Bson)new Document("$set", (Object)values));
        this.updateRoomInfoByRedis(roomId.toString());
        if (RoomManagerImplForIM.getUserManager().isOpenMultipleDevices(userId)) {
            String nickName = RoomManagerImplForIM.getUserManager().getNickName(userId);
            this.multipointLoginUpdateUserInfo(userId, nickName, userId, nickName, roomId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Room.Member> getMemberList(ObjectId roomId, String keyword) {
        Object list = null;
        if (!StringUtil.isEmpty(keyword)) {
            List<Document> containsIgnoreCase = this.containsIgnoreCase(keyword, "nickname", roomId);
            ArrayList<Room.Member> members = new ArrayList<Room.Member>();
            containsIgnoreCase.forEach(document -> {
                try {
                    Room.Member member = DocumentToJavaBean.setFieldValue(new Room.Member(), document);
                    if (null != member) {
                        members.add(member);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            return members;
        }
        List<Room.Member> memberList = RoomManagerImplForIM.getRedisServiceImpl().getMemberList(roomId.toString());
        if (null != memberList && memberList.size() > 0) {
            return memberList;
        }
        ArrayList<Room.Member> memberDBList = new ArrayList<Room.Member>();
        Document query = new Document().append("roomId", (Object)roomId);
        try (MongoCursor iterator = this.getCollection(roomId).find((Bson)query).sort((Bson)new Document("createTime", (Object)-1)).iterator();){
            Room.Member member = null;
            while (iterator.hasNext()) {
                Document document2 = (Document)iterator.next();
                member = DocumentToJavaBean.setFieldValue(new Room.Member(), document2);
                if (null == member) continue;
                memberDBList.add(member);
            }
        }
        RoomManagerImplForIM.getRedisServiceImpl().saveMemberList(roomId.toString(), memberDBList);
        return memberDBList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Room.Member> getAdministrationMemberList(ObjectId roomId) {
        ArrayList<Room.Member> members = new ArrayList<Room.Member>();
        try {
            MongoCollection collection = this.getCollection(roomId);
            Document query = new Document("roomId", (Object)roomId);
            query.append("role", (Object)new Document("$lt", (Object)3));
            MongoCursor iterator = collection.find((Bson)query).iterator();
            Document doc = null;
            Room.Member member = null;
            try {
                while (iterator.hasNext()) {
                    doc = (Document)iterator.next();
                    member = DocumentToJavaBean.setFieldValue(new Room.Member(), doc);
                    if (null == member) continue;
                    members.add(member);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                iterator.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getCommonMemberIdList(ObjectId roomId) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        Document query = new Document("roomId", (Object)roomId);
        query.append("role", (Object)3);
        try (MongoCursor iterator = this.getCollection(roomId).distinct("userId", (Bson)query, Integer.class).iterator();){
            while (iterator.hasNext()) {
                Integer next = (Integer)iterator.next();
                userIds.add(next);
            }
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getMemberIdList(ObjectId roomId) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        Document query = new Document("roomId", (Object)roomId);
        try (MongoCursor iterator = this.getCollection(roomId).distinct("userId", (Bson)query, Integer.class).iterator();){
            while (iterator.hasNext()) {
                Integer next = (Integer)iterator.next();
                userIds.add(next);
            }
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectId> getRoomIdList(Integer userId) {
        ArrayList<ObjectId> roomIds = new ArrayList<ObjectId>();
        try (MongoCursor iterator = this.getCollection(userId).distinct("roomId", (Bson)new Document("userId", (Object)userId), ObjectId.class).iterator();){
            while (iterator.hasNext()) {
                ObjectId next = (ObjectId)iterator.next();
                roomIds.add(next);
            }
        }
        return roomIds;
    }

    public boolean getMemberIsNoPushMsg(ObjectId roomId, int userId) {
        Document query = new Document().append("roomId", (Object)roomId).append("userId", (Object)userId).append("offlineNoPushMsg", (Object)1);
        Document document = (Document)this.getCollection(roomId).find((Bson)query).first();
        return null != document;
    }

    public String getMemberNickname(ObjectId roomId, Integer userId) {
        String nickname = null;
        if (10005 == userId) {
            return String.valueOf(10005);
        }
        if (0 != userId) {
            Room.Member member = this.getMember(roomId, userId);
            if (null == member) {
                return "";
            }
            nickname = member.getNickname();
        }
        return nickname;
    }

    public List<Room.Notice> getNoticeList(ObjectId roomId) {
        List noticesDB;
        Room roomCache = RoomManagerImplForIM.getRedisServiceImpl().queryRoom(roomId);
        List notices = null != roomCache ? roomCache.getNotices() : (noticesDB = ((Query)this.getRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId)).asList());
        return notices;
    }

    public PageVO getNoticeList(ObjectId roomId, Integer pageIndex, Integer pageSize) {
        Query query = ((Query)this.getRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId)).order("-time");
        long total = query.count();
        List pageData = query.offset(pageIndex * pageSize).limit(pageSize.intValue()).asList();
        return new PageVO(pageData, total, pageIndex, pageSize);
    }

    public Room.Notice updateNotice(ObjectId roomId, ObjectId noticeId, String noticeContent, Integer userId) {
        Query query = (Query)((Query)this.getRoomDatastore().createQuery(Room.Notice.class).field("roomId").equal((Object)roomId)).field("_id").equal((Object)noticeId);
        UpdateOperations ops = SKBeanUtils.getDatastore().createUpdateOperations(Room.Notice.class);
        ops.set("text", (Object)noticeContent);
        ops.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.getDatastore().update(query, ops);
        Room.Notice notice = (Room.Notice)query.get();
        Room room = this.getRoom(roomId, userId);
        if (room.getNotice().getId().equals((Object)noticeId)) {
            RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(String.valueOf(roomId));
            this.updateAttribute((Serializable)roomId, "notice", notice);
        }
        RoomManagerImplForIM.getRedisServiceImpl().deleteNoticeList(roomId);
        ThreadUtil.executeInThread(obj -> {
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setFromUserId(userId + "");
            messageBean.setFromUserName(this.getMemberNickname(room.getId(), userId));
            messageBean.setType(934);
            messageBean.setObjectId(room.getJid());
            messageBean.setContent(noticeContent);
            messageBean.setMessageId(StringUtil.randomUUID());
            this.sendGroupMsg(room.getJid(), messageBean);
        });
        return notice;
    }

    public void deleteNotice(ObjectId roomId, ObjectId noticeId) {
        Query query = this.getRoomDatastore().createQuery(Room.Notice.class);
        query.filter("_id", (Object)noticeId);
        query.filter("roomId", (Object)roomId);
        this.getRoomDatastore().delete(query);
        Room room = this.getRoom(roomId, ReqUtil.getUserId());
        if (null != room.getNotice() && noticeId.equals((Object)room.getNotice().getId())) {
            this.updateAttribute((Serializable)roomId, "notice", new Room.Notice());
        }
        RoomManagerImplForIM.getRedisServiceImpl().deleteNoticeList(roomId);
        RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(roomId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<Document> getMemberListByPage(ObjectId roomId, int pageIndex, int pageSize) {
        ArrayList<Document> members = new ArrayList<Document>();
        Document query = new Document("roomId", (Object)roomId);
        MongoCollection collection = this.getCollection(roomId);
        long count = collection.count((Bson)query);
        try (MongoCursor iterator = collection.find((Bson)query).sort((Bson)new Document("createTime", (Object)-1)).skip((pageIndex - 1) * pageSize).limit(pageSize).iterator();){
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                members.add(document);
            }
        }
        return new PageResult<Document>(members, count);
    }

    @Override
    public void join(int userId, ObjectId roomId, int type) {
        Room room = this.getRoom(roomId);
        if (room != null) {
            if (room.getUserSize() + 1 > room.getMaxUserSize()) {
                throw new ServiceException(100423);
            }
        } else {
            throw new ServiceException(100411);
        }
        Room.Member member = new Room.Member();
        member.setUserId(userId);
        member.setRole(1 == type ? 1 : 3);
        this.updateMember(RoomManagerImplForIM.getUserManager().getUser(userId), roomId, member);
    }

    public void sweepCode(ObjectId roomId, User user, Room.Member member) {
        Room room = this.getRoom(roomId, user.getUserId());
        if (null != room && room.getS() == -1) {
            throw new ServiceException(100401);
        }
        User toUser = RoomManagerImplForIM.getUserManager().getUser(member.getUserId());
        if (room.getMaxUserSize() < room.getUserSize() + 1) {
            throw new ServiceException(100423);
        }
        User memberUser = RoomManagerImplForIM.getUserManager().getUser(member.getUserId());
        Room.Member _member = new Room.Member(roomId, memberUser.getUserId(), memberUser.getNickname());
        this.getRoomDatastore().save((Object)_member);
        this.updateUserSize(roomId, 1);
        this.sendNewMemberMessage(user.getUserId(), room, _member);
        this.saveJidsByUserId(toUser.getUserId(), room.getJid(), roomId);
        SKBeanUtils.getRedisService().deleteUserRoomJidList(member.getUserId());
        if (0 == SKBeanUtils.getUserManager().getOnlinestateByUserId(member.getUserId())) {
            SKBeanUtils.getRedisService().addRoomPushMember(room.getJid(), member.getUserId());
        }
        this.updateRoomInfoByRedis(roomId.toString());
        this.updateOfflineOperation(user.getUserId(), roomId, null);
    }

    public void joinRoom(Integer userId, String name, ObjectId roomId, long currentTime, Integer adminUserId) {
        Room room = this.getRoom(roomId);
        if (room == null) {
            throw new ServiceException("\u623f\u95f4\u4e0d\u5b58\u5728");
        }
        List<Room.Member> memberList = Collections.synchronizedList(new ArrayList());
        List<KXMPPServiceImpl.MessageBean> messageList = Collections.synchronizedList(new ArrayList());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("showRead", (Object)room.getShowRead());
        jsonObject.put("lsLook", (Object)room.getIsLook());
        jsonObject.put("isNeedVerify", (Object)room.getIsNeedVerify());
        jsonObject.put("showMember", (Object)room.getShowMember());
        jsonObject.put("allowSendCard", (Object)room.getAllowSendCard());
        jsonObject.put("maxUserSize", (Object)room.getMaxUserSize());
        Room.Member member = new Room.Member(roomId, userId, name);
        memberList.add(member);
        DBObject dbObject = this.objectToDBObject(member);
        this.getDBObjectCollection(roomId).insertOne((Object)dbObject);
        this.saveJidsByUserId(userId, this.queryRoomJid(roomId), roomId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(907);
        messageBean.setObjectId(room.getJid());
        messageBean.setFromUserId(userId + "");
        messageBean.setFromUserName(member.getNickname());
        messageBean.setToUserId(userId + "");
        messageBean.setToUserName(member.getNickname());
        messageBean.setFileSize(room.getShowRead());
        messageBean.setContent(room.getName());
        messageBean.setFileName(room.getId().toString());
        messageBean.setOther(jsonObject.toJSONString());
        messageBean.setMessageId(StringUtil.randomUUID());
        messageList.add(messageBean);
        this.updateUserSize(room.getId(), 1);
        this.updateRoomInfoByRedis(roomId.toString());
        KXMPPServiceImpl.getInstance().sendManyMsgToGroupByJid(room.getJid(), messageList);
    }

    public void updateUserSize(ObjectId roomId, int userSize) {
        BasicDBObject q = new BasicDBObject("_id", (Object)roomId);
        BasicDBObject o = new BasicDBObject("$inc", (Object)new BasicDBObject("userSize", (Object)userSize));
        this.getRoomDatastore().getCollection(this.getEntityClass()).update((DBObject)q, (DBObject)o);
    }

    public void leave(int userId, ObjectId roomId) {
    }

    @Override
    public Room exisname(Object roomname, ObjectId roomId) {
        Query query = this.getRoomDatastore().createQuery(this.getEntityClass());
        query.field("name").equal(roomname);
        if (null != roomId) {
            query.field("_id").notEqual((Object)roomId);
        }
        Room room = (Room)query.get();
        return room;
    }

    public void destroyRoomMsgFileAndShare(ObjectId roomId, String roomJid) {
        Query shareQuery = (Query)this.getRoomDatastore().createQuery(Room.Share.class).field("roomId").equal((Object)roomId);
        List shareList = this.getRoomDatastore().getCollection(Room.Share.class).distinct("url", shareQuery.getQueryObject());
        for (String url : shareList) {
            try {
                ConstantUtil.deleteFile(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getRoomDatastore().delete(shareQuery);
        BasicDBObject msgFileQuery = new BasicDBObject("contentType", (Object)new BasicDBObject("$in", MsgType.FileTypeArr));
        List fileList = this.getRoomDatastore().getDB().getCollection("mucmsg_" + roomJid).distinct("content", (DBObject)msgFileQuery);
        for (String url : fileList) {
            try {
                ConstantUtil.deleteFile(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getRoomDatastore().getDB().getCollection("mucmsg_" + roomJid).drop();
    }

    @Deprecated
    public void destroyRoomToIM(String roomJid) {
    }

    public void destroyRoomToIM(String username, String password, String roomJid) {
        KXMPPServiceImpl.getInstance().destroyMucRoom(username, password, roomJid);
    }

    public void deleMucHistory(String roomJid) {
        DBCollection collection = this.getDatastore().getDB().getCollection("muc_history");
        Pattern regex = Pattern.compile("^" + (roomJid != null ? roomJid : "") + "[^/]*");
        BasicDBObject query = new BasicDBObject("room_jid", (Object)regex);
        collection.remove((DBObject)query);
    }

    @Override
    public void setAdmin(ObjectId roomId, int touserId, int type, int userId) {
        this.getCollection(roomId).updateOne((Bson)new Document("roomId", (Object)roomId).append("userId", (Object)touserId), (Bson)new Document("$set", (Object)new Document("role", (Object)type)));
        this.updateRoomInfoByRedis(roomId.toString());
        String jid = this.queryRoomJid(roomId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(913);
        if (type == 2) {
            messageBean.setContent(1);
        } else {
            messageBean.setContent(0);
        }
        messageBean.setFromUserId(String.valueOf(userId));
        messageBean.setFromUserName(this.getMemberNickname(roomId, userId));
        messageBean.setToUserName(this.getMemberNickname(roomId, touserId));
        messageBean.setToUserId(String.valueOf(touserId));
        messageBean.setObjectId(jid);
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendChatToOneGroupMsg(touserId, jid, messageBean);
    }

    public void setInvisibleGuardian(ObjectId roomId, int touserId, int type, int userId) {
        MongoCollection collection = this.getCollection(roomId);
        if (type == -1 || type == 0) {
            collection.updateOne((Bson)new Document("roomId", (Object)roomId).append("userId", (Object)touserId), (Bson)new Document("$set", (Object)new Document("role", (Object)3)));
        } else if (type == 4 || type == 5) {
            collection.updateOne((Bson)new Document("roomId", (Object)roomId).append("userId", (Object)touserId), (Bson)new Document("$set", (Object)new Document("role", (Object)type)));
        }
        this.updateRoomInfoByRedis(roomId.toString());
        Room room = this.getRoom(roomId);
        User user = RoomManagerImplForIM.getUserManager().getUser(userId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(930);
        if (type == 4) {
            messageBean.setContent(1);
        } else if (type == 5) {
            messageBean.setContent(2);
        } else if (type == -1) {
            messageBean.setContent(-1);
        } else if (type == 0) {
            messageBean.setContent(0);
        }
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
        messageBean.setToUserName(this.getMemberNickname(roomId, touserId));
        messageBean.setToUserId(String.valueOf(touserId));
        messageBean.setObjectId(room.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupOne(touserId, messageBean);
    }

    public void updateRoomMemberNickName(int userId, String nickName) {
        MongoDatabase database = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(this.getCollectionName());
        MongoIterable listCollectionNames = database.listCollectionNames();
        Document query = new Document();
        query.append("userId", (Object)userId);
        Document update = new Document("$set", (Object)new Document("nickname", (Object)nickName));
        MongoCollection collection = null;
        for (String string : listCollectionNames) {
            collection = database.getCollection(string);
            collection.updateMany((Bson)query, (Bson)update);
        }
    }

    @Override
    public Room.Share Addshare(ObjectId roomId, long size, int type, int userId, String url, String name) {
        User user = RoomManagerImplForIM.getUserManager().getUser(userId);
        Room.Share share = new Room.Share();
        share.setRoomId(roomId);
        share.setTime(DateUtil.currentTimeSeconds());
        share.setNickname(user.getNickname());
        share.setUserId(userId);
        share.setSize(size);
        share.setUrl(url);
        share.setType(type);
        share.setName(name);
        this.getRoomDatastore().save((Object)share);
        RoomManagerImplForIM.getRedisServiceImpl().deleteShareList(roomId);
        Room room = this.getRoom(roomId, userId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(401);
        messageBean.setContent(share.getShareId().toString());
        messageBean.setFileName(share.getName());
        messageBean.setObjectId(room.getJid());
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
        return share;
    }

    @Override
    public List<Room.Share> findShare(ObjectId roomId, long time, int userId, int pageIndex, int pageSize) {
        Query q = (Query)this.getRoomDatastore().createQuery(Room.Share.class).field("roomId").equal((Object)roomId);
        if (userId != 0) {
            q.filter("userId", (Object)userId);
        }
        ArrayList<Room.Share> list = new ArrayList();
        list = q.offset(pageSize * pageIndex).limit(pageSize).asList();
        return list;
    }

    @Override
    public void deleteShare(ObjectId roomId, ObjectId shareId, int userId) {
        Query q = (Query)((Query)this.getRoomDatastore().createQuery(Room.Share.class).field("roomId").equal((Object)roomId)).field("shareId").equal((Object)shareId);
        User user = RoomManagerImplForIM.getUserManager().getUser(userId);
        Room room = this.getRoom(roomId, userId);
        Room.Share share = (Room.Share)q.get();
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(402);
        messageBean.setContent(share.getShareId().toString());
        messageBean.setFileName(share.getName());
        messageBean.setObjectId(room.getJid());
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(this.getMemberNickname(roomId, user.getUserId()));
        messageBean.setMessageId(StringUtil.randomUUID());
        this.sendGroupMsg(room.getJid(), messageBean);
        this.getRoomDatastore().delete(q);
        RoomManagerImplForIM.getRedisServiceImpl().deleteShareList(roomId);
    }

    @Override
    public Room.Share getShare(ObjectId roomId, ObjectId shareId) {
        Room.Share share = (Room.Share)((Query)((Query)this.getRoomDatastore().createQuery(Room.Share.class).field("roomId").equal((Object)roomId)).field("shareId").equal((Object)shareId)).get();
        return share;
    }

    @Override
    public String getCall(ObjectId roomId) {
        Room room = (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId)).get();
        return room.getCall();
    }

    @Override
    public String getVideoMeetingNo(ObjectId roomId) {
        Room room = (Room)((Query)this.getRoomDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)roomId)).get();
        return room.getVideoMeetingNo();
    }

    public void sendMsgToRooms(String[] jidArr, int userId, int msgType, String content) {
        User user = SKBeanUtils.getUserManager().getUser(userId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setFromUserId(userId + "");
        messageBean.setFromUserName(user.getNickname());
        messageBean.setType(msgType);
        messageBean.setTimeSend(System.currentTimeMillis());
        messageBean.setContent(content);
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getXmppService().sendMsgToMucRoom(messageBean, jidArr);
    }

    @Override
    public Long countRoomNum() {
        long roomNum = this.getRoomDatastore().createQuery(this.getEntityClass()).count();
        return roomNum;
    }

    public List<Object> addRoomsCount(String startDate, String endDate, short counType) {
        ArrayList<Object> countData = new ArrayList<Object>();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = counType == 4 ? DateUtil.getTodayMorning().getTime() / 1000L : (counType == 3 ? DateUtil.getLastMonth().getTime() / 1000L : DateUtil.getLastYear().getTime() / 1000L);
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime() / 1000L;
        endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gt", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        BasicDBObject query = new BasicDBObject("createTime", (Object)queryTime);
        DBCollection collection = SKBeanUtils.getImRoomDatastore().getCollection(this.getEntityClass());
        String mapStr = "function Map() { var date = new Date(this.createTime*1000);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (counType == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (counType == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (counType == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (counType == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,1);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        MapReduceCommand.OutputType type = MapReduceCommand.OutputType.INLINE;
        MapReduceCommand command = new MapReduceCommand(collection, mapStr, reduce, null, type, (DBObject)query);
        MapReduceOutput mapReduceOutput = collection.mapReduce(command);
        Iterable results = mapReduceOutput.results();
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (DBObject obj : results) {
            map.put((String)obj.get("_id"), (Double)obj.get("value"));
            countData.add(JSON.toJSON(map));
            map.clear();
        }
        return countData;
    }

    public Workbook exprotExcelGroupMembers(String roomId, HttpServletRequest request, HttpServletResponse response) {
        String name = this.getRoomName(new ObjectId(roomId)) + " \u7684\u7fa4\u6210\u5458\u660e\u7ec6";
        String fileName = "groupMembers.xlsx";
        List<Room.Member> members = this.getMemberList(new ObjectId(roomId), null);
        ArrayList titles = Lists.newArrayList();
        titles.add("userId");
        titles.add("userName");
        titles.add("remarkName");
        titles.add("telephone");
        titles.add("role");
        titles.add("offlineNoPushMsg");
        titles.add("createTime");
        titles.add("modifyTime");
        ArrayList values = Lists.newArrayList();
        members.forEach(member -> {
            HashMap map = Maps.newHashMap();
            map.put("userId", member.getUserId());
            map.put("userName", member.getNickname());
            map.put("remarkName", member.getRemarkName());
            map.put("telephone", RoomManagerImplForIM.getUserManager().getUser(member.getUserId()).getPhone());
            map.put("role", member.getRole() == 1 ? "\u7fa4\u4e3b" : (member.getRole() == 2 ? "\u7ba1\u7406\u5458" : (member.getRole() == 3 ? "\u666e\u901a\u6210\u5458" : (member.getRole() == 4 ? "\u9690\u8eab\u4eba" : "\u76d1\u62a4\u4eba"))));
            map.put("offlineNoPushMsg", member.getOfflineNoPushMsg() == 0 ? "\u5426" : "\u662f");
            map.put("createTime", DateUtil.strToDateTime(member.getCreateTime()));
            map.put("modifyTime", DateUtil.strToDateTime(member.getModifyTime()));
            values.add(map);
        });
        Workbook workBook = ExcelUtil.generateWorkbook(name, "xlsx", titles, values);
        response.reset();
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return workBook;
    }

    public void saveJidsByUserId(Integer userId, String jid, ObjectId roomId) {
        Document document = new Document();
        document.append("userId", (Object)userId).append("jid", (Object)jid).append("roomId", (Object)roomId);
        document.append("offlineNoPushMsg", (Object)0);
        this.getCollection(userId).insertOne((Object)document);
    }

    public void updateUserJidNoPushMsg(Integer userId, ObjectId roomId, int offlineNoPushMsg) {
        Document query = new Document();
        query.append("userId", (Object)userId).append("roomId", (Object)roomId);
        Document values = new Document("$set", (Object)new Document("offlineNoPushMsg", (Object)offlineNoPushMsg));
        this.getCollection(userId).updateOne((Bson)query, (Bson)values);
    }

    public void delJidsByUserId(Integer userId, String jid) {
        Document document = new Document();
        document.append("userId", (Object)userId).append("jid", (Object)jid);
        this.getCollection(userId).deleteOne((Bson)document);
    }

    public void consoleJoinRoom(User user, ObjectId roomId, List<Integer> userIdList) {
        int i = 0;
        for (Integer userId : userIdList) {
            long currentTime = DateUtil.currentTimeSeconds();
            currentTime += (long)(++i);
            Room.Member data = SKBeanUtils.getRoomManagerImplForIM().getMember(roomId, userId);
            if (null != data) {
                throw new ServiceException(userId + " \u8be5\u6210\u5458\u5df2\u7ecf\u5728\u7fa4\u7ec4\u4e2d,\u4e0d\u80fd\u91cd\u590d\u9080\u8bf7");
            }
            Room.Member member = new Room.Member();
            member.setActive(currentTime);
            member.setCreateTime(currentTime);
            member.setModifyTime(0L);
            member.setNickname(RoomManagerImplForIM.getUserManager().getNickName(userId));
            member.setRole(3);
            member.setRoomId(roomId);
            member.setSub(1);
            member.setTalkTime(0L);
            member.setUserId(userId);
            this.getDatastore().save((Object)member);
            this.updateUserSize(roomId, 1);
            Room room = this.getRoom(roomId);
            this.sendNewMemberMessage(user.getUserId(), room, member);
            RoomManagerImplForIM.getRedisServiceImpl().deleteMemberList(roomId.toString());
            this.saveJidsByUserId(userId, room.getJid(), roomId);
            SKBeanUtils.getRedisService().deleteUserRoomJidList(member.getUserId());
            if (0 == SKBeanUtils.getUserManager().getOnlinestateByUserId(member.getUserId())) {
                SKBeanUtils.getRedisService().addRoomPushMember(room.getJid(), member.getUserId());
            }
            RoomManagerImplForIM.getRedisServiceImpl().deleteRoom(String.valueOf(roomId));
        }
    }

    public Room queryLocationRoom(String name, double longitude, double latitude, String password, int isQuery) {
        Integer userId = ReqUtil.getUserId();
        Room room = SKBeanUtils.getRedisService().queryLocationRoom(userId, longitude, latitude, password, name);
        if (1 == isQuery) {
            return room;
        }
        ThreadUtil.executeInThread(obj -> {
            for (Room.Member mem : room.getMembers()) {
                if (userId.equals(mem.getUserId())) continue;
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setObjectId(room.getJid());
                messageBean.setFromUserId(userId.toString());
                messageBean.setFromUserName(userId.toString());
                messageBean.setType(933);
                messageBean.setToUserId(mem.getUserId().toString());
                SKBeanUtils.getXmppService().send(messageBean);
            }
        });
        return room;
    }

    public synchronized Room joinLocationRoom(String roomJid) {
        ObjectId roomId = this.getRoomId(roomJid);
        Integer userId = ReqUtil.getUserId();
        User user = null;
        if (null == roomId) {
            Room room = SKBeanUtils.getRedisService().queryLocationRoom(roomJid);
            if (null == room) {
                throw new ServiceException(100415);
            }
            user = SKBeanUtils.getUserManager().getUser(userId);
            roomId = new ObjectId();
            room.setId(roomId);
            this.add(user, room, null, null);
            SKBeanUtils.getRedisService().saveLocationRoom(roomJid, room);
        } else {
            user = SKBeanUtils.getUserManager().getUser(userId);
            Room.Member member = new Room.Member();
            member.setUserId(userId);
            this.updateMember(user, roomId, member);
        }
        return (Room)this.get((Serializable)roomId);
    }

    public void exitLocationRoom(final String roomJid) {
        final Integer userId = ReqUtil.getUserId();
        SKBeanUtils.getRedisService().exitLocationRoom(userId, roomJid);
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                Room room = SKBeanUtils.getRedisService().queryLocationRoom(roomJid);
                for (Room.Member mem : room.getMembers()) {
                    if (userId.equals(mem.getUserId())) continue;
                    KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                    messageBean.setObjectId(room.getJid());
                    messageBean.setFromUserId(userId.toString());
                    messageBean.setFromUserName(userId.toString());
                    messageBean.setType(933);
                    messageBean.setToUserId(mem.getUserId().toString());
                    SKBeanUtils.getXmppService().send(messageBean);
                }
            }
        });
    }

    public JSONMessage addGroupHelper(String helperId, String roomId, String roomJid, Integer userId) {
        Query query = (Query)((Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("roomId").equal((Object)roomId)).field("helperId").equal((Object)helperId);
        if (null != query.get()) {
            return JSONMessage.failureByErrCode((Integer)100416, ReqUtil.getRequestLanguage());
        }
        Query helQuery = (Query)SKBeanUtils.getDatastore().createQuery(Helper.class).field("_id").equal((Object)new ObjectId(helperId));
        if (null == helQuery.get()) {
            return JSONMessage.failureByErrCode((Integer)100417, ReqUtil.getRequestLanguage());
        }
        GroupHelper entity = new GroupHelper();
        entity.setHelperId(helperId);
        entity.setRoomId(roomId);
        entity.setRoomJid(roomJid);
        entity.setUserId(userId);
        if (null == entity.getId()) {
            entity.setId(ObjectId.get());
        }
        SKBeanUtils.getDatastore().save((Object)entity);
        entity.setHelper((Helper)helQuery.get());
        return JSONMessage.success(null, (Object)entity);
    }

    public JSONMessage addAutoResponse(String roomId, String helperId, String keyWord, String value) {
        Query query = (Query)((Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("roomId").equal((Object)roomId)).field("helperId").equal((Object)helperId);
        UpdateOperations ops = SKBeanUtils.getDatastore().createUpdateOperations(GroupHelper.class);
        GroupHelper.KeyWord keyword = new GroupHelper.KeyWord();
        keyword.setId(ObjectId.get().toString());
        keyword.setKeyWord(keyWord);
        keyword.setValue(value);
        ArrayList<GroupHelper.KeyWord> list = new ArrayList<GroupHelper.KeyWord>();
        GroupHelper groupHelper = (GroupHelper)query.get();
        if (null == groupHelper) {
            return JSONMessage.failureByErrCode((Integer)100417, ReqUtil.getRequestLanguage());
        }
        if (null != groupHelper.getKeywords()) {
            for (int i = 0; i < groupHelper.getKeywords().size(); ++i) {
                if (!groupHelper.getKeywords().get(i).getKeyWord().equals(keyWord)) continue;
                return JSONMessage.failureByErrCode((Integer)100418, ReqUtil.getRequestLanguage());
            }
            groupHelper.getKeywords().add(keyword);
        } else {
            list.add(keyword);
            groupHelper.setKeywords(list);
        }
        ops.set("keywords", groupHelper.getKeywords());
        SKBeanUtils.getDatastore().update(query, ops);
        return JSONMessage.success(null, (Object)keyword);
    }

    public JSONMessage updateKeyword(String groupHelperId, String keyWordId, String keyword, String value) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("_id").equal((Object)new ObjectId(groupHelperId));
        UpdateOperations ops = SKBeanUtils.getDatastore().createUpdateOperations(GroupHelper.class);
        GroupHelper groupHelper = (GroupHelper)query.get();
        if (null == groupHelper) {
            return JSONMessage.failureByErrCode((Integer)100417, ReqUtil.getRequestLanguage());
        }
        if (null == groupHelper.getKeywords()) {
            return JSONMessage.failureByErrCode((Integer)100419, ReqUtil.getRequestLanguage());
        }
        for (int i = 0; i < groupHelper.getKeywords().size(); ++i) {
            if (!groupHelper.getKeywords().get(i).getId().equals(keyWordId)) continue;
            groupHelper.getKeywords().get(i).setKeyWord(keyword);
            groupHelper.getKeywords().get(i).setValue(value);
        }
        ops.set("keywords", groupHelper.getKeywords());
        SKBeanUtils.getDatastore().update(query, ops);
        return JSONMessage.success();
    }

    public JSONMessage deleteAutoResponse(Integer userId, String groupHelperId, String keyWordId) {
        Query query = (Query)((Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("_id").equal((Object)new ObjectId(groupHelperId))).field("userId").equal((Object)userId);
        UpdateOperations ops = SKBeanUtils.getDatastore().createUpdateOperations(GroupHelper.class);
        GroupHelper groupHelper = (GroupHelper)query.get();
        if (null == groupHelper) {
            return JSONMessage.failureByErrCode((Integer)100417, ReqUtil.getRequestLanguage());
        }
        if (null == groupHelper.getKeywords()) {
            return JSONMessage.failureByErrCode((Integer)100419, ReqUtil.getRequestLanguage());
        }
        for (int i = 0; i < groupHelper.getKeywords().size(); ++i) {
            if (!groupHelper.getKeywords().get(i).getId().equals(keyWordId)) continue;
            groupHelper.getKeywords().remove(i);
        }
        ops.set("keywords", groupHelper.getKeywords());
        SKBeanUtils.getDatastore().update(query, ops);
        return JSONMessage.success();
    }

    public void deleteGroupHelper(Integer userId, String id) {
        Query query = (Query)((Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("_id").equal((Object)new ObjectId(id))).field("userId").equal((Object)userId);
        WriteResult delete = SKBeanUtils.getDatastore().delete(query);
        if (delete.getN() <= 0) {
            throw new ServiceException(100420);
        }
    }

    public List<GroupHelper> queryGroupHelper(String roomId, String helperId) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("roomId").equal((Object)roomId);
        List list = query.asList();
        ArrayList<GroupHelper> newList = new ArrayList<GroupHelper>();
        if (!StringUtil.isEmpty(helperId)) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((GroupHelper)list.get(i)).getHelperId().equals(helperId)) continue;
                Query q = (Query)SKBeanUtils.getDatastore().createQuery(Helper.class).field("_id").equal((Object)new ObjectId(((GroupHelper)list.get(i)).getHelperId()));
                ((GroupHelper)list.get(i)).setHelper((Helper)q.get());
                newList.add((GroupHelper)list.get(i));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Query q = (Query)SKBeanUtils.getDatastore().createQuery(Helper.class).field("_id").equal((Object)new ObjectId(((GroupHelper)list.get(i)).getHelperId()));
                if (null == q.get()) continue;
                ((GroupHelper)list.get(i)).setHelper((Helper)q.get());
                newList.add((GroupHelper)list.get(i));
            }
        }
        return newList;
    }

    public void multipointLoginUpdateUserInfo(Integer userId, String nickName, Integer toUserId, String toNickName, ObjectId roomId) {
        Datastore datastore = SKBeanUtils.getDatastore();
        this.updateRoomInfo(userId, nickName, toUserId, toNickName, roomId);
        Query query = (Query)datastore.createQuery(OfflineOperation.class).field("userId").equal((Object)userId);
        query.field("friendId").equal((Object)String.valueOf(roomId));
        if (null == query.get()) {
            datastore.save((Object)new OfflineOperation(userId, "room", String.valueOf(roomId), DateUtil.currentTimeSeconds()));
        } else {
            UpdateOperations ops = datastore.createUpdateOperations(OfflineOperation.class);
            ops.set("operationTime", (Object)DateUtil.currentTimeSeconds());
            datastore.update(query, ops);
        }
    }

    public void updateRoomInfo(final Integer userId, final String nickName, Integer toUserId, String toNickName, final ObjectId roomId) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(802);
                messageBean.setFromUserId(String.valueOf(userId));
                messageBean.setFromUserName(nickName);
                messageBean.setToUserId(String.valueOf(roomId));
                messageBean.setToUserName(RoomManagerImplForIM.this.getRoomName(roomId));
                messageBean.setMessageId(StringUtil.randomUUID());
                messageBean.setTo(String.valueOf(userId));
                try {
                    KXMPPServiceImpl.getInstance().send(messageBean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void adminDeleteRoomMsg(String roomJid, int type) {
        MongoCollection dbCollection = this.getImRoomDatabase().getCollection("mucmsg_" + roomJid);
        Document query = new Document();
        dbCollection.createIndex((Bson)new Document("timeSend", (Object)-1));
        if (0 == type) {
            long onedayNextDay = DateUtil.getOnedayNextDay(DateUtil.currentTimeSeconds(), 30, 1);
            this.logger.info("\u4e0a\u4e2a\u6708\u7684\u65f6\u95f4\uff1a" + onedayNextDay);
            query.append("timeSend", (Object)new Document("$lte", (Object)(onedayNextDay * 1000L)));
        } else if (1 == type) {
            int num = 100000;
            long count = dbCollection.count();
            if (count <= 100000L) {
                throw new ServiceException("\u8be5\u7fa4\u7684\u6d88\u606f\u603b\u6570\u91cf\u5c0f\u4e8e100000");
            }
            Document first = (Document)dbCollection.find().sort((Bson)new Document("timeSend", (Object)-1)).skip(100000).first();
            if (null == first) {
                return;
            }
            query.append("timeSend", (Object)new Document("$lt", (Object)first.getLong((Object)"timeSend")));
        }
        SKBeanUtils.getTigaseManager().joinFileUriToDelFielsCollection((MongoCollection<Document>)dbCollection, query);
        dbCollection.deleteMany((Bson)query);
    }

    public Room copyRoom(User user, String roomId) {
        ObjectId objRoomId = new ObjectId(roomId);
        Room room = this.getRoom(objRoomId, user.getUserId());
        List<Integer> memberIdList = this.getMemberIdList(objRoomId);
        memberIdList.remove(user.getUserId());
        room.setId(new ObjectId());
        room.setJid(StringUtil.randomUUID());
        Room newRoom = this.add(user, room, memberIdList, null);
        return newRoom;
    }
}

