/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Role;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class RoleManagerImpl
extends MongoRepository<Role, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Role> getEntityClass() {
        return Role.class;
    }

    public int getUserRoleByUserId(Integer userId) {
        Object roleQuery = this.queryOneField("role", (DBObject)new BasicDBObject("userId", (Object)userId));
        return null == roleQuery ? 0 : (Integer)roleQuery;
    }

    public Role getUserRole(Integer userId, String phone, Integer type) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (!StringUtil.isEmpty(phone)) {
            query.filter("phone", (Object)phone);
        }
        if (null != type && 5 == type) {
            Integer n = type;
            Integer n2 = type = Integer.valueOf(type + 1);
            Integer num = n;
            query.or(new Criteria[]{(Criteria)query.criteria("role").equal((Object)type), (Criteria)query.criteria("role").equal((Object)num), (Criteria)query.criteria("role").equal((Object)1), (Criteria)query.criteria("role").equal((Object)4), (Criteria)query.criteria("role").equal((Object)7)});
        }
        return (Role)query.get();
    }

    public List<Role> getUserRoles(Integer userId, String phone, Integer type) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (!StringUtil.isEmpty(phone)) {
            query.filter("phone", (Object)phone);
        }
        if (0 != type) {
            query.filter("role", (Object)type);
        }
        return query.asList();
    }

    public List<Integer> getUserRoles(Integer userId) {
        ArrayList<Integer> roleType = new ArrayList<Integer>();
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        ((Query)query.field("userId").equal((Object)userId)).field("status").notEqual((Object)-1);
        List asList = query.asList();
        asList.forEach(role -> roleType.add(Integer.valueOf(role.getRole())));
        return roleType;
    }

    public PageResult<Role> adminList(String keyWorld, int page, int limit, Integer type, Integer userId) {
        PageResult<Role> result = new PageResult<Role>();
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (0 == type) {
            query.or(new Criteria[]{(Criteria)query.criteria("role").equal((Object)5), (Criteria)query.criteria("role").equal((Object)6)});
            query.field("userId").notEqual((Object)userId);
        } else if (4 == type) {
            query.filter("role", (Object)4);
        } else if (7 == type) {
            query.filter("role", (Object)7);
        } else if (3 == type) {
            query.filter("role", (Object)3);
        } else if (1 == type) {
            query.filter("role", (Object)1);
        } else if (2 == type) {
            query.filter("role", (Object)2);
        }
        if (!StringUtil.isEmpty(keyWorld)) {
            query.criteria("phone").containsIgnoreCase(keyWorld);
        }
        List roles = query.order("-createTime").asList(this.pageFindOption(page, limit, 1));
        roles.forEach(role -> role.setNickName(SKBeanUtils.getUserManager().getNickName(role.getUserId())));
        result.setData(roles);
        result.setCount(query.count());
        return result;
    }

    public void addAdmin(String telePhone, String phone, byte role, Integer type) {
        User accountUser = SKBeanUtils.getUserManager().getUser(telePhone);
        if (null == accountUser) {
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Role userRole = this.getUserRole(0, phone, null);
        if (null != userRole) {
            throw new ServiceException("\u8be5\u8d26\u53f7\u5df2\u7ecf\u662f" + (userRole.getRole() == 5 ? "\u7ba1\u7406\u5458" : (userRole.getRole() == 6 ? "\u7cfb\u7edf\u7ba1\u7406\u5458" : (userRole.getRole() == 1 ? "\u6e38\u5ba2" : (userRole.getRole() == 4 ? "\u5ba2\u670d" : (userRole.getRole() == 2 ? "\u516c\u4f17\u53f7" : (userRole.getRole() == 3 ? "\u673a\u5668\u4eba" : "\u6709\u5176\u4ed6\u8eab\u4efd")))))));
        }
        Role accountRole = null;
        accountRole = type == 4 ? new Role(accountUser.getUserId(), accountUser.getPhone(), role, 1, 0L, this.promotionUrl(accountUser.getUserId())) : new Role(accountUser.getUserId(), accountUser.getPhone(), role, 1, 0L);
        this.getDatastore().save((Object)accountRole);
        this.updateFriend(accountUser.getUserId(), null);
    }

    public void delAdminById(final String adminId, final Integer type, final Integer adminUserId) {
        if (type == 3) {
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    if (!StringUtil.isEmpty(adminId)) {
                        String[] admins = StringUtil.getStringList(adminId, ",");
                        SKBeanUtils.getUserManager().deleteUser(adminUserId, admins);
                        for (String userId : admins) {
                            Query query = (Query)((Query)RoleManagerImpl.this.getDatastore().createQuery(RoleManagerImpl.this.getEntityClass()).field("userId").equal((Object)Integer.valueOf(userId))).field("role").equal((Object)type);
                            RoleManagerImpl.this.getDatastore().delete(query);
                        }
                    }
                }
            });
        } else if (type == 2) {
            Query userQuery = (Query)this.getDatastore().createQuery(User.class).field("userId").equal((Object)Integer.valueOf(adminId));
            UpdateOperations ops = this.getDatastore().createUpdateOperations(User.class);
            ops.set("userType", (Object)0);
            this.getDatastore().update(userQuery, ops);
            Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)Integer.valueOf(adminId))).field("role").equal((Object)type);
            this.getDatastore().delete(query);
            this.updateFriend(Integer.valueOf(adminId), 0);
            KSessionUtil.deleteUserByUserId(Integer.valueOf(adminId));
        } else {
            Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)Integer.valueOf(adminId))).field("role").equal((Object)type);
            this.getDatastore().delete(query);
            this.updateFriend(Integer.valueOf(adminId), 0);
        }
    }

    public Role modifyRole(Role role) {
        Query q = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)role.getUserId())).field("role").equal((Object)role.getRole());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (role.getRole() != 0) {
            ops.set("role", (Object)role.getRole());
        }
        if (role.getStatus() != 0) {
            ops.set("status", (Object)role.getStatus());
        }
        if (0L != role.getLastLoginTime()) {
            ops.set("lastLoginTime", (Object)role.getLastLoginTime());
        }
        if (!StringUtil.isEmpty(role.getPromotionUrl())) {
            ops.set("promotionUrl", (Object)role.getPromotionUrl());
            Query query = (Query)SKBeanUtils.getImRoomDatastore().createQuery(Room.class).field("userId").equal((Object)role.getUserId());
            UpdateOperations roomOps = this.getDatastore().createUpdateOperations(Room.class);
            roomOps.set("promotionUrl", (Object)role.getPromotionUrl());
            this.getDatastore().update(query, roomOps);
        }
        Role findAndModify = (Role)this.getDatastore().findAndModify(q, ops);
        return findAndModify;
    }

    private String promotionUrl(Integer userId) {
        String promotionUrl = SKBeanUtils.getSystemConfig().getPromotionUrl();
        if (StringUtil.isEmpty(promotionUrl)) {
            throw new ServiceException("\u8bf7\u5148\u5728\u540e\u53f0\u7ba1\u7406\u4e2d\u8bbe\u7f6e\u5728\u7ebf\u54a8\u8be2\u94fe\u63a5");
        }
        return new StringBuffer().append(promotionUrl).append(userId).toString();
    }

    public void updateFriend(Integer toUserId, Integer userType) {
        List<Integer> roles = this.getUserRoles(toUserId);
        SKBeanUtils.getFriendsManager().updateToFriendUserType(toUserId, userType, roles);
        ThreadUtil.executeInThread(obj -> {
            List<Integer> queryFansIdByUserId = SKBeanUtils.getFriendsRepository().queryFansId(toUserId);
            this.logger.info("updateFriend === userId " + JSONObject.toJSONString(queryFansIdByUserId));
            queryFansIdByUserId.forEach(userId -> SKBeanUtils.getRedisService().deleteFriends((Integer)userId));
        });
    }

    public void deleteAllRoles(Integer userId) {
        Datastore datastore = this.getDatastore();
        Query query = (Query)datastore.createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
        datastore.delete(query);
    }
}

