/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.constants.KConstants;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Report;
import cn.xyz.repository.mongo.MongoRepository;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ReportManagerImpl
extends MongoRepository<Report, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Report> getEntityClass() {
        return Report.class;
    }

    public JSONMessage deleteReport(String id) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)id);
        if (null != query) {
            this.getDatastore().delete(query);
            return JSONMessage.success();
        }
        return JSONMessage.failure("\u6682\u65e0\u4e3e\u62a5\u4fe1\u606f");
    }

    public Map<Long, List<Report>> getReport(int type, int sender, int receiver, int pageIndex, int pageSize) {
        ConcurrentMap map = Maps.newConcurrentMap();
        try {
            if (type == 0) {
                Query q = this.getDatastore().createQuery(Report.class);
                if (0 != sender) {
                    q.field("userId").equal((Object)sender);
                }
                if (0 != receiver) {
                    q.field("toUserId").equal((Object)receiver);
                }
                q.field("roomId").equal((Object)"");
                q.offset(pageSize * pageIndex);
                for (Report report : q.asList()) {
                    if (!KConstants.ReportReason.reasonMap.containsKey(report.getReason())) continue;
                    report.setInfo(KConstants.ReportReason.reasonMap.get(report.getReason()));
                }
                List data = q.limit(pageSize).asList();
                map.put(q.count(), data);
            } else if (type == 1) {
                Query q = this.getDatastore().createQuery(Report.class);
                if (0 != sender) {
                    q.field("userId").equal((Object)sender);
                }
                if (0 != receiver) {
                    q.field("roomId").equal((Object)receiver);
                }
                q.field("roomId").notEqual((Object)"");
                q.offset(pageSize * pageIndex);
                for (Report report : q.asList()) {
                    if (!KConstants.ReportReason.reasonMap.containsKey(report.getReason())) continue;
                    report.setInfo(KConstants.ReportReason.reasonMap.get(report.getReason()));
                }
                List data = q.limit(pageSize).asList();
                map.put(q.count(), data);
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }
}

