/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.RedPacket;
import cn.xyz.mianshi.vo.RedReceive;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class RedPacketManagerImpl
extends MongoRepository<RedPacket, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<RedPacket> getEntityClass() {
        return RedPacket.class;
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    public RedPacket saveRedPacket(RedPacket entity) {
        entity.setId(new ObjectId());
        this.save(entity);
        return entity;
    }

    public Object sendRedPacket(int userId, RedPacket packet) {
        packet.setUserId(userId);
        packet.setUserName(SKBeanUtils.getUserManager().getNickName(userId));
        packet.setOver(packet.getMoney());
        long cuTime = DateUtil.currentTimeSeconds();
        packet.setSendTime(cuTime);
        packet.setOutTime(cuTime + 86400L);
        RedPacket data = this.saveRedPacket(packet);
        Double balance = SKBeanUtils.getUserManager().rechargeUserMoeny(userId, packet.getMoney(), 2);
        ThreadUtil.executeInThread(obj -> {
            String tradeNo = StringUtil.getOutTradeNo();
            ConsumeRecord record = new ConsumeRecord();
            record.setUserId(userId);
            record.setToUserId(packet.getToUserId());
            record.setTradeNo(tradeNo);
            record.setMoney(packet.getMoney());
            record.setStatus(1);
            record.setType(4);
            record.setPayType(3);
            record.setDesc("\u7ea2\u5305\u53d1\u9001");
            record.setTime(DateUtil.currentTimeSeconds());
            record.setRedPacketId(packet.getId());
            record.setOperationAmount(packet.getMoney());
            record.setCurrentBalance(balance);
            SKBeanUtils.getConsumeRecordManager().save(record);
        });
        return data;
    }

    public JSONMessage getRedPacketById(Integer userId, ObjectId id) {
        RedPacket packet = (RedPacket)this.get((Serializable)id);
        if (null == packet) {
            return JSONMessage.failureByErrCode(10102);
        }
        HashMap map = Maps.newHashMap();
        map.put("packet", packet);
        if (DateUtil.currentTimeSeconds() > packet.getOutTime()) {
            map.put("list", this.getRedReceivesByRedId(packet.getId()));
            return JSONMessage.failureByErrCodeAndData(100101, map);
        }
        if (packet.getCount() > packet.getReceiveCount()) {
            if (null == packet.getUserIds() || !packet.getUserIds().contains(userId)) {
                map.put("list", this.getRedReceivesByRedId(packet.getId()));
                return JSONMessage.success(map);
            }
            map.put("list", this.getRedReceivesByRedId(packet.getId()));
            return JSONMessage.failureByErrCodeAndData(104103, map);
        }
        map.put("list", this.getRedReceivesByRedId(packet.getId()));
        return JSONMessage.failureByErrCodeAndData(100102, map);
    }

    public synchronized JSONMessage openRedPacketById(Integer userId, ObjectId id) {
        RedPacket packet = (RedPacket)this.get((Serializable)id);
        if (null == packet) {
            return JSONMessage.failureByErrCode(10102);
        }
        HashMap map = Maps.newHashMap();
        map.put("packet", packet);
        if (DateUtil.currentTimeSeconds() > packet.getOutTime()) {
            map.put("list", this.getRedReceivesByRedId(packet.getId()));
            return JSONMessage.failureByErrCodeAndData(100101, map);
        }
        if (packet.getCount() > packet.getReceiveCount()) {
            if (null == packet.getUserIds() || !packet.getUserIds().contains(userId)) {
                packet = this.openRedPacket(userId, packet);
                map.put("packet", packet);
                map.put("list", this.getRedReceivesByRedId(packet.getId()));
                return JSONMessage.success(map);
            }
            map.put("list", this.getRedReceivesByRedId(packet.getId()));
            return JSONMessage.failureByErrCodeAndData(104103, map);
        }
        map.put("list", this.getRedReceivesByRedId(packet.getId()));
        return JSONMessage.failureByErrCodeAndData(100102, map);
    }

    private synchronized RedPacket openRedPacket(final Integer userId, final RedPacket packet) {
        int overCount = packet.getCount() - packet.getReceiveCount();
        User user = RedPacketManagerImpl.getUserManager().getUser(userId);
        Double money = 0.0;
        if (1 == packet.getType()) {
            if (1 == packet.getCount() - packet.getReceiveCount()) {
                money = packet.getOver();
            } else {
                money = packet.getMoney() / (double)packet.getCount();
                DecimalFormat df = new DecimalFormat("#.00");
                money = Double.valueOf(df.format(money));
            }
        } else {
            money = this.getRandomMoney(overCount, packet.getOver());
        }
        Double over = packet.getOver() - money;
        DecimalFormat df = new DecimalFormat("#.00");
        packet.setOver(Double.valueOf(df.format(over)));
        packet.getUserIds().add(userId);
        UpdateOperations ops = this.createUpdateOperations();
        ops.set("receiveCount", (Object)(packet.getReceiveCount() + 1));
        ops.set("over", (Object)packet.getOver());
        ops.set("userIds", packet.getUserIds());
        if (0.0 == packet.getOver()) {
            ops.set("status", (Object)2);
            packet.setStatus(2);
        }
        this.updateAttributeByOps((Serializable)packet.getId(), ops);
        RedReceive receive = new RedReceive();
        receive.setMoney(money);
        receive.setUserId(userId);
        receive.setSendId(packet.getUserId());
        receive.setRedId(packet.getId());
        receive.setTime(DateUtil.currentTimeSeconds());
        receive.setUserName(RedPacketManagerImpl.getUserManager().getUser(userId).getNickname());
        receive.setSendName(RedPacketManagerImpl.getUserManager().getUser(packet.getUserId()).getNickname());
        ObjectId id = (ObjectId)this.getDatastore().save((Object)receive).getId();
        receive.setId(id);
        final Double balance = RedPacketManagerImpl.getUserManager().rechargeUserMoeny(userId, money, 1);
        final Double num = money;
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(83);
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(user.getNickname());
        if (packet.getRoomJid() != null) {
            messageBean.setObjectId(packet.getRoomJid());
            if (0.0 == packet.getOver()) {
                messageBean.setFileSize(1);
                messageBean.setFileName(packet.getSendTime() + "");
            }
            messageBean.setRoomJid(packet.getRoomJid());
        }
        messageBean.setMsgType(null == packet.getRoomJid() ? 0 : 1);
        messageBean.setContent(packet.getId().toString());
        messageBean.setToUserId(packet.getUserId() + "");
        messageBean.setToUserName(RedPacketManagerImpl.getUserManager().getNickName(packet.getUserId()));
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                String tradeNo = StringUtil.getOutTradeNo();
                ConsumeRecord record = new ConsumeRecord();
                record.setUserId(userId);
                record.setToUserId(packet.getUserId());
                record.setTradeNo(tradeNo);
                record.setMoney(num);
                record.setStatus(1);
                record.setType(5);
                record.setPayType(3);
                record.setDesc("\u7ea2\u5305\u63a5\u6536");
                record.setOperationAmount(num);
                record.setCurrentBalance(balance);
                record.setRedPacketId(packet.getId());
                record.setTime(DateUtil.currentTimeSeconds());
                SKBeanUtils.getConsumeRecordManager().save(record);
            }
        });
        return packet;
    }

    public void sendOpenMessageAndCreateRecord() {
    }

    private synchronized Double getRandomMoney(int remainSize, Double remainMoney) {
        Double money = 0.0;
        if (remainSize == 1) {
            --remainSize;
            money = (double)Math.round(remainMoney * 100.0) / 100.0;
            System.out.println("=====> " + money);
            return money;
        }
        Random r = new Random();
        double min = 0.01;
        double max = remainMoney / (double)remainSize * 2.0;
        money = r.nextDouble() * max;
        money = money <= min ? 0.01 : money;
        money = Math.floor(money * 100.0) / 100.0;
        System.out.println("=====> " + money);
        --remainSize;
        remainMoney = remainMoney - money;
        DecimalFormat df = new DecimalFormat("#.00");
        return Double.valueOf(df.format(money));
    }

    public void replyRedPacket(String id, String reply) {
        Integer userId = ReqUtil.getUserId();
        Query query = (Query)this.getDatastore().createQuery(RedReceive.class).field("userId").equal((Object)userId);
        query.filter("redId", (Object)new ObjectId(id));
        UpdateOperations operations = this.getDatastore().createUpdateOperations(RedReceive.class);
        operations.set("reply", (Object)reply);
        this.getDatastore().update(query, operations);
    }

    public List<RedReceive> getRedReceivesByRedId(ObjectId redId) {
        return this.getEntityListsByKey(RedReceive.class, "redId", redId, "-time");
    }

    public List<RedPacket> getSendRedPacketList(Integer userId, int pageIndex, int pageSize) {
        Query q = (Query)this.createQuery().field("userId").equal((Object)userId);
        return q.order("-sendTime").offset(pageIndex * pageSize).limit(pageSize).asList();
    }

    public List<RedReceive> getRedReceiveList(Integer userId, int pageIndex, int pageSize) {
        return this.getEntityListsByKey(RedReceive.class, "userId", userId, "-time", pageIndex, pageSize);
    }

    public PageResult<RedPacket> getRedPacketList(String userName, int pageIndex, int pageSize, String redPacketId) {
        PageResult<RedPacket> result = new PageResult<RedPacket>();
        Query q = this.createQuery().order("-sendTime");
        if (!StringUtil.isEmpty(userName)) {
            q.field("userName").equal((Object)userName);
        }
        if (!StringUtil.isEmpty(redPacketId)) {
            q.field("_id").equal((Object)new ObjectId(redPacketId));
        }
        result.setCount(q.count());
        result.setData(q.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return result;
    }

    public PageResult<RedReceive> receiveWater(String redId, int pageIndex, int pageSize) {
        PageResult<RedReceive> result = new PageResult<RedReceive>();
        Query q = ((Query)this.getDatastore().createQuery(RedReceive.class).field("redId").equal((Object)new ObjectId(redId))).order("-time");
        result.setCount(q.count());
        result.setData(q.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return result;
    }
}

