/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.utils.NumberUtil;
import cn.xyz.commons.utils.RandomUtil;
import cn.xyz.mianshi.model.PressureParam;
import cn.xyz.mianshi.model.PressureThread;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.types.ObjectId;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PressureTestManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(PressureTestManagerImpl.class);
    @Autowired(required=false)
    private KApplicationProperties.XMPPConfig xmppConfig;
    private Map<String, List<XMPPTCPConnection>> userConnMap = Maps.newConcurrentMap();
    XMPPTCPConnectionConfiguration.Builder builder = null;
    private int runStatus = 0;
    final ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    private XMPPTCPConnectionConfiguration.Builder InitializeBuilder() {
        if (null == this.builder) {
            try {
                this.builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setCompressionEnabled(true).setSendPresence(true)).setXmppDomain(this.xmppConfig.getServerName())).setHost(this.xmppConfig.getHost())).setPort(5222);
            }
            catch (XmppStringprepException e) {
                e.printStackTrace();
            }
        }
        return this.builder;
    }

    public void createRobot(int checkNum, List<String> jids) {
        for (String jid : jids) {
            ArrayList<Integer> offlineUsers = new ArrayList<Integer>();
            ObjectId roomId = SKBeanUtils.getRoomManager().getRoomId(jid);
            List<Integer> memberIds = SKBeanUtils.getRoomManager().getCommonMemberIdList(roomId);
            int createNum = checkNum - memberIds.size();
            if (createNum > 0) {
                List<Integer> addRobots = SKBeanUtils.getUserManager().addRobot(createNum, true, roomId, null);
                offlineUsers.addAll(memberIds);
                offlineUsers.addAll(addRobots);
                log.info("\u7fa4\uff1a" + jid + "   \u9700\u8981\u521b\u5efa\u673a\u5668\u4eba\u7684\u4e2a\u6570\uff1a" + createNum);
            } else if (3 < memberIds.size() / checkNum) {
                for (int i = 0; i < checkNum; ++i) {
                    Integer num = NumberUtil.getRandomByMinAndMax(1, memberIds.size());
                    while (offlineUsers.contains(num)) {
                        num = NumberUtil.getRandomByMinAndMax(1, memberIds.size());
                    }
                    offlineUsers.add(memberIds.get(num - 1));
                    memberIds.remove(num);
                }
            } else {
                offlineUsers.addAll(memberIds);
            }
            List<XMPPTCPConnection> connList = Collections.synchronizedList(new ArrayList());
            int i = 0;
            for (Integer userId : offlineUsers) {
                ++i;
                Object pwd = SKBeanUtils.getUserManager().queryOneFieldById("password", userId);
                XMPPTCPConnection conn = this.getConnection(userId.toString(), pwd.toString());
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null != conn && conn.isAuthenticated()) {
                    connList.add(conn);
                }
                if (i < checkNum) continue;
                break;
            }
            System.out.println("\u7fa4\uff1a" + jid + "   \u9009\u4e2d\u7684conn\uff1a" + connList.toString());
            this.userConnMap.put(jid, connList);
        }
    }

    public PressureParam.PressureResult mucTest(PressureParam param) {
        try {
            if (1 == this.runStatus) {
                log.error("\u5df2\u6709\u538b\u6d4b \u4efb\u52a1 \u8fd0\u884c\u4e2d  \u8bf7\u7a0d\u540e \u8bf7\u6c42 \u3002\u3002\u3002\u3002\u3002\u3002");
                return null;
            }
            System.out.println("\u538b\u529b\u6d4b\u8bd5\uff1a roomJids: " + JSONObject.toJSONString(param.getJids()) + " checkNum: " + param.getCheckNum() + " sendMsgNum: " + param.getSendMsgNum() + "  \u6d88\u606f\u65f6\u95f4\u95f4\u9694:" + param.getTimeInterval());
            this.runStatus = 1;
            this.closeConnection();
            param.setAtomic(new AtomicInteger(0));
            String format = new SimpleDateFormat("MM-dd HH:mm").format(System.currentTimeMillis());
            param.setTimeStr(format);
            this.createRobot(param.getCheckNum(), param.getJids());
            List<MultiUserChat> mucChats = null;
            List<XMPPTCPConnection> connList = null;
            List<XMPPTCPConnection> conns = null;
            List<PressureThread> threads = Collections.synchronizedList(new ArrayList());
            for (String jid : param.getJids()) {
                connList = this.userConnMap.get(jid);
                conns = Collections.synchronizedList(new ArrayList());
                for (int i = 0; i < param.getCheckNum(); ++i) {
                    if (connList.size() <= i) continue;
                    conns.add(connList.get(i));
                }
                mucChats = Collections.synchronizedList(new ArrayList());
                for (XMPPTCPConnection conn : conns) {
                    String strJid = jid + this.getMucChatServiceName(conn);
                    MultiUserChat muc = null;
                    try {
                        MultiUserChatManager muChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)conn);
                        muc = muChatManager.getMultiUserChat(JidCreate.entityBareFrom((String)strJid));
                        muc.join(Resourcepart.from((String)conn.getUser().getLocalpart().toString()));
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        try {
                            muc.join(Resourcepart.from((String)conn.getUser().getLocalpart().toString()));
                        }
                        catch (Exception e2) {
                            System.err.println(e2.getMessage());
                        }
                    }
                    if (null == muc || null == muc.getNickname()) continue;
                    mucChats.add(muc);
                }
                threads.add(new PressureThread(jid, param, mucChats));
            }
            param.setStartTime(System.currentTimeMillis());
            HashSet threadFutures = new HashSet();
            threads.forEach(th -> {
                ScheduledFuture<?> scheduledFuture = this.threadPool.scheduleAtFixedRate((Runnable)th, 1000L, param.getTimeInterval(), TimeUnit.MILLISECONDS);
                threadFutures.add(scheduledFuture);
            });
            PressureParam.PressureResult result = null;
            while (this.runStatus == 1) {
                if (param.getAtomic().get() >= param.getSendAllCount()) {
                    try {
                        threadFutures.stream().forEach(th -> th.cancel(false));
                        param.setConns(null);
                        result = new PressureParam.PressureResult();
                        result.setTimeCount((System.currentTimeMillis() - param.getStartTime()) / 1000L);
                        result.setSendAllCount(param.getSendAllCount());
                        result.setTimeStr(param.getTimeStr());
                        log.info("\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5 \uff1a" + JSONObject.toJSONString((Object)param));
                        this.runStatus = 2;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                Thread.sleep(1000L);
            }
            this.runStatus = 0;
            return result;
        }
        catch (Exception e) {
            this.runStatus = 0;
            return new PressureParam.PressureResult();
        }
    }

    private void closeConnection() {
        if (0 == this.userConnMap.size()) {
            return;
        }
        for (String jid : this.userConnMap.keySet()) {
            List<XMPPTCPConnection> list = this.userConnMap.get(jid);
            for (XMPPTCPConnection conn : list) {
                conn.disconnect();
            }
        }
        this.userConnMap = Maps.newConcurrentMap();
    }

    public String getMucChatServiceName(XMPPTCPConnection connection) {
        return "@muc." + connection.getXMPPServiceDomain();
    }

    private XMPPTCPConnectionConfiguration getConfig() {
        XMPPTCPConnectionConfiguration config = null;
        XMPPTCPConnectionConfiguration.Builder builder = this.InitializeBuilder();
        if (null != builder) {
            try {
                config = ((XMPPTCPConnectionConfiguration.Builder)builder.setResource((CharSequence)RandomUtil.getRandomEnAndNum(5))).build();
            }
            catch (XmppStringprepException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public XMPPTCPConnection getConnection(String username, String password) {
        XMPPTCPConnection connection = null;
        try {
            connection = new XMPPTCPConnection(this.getConfig());
            connection.setReplyTimeout(30000L);
            connection.connect();
            connection.login((CharSequence)username, password);
        }
        catch (SmackException e) {
            log.info(" =====\u300b     XMPP\u8d85\u65f6\u5f02\u5e38\uff1a" + username);
            return null;
        }
        catch (Exception e) {
            if (e instanceof SASLErrorException) {
                log.info(" ==== \u300bXMPP\u8ba4\u8bc1\u5f02\u5e38");
                DBCollection collection = SKBeanUtils.getTigaseDatastore().getDB().getCollection("tig_users");
                BasicDBObject query = new BasicDBObject();
                String userId = username + "@" + this.xmppConfig.getServerName();
                query.put((Object)"user_id", (Object)userId);
            }
            return null;
        }
        return connection;
    }
}

