/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.opensdk.entity.SkOpenApp;
import cn.xyz.mianshi.service.PayService;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.CodePay;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.PayOrder;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.AuthServiceOldUtils;
import cn.xyz.service.KXMPPServiceImpl;
import cn.xyz.service.RedisServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.shiku.commons.task.TimerTask;
import com.shiku.commons.thread.ThreadUtils;
import com.shiku.utils.Base64;
import com.wxpay.utils.MD5Util;
import com.wxpay.utils.WXPayUtil;
import com.wxpay.utils.http.HttpClientConnectionManager;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
extends MongoRepository<CodePay, ObjectId>
implements PayService {
    public static DefaultHttpClient httpclient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<CodePay> getEntityClass() {
        return CodePay.class;
    }

    private static RedisServiceImpl getRedisServiceImpl() {
        return SKBeanUtils.getRedisService();
    }

    public Integer analysisCode(String paymentCode) {
        int n = 9;
        String userIdCodeLength = paymentCode.substring(0, 1);
        String userIdCode = paymentCode.substring(userIdCodeLength.length(), Integer.valueOf(userIdCodeLength) + 1);
        int three = userIdCodeLength.length() + userIdCode.length();
        String opt = paymentCode.substring(three, three + 3);
        int four = three + 3;
        String timeCode = paymentCode.substring(four, paymentCode.length());
        int userId = Integer.valueOf(userIdCode) - n - Integer.valueOf(opt);
        long time = Integer.valueOf(timeCode) * Integer.valueOf(opt);
        if (System.currentTimeMillis() / 1000L - time < 256L) {
            return userId;
        }
        time = Integer.valueOf(timeCode) * (Integer.valueOf(opt) - 100);
        if (System.currentTimeMillis() / 1000L - time < 256L) {
            return userId;
        }
        return null;
    }

    public synchronized void paymentCodePay(String paymentCode, Integer userId, Integer fromUserId, String money, String desc) {
        User fromUser = (User)SKBeanUtils.getUserManager().get(fromUserId);
        User user = (User)SKBeanUtils.getUserManager().get(userId);
        Double balance = SKBeanUtils.getUserManager().getUserMoenyV1(fromUserId);
        Double doubleMoney = Double.valueOf(money);
        if (balance < doubleMoney) {
            throw new ServiceException(104001);
        }
        if (doubleMoney > 50.0) {
            throw new ServiceException("\u6700\u591a\u652f\u6301 50\u5143\u652f\u4ed8!");
        }
        if (balance < doubleMoney) {
            throw new ServiceException("\u5bf9\u65b9\u4f59\u989d\u4e0d\u8db3,\u6263\u6b3e\u5931\u8d25");
        }
        double toDayCodePayCount = this.queryToDayCodePayCount(fromUserId);
        if (toDayCodePayCount + doubleMoney > 500.0) {
            throw new ServiceException("\u5f53\u5929\u4ed8\u6b3e\u5df2\u8d85\u9650\u989d,\u6263\u6b3e\u5931\u8d25");
        }
        double count = this.queryCodePayCount(fromUserId);
        if (count > 5000.0) {
            throw new ServiceException("\u603b\u4ed8\u6b3e\u5df2\u8d85\u9650\u989d,\u6263\u6b3e\u5931\u8d25");
        }
        CodePay codePay = new CodePay();
        codePay.setUserId(fromUserId);
        codePay.setUserName(fromUser.getNickname());
        codePay.setType(1);
        codePay.setToUserId(userId);
        codePay.setToUserName(user.getNickname());
        codePay.setMoney(doubleMoney);
        codePay.setCreateTime(DateUtil.currentTimeSeconds());
        this.saveCodePay(codePay);
        SKBeanUtils.getUserManager().rechargeUserMoeny(fromUserId, doubleMoney, 2);
        String lessTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord lessRecord = new ConsumeRecord();
        lessRecord.setUserId(fromUserId);
        lessRecord.setToUserId(userId);
        lessRecord.setTradeNo(lessTradeNo);
        lessRecord.setMoney(doubleMoney);
        lessRecord.setStatus(1);
        lessRecord.setType(10);
        lessRecord.setPayType(3);
        if (!StringUtil.isEmpty(desc)) {
            lessRecord.setDesc(desc);
        } else {
            lessRecord.setDesc("\u4ed8\u6b3e\u7801\u5df2\u4ed8\u6b3e");
        }
        lessRecord.setTime(DateUtil.currentTimeSeconds());
        SKBeanUtils.getConsumeRecordManager().save(lessRecord);
        User sysUser = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(1100));
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setFromUserId(sysUser.getUserId().toString());
        messageBean.setFromUserName(sysUser.getNickname());
        messageBean.setType(90);
        messageBean.setContent(JSONObject.toJSONString((Object)codePay));
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        messageBean.setToUserId(fromUserId.toString());
        messageBean.setToUserName(fromUser.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SKBeanUtils.getUserManager().rechargeUserMoeny(userId, doubleMoney, 1);
        String addTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord addRecord = new ConsumeRecord();
        addRecord.setUserId(userId);
        addRecord.setToUserId(fromUserId);
        addRecord.setTradeNo(addTradeNo);
        addRecord.setMoney(doubleMoney);
        addRecord.setStatus(1);
        addRecord.setType(11);
        addRecord.setPayType(3);
        addRecord.setDesc("\u4ed8\u6b3e\u7801\u5df2\u6536\u6b3e");
        addRecord.setTime(DateUtil.currentTimeSeconds());
        SKBeanUtils.getConsumeRecordManager().save(addRecord);
        KXMPPServiceImpl.MessageBean message = new KXMPPServiceImpl.MessageBean();
        message.setFromUserId(sysUser.getUserId().toString());
        message.setFileName(sysUser.getNickname());
        message.setType(91);
        message.setMsgType(0);
        message.setMessageId(StringUtil.randomUUID());
        message.setContent(JSONObject.toJSONString((Object)codePay));
        message.setToUserId(userId.toString());
        message.setToUserName(user.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PayServiceImpl.getRedisServiceImpl().savePaymentCode(paymentCode, fromUserId);
    }

    public String getPayQrKey(int userId) {
        String qrKey = SKBeanUtils.getRedisService().queryPayQrKey(userId);
        if (!StringUtil.isEmpty(qrKey)) {
            return qrKey;
        }
        byte[] codeArr = new byte[16];
        Random rom = new Random();
        rom.nextBytes(codeArr);
        qrKey = Base64.encode((byte[])codeArr);
        SKBeanUtils.getRedisService().savePayQrKey(userId, qrKey);
        return qrKey;
    }

    public boolean checkPaymentCode(Integer userId, String paymentCode) {
        Integer value = PayServiceImpl.getRedisServiceImpl().getPaymentCode(paymentCode);
        return null != value;
    }

    public synchronized void receipt(Integer userId, Integer fromUserId, String money, String desc) {
        User user = (User)SKBeanUtils.getUserManager().get(userId);
        User fromUser = (User)SKBeanUtils.getUserManager().get(fromUserId);
        Double balance = SKBeanUtils.getUserManager().getUserMoenyV1(userId);
        if (balance < Double.valueOf(money)) {
            throw new ServiceException(104001);
        }
        CodePay codePay = new CodePay();
        codePay.setUserId(fromUserId);
        codePay.setType(2);
        codePay.setUserName(fromUser.getNickname());
        codePay.setToUserId(userId);
        codePay.setToUserName(user.getNickname());
        codePay.setMoney(Double.valueOf(money));
        codePay.setCreateTime(DateUtil.currentTimeSeconds());
        this.saveCodePay(codePay);
        SKBeanUtils.getUserManager().rechargeUserMoeny(userId, Double.valueOf(money), 2);
        String lessTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord lessRecord = new ConsumeRecord();
        lessRecord.setUserId(userId);
        lessRecord.setToUserId(fromUserId);
        lessRecord.setTradeNo(lessTradeNo);
        lessRecord.setMoney(Double.valueOf(money));
        lessRecord.setStatus(1);
        lessRecord.setType(12);
        lessRecord.setPayType(3);
        if (!StringUtil.isEmpty(desc)) {
            lessRecord.setDesc(desc);
        } else {
            lessRecord.setDesc("\u4e8c\u7ef4\u7801\u6536\u6b3e\u5df2\u4ed8\u6b3e");
        }
        lessRecord.setTime(DateUtil.currentTimeSeconds());
        SKBeanUtils.getConsumeRecordManager().save(lessRecord);
        User sysUser = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(1100));
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setFromUserId(sysUser.getUserId().toString());
        messageBean.setFromUserName(sysUser.getNickname());
        messageBean.setType(92);
        messageBean.setContent(JSONObject.toJSONString((Object)codePay));
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        messageBean.setToUserId(user.getUserId().toString());
        messageBean.setToUserName(user.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SKBeanUtils.getUserManager().rechargeUserMoeny(fromUserId, Double.valueOf(money), 1);
        String addTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord addRecord = new ConsumeRecord();
        addRecord.setUserId(fromUserId);
        addRecord.setToUserId(userId);
        addRecord.setTradeNo(addTradeNo);
        addRecord.setMoney(Double.valueOf(money));
        addRecord.setStatus(1);
        addRecord.setType(13);
        addRecord.setPayType(3);
        addRecord.setDesc("\u4e8c\u7ef4\u7801\u6536\u6b3e\u5df2\u5230\u8d26");
        addRecord.setTime(DateUtil.currentTimeSeconds());
        SKBeanUtils.getConsumeRecordManager().save(addRecord);
        KXMPPServiceImpl.MessageBean message = new KXMPPServiceImpl.MessageBean();
        message.setFromUserId(sysUser.getUserId().toString());
        message.setFromUserName(sysUser.getNickname());
        message.setType(93);
        message.setMsgType(0);
        message.setMessageId(StringUtil.randomUUID());
        message.setContent(JSONObject.toJSON((Object)codePay));
        message.setToUserId(fromUser.getUserId().toString());
        message.setToUserName(fromUser.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveCodePay(CodePay entity) {
        this.save(entity);
    }

    public JSONMessage unifiedOrderImpl(Map<String, String> map) throws Exception {
        if (!this.checkSign(map.get("appId"), map.get("body"), map.get("input_charset"), map.get("nonce_str"), map.get("out_trade_no"), map.get("total_fee"), map.get("trade_type"), map.get("notify_url"), map.get("spbill_create_ip"), map.get("sign"))) {
            return JSONMessage.failureByErrCode(104403);
        }
        if (map.get("trade_type").equals("APP")) {
            SkOpenApp openApp = SKBeanUtils.getOpenAppManage().getOpenAppByAppId(map.get("appId"));
            if (null == openApp) {
                return JSONMessage.failureByErrCode(104402);
            }
            if (openApp.getIsAuthPay() != 1) {
                return JSONMessage.failureByErrCode(10111);
            }
        } else if (map.get("trade_type").equals("WEB")) {
            SkOpenApp openWeb = SKBeanUtils.getOpenWebAppManage().checkWebAPPByAppId(map.get("appId"));
            if (null == openWeb) {
                return JSONMessage.failureByErrCode(104402);
            }
            if (openWeb.getIsAuthPay() != 1) {
                return JSONMessage.failureByErrCode(10111);
            }
        }
        PayOrder payOrder = new PayOrder();
        payOrder.setAppId(map.get("appId"));
        payOrder.setMoney(map.get("total_fee"));
        payOrder.setTrade_no(map.get("trade_no"));
        payOrder.setCreateTime(DateUtil.currentTimeSeconds());
        payOrder.setIPAdress(map.get("spbill_create_ip"));
        payOrder.setDesc(map.get("body"));
        payOrder.setAppType(map.get("trade_type"));
        payOrder.setCallBackUrl(map.get("notify_url"));
        payOrder.setStatus((byte)0);
        payOrder.setSign(map.get("sign"));
        payOrder.setId(ObjectId.get());
        this.saveEntity(payOrder);
        SKBeanUtils.getRedisService().savePayOrderSign(payOrder.getId().toString(), map.get("sign"));
        TreeMap<String, String> contentMap = new TreeMap<String, String>();
        contentMap.put("prepay_id", payOrder.getId().toString());
        String resultxml = WXPayUtil.paramsToxmlStr(contentMap);
        return JSONMessage.success(resultxml);
    }

    public boolean checkSign(String appId, String body, String input_charset, String nonce_str, String trade_no, String total_fee, String trade_type, String notify_url, String spbill_create_ip, String sign) {
        TreeMap<String, String> contentMap = new TreeMap<String, String>();
        contentMap.put("appId", appId);
        contentMap.put("body", body);
        contentMap.put("input_charset", input_charset);
        contentMap.put("nonce_str", nonce_str);
        contentMap.put("notify_url", notify_url);
        contentMap.put("spbill_create_ip", spbill_create_ip);
        contentMap.put("total_fee", total_fee);
        contentMap.put("out_trade_no", trade_no);
        contentMap.put("trade_type", trade_type);
        String signKey = this.createSign(contentMap);
        return signKey.equals(sign);
    }

    public JSONMessage getOrderInfo(String appId, String prepayId) {
        Query query = (Query)this.getDatastore().createQuery(PayOrder.class).field("_id").equal((Object)new ObjectId(prepayId));
        query.field("appId").equal((Object)appId);
        PayOrder payOrder = (PayOrder)query.get();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("money", payOrder.getMoney());
        map.put("desc", payOrder.getDesc());
        return JSONMessage.success(null, map);
    }

    public JSONMessage passwordPayment(String appId, String prepayId, String sign, Integer userId, String token, long time, String secret, String salt) {
        User user = (User)SKBeanUtils.getUserManager().get(userId);
        if (StringUtil.isEmpty(salt) && !AuthServiceOldUtils.authPaymentSecret(userId.toString(), token, user.getPayPassword(), time, secret)) {
            return JSONMessage.failureByErrCode(10110);
        }
        if (!SKBeanUtils.getRedisService().queryPayOrderSign(prepayId).equals(sign)) {
            return JSONMessage.failureByErrCode(104403);
        }
        Query query = (Query)this.getDatastore().createQuery(PayOrder.class).field("_id").equal((Object)new ObjectId(prepayId));
        if (null == query.get()) {
            return JSONMessage.failureByErrCode(104404);
        }
        PayOrder order = (PayOrder)query.get();
        if (!order.getAppId().equals(appId)) {
            return JSONMessage.failureByErrCode(104405);
        }
        order.setUserId(userId.toString());
        order.setStatus((byte)1);
        this.saveEntity(order);
        String lessTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord consumeRecord = new ConsumeRecord();
        consumeRecord.setMoney(Double.valueOf(order.getMoney()));
        consumeRecord.setOrderId(order.getId());
        consumeRecord.setType(14);
        consumeRecord.setPayType(3);
        consumeRecord.setDesc(order.getDesc());
        consumeRecord.setTime(DateUtil.currentTimeSeconds());
        consumeRecord.setStatus(1);
        consumeRecord.setTradeNo(lessTradeNo);
        consumeRecord.setUserId(userId);
        SKBeanUtils.getConsumeRecordManager().save(consumeRecord);
        SKBeanUtils.getUserManager().rechargeUserMoeny(userId, Double.valueOf(order.getMoney()), 2);
        User sysUser = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(1100));
        SkOpenApp openApp = SKBeanUtils.getOpenAppManage().getOpenAppByAppId(appId);
        JSONObject obj = new JSONObject();
        obj.put("orderId", (Object)order.getId().toString());
        obj.put("money", (Object)order.getMoney());
        obj.put("icon", (Object)openApp.getAppImg());
        obj.put("name", (Object)openApp.getAppName());
        KXMPPServiceImpl.MessageBean message = new KXMPPServiceImpl.MessageBean();
        message.setFromUserId(sysUser.getUserId().toString());
        message.setFromUserName(sysUser.getNickname());
        message.setType(97);
        message.setMsgType(0);
        message.setMessageId(StringUtil.randomUUID());
        message.setContent(obj);
        message.setToUserId(user.getUserId().toString());
        message.setToUserName(user.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ThreadUtils.executeTimerTask((TimerTask)new PaySyncCallback(order), (long)5L, (long)30L);
        return JSONMessage.success();
    }

    public JSONMessage passwordPaymentV1(String appId, String prepayId, String sign, Integer userId) {
        User user = (User)SKBeanUtils.getUserManager().get(userId);
        if (!SKBeanUtils.getRedisService().queryPayOrderSign(prepayId).equals(sign)) {
            return JSONMessage.failureByErrCode(104403);
        }
        Query query = (Query)this.getDatastore().createQuery(PayOrder.class).field("_id").equal((Object)new ObjectId(prepayId));
        if (null == query.get()) {
            return JSONMessage.failureByErrCode(104404);
        }
        PayOrder order = (PayOrder)query.get();
        if (!order.getAppId().equals(appId)) {
            return JSONMessage.failureByErrCode(104405);
        }
        order.setUserId(userId.toString());
        order.setStatus((byte)1);
        this.saveEntity(order);
        String lessTradeNo = StringUtil.getOutTradeNo();
        ConsumeRecord consumeRecord = new ConsumeRecord();
        consumeRecord.setMoney(Double.valueOf(order.getMoney()));
        consumeRecord.setOrderId(order.getId());
        consumeRecord.setType(14);
        consumeRecord.setPayType(3);
        consumeRecord.setDesc(order.getDesc());
        consumeRecord.setTime(DateUtil.currentTimeSeconds());
        consumeRecord.setStatus(1);
        consumeRecord.setTradeNo(lessTradeNo);
        consumeRecord.setUserId(userId);
        SKBeanUtils.getConsumeRecordManager().save(consumeRecord);
        SKBeanUtils.getUserManager().rechargeUserMoeny(userId, Double.valueOf(order.getMoney()), 2);
        User sysUser = (User)SKBeanUtils.getUserManager().get(Integer.valueOf(1100));
        SkOpenApp openApp = SKBeanUtils.getOpenAppManage().getOpenAppByAppId(appId);
        JSONObject obj = new JSONObject();
        obj.put("orderId", (Object)order.getId().toString());
        obj.put("money", (Object)order.getMoney());
        obj.put("icon", (Object)openApp.getAppImg());
        obj.put("name", (Object)openApp.getAppName());
        KXMPPServiceImpl.MessageBean message = new KXMPPServiceImpl.MessageBean();
        message.setFromUserId(sysUser.getUserId().toString());
        message.setFromUserName(sysUser.getNickname());
        message.setType(97);
        message.setMsgType(0);
        message.setMessageId(StringUtil.randomUUID());
        message.setContent(obj);
        message.setToUserId(user.getUserId().toString());
        message.setToUserName(user.getNickname());
        try {
            KXMPPServiceImpl.getInstance().send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ThreadUtils.executeTimerTask((TimerTask)new PaySyncCallback(order), (long)5L, (long)30L);
        return JSONMessage.success();
    }

    public String createSign(SortedMap<String, String> packageParams) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = packageParams.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        String sign = MD5Util.MD5Encode(sb.toString(), "UTF-8").toUpperCase();
        return sign;
    }

    public double queryCodePayCount(int userId) {
        BasicDBObject groupFileds = new BasicDBObject();
        groupFileds.put("userId", (Object)"$userId");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"userId", (Object)userId);
        BasicDBObject macth = new BasicDBObject("$match", (Object)query);
        BasicDBObject fileds = new BasicDBObject("_id", (Object)groupFileds);
        fileds.put("count", (Object)new BasicDBObject("$sum", (Object)"$money"));
        BasicDBObject group = new BasicDBObject("$group", (Object)fileds);
        DBCollection collection = this.getDatastore().getCollection(CodePay.class);
        AggregationOutput out = collection.aggregate(Arrays.asList(macth, group));
        Iterator result = out.results().iterator();
        if (result.hasNext()) {
            return Double.valueOf(((DBObject)result.next()).get("count").toString());
        }
        return 0.0;
    }

    public double queryToDayCodePayCount(int userId) {
        BasicDBObject groupFileds = new BasicDBObject();
        groupFileds.put("userId", (Object)"$userId");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"userId", (Object)userId);
        query.put((Object)"createTime", (Object)new BasicDBObject("$gt", (Object)(DateUtil.getTodayMorning().getTime() / 1000L)).append("$lte", (Object)DateUtil.currentTimeSeconds()));
        BasicDBObject macth = new BasicDBObject("$match", (Object)query);
        BasicDBObject fileds = new BasicDBObject("_id", (Object)groupFileds);
        fileds.put("count", (Object)new BasicDBObject("$sum", (Object)"$money"));
        BasicDBObject group = new BasicDBObject("$group", (Object)fileds);
        DBCollection collection = this.getDatastore().getCollection(CodePay.class);
        AggregationOutput out = collection.aggregate(Arrays.asList(macth, group));
        Iterator result = out.results().iterator();
        if (result.hasNext()) {
            return Double.valueOf(((DBObject)result.next()).get("count").toString());
        }
        return 0.0;
    }

    private class PaySyncCallback
    extends TimerTask {
        private PayOrder order;

        public PaySyncCallback(PayOrder order) {
            this.order = order;
        }

        public void run() {
            String callBackUrl = this.order.getCallBackUrl();
            if (StringUtil.isEmpty(callBackUrl)) {
                if (this.order.getAppType().equals("APP")) {
                    Query openAppQuery = (Query)PayServiceImpl.this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)this.order.getAppId());
                    callBackUrl = ((SkOpenApp)openAppQuery.get()).getPayCallBackUrl();
                } else {
                    Query openWebQuery = (Query)PayServiceImpl.this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)this.order.getAppId());
                    callBackUrl = ((SkOpenApp)openWebQuery.get()).getPayCallBackUrl();
                }
            }
            try {
                TreeMap<String, String> contentMap = new TreeMap<String, String>();
                contentMap.put("out_trade_no", this.order.getTrade_no());
                String xmlParam = WXPayUtil.paramsToxmlStr(contentMap);
                HttpPost httpPost = HttpClientConnectionManager.getPostMethod(callBackUrl);
                httpPost.setEntity((HttpEntity)new StringEntity(xmlParam, "UTF-8"));
                PayServiceImpl.this.logger.info("\u7b2c\u4e09\u65b9\u652f\u4ed8\u6210\u529f,\u5f00\u59cb\u56de\u8c03");
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 200) {
                    PayServiceImpl.this.logger.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
                    this.cancel();
                } else {
                    PayServiceImpl.this.logger.info("\u652f\u4ed8\u56de\u8c03\u5931\u8d25\u7ee7\u7eed\u5c1d\u8bd5\u8bf7\u6c42");
                }
            }
            catch (UnknownHostException e1) {
                PayServiceImpl.this.logger.error(e1.getMessage() + " \u652f\u4ed8\u56de\u8c03\u8def\u5f84\u8bf7\u6c42\u5931\u8d25");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancel();
            }
        }
    }
}

