/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.MusicInfo;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class MusicManagerImpl
extends MongoRepository<MusicInfo, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<MusicInfo> getEntityClass() {
        return MusicInfo.class;
    }

    public List<MusicInfo> queryMusicInfo(int pageIndex, int pageSize, String keyword) {
        Query query = this.createQuery();
        if (!StringUtil.isEmpty(keyword)) {
            query.or(new Criteria[]{(Criteria)query.criteria("name").contains(keyword), (Criteria)query.criteria("nikeName").contains(keyword)});
        }
        query.order("-useCount");
        List resultList = query.asList(this.pageFindOption(pageIndex, pageSize, 0));
        return resultList;
    }

    public void addMusicInfo(MusicInfo musicInfo) {
        MusicInfo entity = new MusicInfo();
        if (!StringUtil.isEmpty(musicInfo.getCover())) {
            entity.setCover(musicInfo.getCover());
        }
        if (!StringUtil.isEmpty(musicInfo.getName())) {
            entity.setName(musicInfo.getName());
        }
        if (!StringUtil.isEmpty(musicInfo.getNikeName())) {
            entity.setNikeName(musicInfo.getNikeName());
        }
        if (!StringUtil.isEmpty(musicInfo.getPath())) {
            entity.setPath(musicInfo.getPath());
        }
        entity.setLength(musicInfo.getLength());
        entity.setUseCount(musicInfo.getUseCount());
        this.saveEntity(entity);
    }

    public void deleteMusicInfo(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(MusicInfo.class).field("_id").equal((Object)id);
        MusicInfo musicInfo = (MusicInfo)query.get();
        try {
            this.deleteResource(musicInfo.getPath());
            this.deleteResource(musicInfo.getCover());
            this.deleteByQuery(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMusicInfo(MusicInfo musicInfo) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)musicInfo.getId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (!StringUtil.isEmpty(musicInfo.getCover())) {
            ops.set("cover", (Object)musicInfo.getCover());
        }
        if (!StringUtil.isEmpty(musicInfo.getName())) {
            ops.set("name", (Object)musicInfo.getName());
        }
        if (!StringUtil.isEmpty(musicInfo.getNikeName())) {
            ops.set("nikeName", (Object)musicInfo.getNikeName());
        }
        if (!StringUtil.isEmpty(musicInfo.getPath())) {
            ops.set("path", (Object)musicInfo.getPath());
        }
        if (musicInfo.getLength() != 0L) {
            ops.set("length", (Object)musicInfo.getLength());
        }
        ops.set("useCount", (Object)musicInfo.getUseCount());
        this.getDatastore().update(query, ops);
    }

    public void updateUseCount(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)id);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("useCount", (Object)(((MusicInfo)query.get()).getUseCount() + 1));
        this.getDatastore().update(query, ops);
    }

    public void deleteResource(String url) {
        ConstantUtil.deleteFile(url);
    }
}

