/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.dao.MsgInferceptDAO;
import cn.xyz.mianshi.service.MsgInferceptManager;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.KeyWord;
import cn.xyz.mianshi.vo.MsgIntercept;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgInferceptManagerImpl
implements MsgInferceptManager {
    @Autowired
    private MsgInferceptDAO msgInferceptDAO;

    @Override
    public void addKeyword(String word, String id) {
        KeyWord keyword = null;
        if (StringUtil.isEmpty(id)) {
            keyword = new KeyWord();
            keyword.setWord(word);
            keyword.setCreateTime(DateUtil.currentTimeSeconds());
            this.msgInferceptDAO.saveKeyword(keyword);
        } else {
            this.msgInferceptDAO.updateKeyword(word, new ObjectId(id));
        }
    }

    @Override
    public void deleteKeyword(ObjectId id) {
        this.msgInferceptDAO.deleteKeyword(id);
    }

    @Override
    public List<KeyWord> queryKeywordList(String word, int pageIndex, int pageSize) {
        return this.msgInferceptDAO.queryKeywordList(word, pageIndex, pageSize);
    }

    @Override
    public List<MsgIntercept> queryMsgInterceptList(Integer userId, String toUserId, int pageIndex, int pageSize, int type, String content) {
        List<MsgIntercept> data = this.msgInferceptDAO.queryMsgInerceptList(userId, toUserId, pageIndex, pageSize, type, content);
        for (MsgIntercept keyWordIntercept : data) {
            keyWordIntercept.setSenderName(SKBeanUtils.getUserManager().getNickName(Integer.valueOf(keyWordIntercept.getSender())));
            if (!StringUtil.isEmpty(keyWordIntercept.getReceiver())) {
                keyWordIntercept.setReceiverName(SKBeanUtils.getUserManager().getNickName(Integer.valueOf(keyWordIntercept.getReceiver())));
                continue;
            }
            if (StringUtil.isEmpty(keyWordIntercept.getRoomJid())) continue;
            keyWordIntercept.setRoomName(SKBeanUtils.getRoomManager().getRoomName(keyWordIntercept.getRoomJid()));
        }
        return data;
    }

    @Override
    public void deleteMsgIntercept(ObjectId id) {
        this.msgInferceptDAO.deleteMsgIntercept(id);
    }
}

