/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.DocumentToJavaBean;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Black;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.Gift;
import cn.xyz.mianshi.vo.Givegift;
import cn.xyz.mianshi.vo.LiveRoom;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.springframework.stereotype.Service;

@Service
public class LiveRoomManagerImpl
extends MongoRepository<LiveRoom, ObjectId> {
    public final String mucMsg = "mucmsg_";

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<LiveRoom> getEntityClass() {
        return LiveRoom.class;
    }

    @Override
    public String getCollectionName() {
        MappedClass mappedClass = this.morphia.getMapper().getMappedClass(LiveRoom.LiveRoomMember.class);
        if (null == mappedClass) {
            return null;
        }
        return mappedClass.getCollectionName();
    }

    @Override
    public String getCollectionName(ObjectId id) {
        if (null == id) {
            this.logger.info(" ====  getCollectionName ObjectId is null  ====");
            throw new ServiceException("ObjectId  is  null !");
        }
        int remainder = 0;
        int counter = id.getCounter();
        remainder = counter / 10000;
        return String.valueOf(remainder);
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    public LiveRoom getLiveRoom(Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
        LiveRoom liveRoom = (LiveRoom)query.get();
        if (null == liveRoom) {
            return null;
        }
        if (!liveRoom.getUrl().startsWith("rtmp://")) {
            liveRoom.setUrl(KSessionUtil.getClientConfig().getLiveUrl() + liveRoom.getUrl());
        }
        return liveRoom;
    }

    public LiveRoom getLiveRoomByJid(String jid) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("jid").equal((Object)jid);
        LiveRoom liveRoom = (LiveRoom)query.get();
        if (null != liveRoom && !liveRoom.getUrl().startsWith("rtmp://")) {
            liveRoom.setUrl(KSessionUtil.getClientConfig().getLiveUrl() + liveRoom.getUrl());
        }
        return liveRoom;
    }

    public LiveRoom createLiveRoom(LiveRoom room) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)room.getUserId());
        LiveRoom liveRoom = (LiveRoom)query.get();
        if (null != liveRoom) {
            throw new ServiceException(100908);
        }
        User user = LiveRoomManagerImpl.getUserManager().getUser(room.getUserId());
        room.setNickName(user.getNickname());
        room.setCreateTime(DateUtil.currentTimeSeconds());
        room.setNotice(room.getNotice());
        room.setNumbers(1);
        room.setUrl(room.getUserId() + "_" + DateUtil.currentTimeSeconds());
        room.setJid(room.getJid());
        room.setUrl(room.getUrl());
        ObjectId id = (ObjectId)this.save(room).getId();
        this.enterIntoLiveRoom(room.getUserId(), id);
        room.setUrl(KSessionUtil.getClientConfig().getLiveUrl() + room.getUrl());
        return room;
    }

    public void updateLiveRoom(Integer userId, LiveRoom room) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("roomId").equal((Object)room.getRoomId())).field("userId").equal((Object)userId);
        UpdateOperations ops = this.createUpdateOperations();
        if (!StringUtil.isEmpty(room.getName())) {
            ops.set("name", (Object)room.getName());
        }
        if (!StringUtil.isEmpty(room.getNotice())) {
            ops.set("notice", (Object)room.getNotice());
        }
        ops.set("currentState", (Object)room.getCurrentState());
        ops.disableValidation();
        UpdateResults update = this.getDatastore().update(query, ops);
        if (update.getUpdatedCount() <= 0) {
            throw new ServiceException(100702);
        }
    }

    public void deleteLiveRoom(ObjectId roomId) {
        Query query = (Query)this.getDatastore().createQuery(LiveRoom.class).field("_id").equal((Object)roomId);
        LiveRoom liveRoom = (LiveRoom)query.get();
        SKBeanUtils.getImRoomDatastore().getDB().getCollection("mucmsg_" + liveRoom.getJid()).drop();
        MongoCollection collection = this.getCollection(roomId);
        Document merquery = new Document("roomId", (Object)roomId);
        collection.deleteMany((Bson)merquery);
        this.getDatastore().delete(query);
    }

    public void start(int userId, ObjectId roomId, int status) {
        Integer currentState = ((LiveRoom)this.get((Serializable)roomId)).getCurrentState();
        if (1 == currentState) {
            throw new ServiceException(100901);
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("status", (Object)status);
        this.updateAttributeByOps((Serializable)roomId, ops);
        this.enterIntoLiveRoom(userId, roomId);
    }

    public PageResult<LiveRoom> findConsoleLiveRoomList(String name, String nickName, Integer userId, Integer page, Integer limit, int status, int type) {
        PageResult<LiveRoom> result = new PageResult<LiveRoom>();
        Query query = this.createQuery();
        if (!StringUtil.isEmpty(name)) {
            query.filter("name", (Object)name);
        }
        if (!StringUtil.isEmpty(nickName)) {
            query.filter("nickName", (Object)nickName);
        }
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (1 == status) {
            query.filter("status", (Object)status);
        }
        query.order("-createTime");
        List roomList = query.asList(this.pageFindOption(page, limit, type));
        for (LiveRoom liveRoom : roomList) {
            if (liveRoom.getUrl().contains("//")) continue;
            liveRoom.setUrl(KSessionUtil.getClientConfig().getLiveUrl() + liveRoom.getUrl());
        }
        result.setData(roomList);
        result.setCount(query.count());
        return result;
    }

    public List<LiveRoom> findLiveRoomList(String name, String nickName, Integer userId, Integer page, Integer limit, int status, int type) {
        Query query = this.createQuery();
        if (!StringUtil.isEmpty(name)) {
            query.filter("name", (Object)name);
        }
        if (!StringUtil.isEmpty(nickName)) {
            query.filter("nickName", (Object)nickName);
        }
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (1 == status) {
            query.filter("status", (Object)status);
        }
        query.order("-createTime");
        List roomList = query.asList(this.pageFindOption(page, limit, type));
        for (LiveRoom liveRoom : roomList) {
            if (liveRoom.getUrl().contains("//")) continue;
            liveRoom.setUrl(KSessionUtil.getClientConfig().getLiveUrl() + liveRoom.getUrl());
        }
        return roomList;
    }

    public boolean enterIntoLiveRoom(Integer userId, ObjectId roomId) {
        Query r = this.getDatastore().createQuery(this.getEntityClass());
        LiveRoom liveRoom = (LiveRoom)r.filter("roomId", (Object)roomId).get();
        if (!userId.equals(liveRoom.getUserId()) && 0 == liveRoom.getStatus()) {
            throw new ServiceException("\u8be5\u76f4\u64ad\u95f4\u5c1a\u672a\u5f00\u64ad\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5");
        }
        MongoCollection collection = this.getDBObjectCollection(roomId);
        BasicDBObject merquery = new BasicDBObject("roomId", (Object)roomId);
        merquery.append("userId", (Object)userId);
        DBObject first = (DBObject)collection.find((Bson)merquery).first();
        if (null != first) {
            return true;
        }
        Query b = this.getDatastore().createQuery(Black.class);
        b.filter("roomId", (Object)roomId);
        b.filter("userId", (Object)userId);
        if (null == b.get()) {
            User user = LiveRoomManagerImpl.getUserManager().getUser(userId);
            if (null != first) {
                BasicDBObject ops = new BasicDBObject("$set", (Object)new BasicDBObject("online", (Object)1));
                collection.updateOne((Bson)merquery, (Bson)ops);
            } else {
                LiveRoom.LiveRoomMember member = new LiveRoom.LiveRoomMember();
                member.setUserId(userId);
                member.setRoomId(roomId);
                member.setCreateTime(DateUtil.currentTimeSeconds());
                member.setNickName(LiveRoomManagerImpl.getUserManager().getUser(userId).getNickname());
                member.setOnline(1);
                member.setType(userId.equals(liveRoom.getUserId()) ? 1 : 3);
                DBObject dbObject = this.objectToDBObject(member);
                collection.insertOne((Object)dbObject);
                UpdateOperations ops = this.createUpdateOperations();
                ops.inc("numbers", (Number)1);
                this.updateAttributeByOps((Serializable)roomId, ops);
            }
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(914);
            messageBean.setContent(liveRoom.getName());
            messageBean.setObjectId(liveRoom.getJid());
            messageBean.setFileName(liveRoom.getRoomId().toString());
            messageBean.setToUserId(user.getUserId() + "");
            messageBean.setToUserName(user.getNickname());
            messageBean.setMessageId(StringUtil.randomUUID());
            SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
            return true;
        }
        throw new ServiceException(100904);
    }

    public void exitLiveRoom(Integer userId, ObjectId roomId) {
        UpdateOperations ops;
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document("roomId", (Object)roomId);
        query.append("userId", (Object)userId);
        Document first = (Document)collection.find((Bson)query).first();
        if (null == first) {
            return;
        }
        LiveRoom.LiveRoomMember liveRoomMember = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), first);
        if (null == liveRoomMember) {
            return;
        }
        User user = LiveRoomManagerImpl.getUserManager().getUser(userId);
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        if (liveRoomMember.getType() == 3 && liveRoomMember.getState() != 1) {
            collection.deleteOne((Bson)query);
            ops = this.createUpdateOperations();
            if (liveRoom.getNumbers() <= 0) {
                return;
            }
            ops.inc("numbers", (Number)-1);
            this.updateAttributeByOps((Serializable)roomId, ops);
        } else if (liveRoomMember.getType() == 1) {
            ops = new Document("$set", (Object)new Document("online", (Object)0));
            collection.updateOne((Bson)query, (Bson)ops);
            Query b = this.getDatastore().createQuery(Black.class);
            b.filter("roomId", (Object)roomId);
            this.getDatastore().delete(b);
        } else {
            ops = new Document("$set", (Object)new Document("online", (Object)0));
            collection.updateOne((Bson)query, (Bson)ops);
        }
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(927);
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setFromUserId(user.getUserId() + "");
        messageBean.setFromUserName(user.getNickname());
        messageBean.setToUserId(user.getUserId() + "");
        messageBean.setToUserName(user.getNickname());
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
    }

    public void OutTimeRemoveLiveRoom(Integer userId) {
        UpdateOperations ops;
        Document query;
        MongoCollection collection = this.getCollection(userId.intValue());
        Document first = (Document)collection.find((Bson)(query = new Document("userId", (Object)userId))).first();
        if (null == first) {
            return;
        }
        LiveRoom.LiveRoomMember liveRoomMember = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), first);
        if (null == liveRoomMember) {
            return;
        }
        User user = LiveRoomManagerImpl.getUserManager().getUser(userId);
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)liveRoomMember.getRoomId());
        if (liveRoomMember.getType() == 3 && liveRoomMember.getState() != 1) {
            collection.deleteOne((Bson)query);
            ops = this.createUpdateOperations();
            if (liveRoom.getNumbers() <= 0) {
                return;
            }
            ops.inc("numbers", (Number)-1);
            this.updateAttributeByOps((Serializable)liveRoom.getRoomId(), ops);
        } else if (liveRoomMember.getType() == 1) {
            ops = new Document("$set", (Object)new Document("online", (Object)0));
            collection.updateOne((Bson)query, (Bson)ops);
            Query b = this.getDatastore().createQuery(Black.class);
            b.filter("roomId", (Object)liveRoom.getRoomId());
            this.getDatastore().delete(b);
        } else {
            ops = new Document("$set", (Object)new Document("online", (Object)0));
            collection.updateOne((Bson)query, (Bson)ops);
        }
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(936);
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setFromUserId(user.getUserId() + "");
        messageBean.setFromUserName(user.getNickname());
        messageBean.setToUserId(user.getUserId() + "");
        messageBean.setToUserName(user.getNickname());
        messageBean.setMessageId(StringUtil.randomUUID());
        if (liveRoomMember.getType() == 1) {
            messageBean.setOther(userId.toString());
        }
        SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
        SKBeanUtils.getRoomManager().sendGroupOne(userId, messageBean);
    }

    public void kick(final Integer userId, final ObjectId roomId) {
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        UpdateOperations ops = this.createUpdateOperations();
        if (liveRoom.getNumbers() <= 0) {
            return;
        }
        ops.inc("numbers", (Number)-1);
        this.updateAttributeByOps((Serializable)roomId, ops);
        User touser = LiveRoomManagerImpl.getUserManager().getUser(userId);
        if (touser == null) {
            return;
        }
        User user = LiveRoomManagerImpl.getUserManager().getUser(ReqUtil.getUserId());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(927);
        messageBean.setObjectId(liveRoom.getJid());
        if (null == user) {
            messageBean.setFromUserId("10005");
            messageBean.setFromUserName("10005");
        } else {
            messageBean.setFromUserId(user.getUserId() + "");
            messageBean.setFromUserName(user.getNickname());
        }
        messageBean.setToUserId(touser.getUserId() + "");
        messageBean.setToUserName(touser.getNickname());
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    MongoCollection collection = LiveRoomManagerImpl.this.getCollection(roomId);
                    Document query = new Document("roomId", (Object)roomId);
                    query.append("userId", (Object)userId);
                    collection.deleteOne((Bson)query);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Black black = new Black();
        black.setRoomId(roomId);
        black.setUserId(userId);
        black.setTime(DateUtil.currentTimeSeconds());
        this.saveEntity(black);
    }

    public void operationLiveRoom(ObjectId roomId, int currentState) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("roomId").equal((Object)roomId);
        UpdateOperations ops = this.createUpdateOperations();
        ops.set("currentState", (Object)currentState);
        ops.set("status", (Object)0);
        this.getDatastore().update(query, ops);
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        User user = LiveRoomManagerImpl.getUserManager().getUser(liveRoom.getUserId());
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(926);
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setFromUserId("10005");
        messageBean.setFromUserName("\u540e\u53f0\u7ba1\u7406\u5458");
        messageBean.setToUserId(user.getUserId() + "");
        messageBean.setToUserName(user.getNickname());
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LiveRoom.LiveRoomMember> findLiveRoomMemberList(ObjectId roomId) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document();
        if (null != roomId) {
            query.append("roomId", (Object)roomId);
        }
        MongoCursor iterator = collection.find((Bson)query).iterator();
        List<LiveRoom.LiveRoomMember> results = Collections.synchronizedList(new ArrayList());
        LiveRoom.LiveRoomMember member = null;
        Document document = null;
        try {
            while (iterator.hasNext()) {
                document = (Document)iterator.next();
                if (null == document || null == (member = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), document))) continue;
                results.add(member);
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> findMembersUserIds(ObjectId roomId) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document();
        if (null != roomId) {
            query.append("roomId", (Object)roomId);
        }
        query.append("online", (Object)1);
        ArrayList<Integer> results = new ArrayList<Integer>();
        try (MongoCursor iterator = collection.distinct("userId", Integer.class).iterator();){
            while (iterator.hasNext()) {
                Integer integer = (Integer)iterator.next();
                results.add(integer);
            }
        }
        return results;
    }

    public LiveRoom.LiveRoomMember getLiveRoomMember(ObjectId roomId, Integer userId) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document();
        query.append("roomId", (Object)roomId);
        query.append("userId", (Object)userId);
        Document first = (Document)collection.find((Bson)query).first();
        if (null == first) {
            return null;
        }
        LiveRoom.LiveRoomMember liveRoomMember = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), first);
        liveRoomMember.setRoomId(first.getObjectId((Object)"roomId"));
        return liveRoomMember;
    }

    public LiveRoom.LiveRoomMember shutup(int state, Integer userId, ObjectId roomId) {
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document();
        query.append("roomId", (Object)roomId);
        query.append("userId", (Object)userId);
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        Document first = (Document)collection.find((Bson)query).first();
        if (null == first) {
            return null;
        }
        LiveRoom.LiveRoomMember livemember = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), first);
        Document ops = new Document("$set", (Object)new Document("state", (Object)state));
        collection.updateOne((Bson)query, (Bson)ops);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(928);
        if (state == 1) {
            messageBean.setContent(DateUtil.currentTimeSeconds());
        } else {
            messageBean.setContent(0);
        }
        messageBean.setFromUserId(liveRoom.getUserId().toString());
        messageBean.setFromUserName(liveRoom.getNickName());
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setToUserId(livemember.getUserId() + "");
        messageBean.setToUserName(livemember.getNickName());
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
        return livemember;
    }

    public void updateLiveRoomMemberNickName(int userId, String nickName) {
        MongoDatabase database = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(this.getCollectionName());
        MongoIterable listCollectionNames = database.listCollectionNames();
        Document query = new Document();
        query.append("userId", (Object)userId);
        Document update = new Document("$set", (Object)new Document("nickName", (Object)nickName));
        MongoCollection collection = null;
        for (String string : listCollectionNames) {
            collection = database.getCollection(string);
            collection.updateMany((Bson)query, (Bson)update);
        }
    }

    public void addGift(String name, String photo, double price, int type) {
        Gift gift = new Gift();
        gift.setName(name);
        gift.setPhoto(photo);
        gift.setPrice(price);
        gift.setType(type);
        this.saveEntity(gift);
    }

    public void deleteGift(ObjectId giftId) {
        Query q = this.getDatastore().createQuery(Gift.class);
        q.filter("giftId", (Object)giftId);
        if (null == q.get()) {
            throw new ServiceException(10102);
        }
        this.getDatastore().delete(q);
    }

    public Map<String, Object> consolefindAllgift(String name, int pageIndex, int pageSize) {
        ConcurrentMap giftMap = Maps.newConcurrentMap();
        Query query = this.getDatastore().createQuery(Gift.class);
        if (!name.equals("")) {
            query.filter("name", (Object)name);
        }
        query.offset(pageSize * pageIndex);
        giftMap.put("total", query.count());
        giftMap.put("data", query.limit(pageSize).asList());
        return giftMap;
    }

    public List<Gift> findAllgift(String name, int pageIndex, int pageSize) {
        Query query = this.getDatastore().createQuery(Gift.class);
        if (!name.equals("")) {
            query.filter("name", (Object)name);
        }
        query.offset(pageSize * pageIndex);
        List giftList = query.limit(pageSize).asList();
        return giftList;
    }

    public Gift queryGift(ObjectId giftId) {
        Query query = this.getDatastore().createQuery(Gift.class);
        query.filter("_id", (Object)giftId);
        return (Gift)query.get();
    }

    public synchronized ObjectId giveGift(final Integer userId, final Integer toUserId, ObjectId giftId, int count, Double price, ObjectId roomId) {
        final Double totalMoney = price * (double)count;
        Query q = this.getDatastore().createQuery(User.class);
        q.filter("userId", (Object)userId);
        User user = SKBeanUtils.getUserManager().getUser(userId);
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        Double userMoeny = SKBeanUtils.getUserManager().getUserMoeny(userId);
        if (userMoeny >= price * (double)count) {
            Givegift givegift = new Givegift();
            givegift.setUserId(userId);
            givegift.setToUserId(toUserId);
            givegift.setGiftId(giftId);
            givegift.setCount(count);
            givegift.setPrice(price * (double)count);
            givegift.setTime(DateUtil.currentTimeSeconds());
            this.saveEntity(givegift);
            LiveRoomManagerImpl.getUserManager().rechargeUserMoeny(userId, totalMoney, 2);
            Config config = SKBeanUtils.getAdminManager().getConfig();
            final double giftRatio = totalMoney * config.getGiftRatio();
            if (null != config) {
                LiveRoomManagerImpl.getUserManager().rechargeUserMoeny(toUserId, giftRatio, 1);
            }
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(911);
            messageBean.setFromUserId(userId.toString());
            messageBean.setFromUserName(user.getNickname());
            messageBean.setObjectId(liveRoom.getJid());
            messageBean.setContent(giftId.toString());
            messageBean.setMessageId(StringUtil.randomUUID());
            SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    String tradeNo = StringUtil.getOutTradeNo();
                    ConsumeRecord record = new ConsumeRecord();
                    record.setUserId(userId);
                    record.setToUserId(toUserId);
                    record.setTradeNo(tradeNo);
                    record.setMoney(totalMoney);
                    record.setStatus(1);
                    record.setType(14);
                    record.setPayType(3);
                    record.setDesc("\u76f4\u64ad\u793c\u7269\u9001\u51fa");
                    record.setTime(DateUtil.currentTimeSeconds());
                    SKBeanUtils.getConsumeRecordManager().save(record);
                    tradeNo = StringUtil.getOutTradeNo();
                    ConsumeRecord recordTo = new ConsumeRecord();
                    record.setUserId(toUserId);
                    record.setToUserId(userId);
                    record.setTradeNo(tradeNo);
                    record.setMoney(giftRatio);
                    record.setStatus(1);
                    record.setType(15);
                    record.setPayType(3);
                    record.setDesc("\u76f4\u64ad\u793c\u7269\u63a5\u53d7");
                    record.setTime(DateUtil.currentTimeSeconds());
                    SKBeanUtils.getConsumeRecordManager().save(recordTo);
                }
            });
            return giftId;
        }
        throw new ServiceException(104001);
    }

    public PageResult<Givegift> getGiftList(Integer userId, String startDate, String endDate, Integer page, Integer limit) {
        Query query;
        PageResult<Givegift> result = new PageResult<Givegift>();
        double totalMoney = 0.0;
        Config config = SKBeanUtils.getAdminManager().getConfig();
        if (StringUtil.isEmpty(startDate) && StringUtil.isEmpty(endDate)) {
            query = this.getDatastore().createQuery(Givegift.class).filter("toUserId", (Object)userId);
        } else {
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            DateUtil.getTodayNight();
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            long formateEndtime = DateUtil.getOnedayNextDay(endTime, 1, 0);
            query = (Query)((Query)this.getDatastore().createQuery(Givegift.class).field("time").greaterThan((Object)startTime)).field("time").lessThanOrEq((Object)formateEndtime);
        }
        List giveGiftList = query.asList(this.pageFindOption(page, limit, 1));
        for (Givegift givegift : giveGiftList) {
            Query liveRoom = this.getDatastore().createQuery(this.getEntityClass()).filter("userId", (Object)givegift.getToUserId());
            Query gift = this.getDatastore().createQuery(Gift.class).filter("giftId", (Object)givegift.getGiftId());
            givegift.setGiftName(((Gift)gift.get()).getName());
            givegift.setLiveRoomName(((LiveRoom)liveRoom.get()).getName());
            givegift.setActualPrice(config.getGiftRatio() * givegift.getPrice());
            totalMoney += givegift.getActualPrice().doubleValue();
            givegift.setUserName(LiveRoomManagerImpl.getUserManager().getNickName(givegift.getUserId()));
            givegift.setToUserName(LiveRoomManagerImpl.getUserManager().getNickName(givegift.getToUserId()));
        }
        result.setData(giveGiftList);
        result.setCount(query.count());
        result.setTotal(totalMoney);
        return result;
    }

    public List<Givegift> giftdeal(Integer userId, int pageIndex, int pageSize) {
        Query query = this.getDatastore().createQuery(Givegift.class);
        query.filter("userId", (Object)userId);
        query.offset(pageSize * pageIndex);
        List givegiftList = query.limit(pageSize).asList();
        return givegiftList;
    }

    public ObjectId barrage(Integer userId, ObjectId roomId, String text) {
        Query q = this.getDatastore().createQuery(User.class);
        q.filter("userId", (Object)userId);
        User user = new User();
        user = (User)q.get();
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        int price = 1;
        ObjectId barrageId = null;
        Double balance = SKBeanUtils.getUserManager().getUserMoenyV1(userId);
        if (balance >= (double)(1 * price)) {
            Givegift givegift = new Givegift();
            givegift.setCount(1);
            givegift.setPrice(1.0);
            givegift.setUserId(userId);
            givegift.setTime(DateUtil.currentTimeSeconds());
            this.saveEntity(givegift);
            barrageId = givegift.getGiftId();
            user.setBalance(balance - 1.0);
            this.saveEntity(user);
            KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
            messageBean.setType(910);
            messageBean.setFromUserId(userId.toString());
            messageBean.setFromUserName(user.getNickname());
            messageBean.setObjectId(liveRoom.getJid());
            messageBean.setContent(text);
            messageBean.setMessageId(StringUtil.randomUUID());
            SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
            return barrageId;
        }
        throw new ServiceException(104001);
    }

    public void setmanage(Integer userId, int type, ObjectId roomId) {
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        if (userId == liveRoom.getUserId()) {
            throw new ServiceException(100906);
        }
        MongoCollection collection = this.getCollection(roomId);
        Document query = new Document();
        query.append("roomId", (Object)roomId);
        query.append("userId", (Object)userId);
        Document first = (Document)collection.find((Bson)query).first();
        LiveRoom.LiveRoomMember livemember = DocumentToJavaBean.setFieldValue(new LiveRoom.LiveRoomMember(), first);
        if (null != livemember && 2 == livemember.getType()) {
            throw new ServiceException("\u8be5\u7528\u6237\u5df2\u7ecf\u662f\u7ba1\u7406\u5458");
        }
        Document ops = new Document("$set", (Object)new Document("type", (Object)type));
        collection.updateOne((Bson)query, (Bson)ops);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(929);
        if (type == 2) {
            messageBean.setContent(1);
        } else {
            messageBean.setContent(0);
        }
        messageBean.setFromUserId(liveRoom.getUserId().toString());
        messageBean.setFromUserName(liveRoom.getNickName());
        messageBean.setToUserName(livemember.getNickName());
        messageBean.setToUserId(livemember.getUserId().toString());
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
    }

    public void addpraise(ObjectId roomId) {
        LiveRoom liveRoom = (LiveRoom)this.get((Serializable)roomId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(912);
        messageBean.setObjectId(liveRoom.getJid());
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getRoomManager().sendGroupMsg(liveRoom.getJid(), messageBean);
    }

    public void clearLiveRoom() {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        this.getDatastore().delete(query);
    }
}

